/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.Swagger20Parser;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.SwaggerResolver;
import io.swagger.parser.util.DeserializationUtils;
import io.swagger.parser.util.InlineModelResolver;
import io.swagger.parser.util.ParseOptions;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class SwaggerParser {
    public SwaggerDeserializationResult readWithInfo(String location, List<AuthorizationValue> auths, boolean resolve2) {
        if (location == null) {
            return null;
        }
        location = location.replaceAll("\\\\", "/");
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        SwaggerDeserializationResult output = new SwaggerDeserializationResult();
        ArrayList<SwaggerDeserializationResult> results2 = new ArrayList<SwaggerDeserializationResult>();
        try {
            if (auths == null) {
                auths = new ArrayList<AuthorizationValue>();
            }
            if ((output = new Swagger20Parser().readWithInfo(location, auths)) != null && output.getSwagger() != null && "2.0".equals(output.getSwagger().getSwagger())) {
                if (resolve2) {
                    output.setSwagger(new SwaggerResolver(output.getSwagger(), auths, location).resolve());
                }
                return output;
            }
            for (SwaggerParserExtension extension : parserExtensions) {
                output = extension.readWithInfo(location, auths);
                if (output != null && output.getSwagger() != null && "2.0".equals(output.getSwagger().getSwagger())) {
                    return output;
                }
                results2.add(output);
            }
            if (output == null) {
                output = new SwaggerDeserializationResult().message("The swagger definition could not be read");
            }
        }
        catch (Exception e2) {
            output.message(e2.getMessage());
        }
        if (output.getMessages() == null && output.getSwagger() == null) {
            for (int i2 = 0; i2 < results2.size(); ++i2) {
                if (((SwaggerDeserializationResult)results2.get(i2)).getMessages() == null || ((SwaggerDeserializationResult)results2.get(i2)).getSwagger() == null) continue;
                output.setMessages(((SwaggerDeserializationResult)results2.get(i2)).getMessages());
            }
        }
        return output;
    }

    public Swagger read(String location) {
        return this.read(location, null, true);
    }

    public Swagger read(String location, List<AuthorizationValue> auths, boolean resolve2) {
        ParseOptions options2 = new ParseOptions();
        options2.setResolve(resolve2);
        return this.read(location, auths, options2);
    }

    public Swagger read(String location, List<AuthorizationValue> auths, ParseOptions options2) {
        Swagger output;
        if (location == null) {
            return null;
        }
        location = location.replaceAll("\\\\", "/");
        try {
            output = new Swagger20Parser().read(location, auths);
            if (output != null) {
                if (options2 != null) {
                    if (options2.isResolve()) {
                        output = new SwaggerResolver(output, auths, location, null, options2).resolve();
                    }
                    if (options2.isFlatten()) {
                        InlineModelResolver inlineModelResolver = new InlineModelResolver();
                        inlineModelResolver.flatten(output);
                    }
                }
                return output;
            }
        }
        catch (IOException inlineModelResolver) {
            // empty catch block
        }
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            try {
                output = extension.read(location, auths);
                if (output == null) continue;
                return output;
            }
            catch (IOException e2) {
                if (System.getProperty("debugParser") == null) continue;
                e2.printStackTrace();
            }
        }
        return null;
    }

    public SwaggerDeserializationResult readWithInfo(String swaggerAsString) {
        return this.readWithInfo(swaggerAsString, Boolean.TRUE);
    }

    protected JsonNode deserializeYaml(String data2) throws IOException {
        return DeserializationUtils.readYamlTree(data2, null);
    }

    public SwaggerDeserializationResult readWithInfo(String swaggerAsString, boolean resolve2) {
        if (swaggerAsString == null || swaggerAsString.trim().isEmpty()) {
            return new SwaggerDeserializationResult().message("empty or null swagger supplied");
        }
        try {
            JsonNode node;
            if (swaggerAsString.trim().startsWith("{")) {
                ObjectMapper mapper = Json.mapper();
                node = mapper.readTree(swaggerAsString);
            } else {
                node = this.deserializeYaml(swaggerAsString);
            }
            SwaggerDeserializationResult result2 = new Swagger20Parser().readWithInfo(node);
            if (result2 != null) {
                if (resolve2) {
                    result2.setSwagger(new SwaggerResolver(result2.getSwagger(), new ArrayList<AuthorizationValue>(), null).resolve());
                }
            } else {
                result2 = new SwaggerDeserializationResult().message("Definition does not appear to be a valid Swagger format");
            }
            return result2;
        }
        catch (Exception e2) {
            return new SwaggerDeserializationResult().message("malformed or unreadable swagger supplied");
        }
    }

    public Swagger parse(String swaggerAsString) {
        return this.parse(swaggerAsString, null);
    }

    public Swagger parse(String swaggerAsString, List<AuthorizationValue> auths) {
        try {
            Swagger output = new Swagger20Parser().parse(swaggerAsString);
            if (output != null) {
                return new SwaggerResolver(output, auths, null).resolve();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Swagger read(JsonNode node) {
        return this.read(node, false);
    }

    public Swagger read(JsonNode node, boolean resolve2) {
        return this.read(node, new ArrayList<AuthorizationValue>(), resolve2);
    }

    public Swagger read(JsonNode node, List<AuthorizationValue> authorizationValues, boolean resolve2) {
        ParseOptions options2 = new ParseOptions();
        options2.setResolve(resolve2);
        return this.read(node, authorizationValues, options2);
    }

    public Swagger read(JsonNode node, List<AuthorizationValue> authorizationValues, ParseOptions options2) {
        if (node == null) {
            return null;
        }
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        Swagger output = null;
        try {
            output = new Swagger20Parser().read(node);
            if (output != null) {
                if (options2 != null) {
                    if (options2.isResolve()) {
                        output = new SwaggerResolver(output, authorizationValues, null, null, options2).resolve();
                    }
                    if (options2.isFlatten()) {
                        InlineModelResolver inlineModelResolver = new InlineModelResolver();
                        inlineModelResolver.flatten(output);
                    }
                }
                return output;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (SwaggerParserExtension extension : parserExtensions) {
            try {
                output = extension.read(node);
                if (output == null) continue;
                return output;
            }
            catch (IOException e2) {
                if (System.getProperty("debugParser") == null) continue;
                e2.printStackTrace();
            }
        }
        return null;
    }

    public List<SwaggerParserExtension> getExtensions() {
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        ArrayList<SwaggerParserExtension> output = new ArrayList<SwaggerParserExtension>();
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            output.add(itr.next());
        }
        return output;
    }
}

