/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ComposedProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache2, Swagger swagger) {
        this.cache = cache2;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        if (model == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        Map<String, Model> definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new LinkedHashMap<String, Model>();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        String tryName = null;
        Model existingModel = definitions.get(possiblyConflictingDefinitionName);
        if (existingModel != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
            if (existingModel instanceof RefModel) {
                existingModel = null;
            } else {
                int i2 = 2;
                for (String name : definitions.keySet()) {
                    if (!name.equals(possiblyConflictingDefinitionName)) continue;
                    tryName = possiblyConflictingDefinitionName + "_" + i2;
                    existingModel = definitions.get(tryName);
                    ++i2;
                }
            }
        }
        String newRef = StringUtils.isNotBlank(tryName) ? tryName : possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            this.swagger.addDefinition(newRef, model);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (model instanceof RefModel) {
                RefModel refModel = (RefModel)model;
                if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                    refModel.set$ref(this.processRefToExternalDefinition(refModel.get$ref(), refModel.getRefFormat()));
                } else {
                    refModel.set$ref(this.processRefToExternalDefinition(file2 + refModel.get$ref(), RefFormat.RELATIVE));
                }
            }
            if (model instanceof ComposedModel) {
                ComposedModel composedModel = (ComposedModel)model;
                List<Model> listOfAllOF = composedModel.getAllOf();
                for (Model allOfModel : listOfAllOF) {
                    if (allOfModel instanceof RefModel) {
                        RefModel refModel = (RefModel)allOfModel;
                        if (RefUtils.isAnExternalRefFormat(refModel.getRefFormat())) {
                            String joinedRef = ExternalRefProcessor.join(file2, refModel.get$ref());
                            refModel.set$ref(this.processRefToExternalDefinition(joinedRef, refModel.getRefFormat()));
                            continue;
                        }
                        this.processRefToExternalDefinition(file2 + refModel.get$ref(), RefFormat.RELATIVE);
                        continue;
                    }
                    if (!(allOfModel instanceof ModelImpl)) continue;
                    this.processProperties(allOfModel.getProperties(), file2);
                }
            }
            this.processProperties(model.getProperties(), file2);
            if (model instanceof ModelImpl) {
                ModelImpl modelImpl = (ModelImpl)model;
                String discriminator = modelImpl.getDiscriminator();
                if (discriminator != null) {
                    this.processDiscriminator(discriminator, modelImpl.getProperties(), file2);
                }
                this.processProperties(Arrays.asList(modelImpl.getAdditionalProperties()), file2);
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() instanceof RefProperty) {
                this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file2);
            }
            if (model instanceof ArrayModel && ((ArrayModel)model).getItems() != null) {
                ArrayModel arraySchema = (ArrayModel)model;
                if (arraySchema.getItems() instanceof RefModel) {
                    this.processRefProperty((RefProperty)((ArrayModel)model).getItems(), file2);
                } else {
                    Property properties = arraySchema.getItems();
                    if (properties instanceof ObjectProperty) {
                        this.processProperties(((ObjectProperty)properties).getProperties(), file2);
                    }
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Response existingResponse;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Response response2 = this.cache.loadRef($ref, refFormat, Response.class);
        Map<String, Response> responses2 = this.swagger.getResponses();
        if (responses2 == null) {
            responses2 = new LinkedHashMap<String, Response>();
        }
        if ((existingResponse = responses2.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingResponse + " already exists");
            if (existingResponse instanceof RefResponse) {
                existingResponse = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (response2 != null) {
            Object model = null;
            if (response2.getResponseSchema() != null) {
                this.processRefSchemaObject(response2.getResponseSchema(), $ref);
            }
        }
        return newRef;
    }

    private void processRefSchemaObject(Model schema, String $ref) {
        String file2 = $ref.split("#/")[0];
        if (schema instanceof RefModel) {
            RefModel refModel = (RefModel)schema;
            RefFormat ref = refModel.getRefFormat();
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefModel(refModel, $ref);
            } else {
                this.processRefToExternalDefinition(file2 + refModel.get$ref(), RefFormat.RELATIVE);
            }
        } else {
            this.processSchema(schema, file2);
        }
    }

    private void processSchema(Model property2, String file2) {
        if (property2 != null) {
            MapProperty mapProperty;
            if (property2 instanceof RefModel) {
                this.processRefModel((RefModel)property2, file2);
            }
            if (property2.getProperties() != null) {
                this.processProperties(property2.getProperties(), file2);
            }
            if (property2 instanceof ArrayModel) {
                this.processProperty(((ArrayModel)property2).getItems(), file2);
            }
            if (property2 instanceof MapProperty && (mapProperty = (MapProperty)((Object)property2)).getAdditionalProperties() instanceof Model) {
                this.processProperty(mapProperty.getAdditionalProperties(), file2);
            }
            if (property2 instanceof ComposedModel) {
                ComposedModel composed = (ComposedModel)property2;
                this.processComposedProperties(composed.getAllOf(), file2);
            }
        }
    }

    private void processProperty(Property property2, String file2) {
    }

    private void processComposedProperties(Collection<Model> properties, String file2) {
        if (properties != null) {
            for (Model property2 : properties) {
                this.processSchema(property2, file2);
            }
        }
    }

    private void processDiscriminator(String discriminator, Map<String, Property> properties, String file2) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Property> prop : properties.entrySet()) {
            if (!prop.getKey().equals(discriminator)) continue;
            if (prop.getValue() instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)prop.getValue();
                if (stringProperty.getEnum() == null) continue;
                for (String name : stringProperty.getEnum()) {
                    this.processRefProperty(new RefProperty(RefType.DEFINITION.getInternalPrefix() + name), file2);
                }
                continue;
            }
            if (!(prop.getValue() instanceof RefProperty)) continue;
            String ref = ((RefProperty)prop.getValue()).getSimpleRef();
            Map<String, String> renameCache = this.cache.getRenameCache();
            for (String key2 : renameCache.keySet()) {
                ModelImpl schema;
                Object resolved2;
                String value2 = renameCache.get(key2);
                if (!value2.equals(ref) || (resolved2 = this.cache.getResolutionCache().get(key2)) == null || !(resolved2 instanceof ModelImpl) || (schema = (ModelImpl)resolved2).getEnum() == null) continue;
                for (String name : schema.getEnum()) {
                    this.processRefProperty(new RefProperty(RefType.DEFINITION.getInternalPrefix() + name), file2);
                }
            }
        }
    }

    private void processProperties(Map<String, Property> subProps, String file2) {
        if (subProps == null || subProps.isEmpty()) {
            return;
        }
        this.processProperties(subProps.values(), file2);
    }

    private void processProperties(Collection<Property> subProps, String file2) {
        if (subProps == null || subProps.isEmpty()) {
            return;
        }
        for (Property prop : subProps) {
            if (prop instanceof RefProperty) {
                this.processRefProperty((RefProperty)prop, file2);
                continue;
            }
            if (prop instanceof ArrayProperty) {
                this.processProperties(Arrays.asList(((ArrayProperty)prop).getItems()), file2);
                continue;
            }
            if (prop instanceof MapProperty) {
                this.processProperties(Arrays.asList(((MapProperty)prop).getAdditionalProperties()), file2);
                continue;
            }
            if (prop instanceof ObjectProperty) {
                this.processProperties(((ObjectProperty)prop).getProperties(), file2);
                continue;
            }
            if (!(prop instanceof ComposedProperty)) continue;
            this.processProperties(((ComposedProperty)prop).getAllOf(), file2);
        }
    }

    private void processDiscriminatorAsRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref(this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat()));
        } else {
            String processRef = this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
        }
    }

    private void processRefProperty(RefProperty subRef, String externalFile) {
        if (RefUtils.isAnExternalRefFormat(subRef.getRefFormat())) {
            String joinedRef = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            String processRef = this.processRefToExternalDefinition(joinedRef, subRef.getRefFormat());
            if (processRef.startsWith("http") || processRef.startsWith("https:")) {
                subRef.set$ref(processRef);
            } else {
                subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
            }
        } else {
            String processRef = this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE);
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + processRef);
        }
    }

    private void processRefModel(RefModel subRef, String externalFile) {
        RefFormat format2 = subRef.getRefFormat();
        if (!RefUtils.isAnExternalRefFormat(format2)) {
            subRef.set$ref(RefType.DEFINITION.getInternalPrefix() + this.processRefToExternalDefinition(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = ExternalRefProcessor.getExternalPath(subRef.get$ref());
        if (format2.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalDefinition($ref, format2);
        }
    }

    protected String constructRef(Model refProperty, String rootLocation) {
        RefModel refModel = (RefModel)refProperty;
        String ref = refModel.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    public static String getExternalPath(String ref) {
        if (ref == null) {
            return null;
        }
        String[] elements = ref.split("#/");
        String element = null;
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (elements[i2].length() != 2) continue;
            element = elements[i2];
        }
        return element;
    }

    public static String join(String source2, String fragment) {
        try {
            boolean isRelative = false;
            if (source2.startsWith("/") || source2.startsWith(".")) {
                isRelative = true;
            }
            URI uri2 = new URI(source2);
            if (!source2.endsWith("/") && fragment.startsWith("./") && "".equals(uri2.getPath())) {
                uri2 = new URI(source2 + "/");
            } else if ("".equals(uri2.getPath()) && !fragment.startsWith("/")) {
                uri2 = new URI(source2 + "/");
            }
            URI f2 = new URI(fragment);
            URI resolved2 = uri2.resolve(f2);
            URI normalized = resolved2.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e2) {
            return source2;
        }
    }
}

