/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Operation;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Responses;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ParameterProcessor;
import io.swagger.parser.processors.ResponseProcessor;
import java.util.List;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache2, Swagger swagger) {
        this.cache = cache2;
        this.parameterProcessor = new ParameterProcessor(cache2, swagger);
        this.responseProcessor = new ResponseProcessor(cache2, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Responses responses2 = operation.getResponsesObject();
        if (responses2 != null) {
            for (String responseCode : responses2.keySet()) {
                Response response2 = (Response)responses2.get(responseCode);
                if (response2 == null) continue;
                if (response2 instanceof RefResponse) {
                    RefResponse refResponse = (RefResponse)response2;
                    this.responseProcessor.processResponse(response2);
                    Response resolvedResponse = this.cache.loadRef(refResponse.get$ref(), refResponse.getRefFormat(), Response.class);
                    if (resolvedResponse != null) {
                        response2 = resolvedResponse;
                        responses2.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response2);
            }
        }
    }
}

