/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ComposedProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefType;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ExternalRefProcessor;
import io.swagger.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class PropertyProcessor {
    private final ExternalRefProcessor externalRefProcessor;

    public PropertyProcessor(ResolverCache cache2, Swagger swagger) {
        this.externalRefProcessor = new ExternalRefProcessor(cache2, swagger);
    }

    public void processProperty(Property property2) {
        if (property2 instanceof RefProperty) {
            this.processRefProperty((RefProperty)property2);
        } else if (property2 instanceof ArrayProperty) {
            this.processArrayProperty((ArrayProperty)property2);
        } else if (property2 instanceof MapProperty) {
            this.processMapProperty((MapProperty)property2);
        } else if (property2 instanceof ObjectProperty) {
            this.processObjectProperty((ObjectProperty)property2);
        } else if (property2 instanceof ComposedProperty) {
            this.processComposedProperty((ComposedProperty)property2);
        }
    }

    private void processRefProperty(RefProperty refProperty) {
        String newRef;
        if (RefUtils.isAnExternalRefFormat(refProperty.getRefFormat()) && (newRef = this.externalRefProcessor.processRefToExternalDefinition(refProperty.get$ref(), refProperty.getRefFormat())) != null) {
            refProperty.set$ref(RefType.DEFINITION.getInternalPrefix() + newRef);
        }
    }

    private void processMapProperty(MapProperty property2) {
        Property additionalProperties = property2.getAdditionalProperties();
        if (additionalProperties != null) {
            this.processProperty(additionalProperties);
        }
    }

    private void processArrayProperty(ArrayProperty property2) {
        Property items2 = property2.getItems();
        if (items2 != null) {
            this.processProperty(items2);
        }
    }

    private void processObjectProperty(ObjectProperty property2) {
        Map<String, Property> properties = property2.getProperties();
        if (properties != null) {
            for (Property p : properties.values()) {
                this.processProperty(p);
            }
        }
    }

    private void processComposedProperty(ComposedProperty property2) {
        List<Property> properties = property2.getAllOf();
        if (properties != null) {
            for (Property p : properties) {
                this.processProperty(p);
            }
        }
    }
}

