/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ExternalRefProcessor;
import io.swagger.parser.processors.ModelProcessor;
import io.swagger.parser.util.RefUtils;

public class ResponseProcessor {
    private final ModelProcessor modelProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ResponseProcessor(ResolverCache cache2, Swagger swagger) {
        this.modelProcessor = new ModelProcessor(cache2, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache2, swagger);
    }

    public void processResponse(Response response2) {
        Model schema = response2.getResponseSchema();
        if (response2 instanceof RefResponse) {
            RefResponse refResponse = (RefResponse)response2;
            this.processReferenceResponse(refResponse);
        }
        if (schema != null) {
            this.modelProcessor.processModel(schema);
        }
    }

    public void processReferenceResponse(RefResponse refResponse) {
        RefFormat refFormat = refResponse.getRefFormat();
        String $ref = refResponse.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat)) {
            this.externalRefProcessor.processRefToExternalResponse($ref, refFormat);
        }
    }
}

