/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.urlresolver.matchers;

import io.swagger.parser.urlresolver.utils.NetUtils;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class UrlPatternMatcher {
    private final List<String> patterns = new ArrayList<String>();

    public UrlPatternMatcher(List<String> patterns2) {
        patterns2.forEach(pattern2 -> {
            String port2;
            String patternLower = pattern2.toLowerCase();
            String hostAndPort = pattern2.contains(":") ? patternLower : patternLower + ":*";
            String[] split2 = hostAndPort.split(":");
            String host2 = Character.isDigit(split2[0].charAt(0)) ? split2[0] : IDN.toASCII(split2[0], 1);
            String string = port2 = split2.length > 1 ? split2[1] : "*";
            if (host2.length() > 1 && !NetUtils.isIPv4(host2.replace("*", "0")) && host2.endsWith("*")) {
                return;
            }
            this.patterns.add(String.format("%s:%s", host2, port2));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String url2) {
        String hostAndPort;
        URL parsed;
        try {
            parsed = new URL(url2.toLowerCase());
        }
        catch (MalformedURLException e2) {
            return false;
        }
        String host2 = IDN.toASCII(parsed.getHost(), 1);
        if (parsed.getPort() == -1) {
            if (parsed.getProtocol().equals("http")) {
                hostAndPort = host2 + ":80";
                return this.patterns.stream().anyMatch(pattern2 -> FilenameUtils.wildcardMatch(hostAndPort, pattern2));
            } else {
                if (!parsed.getProtocol().equals("https")) return false;
                hostAndPort = host2 + ":443";
            }
            return this.patterns.stream().anyMatch(pattern2 -> FilenameUtils.wildcardMatch(hostAndPort, pattern2));
        } else {
            hostAndPort = host2 + ":" + parsed.getPort();
        }
        return this.patterns.stream().anyMatch(pattern2 -> FilenameUtils.wildcardMatch(hostAndPort, pattern2));
    }
}

