/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.util.Json;
import io.swagger.util.ObjectMapperFactory;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class DeserializationUtils {
    private static Options options = new Options();
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializationUtils.class);
    private static ObjectMapper yamlMapper = Yaml.mapper();

    public static void setYamlMapper(YAMLFactory yamlFactory) {
        yamlMapper = ObjectMapperFactory.createYaml(yamlFactory);
    }

    public static ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    public static Options getOptions() {
        return options;
    }

    public static JsonNode deserializeIntoTree(String contents, String fileOrHost) {
        return DeserializationUtils.deserializeIntoTree(contents, fileOrHost, null);
    }

    public static JsonNode deserializeIntoTree(String contents, String fileOrHost, SwaggerDeserializationResult errorOutput) {
        JsonNode result2;
        try {
            result2 = DeserializationUtils.isJson(contents) ? Json.mapper().readTree(contents) : DeserializationUtils.readYamlTree(contents, errorOutput);
        }
        catch (IOException e2) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into a JsonNode tree", e2);
        }
        return result2;
    }

    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType2) {
        return DeserializationUtils.deserialize(contents, fileOrHost, expectedType2, null);
    }

    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType2, SwaggerDeserializationResult errorOutput) {
        T result2;
        boolean isJson = contents instanceof String && DeserializationUtils.isJson((String)contents);
        try {
            result2 = contents instanceof String ? (isJson ? Json.mapper().readValue((String)contents, expectedType2) : DeserializationUtils.getYamlMapper().convertValue((Object)DeserializationUtils.readYamlTree((String)contents, errorOutput), expectedType2)) : Json.mapper().convertValue(contents, expectedType2);
        }
        catch (Exception e2) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into type " + expectedType2, e2);
        }
        return result2;
    }

    private static boolean isJson(String contents) {
        return contents.trim().startsWith("{");
    }

    public static org.yaml.snakeyaml.Yaml buildSnakeYaml(BaseConstructor constructor) {
        try {
            LoaderOptions.class.getMethod("getMaxAliasesForCollections", new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            return new org.yaml.snakeyaml.Yaml(constructor);
        }
        try {
            LoaderOptions loaderOptions = DeserializationUtils.buildLoaderOptions();
            org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml(constructor, new Representer(new DumperOptions()), new DumperOptions(), loaderOptions, new CustomResolver());
            return yaml;
        }
        catch (Exception e3) {
            LOGGER.error("error building snakeYaml", e3);
            return new org.yaml.snakeyaml.Yaml(constructor);
        }
    }

    public static LoaderOptions buildLoaderOptions() {
        LoaderOptions loaderOptions = new LoaderOptions();
        try {
            Method method2 = LoaderOptions.class.getMethod("setMaxAliasesForCollections", Integer.TYPE);
            method2.invoke((Object)loaderOptions, options.getMaxYamlAliasesForCollections());
            method2 = LoaderOptions.class.getMethod("setAllowRecursiveKeys", Boolean.TYPE);
            method2.invoke((Object)loaderOptions, options.isYamlAllowRecursiveKeys());
            method2 = LoaderOptions.class.getMethod("setCodePointLimit", Integer.TYPE);
            method2.invoke((Object)loaderOptions, options.getMaxYamlCodePoints());
        }
        catch (ReflectiveOperationException e2) {
            LOGGER.debug("using snakeyaml < 1.25, not setting YAML Billion Laughs Attack snakeyaml level protection");
        }
        return loaderOptions;
    }

    public static JsonNode readYamlTree(String contents, SwaggerDeserializationResult errorOutput) throws IOException {
        if (!options.isSupportYamlAnchors()) {
            return DeserializationUtils.getYamlMapper().readTree(contents);
        }
        try {
            boolean res;
            org.yaml.snakeyaml.Yaml yaml = null;
            yaml = options.isValidateYamlInput() ? DeserializationUtils.buildSnakeYaml(new CustomSnakeYamlConstructor()) : DeserializationUtils.buildSnakeYaml(new SafeConstructor(DeserializationUtils.buildLoaderOptions()));
            Object o = yaml.load(contents);
            if (options.isValidateYamlInput() && (res = DeserializationUtils.exceedsLimits(o, null, new Integer(0), new IdentityHashMap<Object, Long>(), errorOutput))) {
                LOGGER.warn("Error converting snake-parsed yaml to JsonNode");
                return DeserializationUtils.getYamlMapper().readTree(contents);
            }
            JsonNode n = Json.mapper().convertValue(o, JsonNode.class);
            return n;
        }
        catch (Throwable e2) {
            LOGGER.warn("Error snake-parsing yaml content", e2);
            if (errorOutput != null) {
                errorOutput.message(e2.getMessage());
            }
            return DeserializationUtils.getYamlMapper().readTree(contents);
        }
    }

    private static boolean exceedsLimits(Object o, Object parent, Integer depth, Map<Object, Long> visited, SwaggerDeserializationResult errorOutput) {
        block14: {
            int currentDepth;
            block13: {
                boolean res;
                if (o == null) {
                    return false;
                }
                if (!(o instanceof List) && !(o instanceof Map)) {
                    return false;
                }
                if (depth > options.getMaxYamlDepth()) {
                    String msg = String.format("snake-yaml result exceeds max depth %d; threshold can be increased if needed by setting system property `maxYamlDepth` to a higher value.", options.getMaxYamlDepth());
                    LOGGER.warn(msg);
                    if (errorOutput != null) {
                        errorOutput.message(msg);
                    }
                    return true;
                }
                currentDepth = depth;
                if (visited.containsKey(o)) {
                    boolean res2;
                    Object target = parent;
                    if (target == null) {
                        target = o;
                    }
                    if (options.isYamlCycleCheck() && (res2 = DeserializationUtils.hasReference(o, target, new Integer(0), new IdentityHashMap<Object, Long>(), errorOutput))) {
                        return true;
                    }
                    if (visited.get(o) > options.getMaxYamlReferences()) {
                        String msg = String.format("snake-yaml result exceeds max references %d; threshold can be increased if needed by setting system property `maxYamlReferences` to a higher value.", options.getMaxYamlReferences());
                        LOGGER.warn(msg);
                        if (errorOutput != null) {
                            errorOutput.message(msg);
                        }
                        return true;
                    }
                    visited.put(o, visited.get(o) + 1L);
                } else {
                    visited.put(o, 1L);
                }
                if (!(o instanceof Map)) break block13;
                for (Object k2 : ((Map)o).keySet()) {
                    res = DeserializationUtils.exceedsLimits(k2, o, currentDepth + 1, visited, errorOutput);
                    if (!res) continue;
                    return true;
                }
                for (Object v : ((Map)o).values()) {
                    res = DeserializationUtils.exceedsLimits(v, o, currentDepth + 1, visited, errorOutput);
                    if (!res) continue;
                    return true;
                }
                break block14;
            }
            if (!(o instanceof List)) break block14;
            for (Object v : (List)o) {
                boolean res = DeserializationUtils.exceedsLimits(v, o, currentDepth + 1, visited, errorOutput);
                if (!res) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasReference(Object o, Object target, Integer depth, Map<Object, Long> visited, SwaggerDeserializationResult errorOutput) {
        if (o == null || target == null) {
            return false;
        }
        if (!(o instanceof List) && !(o instanceof Map)) {
            return false;
        }
        if (!(target instanceof List) && !(target instanceof Map)) {
            return false;
        }
        if (depth > options.getMaxYamlDepth()) {
            String msg = String.format("snake-yaml result exceeds max depth %d; threshold can be increased if needed by setting system property `maxYamlDepth` to a higher value.", options.getMaxYamlDepth());
            LOGGER.warn(msg);
            if (errorOutput != null) {
                errorOutput.message(msg);
            }
            return true;
        }
        int currentDepth = depth;
        if (visited.containsKey(target)) {
            return false;
        }
        visited.put(o, 1L);
        ArrayList<Object> children2 = new ArrayList<Object>();
        if (o instanceof Map) {
            children2.addAll(((Map)o).keySet());
            children2.addAll(((Map)o).values());
        } else if (o instanceof List) {
            children2.addAll((List)o);
        }
        for (Object e2 : children2) {
            if (e2 == target) {
                String msg = "detected cycle in snake-yaml result; cycle check can be disabled by setting system property `yamlCycleCheck` to false.";
                LOGGER.warn(msg);
                if (errorOutput != null) {
                    errorOutput.message(msg);
                }
                return true;
            }
            boolean res = DeserializationUtils.hasReference(e2, target, currentDepth + 1, visited, errorOutput);
            if (!res) continue;
            return true;
        }
        return false;
    }

    static class CustomSnakeYamlConstructor
    extends SafeConstructor {
        public CustomSnakeYamlConstructor() {
            super(DeserializationUtils.buildLoaderOptions());
        }

        private boolean checkNode(MappingNode node, Integer depth) {
            if (node.getValue() == null) {
                return true;
            }
            if (depth > options.getMaxYamlDepth()) {
                return false;
            }
            int currentDepth = depth;
            List<NodeTuple> list = node.getValue();
            for (NodeTuple t2 : list) {
                boolean res;
                Node n = t2.getKeyNode();
                if (!(n instanceof MappingNode) || (res = this.checkNode((MappingNode)n, currentDepth + 1))) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getSingleData(Class<?> type2) {
            try {
                Node node = this.composer.getSingleNode();
                if (node != null) {
                    if (node instanceof MappingNode && !this.checkNode((MappingNode)node, new Integer(0))) {
                        LOGGER.warn("yaml tree depth exceeds max depth {}; threshold can be increased if needed by setting  system property `maxYamlDepth` to a higher value.", (Object)options.getMaxYamlDepth());
                        throw new SnakeException("yaml tree depth exceeds max " + options.getMaxYamlDepth());
                    }
                    if (Object.class != type2) {
                        node.setTag(new Tag(type2));
                    } else if (this.rootTag != null) {
                        node.setTag(this.rootTag);
                    }
                    return this.constructDocument(node);
                }
                return null;
            }
            catch (StackOverflowError e2) {
                throw new SnakeException("StackOverflow safe-checking yaml content (maxDepth " + options.getMaxYamlDepth() + ")", e2);
            }
            catch (Throwable e3) {
                throw new SnakeException("Exception safe-checking yaml content  (maxDepth " + options.getMaxYamlDepth() + ", maxYamlAliasesForCollections " + options.getMaxYamlAliasesForCollections() + ")", e3);
            }
        }
    }

    static class SnakeException
    extends RuntimeException {
        public SnakeException() {
        }

        public SnakeException(String msg) {
            super(msg);
        }

        public SnakeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CustomResolver
    extends Resolver {
        @Override
        protected void addImplicitResolvers() {
            this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
            this.addImplicitResolver(Tag.INT, INT, "-+0123456789");
            this.addImplicitResolver(Tag.FLOAT, FLOAT, "-+0123456789.");
            this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
            this.addImplicitResolver(Tag.NULL, EMPTY, null);
        }
    }

    public static class Options {
        private Integer maxYamlDepth = System.getProperty("maxYamlDepth") == null ? 2000 : Integer.parseInt(System.getProperty("maxYamlDepth"));
        private Long maxYamlReferences = System.getProperty("maxYamlReferences") == null ? 10000000L : Long.parseLong(System.getProperty("maxYamlReferences"));
        private boolean validateYamlInput = System.getProperty("validateYamlInput") == null || Boolean.parseBoolean(System.getProperty("validateYamlInput"));
        private boolean supportYamlAnchors = System.getProperty("supportYamlAnchors") == null || Boolean.parseBoolean(System.getProperty("supportYamlAnchors"));
        private boolean yamlCycleCheck = System.getProperty("yamlCycleCheck") == null || Boolean.parseBoolean(System.getProperty("yamlCycleCheck"));
        private Integer maxYamlAliasesForCollections = System.getProperty("maxYamlAliasesForCollections") == null ? Integer.MAX_VALUE : Integer.parseInt(System.getProperty("maxYamlAliasesForCollections"));
        private boolean yamlAllowRecursiveKeys = System.getProperty("yamlAllowRecursiveKeys") == null || Boolean.parseBoolean(System.getProperty("yamlAllowRecursiveKeys"));
        private Integer maxYamlCodePoints = System.getProperty("maxYamlCodePoints") == null ? 0x300000 : Integer.parseInt(System.getProperty("maxYamlCodePoints"));

        public Integer getMaxYamlDepth() {
            return this.maxYamlDepth;
        }

        public void setMaxYamlDepth(Integer maxYamlDepth) {
            this.maxYamlDepth = maxYamlDepth;
        }

        public Long getMaxYamlReferences() {
            return this.maxYamlReferences;
        }

        public void setMaxYamlReferences(Long maxYamlReferences) {
            this.maxYamlReferences = maxYamlReferences;
        }

        public boolean isValidateYamlInput() {
            return this.validateYamlInput;
        }

        public void setValidateYamlInput(boolean validateYamlInput) {
            this.validateYamlInput = validateYamlInput;
        }

        public boolean isSupportYamlAnchors() {
            return this.supportYamlAnchors;
        }

        public void setSupportYamlAnchors(boolean supportYamlAnchors) {
            this.supportYamlAnchors = supportYamlAnchors;
        }

        public boolean isYamlCycleCheck() {
            return this.yamlCycleCheck;
        }

        public void setYamlCycleCheck(boolean yamlCycleCheck) {
            this.yamlCycleCheck = yamlCycleCheck;
        }

        public Integer getMaxYamlAliasesForCollections() {
            return this.maxYamlAliasesForCollections;
        }

        public void setMaxYamlAliasesForCollections(Integer maxYamlAliasesForCollections) {
            this.maxYamlAliasesForCollections = maxYamlAliasesForCollections;
        }

        public boolean isYamlAllowRecursiveKeys() {
            return this.yamlAllowRecursiveKeys;
        }

        public void setYamlAllowRecursiveKeys(boolean yamlAllowRecursiveKeys) {
            this.yamlAllowRecursiveKeys = yamlAllowRecursiveKeys;
        }

        public Integer getMaxYamlCodePoints() {
            return this.maxYamlCodePoints;
        }

        public void setMaxYamlCodePoints(Integer maxYamlCodePointsInBytes) {
            this.maxYamlCodePoints = maxYamlCodePointsInBytes;
        }
    }
}

