/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.util.ManagedValue;
import java.net.URL;
import java.util.regex.Pattern;

public class HostAuthorizationValue
extends AuthorizationValue
implements ManagedValue {
    private final HostMatcher matcher;

    public HostAuthorizationValue(String host2, String name, String value2, String type2) {
        this(new ExactHostMatcher(host2), name, value2, type2);
    }

    public HostAuthorizationValue(Pattern host2, String name, String value2, String type2) {
        this(new RxHostMatcher(host2), name, value2, type2);
    }

    protected HostAuthorizationValue(HostMatcher matcher, String name, String value2, String type2) {
        super(name, value2, type2);
        this.matcher = matcher;
    }

    @Override
    public boolean process(URL url2) {
        return this.matcher.match(url2.getHost());
    }

    protected static class RxHostMatcher
    implements HostMatcher {
        private final Pattern rx;

        public RxHostMatcher(Pattern rx) {
            this.rx = rx;
        }

        @Override
        public boolean match(String host2) {
            return this.rx.matcher(host2).matches();
        }
    }

    protected static class ExactHostMatcher
    implements HostMatcher {
        private final String host;

        public ExactHostMatcher(String host2) {
            this.host = host2;
        }

        @Override
        public boolean match(String host2) {
            return this.host.equalsIgnoreCase(host2);
        }
    }

    protected static interface HostMatcher {
        public boolean match(String var1);
    }
}

