/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.AbstractModel;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Xml;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ComposedProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.utils.PropertyModelConverter;
import io.swagger.util.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private Swagger swagger;
    private boolean skipMatches;
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Model> addedModels = new HashMap<String, Model>();
    Map<String, String> generatedSignature = new HashMap<String, String>();

    public void flatten(Swagger swagger) {
        this.swagger = swagger;
        if (swagger.getDefinitions() == null) {
            swagger.setDefinitions(new HashMap<String, Model>());
        }
        Map<String, Path> paths = swagger.getPaths();
        Map<String, Model> models = swagger.getDefinitions();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                Path path2 = paths.get(pathname);
                for (Operation operation : path2.getOperations()) {
                    Map<String, Response> responses2;
                    List<Parameter> parameters2 = operation.getParameters();
                    if (parameters2 != null) {
                        for (Parameter parameter : parameters2) {
                            RefProperty refProperty;
                            ObjectProperty op;
                            ArrayModel am;
                            Property inner;
                            BodyParameter bp;
                            if (!(parameter instanceof BodyParameter) || (bp = (BodyParameter)parameter).getSchema() == null) continue;
                            Model model = bp.getSchema();
                            if (model instanceof ModelImpl) {
                                ModelImpl obj = (ModelImpl)model;
                                if (obj.getType() != null && !"object".equals(obj.getType()) || obj.getProperties() == null || obj.getProperties().size() <= 0) continue;
                                this.flattenProperties(obj.getProperties(), pathname);
                                String modelName = this.resolveModelName(obj.getTitle(), bp.getName());
                                bp.setSchema(new RefModel(modelName));
                                this.addGenerated(modelName, model);
                                swagger.addDefinition(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArrayModel) || !((inner = (am = (ArrayModel)model).getItems()) instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            String modelName = this.resolveModelName(op.getTitle(), bp.getName());
                            Model innerModel = this.modelFromProperty(op, modelName);
                            String existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                refProperty = new RefProperty(existing);
                                refProperty.setRequired(op.getRequired());
                                am.setItems(refProperty);
                                continue;
                            }
                            refProperty = new RefProperty(modelName);
                            refProperty.setRequired(op.getRequired());
                            am.setItems(refProperty);
                            this.addGenerated(modelName, innerModel);
                            swagger.addDefinition(modelName, innerModel);
                        }
                    }
                    if ((responses2 = operation.getResponses()) == null) continue;
                    for (String key2 : responses2.keySet()) {
                        MapProperty mp;
                        Property innerProperty;
                        Property refProperty;
                        String existing;
                        Model innerModel;
                        String modelName;
                        ObjectProperty op;
                        Response response2 = responses2.get(key2);
                        if (response2.getSchema() == null) continue;
                        Property property2 = response2.getSchema();
                        if (property2 instanceof ObjectProperty) {
                            ObjectProperty op2 = (ObjectProperty)property2;
                            if (op2.getProperties() == null || op2.getProperties().size() <= 0) continue;
                            String modelName2 = this.resolveModelName(op2.getTitle(), "inline_response_" + key2);
                            Model model = this.modelFromProperty(op2, modelName2);
                            String existing2 = this.matchGenerated(model);
                            if (existing2 != null) {
                                Property refProperty2 = this.makeRefProperty(existing2, property2);
                                refProperty2.setRequired(op2.getRequired());
                                response2.setResponseSchema(new PropertyModelConverter().propertyToModel(refProperty2));
                                continue;
                            }
                            Property refProperty2 = this.makeRefProperty(modelName2, property2);
                            refProperty2.setRequired(op2.getRequired());
                            response2.setResponseSchema(new PropertyModelConverter().propertyToModel(refProperty2));
                            this.addGenerated(modelName2, model);
                            swagger.addDefinition(modelName2, model);
                            continue;
                        }
                        if (property2 instanceof ArrayProperty) {
                            ArrayProperty ap = (ArrayProperty)property2;
                            Property inner = ap.getItems();
                            if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key2);
                            innerModel = this.modelFromProperty(op, modelName);
                            existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                refProperty = this.makeRefProperty(existing, op);
                                refProperty.setRequired(op.getRequired());
                                ap.setItems(refProperty);
                                response2.setResponseSchema(new PropertyModelConverter().propertyToModel(ap));
                                continue;
                            }
                            refProperty = this.makeRefProperty(modelName, op);
                            refProperty.setRequired(op.getRequired());
                            ap.setItems(refProperty);
                            response2.setResponseSchema(new PropertyModelConverter().propertyToModel(ap));
                            this.addGenerated(modelName, innerModel);
                            swagger.addDefinition(modelName, innerModel);
                            continue;
                        }
                        if (!(property2 instanceof MapProperty) || !((innerProperty = (mp = (MapProperty)property2).getAdditionalProperties()) instanceof ObjectProperty) || (op = (ObjectProperty)innerProperty).getProperties() == null || op.getProperties().size() <= 0) continue;
                        this.flattenProperties(op.getProperties(), pathname);
                        modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key2);
                        innerModel = this.modelFromProperty(op, modelName);
                        existing = this.matchGenerated(innerModel);
                        if (existing != null) {
                            refProperty = new RefProperty(existing);
                            ((AbstractProperty)refProperty).setRequired(op.getRequired());
                            mp.setAdditionalProperties(refProperty);
                            response2.setResponseSchema(new PropertyModelConverter().propertyToModel(mp));
                            continue;
                        }
                        refProperty = new RefProperty(modelName);
                        ((AbstractProperty)refProperty).setRequired(op.getRequired());
                        mp.setAdditionalProperties(refProperty);
                        response2.setResponseSchema(new PropertyModelConverter().propertyToModel(mp));
                        this.addGenerated(modelName, innerModel);
                        swagger.addDefinition(modelName, innerModel);
                    }
                }
            }
        }
        if (models != null) {
            ArrayList<String> modelNames = new ArrayList<String>(models.keySet());
            for (String modelName : modelNames) {
                AbstractModel m4;
                Map<String, Property> properties;
                Model model = models.get(modelName);
                if (model instanceof ModelImpl) {
                    ModelImpl m42 = (ModelImpl)model;
                    properties = m42.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(m42);
                    continue;
                }
                if (model instanceof ArrayModel) {
                    RefProperty refProperty;
                    ObjectProperty op;
                    m4 = (ArrayModel)model;
                    Property inner = ((ArrayModel)m4).getItems();
                    if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String string = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Model innerModel = this.modelFromProperty(op, string);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        swagger.addDefinition(string, innerModel);
                        this.addGenerated(string, innerModel);
                        refProperty = new RefProperty(string);
                        refProperty.setRequired(op.getRequired());
                        ((ArrayModel)m4).setItems(refProperty);
                        continue;
                    }
                    refProperty = new RefProperty(existing);
                    refProperty.setRequired(op.getRequired());
                    ((ArrayModel)m4).setItems(refProperty);
                    continue;
                }
                if (!(model instanceof ComposedModel) || ((ComposedModel)(m4 = (ComposedModel)model)).getChild() == null) continue;
                properties = ((ComposedModel)m4).getChild().getProperties();
                this.flattenProperties(properties, modelName);
            }
        }
    }

    private void fixStringModel(ModelImpl m4) {
        String example;
        if (m4.getType() != null && m4.getType().equals("string") && m4.getExample() != null && !(example = m4.getExample().toString()).isEmpty() && example.substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m4.setExample(example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key2) {
        if (title == null) {
            return this.uniqueName(key2);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Model model) {
        if (this.skipMatches) {
            return null;
        }
        String json2 = Json.pretty(model);
        if (this.generatedSignature.containsKey(json2)) {
            return this.generatedSignature.get(json2);
        }
        return null;
    }

    public void addGenerated(String name, Model model) {
        this.generatedSignature.put(Json.pretty(model), name);
    }

    public String uniqueName(String key2) {
        int count2 = 0;
        boolean done = false;
        key2 = key2.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key2;
            if (count2 > 0) {
                name = key2 + "_" + count2;
            }
            if (this.swagger.getDefinitions() == null) {
                return name;
            }
            if (!this.swagger.getDefinitions().containsKey(name)) {
                return name;
            }
            ++count2;
        }
        return key2;
    }

    public void flattenProperties(Map<String, Property> properties, String path2) {
        if (properties == null) {
            return;
        }
        HashMap<String, RefProperty> propsToUpdate = new HashMap<String, RefProperty>();
        HashMap<String, Model> modelsToAdd = new HashMap<String, Model>();
        for (String key2 : properties.keySet()) {
            RefProperty refProperty;
            String existing;
            Model innerModel;
            String modelName;
            ObjectProperty op;
            Property inner;
            RefProperty refProperty2;
            String existing2;
            Model model;
            String modelName2;
            Property property2 = properties.get(key2);
            if (property2 instanceof ObjectProperty && ((ObjectProperty)property2).getProperties() != null && ((ObjectProperty)property2).getProperties().size() > 0) {
                ObjectProperty op2 = (ObjectProperty)property2;
                modelName2 = this.resolveModelName(op2.getTitle(), path2 + "_" + key2);
                model = this.modelFromProperty(op2, modelName2);
                existing2 = this.matchGenerated(model);
                if (existing2 != null) {
                    refProperty2 = new RefProperty(existing2);
                    refProperty2.setRequired(op2.getRequired());
                    propsToUpdate.put(key2, refProperty2);
                    continue;
                }
                refProperty2 = new RefProperty(modelName2);
                refProperty2.setRequired(op2.getRequired());
                propsToUpdate.put(key2, refProperty2);
                modelsToAdd.put(modelName2, model);
                this.addGenerated(modelName2, model);
                this.swagger.addDefinition(modelName2, model);
                continue;
            }
            if (property2 instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)property2;
                inner = ap.getItems();
                if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                this.flattenProperties(op.getProperties(), path2);
                modelName = this.resolveModelName(op.getTitle(), path2 + "_" + key2);
                innerModel = this.modelFromProperty(op, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    refProperty = new RefProperty(existing);
                    refProperty.setRequired(op.getRequired());
                    ap.setItems(refProperty);
                    continue;
                }
                refProperty = new RefProperty(modelName);
                refProperty.setRequired(op.getRequired());
                ap.setItems(refProperty);
                this.addGenerated(modelName, innerModel);
                this.swagger.addDefinition(modelName, innerModel);
                continue;
            }
            if (property2 instanceof MapProperty) {
                MapProperty mp = (MapProperty)property2;
                inner = mp.getAdditionalProperties();
                if (!(inner instanceof ObjectProperty) || (op = (ObjectProperty)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                this.flattenProperties(op.getProperties(), path2);
                modelName = this.resolveModelName(op.getTitle(), path2 + "_" + key2);
                innerModel = this.modelFromProperty(op, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    refProperty = new RefProperty(existing);
                    refProperty.setRequired(op.getRequired());
                    mp.setAdditionalProperties(refProperty);
                    continue;
                }
                refProperty = new RefProperty(modelName);
                refProperty.setRequired(op.getRequired());
                mp.setAdditionalProperties(refProperty);
                this.addGenerated(modelName, innerModel);
                this.swagger.addDefinition(modelName, innerModel);
                continue;
            }
            if (!(property2 instanceof ComposedProperty)) continue;
            ComposedProperty composedProperty = (ComposedProperty)property2;
            modelName2 = this.resolveModelName(composedProperty.getTitle(), path2 + "_" + key2);
            model = this.modelFromProperty(composedProperty, modelName2);
            existing2 = this.matchGenerated(model);
            if (existing2 != null) {
                refProperty2 = new RefProperty(existing2);
                refProperty2.setRequired(composedProperty.getRequired());
                propsToUpdate.put(key2, refProperty2);
                continue;
            }
            refProperty2 = new RefProperty(modelName2);
            refProperty2.setRequired(composedProperty.getRequired());
            propsToUpdate.put(key2, refProperty2);
            this.addGenerated(modelName2, model);
            this.swagger.addDefinition(modelName2, model);
        }
        if (propsToUpdate.size() > 0) {
            for (String key2 : propsToUpdate.keySet()) {
                properties.put(key2, (Property)propsToUpdate.get(key2));
            }
        }
        for (String key2 : modelsToAdd.keySet()) {
            this.swagger.addDefinition(key2, (Model)modelsToAdd.get(key2));
            this.addedModels.put(key2, (Model)modelsToAdd.get(key2));
        }
    }

    public Model modelFromProperty(ArrayProperty object, String path2) {
        Property inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectProperty) {
            ArrayModel model = new ArrayModel();
            model.setDescription(description);
            model.setExample(example);
            model.setItems(object.getItems());
            if (object.getVendorExtensions() != null) {
                for (String key2 : object.getVendorExtensions().keySet()) {
                    model.setVendorExtension(key2, object.getVendorExtensions().get(key2));
                }
            }
            return model;
        }
        return null;
    }

    public Model modelFromProperty(ObjectProperty object, String path2) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = object.getName();
        Xml xml = object.getXml();
        Map<String, Property> properties = object.getProperties();
        ModelImpl model = new ModelImpl();
        model.type(object.getType());
        model.setDescription(description);
        model.setExample(example);
        model.setName(name);
        model.setXml(xml);
        if (object.getVendorExtensions() != null) {
            for (String key2 : object.getVendorExtensions().keySet()) {
                model.setVendorExtension(key2, object.getVendorExtensions().get(key2));
            }
        }
        if (properties != null) {
            this.flattenProperties(properties, path2);
            model.setProperties(properties);
        }
        return model;
    }

    public Model modelFromProperty(ComposedProperty composedProperty, String path2) {
        String description = composedProperty.getDescription();
        String example = null;
        Object obj = composedProperty.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        Xml xml = composedProperty.getXml();
        ModelImpl model = new ModelImpl();
        model.type(composedProperty.getType());
        model.setDescription(description);
        model.setExample(example);
        model.setName(path2);
        model.setXml(xml);
        if (composedProperty.getVendorExtensions() != null) {
            for (String key2 : composedProperty.getVendorExtensions().keySet()) {
                model.setVendorExtension(key2, composedProperty.getVendorExtensions().get(key2));
            }
        }
        return model;
    }

    public Model modelFromProperty(MapProperty object, String path2) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArrayModel model = new ArrayModel();
        model.setDescription(description);
        model.setExample(example);
        model.setItems(object.getAdditionalProperties());
        if (object.getVendorExtensions() != null) {
            for (String key2 : object.getVendorExtensions().keySet()) {
                model.setVendorExtension(key2, object.getVendorExtensions().get(key2));
            }
        }
        return model;
    }

    public Property makeRefProperty(String ref, Property property2) {
        RefProperty newProperty = new RefProperty(ref);
        this.copyVendorExtensions(property2, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Property source2, AbstractProperty target) {
        Map<String, Object> vendorExtensions = source2.getVendorExtensions();
        for (String extName : vendorExtensions.keySet()) {
            target.setVendorExtension(extName, vendorExtensions.get(extName));
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

