/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.processors.ExternalRefProcessor;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class RefUtils {
    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file2 = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file2.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split2 = plausibleName.split("\\.");
            plausibleName = split2[0];
        }
        return plausibleName;
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static String readExternalUrlRef(String file2, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result2;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url2 = RefUtils.buildUrl(rootPath, file2);
                return RefUtils.readExternalRef(url2, RefFormat.URL, auths, null);
            }
            result2 = RemoteUrl.urlToString(file2, auths);
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file2 + " path:" + rootPath, e2);
        }
        return result2;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        return ExternalRefProcessor.join(rootPath, relativePath);
    }

    public static String readExternalRef(String file2, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        String result2;
        block31: {
            if (!RefUtils.isAnExternalRefFormat(refFormat)) {
                throw new RuntimeException("Ref is not external");
            }
            result2 = null;
            try {
                if (refFormat == RefFormat.URL) {
                    result2 = RemoteUrl.urlToString(file2, auths);
                    break block31;
                }
                Path pathToUse = parentDirectory.resolve(file2).normalize();
                if (Files.exists(pathToUse, new LinkOption[0])) {
                    try (FileInputStream inputStream2 = new FileInputStream(pathToUse.toFile());){
                        result2 = IOUtils.toString((InputStream)inputStream2, "UTF-8");
                    }
                }
                String url2 = file2;
                url2 = url2.contains("..") ? parentDirectory + url2.substring(url2.indexOf(".") + 2) : parentDirectory + url2.substring(url2.indexOf(".") + 1);
                Path pathToUse2 = parentDirectory.resolve(url2).normalize();
                if (Files.exists(pathToUse2, new LinkOption[0])) {
                    try (FileInputStream inputStream3 = new FileInputStream(pathToUse2.toFile());){
                        result2 = IOUtils.toString((InputStream)inputStream3, "UTF-8");
                    }
                }
                if (result2 == null) {
                    result2 = ClasspathHelper.loadFileFromClasspath(file2);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file2 + " path: " + parentDirectory, e2);
            }
        }
        return result2;
    }
}

