/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.reader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.io.Authentication;
import io.swagger.io.HttpClient;
import io.swagger.reader.SwaggerReader;
import io.swagger.report.Message;
import io.swagger.report.MessageBuilder;
import io.swagger.report.Severity;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;

final class SimpleSwaggerReader
implements SwaggerReader {
    private final ObjectMapper objectMapper = new ObjectMapper();

    SimpleSwaggerReader() {
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    @Override
    public JsonNode read(String url2, Authentication authentication, MessageBuilder messageBuilder) {
        HttpClient httpClient = new HttpClient(url2);
        JsonNode jsonNode = null;
        authentication.apply(httpClient);
        try {
            InputStream swaggerJson = httpClient.execute();
            jsonNode = this.objectMapper.readTree(swaggerJson);
        }
        catch (IOException | URISyntaxException e2) {
            messageBuilder.append(new Message("", e2.getMessage(), Severity.ERROR));
        }
        httpClient.close();
        return jsonNode;
    }
}

