/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class V11AllowableValuesMigrator
implements SwaggerMigrator {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonPatch PATCH;

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        if (!input.has("allowableValues")) {
            return input;
        }
        String valueType = JsonPointer.of("allowableValues", "valueType").get(input).textValue();
        if ("LIST".equals(valueType)) {
            return SwaggerMigrators.fromPatch(PATCH).migrate(input);
        }
        return input;
    }

    static {
        String op = "[                                              \n  {                                            \n    \"op\": \"move\",                          \n    \"from\": \"/allowableValues/values\",     \n    \"path\": \"/enum\"                        \n  },                                           \n  {                                            \n    \"op\": \"remove\",                        \n    \"path\": \"/allowableValues\"             \n  }                                            \n]";
        try {
            PATCH = MAPPER.readValue("[                                              \n  {                                            \n    \"op\": \"move\",                          \n    \"from\": \"/allowableValues/values\",     \n    \"path\": \"/enum\"                        \n  },                                           \n  {                                            \n    \"op\": \"remove\",                        \n    \"path\": \"/allowableValues\"             \n  }                                            \n]", JsonPatch.class);
        }
        catch (IOException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }
}

