/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);
    private static final char COLON = ':';
    private static final char OPEN = '{';
    private static final char CLOSE = '}';
    private static final char SLASH = '/';
    private static final Pattern TRIM_PATTERN = Pattern.compile("^/*(.*?)/*$");

    public static String parsePath(String uri2, Map<String, String> patterns2) {
        if (uri2 == null) {
            return null;
        }
        if (StringUtils.isBlank(uri2)) {
            return String.valueOf('/');
        }
        StringCharacterIterator ci = new StringCharacterIterator(uri2);
        StringBuilder pathBuffer = new StringBuilder();
        char c2 = ci.first();
        if (c2 == '\uffff') {
            return String.valueOf('/');
        }
        do {
            if (c2 == '{') {
                String regexBuffer = PathUtils.cutParameter(ci, patterns2);
                if (regexBuffer == null) {
                    LOGGER.warn("Operation path \"" + uri2 + "\" contains syntax error.");
                    return null;
                }
                pathBuffer.append(regexBuffer);
                continue;
            }
            int length = pathBuffer.length();
            if (c2 == '/' && length != 0 && pathBuffer.charAt(length - 1) == '/') continue;
            pathBuffer.append(c2);
        } while ((c2 = ci.next()) != '\uffff');
        return pathBuffer.toString();
    }

    public static String collectPath(String ... pathParts) {
        StringBuilder sb = new StringBuilder();
        for (String item : pathParts) {
            String path2;
            if (StringUtils.isBlank(item) || !StringUtils.isNotBlank(path2 = PathUtils.trimPath(item))) continue;
            sb.append('/').append(path2);
        }
        return sb.length() > 0 ? sb.toString() : String.valueOf('/');
    }

    private static String trimPath(String value2) {
        Matcher matcher = TRIM_PATTERN.matcher(value2);
        return matcher.find() && StringUtils.isNotBlank(matcher.group(1)) ? matcher.group(1) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String cutParameter(CharacterIterator ci, Map<String, String> patterns2) {
        StringBuilder regexBuffer = new StringBuilder();
        int braceCount = 1;
        char regexChar = ci.next();
        while (regexChar != '\uffff') {
            if (regexChar == '{') {
                ++braceCount;
            } else if (regexChar == '}' && --braceCount == 0) break;
            regexBuffer.append(regexChar);
            regexChar = ci.next();
        }
        if (braceCount != 0) {
            return null;
        }
        String regex = StringUtils.trimToNull(regexBuffer.toString());
        if (regex == null) {
            return null;
        }
        StringBuilder pathBuffer = new StringBuilder();
        pathBuffer.append('{');
        int index = regex.indexOf(58);
        if (index != -1) {
            String name = StringUtils.trimToNull(regex.substring(0, index));
            String value2 = StringUtils.trimToNull(regex.substring(index + 1, regex.length()));
            if (name == null) return null;
            pathBuffer.append(name);
            if (value2 != null) {
                patterns2.put(name, value2);
            }
        } else {
            pathBuffer.append(regex);
        }
        pathBuffer.append('}');
        return pathBuffer.toString();
    }
}

