/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Sets;
import io.swagger.util.PrimitiveType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Type typeFromString(String type2) {
        PrimitiveType primitive = PrimitiveType.fromName(type2);
        if (primitive != null) {
            return primitive.getKeyClass();
        }
        if (StringUtils.isBlank(type2)) {
            return null;
        }
        try {
            return ReflectionUtils.loadClassByName(type2);
        }
        catch (Exception e2) {
            LOGGER.error(String.format("Failed to resolve '%s' into class", type2), e2);
            return null;
        }
    }

    public static Class<?> loadClassByName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e2) {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
    }

    public static boolean isOverriddenMethod(Method methodToFind, Class<?> cls) {
        HashSet<Class<?>> superClasses = Sets.newHashSet(cls.getInterfaces());
        if (cls.getSuperclass() != null) {
            superClasses.add(cls.getSuperclass());
        }
        for (Class clazz : superClasses) {
            if (clazz == null || clazz.equals(Object.class)) continue;
            for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(methodToFind.getName()) || !method2.getReturnType().isAssignableFrom(methodToFind.getReturnType()) || !Arrays.equals(method2.getParameterTypes(), methodToFind.getParameterTypes()) || Arrays.equals(method2.getGenericParameterTypes(), methodToFind.getGenericParameterTypes())) continue;
                return true;
            }
            if (!ReflectionUtils.isOverriddenMethod(methodToFind, clazz)) continue;
            return true;
        }
        return false;
    }

    public static Method getOverriddenMethod(Method method2) {
        Class<?> declaringClass = method2.getDeclaringClass();
        Class<?> superClass = declaringClass.getSuperclass();
        Method result2 = null;
        if (superClass != null && !superClass.equals(Object.class)) {
            result2 = ReflectionUtils.findMethod(method2, superClass);
        }
        if (result2 == null) {
            for (Class<?> anInterface : declaringClass.getInterfaces()) {
                result2 = ReflectionUtils.findMethod(method2, anInterface);
                if (result2 == null) continue;
                return result2;
            }
        }
        return result2;
    }

    public static Method findMethod(Method methodToFind, Class<?> cls) {
        if (cls == null) {
            return null;
        }
        String methodToSearch = methodToFind.getName();
        Class<?>[] soughtForParameterType = methodToFind.getParameterTypes();
        Type[] soughtForGenericParameterType = methodToFind.getGenericParameterTypes();
        for (Method method2 : cls.getMethods()) {
            if (!method2.getName().equals(methodToSearch) || !method2.getReturnType().isAssignableFrom(methodToFind.getReturnType())) continue;
            Class<?>[] srcParameterTypes = method2.getParameterTypes();
            Type[] srcGenericParameterTypes = method2.getGenericParameterTypes();
            if (soughtForParameterType.length != srcParameterTypes.length || soughtForGenericParameterType.length != srcGenericParameterTypes.length || !ReflectionUtils.hasIdenticalParameters(srcParameterTypes, soughtForParameterType, srcGenericParameterTypes, soughtForGenericParameterType)) continue;
            return method2;
        }
        return null;
    }

    private static boolean hasIdenticalParameters(Class<?>[] srcParameterTypes, Class<?>[] soughtForParameterType, Type[] srcGenericParameterTypes, Type[] soughtForGenericParameterType) {
        for (int j2 = 0; j2 < soughtForParameterType.length; ++j2) {
            Class<?> parameterType = soughtForParameterType[j2];
            if (srcParameterTypes[j2].equals(parameterType) || !srcGenericParameterTypes[j2].equals(soughtForGenericParameterType[j2]) && srcParameterTypes[j2].isAssignableFrom(parameterType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInject(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!"javax.inject.Inject".equals(annotation.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructorCompatible(Constructor<?> constructor) {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            int access = 7;
            return constructor.getParameterTypes().length == 0 && (constructor.getDeclaringClass().getModifiers() & 7) == constructor.getModifiers();
        }
        return true;
    }

    public static List<Field> getDeclaredFields(Class<?> cls) {
        if (cls == null || Object.class.equals(cls)) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields2 = new ArrayList<Field>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : cls.getDeclaredFields()) {
            fields2.add(field);
            fieldNames.add(field.getName());
        }
        for (Field field : ReflectionUtils.getDeclaredFields(cls.getSuperclass())) {
            if (fieldNames.contains(field.getName())) continue;
            fields2.add(field);
        }
        return fields2;
    }

    public static <A extends Annotation> A getAnnotation(Method method2, Class<A> annotationClass) {
        A annotation = method2.getAnnotation(annotationClass);
        if (annotation == null) {
            for (Annotation metaAnnotation : method2.getAnnotations()) {
                annotation = metaAnnotation.annotationType().getAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
            Method superclassMethod = ReflectionUtils.getOverriddenMethod(method2);
            if (superclassMethod != null) {
                annotation = ReflectionUtils.getAnnotation(superclassMethod, annotationClass);
            }
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> cls, Class<A> annotationClass) {
        A annotation = cls.getAnnotation(annotationClass);
        if (annotation == null) {
            for (Annotation metaAnnotation : cls.getAnnotations()) {
                annotation = metaAnnotation.annotationType().getAnnotation(annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
            Class<?> superClass = cls.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                annotation = ReflectionUtils.getAnnotation(superClass, annotationClass);
            }
        }
        if (annotation == null) {
            for (Class<?> anInterface : cls.getInterfaces()) {
                for (Annotation metaAnnotation : anInterface.getAnnotations()) {
                    annotation = metaAnnotation.annotationType().getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    return annotation;
                }
                annotation = ReflectionUtils.getAnnotation(anInterface, annotationClass);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return annotation;
    }

    public static Annotation[][] getParameterAnnotations(Method method2) {
        Annotation[][] methodAnnotations = method2.getParameterAnnotations();
        Method overriddenmethod = ReflectionUtils.getOverriddenMethod(method2);
        if (overriddenmethod != null) {
            Annotation[][] overriddenAnnotations = overriddenmethod.getParameterAnnotations();
            for (int i2 = 0; i2 < methodAnnotations.length; ++i2) {
                int j2;
                ArrayList<Class<? extends Annotation>> types = new ArrayList<Class<? extends Annotation>>();
                for (j2 = 0; j2 < methodAnnotations[i2].length; ++j2) {
                    types.add(methodAnnotations[i2][j2].annotationType());
                }
                for (j2 = 0; j2 < overriddenAnnotations[i2].length; ++j2) {
                    if (types.contains(overriddenAnnotations[i2][j2].annotationType())) continue;
                    methodAnnotations[i2] = ArrayUtils.add(methodAnnotations[i2], overriddenAnnotations[i2][j2]);
                }
            }
        }
        return methodAnnotations;
    }

    public static boolean isVoid(Type type2) {
        Class<?> cls = TypeFactory.defaultInstance().constructType(type2).getRawClass();
        return Void.class.isAssignableFrom(cls) || Void.TYPE.isAssignableFrom(cls);
    }

    public static Object safeInvoke(Method method2, Object obj, Object ... args2) {
        try {
            return method2.invoke(obj, args2);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            return null;
        }
    }
}

