/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.SwaggerAnnotationIntrospector;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractModelConverter
implements ModelConverter {
    protected final ObjectMapper _mapper;
    protected final TypeNameResolver _typeNameResolver;
    protected Map<JavaType, String> _resolvedTypeNames = new ConcurrentHashMap<JavaType, String>();

    protected AbstractModelConverter(ObjectMapper mapper) {
        this(mapper, TypeNameResolver.std);
    }

    protected AbstractModelConverter(ObjectMapper mapper, TypeNameResolver typeNameResolver) {
        mapper.registerModule(new SimpleModule("swagger", Version.unknownVersion()){

            @Override
            public void setupModule(Module.SetupContext context) {
                context.insertAnnotationIntrospector(new SwaggerAnnotationIntrospector());
            }
        });
        this._mapper = mapper;
        this._typeNameResolver = typeNameResolver;
    }

    @Override
    public Schema resolve(AnnotatedType type2, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type2, context, chain);
        }
        return null;
    }

    protected AnnotationIntrospector _intr() {
        return this._mapper.getSerializationConfig().getAnnotationIntrospector();
    }

    protected String _typeName(JavaType type2) {
        return this._typeName(type2, null);
    }

    protected String _typeName(JavaType type2, BeanDescription beanDesc) {
        String name = this._resolvedTypeNames.get(type2);
        if (name != null) {
            return name;
        }
        name = this._findTypeName(type2, beanDesc);
        this._resolvedTypeNames.put(type2, name);
        return name;
    }

    protected String _findTypeName(JavaType type2, BeanDescription beanDesc) {
        PropertyName rootName;
        if (type2.isArrayType()) {
            return "Array";
        }
        if (type2.isMapLikeType() && ReflectionUtils.isSystemType(type2)) {
            return "Map";
        }
        if (type2.isContainerType() && ReflectionUtils.isSystemType(type2)) {
            if (Set.class.isAssignableFrom(type2.getRawClass())) {
                return "Set";
            }
            return "List";
        }
        if (beanDesc == null) {
            beanDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(type2);
        }
        if ((rootName = this._intr().findRootName(beanDesc.getClassInfo())) != null && rootName.hasSimpleName()) {
            return rootName.getSimpleName();
        }
        return this._typeNameResolver.nameForType(type2, new TypeNameResolver.Options[0]);
    }

    protected String _typeQName(JavaType type2) {
        return type2.getRawClass().getName();
    }

    protected String _subTypeName(NamedType type2) {
        return type2.getType().getName();
    }

    protected boolean _isSetType(Class<?> cls) {
        if (cls != null) {
            if (Set.class.equals(cls)) {
                return true;
            }
            for (Class<?> a2 : cls.getInterfaces()) {
                if (!Set.class.equals(a2) && !"interface scala.collection.Set".equals(a2.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

