/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.swagger.v3.oas.models.callbacks.Callback;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CallbackSerializer
extends JsonSerializer<Callback> {
    @Override
    public void serialize(Callback value2, JsonGenerator jgen, SerializerProvider provider2) throws IOException {
        if (value2 != null && value2.getExtensions() != null && !value2.getExtensions().isEmpty()) {
            jgen.writeStartObject();
            if (StringUtils.isBlank(value2.get$ref())) {
                if (!value2.isEmpty()) {
                    for (Map.Entry entry : value2.entrySet()) {
                        jgen.writeObjectField((String)entry.getKey(), entry.getValue());
                    }
                }
            } else {
                jgen.writeStringField("$ref", value2.get$ref());
            }
            for (String string : value2.getExtensions().keySet()) {
                jgen.writeObjectField(string, value2.getExtensions().get(string));
            }
            jgen.writeEndObject();
        } else if (value2 == null || StringUtils.isBlank(value2.get$ref())) {
            provider2.defaultSerializeValue(value2, jgen);
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value2.get$ref());
            jgen.writeEndObject();
        }
    }
}

