/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import com.fasterxml.jackson.databind.introspect.Annotated;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import java.lang.annotation.Annotation;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang3.StringUtils;

class JAXBAnnotationsHelper {
    public static final String JAXB_DEFAULT = "##default";

    private JAXBAnnotationsHelper() {
    }

    public static void apply(Annotated member, Annotation[] annotations, Schema property2) {
        XmlElement elem;
        XmlAttribute attr;
        XmlElementWrapper wrapper2 = member.getAnnotation(XmlElementWrapper.class);
        if (wrapper2 == null) {
            wrapper2 = AnnotationsUtils.getAnnotation(XmlElementWrapper.class, annotations);
        }
        if ((attr = member.getAnnotation(XmlAttribute.class)) == null) {
            attr = AnnotationsUtils.getAnnotation(XmlAttribute.class, annotations);
        }
        if ((elem = member.getAnnotation(XmlElement.class)) == null) {
            elem = AnnotationsUtils.getAnnotation(XmlElement.class, annotations);
        }
        if (wrapper2 != null) {
            JAXBAnnotationsHelper.applyElement(wrapper2, property2);
        } else if (elem != null) {
            JAXBAnnotationsHelper.applyElement(elem, property2);
        } else if (attr != null && JAXBAnnotationsHelper.isAttributeAllowed(property2)) {
            JAXBAnnotationsHelper.applyAttribute(attr, property2);
        }
    }

    private static void applyElement(XmlElementWrapper wrapper2, Schema property2) {
        if (wrapper2 != null) {
            XML xml = JAXBAnnotationsHelper.getXml(property2);
            xml.setWrapped(true);
            if (!(JAXB_DEFAULT.equals(wrapper2.name()) || wrapper2.name().isEmpty() || wrapper2.name().equals(property2.getName()))) {
                xml.setName(wrapper2.name());
            }
        }
    }

    private static void applyElement(XmlElement element, Schema property2) {
        if (element != null) {
            JAXBAnnotationsHelper.setName(element.namespace(), element.name(), property2);
        }
    }

    private static void applyAttribute(XmlAttribute attribute, Schema property2) {
        if (attribute != null) {
            XML xml = JAXBAnnotationsHelper.getXml(property2);
            xml.setAttribute(true);
            JAXBAnnotationsHelper.setName(attribute.namespace(), attribute.name(), property2);
        }
    }

    private static XML getXml(Schema property2) {
        XML existing = property2.getXml();
        if (existing != null) {
            return existing;
        }
        XML created = new XML();
        property2.setXml(created);
        return created;
    }

    private static boolean setName(String ns, String name, Schema property2) {
        String useNS;
        String useName;
        boolean apply = false;
        String cleanName = StringUtils.trimToNull(name);
        if (!JAXBAnnotationsHelper.isEmpty(cleanName) && !cleanName.equals(property2.getName())) {
            useName = cleanName;
            apply = true;
        } else {
            useName = null;
        }
        String cleanNS = StringUtils.trimToNull(ns);
        if (!JAXBAnnotationsHelper.isEmpty(cleanNS)) {
            useNS = cleanNS;
            apply = true;
        } else {
            useNS = null;
        }
        if (apply) {
            JAXBAnnotationsHelper.getXml(property2).name(useName).namespace(useNS);
        }
        return apply;
    }

    private static boolean isAttributeAllowed(Schema property2) {
        for (Class item : new Class[]{ArraySchema.class, MapSchema.class, ObjectSchema.class}) {
            if (!item.isInstance(property2)) continue;
            return false;
        }
        return StringUtils.isBlank(property2.get$ref());
    }

    private static boolean isEmpty(String name) {
        return StringUtils.isEmpty(name) || JAXB_DEFAULT.equals(name);
    }
}

