/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.util.Json;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceTypeUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(ReferenceTypeUtils.class);

    public static boolean _isReferenceType(JavaType jtype) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(jtype.getRawClass().getCanonicalName()) || jtype.isReferenceType();
    }

    public static AnnotatedType unwrapReference(AnnotatedType type2) {
        if (type2 == null) {
            return type2;
        }
        if (type2.getType() == null) {
            return null;
        }
        try {
            JavaType jtype = type2.getType() instanceof JavaType ? (JavaType)type2.getType() : Json.mapper().constructType(type2.getType());
            if (ReferenceTypeUtils._isReferenceType(jtype)) {
                AnnotatedType aType = new AnnotatedType().type(jtype.containedType(0)).name(type2.getName()).parent(type2.getParent()).jsonUnwrappedHandler(type2.getJsonUnwrappedHandler()).skipOverride(type2.isSkipOverride()).schemaProperty(type2.isSchemaProperty()).ctxAnnotations(type2.getCtxAnnotations()).resolveAsRef(type2.isResolveAsRef()).jsonViewAnnotation(type2.getJsonViewAnnotation()).skipSchemaName(type2.isSkipSchemaName()).skipJsonIdentity(type2.isSkipJsonIdentity()).components(type2.getComponents()).propertyName(type2.getPropertyName());
                return aType;
            }
            return null;
        }
        catch (Exception e2) {
            LOGGER.error("Error unwrapping optional", e2);
            return null;
        }
    }
}

