/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.oas.models.media;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

public class ByteArraySchema
extends Schema<byte[]> {
    public ByteArraySchema() {
        super("string", "byte");
    }

    @Override
    public ByteArraySchema type(String type2) {
        super.setType(type2);
        return this;
    }

    @Override
    public ByteArraySchema format(String format2) {
        super.setFormat(format2);
        return this;
    }

    public ByteArraySchema _default(byte[] _default) {
        super.setDefault(_default);
        return this;
    }

    @Override
    protected byte[] cast(Object value2) {
        if (value2 != null) {
            try {
                if (value2 instanceof byte[]) {
                    return (byte[])value2;
                }
                if (value2 instanceof String) {
                    if (System.getProperty("binary-string-conversion") != null && System.getProperty("binary-string-conversion").equals(Schema.BynaryStringConversion.BINARY_STRING_CONVERSION_BASE64.toString()) || System.getenv("binary-string-conversion") != null && System.getenv("binary-string-conversion").equals(Schema.BynaryStringConversion.BINARY_STRING_CONVERSION_BASE64.toString())) {
                        return Base64.getDecoder().decode((String)value2);
                    }
                    return value2.toString().getBytes();
                }
                return value2.toString().getBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ByteArraySchema _enum(List<byte[]> _enum) {
        super.setEnum(_enum);
        return this;
    }

    public ByteArraySchema addEnumItem(byte[] _enumItem) {
        super.addEnumItemObject(_enumItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ByteArraySchema {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

