/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.oas.models.media;

import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.media.Schema;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JsonSchema
extends Schema<Object> {
    private static final Set<String> NUMBER_TYPES = new HashSet<String>(Arrays.asList("integer", "number"));

    public JsonSchema() {
        this.specVersion(SpecVersion.V31);
    }

    private String resolveType() {
        if (this.getTypes() != null) {
            if (this.getTypes().size() == 1) {
                String type2 = this.getTypes().iterator().next();
                if (NUMBER_TYPES.contains(type2)) {
                    return "number";
                }
                return type2;
            }
            if (this.getTypes().contains("object")) {
                return "object";
            }
            if (this.getTypes().contains("string")) {
                return "string";
            }
            if (this.getTypes().contains("array")) {
                return "array";
            }
            if (this.getTypes().contains("integer") || this.getTypes().contains("number")) {
                return "number";
            }
            if (this.getTypes().contains("boolean")) {
                return "boolean";
            }
            return this.getTypes().iterator().next();
        }
        return "null";
    }

    @Override
    protected Object cast(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            if (this.resolveType().equals("number")) {
                try {
                    Number casted = NumberFormat.getInstance().parse(value2.toString());
                    if (Integer.MIN_VALUE <= casted.longValue() && casted.longValue() <= Integer.MAX_VALUE) {
                        return Integer.parseInt(value2.toString());
                    }
                    return Long.parseLong(value2.toString());
                }
                catch (Exception e2) {
                    return value2;
                }
            }
            if (this.resolveType().equals("boolean")) {
                return Boolean.parseBoolean(value2.toString());
            }
        }
        return value2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonSchema {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

