/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.ObjectMapperFactory;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.exception.EncodingNotSupportedException;
import io.swagger.v3.parser.exception.ReadContentException;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.DereferencersFactory;
import io.swagger.v3.parser.reference.OpenAPIDereferencer;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.DeserializationUtils;
import io.swagger.v3.parser.util.InlineModelResolver;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.RemoteUrl;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIV3Parser
implements SwaggerParserExtension {
    public static final String DISABLE_OAS31_RESOLVE = "disableOas31Resolve";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIV3Parser.class);
    private static ObjectMapper JSON_MAPPER;
    private static ObjectMapper YAML_MAPPER;
    private static String encoding;

    public static List<SwaggerParserExtension> getExtensions() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        List<SwaggerParserExtension> extensions = OpenAPIV3Parser.getExtensions(tccl);
        ClassLoader cl = SwaggerParserExtension.class.getClassLoader();
        if (cl != tccl) {
            extensions.addAll(OpenAPIV3Parser.getExtensions(cl));
        }
        extensions.add(0, new OpenAPIV3Parser());
        return extensions;
    }

    protected static List<SwaggerParserExtension> getExtensions(ClassLoader cl) {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class, cl);
        for (SwaggerParserExtension extension : loader) {
            extensions.add(extension);
        }
        return extensions;
    }

    public static String getEncoding() {
        return encoding;
    }

    public static void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            throw new EncodingNotSupportedException(encoding);
        }
        OpenAPIV3Parser.encoding = encoding;
    }

    @Override
    public SwaggerParseResult readLocation(String url2, List<AuthorizationValue> auth, ParseOptions options2) {
        try {
            String content2 = this.readContentFromLocation(url2, this.emptyListIfNull(auth));
            LOGGER.debug("Loaded raw data: {}", (Object)content2);
            return this.readContents(content2, auth, options2, url2);
        }
        catch (ReadContentException e2) {
            LOGGER.warn("Exception while reading:", e2);
            return SwaggerParseResult.ofError(e2.getMessage());
        }
    }

    @Override
    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options2) {
        return this.readContents(swaggerAsString, auth, options2, null);
    }

    public OpenAPI read(String location) {
        ParseOptions options2 = new ParseOptions();
        options2.setResolve(true);
        return this.read(location, null, options2);
    }

    public OpenAPI read(String location, List<AuthorizationValue> auths, ParseOptions resolve2) {
        if (location == null) {
            return null;
        }
        List<SwaggerParserExtension> parserExtensions = OpenAPIV3Parser.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            OpenAPI result2;
            SwaggerParseResult parsed = extension.readLocation(location, auths, resolve2);
            if (parsed.getMessages() != null) {
                for (String message : parsed.getMessages()) {
                    LOGGER.info("{}: {}", (Object)extension, (Object)message);
                }
            }
            if ((result2 = parsed.getOpenAPI()) == null) continue;
            return result2;
        }
        return null;
    }

    @Deprecated
    public SwaggerParseResult readWithInfo(String path2, JsonNode node) {
        return this.parseJsonNode(path2, node);
    }

    public SwaggerParseResult parseJsonNode(String path2, JsonNode node) {
        return new OpenAPIDeserializer().deserialize(node, path2, new ParseOptions());
    }

    public SwaggerParseResult parseJsonNode(String path2, JsonNode node, ParseOptions options2) {
        return new OpenAPIDeserializer().deserialize(node, path2, options2, options2.isOaiAuthor());
    }

    public SwaggerParseResult readContents(String yaml) {
        ParseOptions options2 = new ParseOptions();
        options2.setResolve(true);
        return this.readContents(yaml, null, options2);
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options2, String location) {
        if (swaggerAsString == null || swaggerAsString.trim().isEmpty()) {
            return SwaggerParseResult.ofError("Null or empty definition");
        }
        try {
            JsonNode rootNode;
            ObjectMapper mapper = this.getRightMapper(swaggerAsString);
            SwaggerParseResult deserializationUtilsResult = new SwaggerParseResult();
            if (options2 != null && options2.isLegacyYamlDeserialization()) {
                rootNode = mapper.readTree(swaggerAsString);
            } else {
                try {
                    rootNode = DeserializationUtils.deserializeIntoTree(swaggerAsString, location, options2, deserializationUtilsResult);
                }
                catch (Exception e2) {
                    rootNode = mapper.readTree(swaggerAsString);
                }
            }
            SwaggerParseResult result2 = options2 != null ? this.parseJsonNode(location, rootNode, options2) : this.parseJsonNode(location, rootNode);
            if (result2.getOpenAPI() != null) {
                result2 = this.resolve(result2, auth, options2, location);
            }
            if (deserializationUtilsResult.getMessages() != null) {
                for (String s2 : deserializationUtilsResult.getMessages()) {
                    result2.message(this.getParseErrorMessage(s2, location));
                }
            }
            return result2;
        }
        catch (JsonProcessingException e3) {
            LOGGER.warn("Exception while parsing:", e3);
            String message = this.getParseErrorMessage(e3.getOriginalMessage(), location);
            return SwaggerParseResult.ofError(message);
        }
        catch (Exception e4) {
            LOGGER.warn("Exception while parsing:", e4);
            String message = this.getParseErrorMessage(e4.getMessage(), location);
            return SwaggerParseResult.ofError(message);
        }
    }

    @Deprecated
    public SwaggerParseResult readWithInfo(String location, List<AuthorizationValue> auths) {
        return this.readContents(this.readContentFromLocation(location, auths), auths, null);
    }

    private SwaggerParseResult resolve(SwaggerParseResult result2, List<AuthorizationValue> auth, ParseOptions options2, String location) {
        try {
            if (options2 != null) {
                if (options2.isResolve() || options2.isResolveFully()) {
                    if (result2.getOpenAPI().getOpenapi() != null && result2.getOpenAPI().getOpenapi().startsWith("3.1")) {
                        if (StringUtils.isBlank(System.getenv(DISABLE_OAS31_RESOLVE))) {
                            DereferencerContext dereferencerContext = new DereferencerContext(result2, auth, location, options2, null, null, true);
                            List<OpenAPIDereferencer> dereferencers = DereferencersFactory.getInstance().getDereferencers();
                            if (dereferencers.iterator().hasNext()) {
                                OpenAPIDereferencer dereferencer = dereferencers.iterator().next();
                                dereferencer.dereference(dereferencerContext, dereferencers.iterator());
                            }
                            if (options2.isResolveFully()) {
                                new ResolverFully(options2).resolveFully(result2.getOpenAPI());
                            }
                        } else {
                            String msg = "Resolution of OAS 3.1 spec disabled by 'disableOas31Resolve' env variable";
                            LOGGER.warn(msg);
                            result2.getMessages().add(msg);
                        }
                    } else {
                        OpenAPIResolver resolver = new OpenAPIResolver(result2.getOpenAPI(), this.emptyListIfNull(auth), location, null, options2);
                        resolver.resolve(result2);
                        if (options2.isResolveFully()) {
                            new ResolverFully(options2).resolveFully(result2.getOpenAPI());
                        }
                    }
                }
                if (options2.isFlatten()) {
                    InlineModelResolver inlineModelResolver = new InlineModelResolver(options2.isFlattenComposedSchemas(), options2.isCamelCaseFlattenNaming(), options2.isSkipMatches());
                    if (result2.getOpenAPI() != null) {
                        inlineModelResolver.flatten(result2.getOpenAPI());
                    }
                }
            }
        }
        catch (Exception e2) {
            LOGGER.warn("Exception while resolving:", e2);
            result2.getMessages().add(e2.getMessage());
        }
        return result2;
    }

    private String getParseErrorMessage(String originalMessage, String location) {
        if (Objects.isNull(originalMessage)) {
            return String.format("Unable to parse `%s`", location);
        }
        if (originalMessage.startsWith("Duplicate field")) {
            return String.format("%s in `%s`", originalMessage, location);
        }
        return originalMessage;
    }

    private <T> List<T> emptyListIfNull(List<T> list) {
        return Objects.isNull(list) ? new ArrayList() : list;
    }

    private ObjectMapper getRightMapper(String data2) {
        if (data2.trim().startsWith("{")) {
            return JSON_MAPPER;
        }
        return YAML_MAPPER;
    }

    private String readContentFromLocation(String location, List<AuthorizationValue> auth) {
        String adjustedLocation = location.replaceAll("\\\\", "/");
        try {
            Path path2;
            if (adjustedLocation.toLowerCase().startsWith("http")) {
                return RemoteUrl.urlToString(adjustedLocation, auth);
            }
            if (adjustedLocation.toLowerCase().startsWith("jar:")) {
                InputStream in = new URI(adjustedLocation).toURL().openStream();
                return IOUtils.toString(in, encoding);
            }
            String fileScheme = "file:";
            Path path3 = path2 = adjustedLocation.toLowerCase().startsWith("file:") ? Paths.get(URI.create(adjustedLocation)) : Paths.get(adjustedLocation, new String[0]);
            if (Files.exists(path2, new LinkOption[0])) {
                return FileUtils.readFileToString(path2.toFile(), encoding);
            }
            return ClasspathHelper.loadFileFromClasspath(adjustedLocation);
        }
        catch (SSLHandshakeException e2) {
            String message = String.format("Unable to read location `%s` due to a SSL configuration error. It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority.", adjustedLocation);
            throw new ReadContentException(message, e2);
        }
        catch (Exception e3) {
            throw new ReadContentException(String.format("Unable to read location `%s`", adjustedLocation), e3);
        }
    }

    @Deprecated
    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value2 : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value2.getKeyName());
            v.setValue(value2.getValue());
            v.setType(value2.getType());
            v.setUrlMatcher(value2.getUrlMatcher());
            output.add(v);
        }
        return output;
    }

    static {
        encoding = StandardCharsets.UTF_8.displayName();
        JSON_MAPPER = ObjectMapperFactory.createJson();
        YAML_MAPPER = ObjectMapperFactory.createYaml();
    }
}

