/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.models.RefType;
import io.swagger.v3.parser.urlresolver.PermittedUrlsChecker;
import io.swagger.v3.parser.urlresolver.exceptions.HostDeniedException;
import io.swagger.v3.parser.util.DeserializationUtils;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.PathUtils;
import io.swagger.v3.parser.util.RefUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ResolverCache {
    private static final Pattern SCHEMAS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "schemas/(?<name>.+)");
    private static final Pattern RESPONSES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "responses/(?<name>.+)");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "parameters/(?<name>.+)");
    private static final Pattern REQUEST_BODIES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "requestBodies/(?<name>.+)");
    private static final Pattern EXAMPLES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "examples/(?<name>.+)");
    private static final Pattern LINKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "links/(?<name>.+)");
    private static final Pattern CALLBACKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "callbacks/(?<name>.+)");
    private static final Pattern HEADERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "headers/(?<name>.+)");
    private static final Pattern SECURITY_SCHEMES = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "securitySchemes/(?<name>.+)");
    private static final Pattern PATHS_PATTERN = Pattern.compile("^" + RefType.PATH.getInternalPrefix() + "(?<name>.+)");
    private final OpenAPI openApi;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String rootPath;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private List<String> referencedModelKeys = new ArrayList<String>();
    private Set<String> resolveValidationMessages;
    private final ParseOptions parseOptions;
    protected boolean openapi31;
    private Map<String, String> renameCache = new HashMap<String, String>();

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, new HashSet<String>());
    }

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Set<String> resolveValidationMessages) {
        this(openApi, auths, parentFileLocation, resolveValidationMessages, new ParseOptions());
    }

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Set<String> resolveValidationMessages, ParseOptions parseOptions) {
        this.openapi31 = openApi != null && openApi.getOpenapi() != null && openApi.getOpenapi().startsWith("3.1");
        this.openApi = openApi;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        this.resolveValidationMessages = resolveValidationMessages;
        this.parseOptions = parseOptions;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") || parentFileLocation.startsWith("jar") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file2 = new File(".");
            this.parentDirectory = file2.toPath();
        }
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType2) {
        String[] jsonPathElements;
        String contents;
        if (refFormat == RefFormat.INTERNAL) {
            Object loadedRef = this.loadInternalRef(ref);
            try {
                return expectedType2.cast(loadedRef);
            }
            catch (Exception e2) {
                return null;
            }
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file2 = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            if (expectedType2.equals(Header.class)) {
                if (expectedType2.getClass().equals(previouslyResolvedEntity.getClass())) {
                    return expectedType2.cast(previouslyResolvedEntity);
                }
            } else {
                return expectedType2.cast(previouslyResolvedEntity);
            }
        }
        if ((contents = this.externalFileCache.get(file2)) == null) {
            if (this.parseOptions.isSafelyResolveURL()) {
                this.checkUrlIsPermitted(file2);
            }
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file2, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null && this.rootPath.startsWith("http")) {
                contents = RefUtils.readExternalUrlRef(file2, refFormat, this.auths, this.rootPath);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalClasspathRef(file2, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file2, contents);
        }
        SwaggerParseResult deserializationUtilResult = new SwaggerParseResult();
        JsonNode tree = DeserializationUtils.deserializeIntoTree(contents, file2, this.parseOptions, deserializationUtilResult);
        if (definitionPath == null) {
            T result2 = null;
            result2 = this.parseOptions.isValidateExternalRefs() ? (T)this.deserializeFragment(tree, expectedType2, file2, "/") : (T)DeserializationUtils.deserialize(contents, file2, expectedType2, this.openapi31);
            this.resolutionCache.put(ref, result2);
            if (deserializationUtilResult.getMessages() != null && this.resolveValidationMessages != null) {
                this.resolveValidationMessages.addAll(deserializationUtilResult.getMessages());
            }
            return result2;
        }
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if (tree.isArray()) {
                try {
                    tree = tree.get(Integer.valueOf(jsonPathElement));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                tree = tree.get(this.unescapePointer(jsonPathElement));
            }
            if (tree != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file2);
        }
        Schema result3 = null;
        if (this.parseOptions.isValidateExternalRefs()) {
            result3 = (Schema)this.deserializeFragment(tree, expectedType2, file2, definitionPath);
        } else if (expectedType2.equals(Schema.class)) {
            OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
            result3 = deserializer.getSchema((ObjectNode)tree, definitionPath.replace("/", "."), new OpenAPIDeserializer.ParseResult().openapi31(this.openapi31));
        } else {
            result3 = (Schema)DeserializationUtils.deserialize(tree, file2, expectedType2, this.openapi31);
        }
        this.updateLocalRefs(file2, (T)result3);
        this.resolutionCache.put(ref, result3);
        if (deserializationUtilResult.getMessages() != null && this.resolveValidationMessages != null) {
            this.resolveValidationMessages.addAll(deserializationUtilResult.getMessages());
        }
        return (T)result3;
    }

    private <T> T deserializeFragment(JsonNode node, Class<T> expectedType2, String file2, String definitionPath) {
        OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
        OpenAPIDeserializer.ParseResult parseResult = new OpenAPIDeserializer.ParseResult();
        Object result2 = null;
        if (expectedType2.equals(Schema.class)) {
            result2 = deserializer.getSchema((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(RequestBody.class)) {
            result2 = deserializer.getRequestBody((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(ApiResponse.class)) {
            result2 = deserializer.getResponse((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Callback.class)) {
            result2 = deserializer.getCallback((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Example.class)) {
            result2 = deserializer.getExample((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Header.class)) {
            result2 = deserializer.getHeader((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Link.class)) {
            result2 = deserializer.getLink((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Parameter.class)) {
            result2 = deserializer.getParameter((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(SecurityScheme.class)) {
            result2 = deserializer.getSecurityScheme((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType2.equals(PathItem.class)) {
            result2 = deserializer.getPathItem((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        }
        parseResult.getMessages().forEach(m4 -> this.resolveValidationMessages.add(m4 + " (" + file2 + ")"));
        if (result2 != null) {
            return (T)result2;
        }
        return DeserializationUtils.deserialize(node, file2, expectedType2);
    }

    protected <T> void updateLocalRefs(String file2, T result2) {
        Parameter parameter;
        if (result2 instanceof Parameter && (parameter = (Parameter)result2).getSchema() != null) {
            this.updateLocalRefs(file2, parameter.getSchema());
        }
        if (result2 instanceof Schema && ((Schema)result2).get$ref() != null) {
            Schema prop = (Schema)result2;
            this.updateLocalRefs(file2, prop);
        } else if (result2 instanceof Schema) {
            Schema model = (Schema)result2;
            this.updateLocalRefs(file2, model);
        }
    }

    protected <T> void updateLocalRefs(String file2, Schema schema) {
        if (schema.get$ref() != null) {
            String updatedLocation = this.merge(file2, schema.get$ref());
            schema.set$ref(updatedLocation);
        } else if (schema.getProperties() != null) {
            Map<String, Schema> properties = schema.getProperties();
            for (Schema property2 : properties.values()) {
                this.updateLocalRefs(file2, property2);
            }
        }
    }

    protected String merge(String host2, String ref) {
        if (StringUtils.isBlank(host2)) {
            return ref;
        }
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            return ref;
        }
        if (!(host2.startsWith("http:") || host2.startsWith("https:") || ref.startsWith("#/components"))) {
            return ref;
        }
        if (ref.startsWith(".")) {
            return ref;
        }
        if (host2.endsWith("/") && ref.startsWith("/")) {
            return host2 + ref.substring(1);
        }
        return host2 + ref;
    }

    private Object loadInternalRef(String ref) {
        Object result2 = null;
        if (ref.startsWith("#/paths")) {
            result2 = this.getFromMap(ref, this.openApi.getPaths(), PATHS_PATTERN);
        } else if (this.openApi.getComponents() != null) {
            if (ref.startsWith("#/components/schemas")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getSchemas(), SCHEMAS_PATTERN);
            } else if (ref.startsWith("#/components/requestBodies")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getRequestBodies(), REQUEST_BODIES_PATTERN);
            } else if (ref.startsWith("#/components/examples")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getExamples(), EXAMPLES_PATTERN);
            } else if (ref.startsWith("#/components/responses")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getResponses(), RESPONSES_PATTERN);
            } else if (ref.startsWith("#/components/parameters")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getParameters(), PARAMETERS_PATTERN);
            } else if (ref.startsWith("#/components/links")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getLinks(), LINKS_PATTERN);
            } else if (ref.startsWith("#/components/headers")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getHeaders(), HEADERS_PATTERN);
            } else if (ref.startsWith("#/components/callbacks")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getCallbacks(), CALLBACKS_PATTERN);
            } else if (ref.startsWith("#/components/securitySchemes")) {
                result2 = this.getFromMap(ref, this.openApi.getComponents().getSecuritySchemes(), SECURITY_SCHEMES);
            }
        }
        return result2;
    }

    private String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private Object getFromMap(String ref, Map map2, Pattern pattern2) {
        Matcher parameterMatcher = pattern2.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = this.unescapePointer(parameterMatcher.group("name"));
            if (map2 != null) {
                return map2.get(paramName);
            }
        }
        return null;
    }

    protected void checkUrlIsPermitted(String refSet) {
        try {
            PermittedUrlsChecker permittedUrlsChecker = new PermittedUrlsChecker(this.parseOptions.getRemoteRefAllowList(), this.parseOptions.getRemoteRefBlockList());
            permittedUrlsChecker.verify(refSet);
        }
        catch (HostDeniedException e2) {
            throw new RuntimeException(e2.getMessage());
        }
    }

    public boolean hasReferencedKey(String modelKey) {
        if (this.referencedModelKeys == null) {
            return false;
        }
        return this.referencedModelKeys.contains(modelKey);
    }

    public void addReferencedKey(String modelKey) {
        this.referencedModelKeys.add(modelKey);
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }
}

