/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.converter;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ComposedProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.SwaggerResolver;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerInventory;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ResolverFully;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SwaggerConverter
implements SwaggerParserExtension {
    private List<String> globalConsumes = new ArrayList<String>();
    private List<String> globalProduces = new ArrayList<String>();
    private Components components = new Components();
    private Map<String, Parameter> globalV2Parameters = new HashMap<String, Parameter>();

    @Override
    public SwaggerParseResult readLocation(String url2, List<io.swagger.v3.parser.core.models.AuthorizationValue> auths, ParseOptions options2) {
        boolean resolve2 = false;
        if (options2 != null) {
            resolve2 = options2.isResolve();
        }
        SwaggerDeserializationResult result2 = new SwaggerParser().readWithInfo(url2, this.convert(auths), resolve2);
        return this.readResult(result2, auths, options2);
    }

    @Override
    public SwaggerParseResult readContents(String swaggerAsString, List<io.swagger.v3.parser.core.models.AuthorizationValue> auth, ParseOptions options2) {
        SwaggerDeserializationResult result2 = new SwaggerParser().readWithInfo(swaggerAsString, options2 == null ? true : options2.isResolve());
        if (options2 != null && options2.isResolve()) {
            Swagger resolved2 = new SwaggerResolver(result2.getSwagger(), this.convert(auth)).resolve();
            result2.setSwagger(resolved2);
        }
        return this.readResult(result2, auth, options2);
    }

    private SwaggerParseResult readResult(SwaggerDeserializationResult result2, List<io.swagger.v3.parser.core.models.AuthorizationValue> auth, ParseOptions options2) {
        SwaggerParseResult out2 = this.convert(result2);
        if (out2 != null && out2.getOpenAPI() != null && options2 != null) {
            if (options2.isResolveFully()) {
                new ResolverFully(options2).resolveFully(out2.getOpenAPI());
            }
            if (options2.isFlatten()) {
                try {
                    SwaggerParseResult resultV3 = new OpenAPIV3Parser().readContents(Yaml.pretty(out2.getOpenAPI()), auth, options2);
                    out2.setOpenAPI(resultV3.getOpenAPI());
                    if (out2.getMessages() != null) {
                        out2.getMessages().addAll(resultV3.getMessages());
                        out2.messages(out2.getMessages().stream().distinct().collect(Collectors.toList()));
                    } else {
                        out2.messages(resultV3.getMessages());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return out2;
    }

    public List<AuthorizationValue> convert(List<io.swagger.v3.parser.core.models.AuthorizationValue> auths) {
        ArrayList<AuthorizationValue> convertedAuth = new ArrayList<AuthorizationValue>();
        if (auths != null) {
            for (io.swagger.v3.parser.core.models.AuthorizationValue auth : auths) {
                AuthorizationValue v = new AuthorizationValue();
                v.setType(auth.getType());
                v.setValue(auth.getValue());
                v.setKeyName(auth.getKeyName());
                convertedAuth.add(v);
            }
        }
        return convertedAuth;
    }

    public SwaggerParseResult convert(SwaggerDeserializationResult parse2) {
        Object updatedRef;
        Object ref;
        if (parse2 == null) {
            return null;
        }
        SwaggerParseResult output = new SwaggerParseResult().messages(parse2.getMessages());
        if (parse2.getSwagger() == null) {
            return output;
        }
        OpenAPI openAPI = new OpenAPI();
        SwaggerInventory inventory = new SwaggerInventory().process(parse2.getSwagger());
        Swagger swagger = parse2.getSwagger();
        if (swagger.getVendorExtensions() != null) {
            openAPI.setExtensions(this.convert(swagger.getVendorExtensions()));
        }
        openAPI.addExtension("x-original-swagger-version", swagger.getSwagger());
        if (swagger.getExternalDocs() != null) {
            openAPI.setExternalDocs(this.convert(swagger.getExternalDocs()));
        }
        if (swagger.getInfo() != null) {
            openAPI.setInfo(this.convert(swagger.getInfo()));
        }
        openAPI.setServers(this.convert(swagger.getSchemes(), swagger.getHost(), swagger.getBasePath()));
        if (swagger.getTags() != null) {
            openAPI.setTags(this.convertTags(swagger.getTags()));
        }
        if (swagger.getConsumes() != null) {
            this.globalConsumes.addAll(swagger.getConsumes());
        }
        if (swagger.getProduces() != null) {
            this.globalProduces.addAll(swagger.getProduces());
        }
        if (swagger.getSecurity() != null && swagger.getSecurity().size() > 0) {
            openAPI.setSecurity(this.convertSecurityRequirements(swagger.getSecurity()));
        }
        List<Model> models = inventory.getModels();
        for (Model model : models) {
            if (!(model instanceof RefModel) || ((RefModel)(ref = (RefModel)model)).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ((RefModel)ref).get$ref().substring("#/definitions".length());
            ((RefModel)ref).set$ref((String)updatedRef);
        }
        for (Property property2 : inventory.getProperties()) {
            ComposedProperty comprop;
            if (property2 instanceof RefProperty && ((RefProperty)(ref = (RefProperty)property2)).get$ref().indexOf("#/definitions") == 0) {
                updatedRef = "#/components/schemas" + ((RefProperty)ref).get$ref().substring("#/definitions".length());
                ((RefProperty)ref).set$ref((String)updatedRef);
            }
            if (!(property2 instanceof ComposedProperty) || (comprop = (ComposedProperty)property2).getAllOf() == null) continue;
            for (Property item : comprop.getAllOf()) {
                RefProperty ref2;
                if (!(item instanceof RefProperty) || (ref2 = (RefProperty)item).get$ref().indexOf("#/definitions") != 0) continue;
                String updatedRef2 = "#/components/schemas" + ref2.get$ref().substring("#/definitions".length());
                ref2.set$ref(updatedRef2);
            }
        }
        if (swagger.getParameters() != null) {
            this.globalV2Parameters.putAll(swagger.getParameters());
            swagger.getParameters().forEach((k2, v) -> {
                if ("body".equals(v.getIn())) {
                    this.components.addRequestBodies((String)k2, this.convertParameterToRequestBody((Parameter)v));
                } else if ("formData".equals(v.getIn())) {
                    this.components.addSchemas("formData_" + k2, this.convertFormDataToSchema((Parameter)v));
                } else {
                    this.components.addParameters((String)k2, this.convert((Parameter)v));
                }
            });
        }
        Paths v3Paths = new Paths();
        Map pathMap = Optional.ofNullable(swagger.getPaths()).orElse(new HashMap());
        for (String pathname : pathMap.keySet()) {
            Path v2Path = swagger.getPath(pathname);
            PathItem v3Path = this.convert(v2Path);
            v3Paths.put(pathname, v3Path);
        }
        openAPI.setPaths(v3Paths);
        if (swagger.getResponses() != null) {
            swagger.getResponses().forEach((k2, v) -> this.components.addResponses((String)k2, this.convert((Response)v)));
        }
        if (swagger.getDefinitions() != null) {
            for (String key2 : swagger.getDefinitions().keySet()) {
                Model model = swagger.getDefinitions().get(key2);
                Schema schema = this.convert(model);
                this.components.addSchemas(key2, schema);
            }
        }
        if (swagger.getSecurityDefinitions() != null) {
            swagger.getSecurityDefinitions().forEach((k2, v) -> this.components.addSecuritySchemes((String)k2, this.convert((SecuritySchemeDefinition)v)));
        }
        openAPI.setComponents(this.components);
        output.setOpenAPI(openAPI);
        return output;
    }

    private List<SecurityRequirement> convertSecurityRequirements(List<io.swagger.models.SecurityRequirement> security) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.models.SecurityRequirement requirement : security) {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            requirement.getRequirements().forEach((k2, v) -> securityRequirement.addList((String)k2, (List<String>)v));
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    private List<SecurityRequirement> convertSecurityRequirementsMap(List<Map<String, List<String>>> security) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (Map<String, List<String>> map2 : security) {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            map2.forEach((k2, v) -> securityRequirement.addList((String)k2, (List<String>)v));
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    private SecurityScheme convert(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme;
        switch (definition.getType()) {
            case "basic": {
                securityScheme = this.createBasicSecurityScheme();
                break;
            }
            case "apiKey": {
                securityScheme = this.convertApiKeySecurityScheme(definition);
                break;
            }
            case "oauth2": {
                securityScheme = this.convertOauth2SecurityScheme(definition);
                break;
            }
            default: {
                securityScheme = new SecurityScheme();
            }
        }
        securityScheme.setDescription(definition.getDescription());
        securityScheme.setExtensions(this.convert(definition.getVendorExtensions()));
        return securityScheme;
    }

    private SecurityScheme convertOauth2SecurityScheme(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme = new SecurityScheme();
        OAuth2Definition oAuth2Definition = (OAuth2Definition)definition;
        OAuthFlows oAuthFlows = new OAuthFlows();
        OAuthFlow oAuthFlow = new OAuthFlow();
        securityScheme.setType(SecurityScheme.Type.OAUTH2);
        String flow = oAuth2Definition.getFlow();
        if (flow != null) {
            switch (flow) {
                case "implicit": {
                    oAuthFlow.setAuthorizationUrl(oAuth2Definition.getAuthorizationUrl());
                    oAuthFlows.setImplicit(oAuthFlow);
                    break;
                }
                case "password": {
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setPassword(oAuthFlow);
                    break;
                }
                case "application": {
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setClientCredentials(oAuthFlow);
                    break;
                }
                case "accessCode": {
                    oAuthFlow.setAuthorizationUrl(oAuth2Definition.getAuthorizationUrl());
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setAuthorizationCode(oAuthFlow);
                }
            }
        }
        Scopes scopes = new Scopes();
        Map<String, String> oAuth2Scopes = oAuth2Definition.getScopes();
        if (oAuth2Scopes != null) {
            oAuth2Scopes.forEach((k2, v) -> scopes.addString((String)k2, (String)v));
        }
        oAuthFlow.setScopes(scopes);
        securityScheme.setFlows(oAuthFlows);
        return securityScheme;
    }

    private SecurityScheme convertApiKeySecurityScheme(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme = new SecurityScheme();
        ApiKeyAuthDefinition apiKeyAuthDefinition = (ApiKeyAuthDefinition)definition;
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName(apiKeyAuthDefinition.getName());
        securityScheme.setIn(SecurityScheme.In.valueOf(apiKeyAuthDefinition.getIn().toString()));
        return securityScheme;
    }

    private SecurityScheme createBasicSecurityScheme() {
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.HTTP);
        securityScheme.setScheme("basic");
        return securityScheme;
    }

    private List<Tag> convertTags(List<io.swagger.models.Tag> v2tags) {
        ArrayList<Tag> v3tags = new ArrayList<Tag>();
        for (io.swagger.models.Tag v2tag : v2tags) {
            Map<String, Object> extensions;
            Tag v3tag = new Tag();
            v3tag.setDescription(v2tag.getDescription());
            v3tag.setName(v2tag.getName());
            if (v2tag.getExternalDocs() != null) {
                v3tag.setExternalDocs(this.convert(v2tag.getExternalDocs()));
            }
            if ((extensions = this.convert(v2tag.getVendorExtensions())) != null) {
                v3tag.setExtensions(extensions);
            }
            v3tags.add(v3tag);
        }
        return v3tags;
    }

    private ExternalDocumentation convert(ExternalDocs externalDocs) {
        ExternalDocumentation externalDocumentation = new ExternalDocumentation();
        externalDocumentation.setUrl(externalDocs.getUrl());
        externalDocumentation.setDescription(externalDocs.getDescription());
        Map<String, Object> extensions = this.convert(externalDocs.getVendorExtensions());
        if (extensions != null && extensions.size() > 0) {
            externalDocumentation.setExtensions(extensions);
        }
        return externalDocumentation;
    }

    private List<Server> convert(List<Scheme> schemes, String host2, String basePath) {
        ArrayList<Server> servers = new ArrayList<Server>();
        String baseUrl = StringUtils.isNotEmpty(basePath) ? basePath : "/";
        if (StringUtils.isNotEmpty(host2)) {
            baseUrl = host2 + baseUrl;
        }
        if (!StringUtils.startsWith(baseUrl, "/") && schemes != null && !schemes.isEmpty()) {
            for (Scheme scheme2 : schemes) {
                Server server2 = new Server();
                server2.setUrl(scheme2.toValue() + "://" + baseUrl);
                servers.add(server2);
            }
        } else {
            if (!StringUtils.startsWith(baseUrl, "/") && !"/".equals(baseUrl)) {
                baseUrl = "//" + baseUrl;
            }
            Server server3 = new Server();
            server3.setUrl(baseUrl);
            servers.add(server3);
        }
        return servers;
    }

    public io.swagger.v3.oas.models.info.Info convert(Info v2Info) {
        io.swagger.v3.oas.models.info.Info info = new io.swagger.v3.oas.models.info.Info();
        info.setContact(this.convert(v2Info.getContact()));
        info.setDescription(v2Info.getDescription());
        info.setLicense(this.convert(v2Info.getLicense()));
        info.setTermsOfService(v2Info.getTermsOfService());
        info.setTitle(v2Info.getTitle());
        info.setVersion(v2Info.getVersion());
        info.setExtensions(this.convert(v2Info.getVendorExtensions()));
        return info;
    }

    private License convert(io.swagger.models.License v2License) {
        if (v2License == null) {
            return null;
        }
        License license2 = new License();
        license2.setExtensions(this.convert(v2License.getVendorExtensions()));
        license2.setName(v2License.getName());
        license2.setUrl(v2License.getUrl());
        return license2;
    }

    public io.swagger.v3.oas.models.info.Contact convert(Contact v2Contact) {
        if (v2Contact == null) {
            return null;
        }
        io.swagger.v3.oas.models.info.Contact contact = new io.swagger.v3.oas.models.info.Contact();
        contact.setUrl(v2Contact.getUrl());
        contact.setName(v2Contact.getName());
        contact.setEmail(v2Contact.getEmail());
        return contact;
    }

    public PathItem convert(Path v2Path) {
        PathItem v3Path = new PathItem();
        if (v2Path instanceof RefPath) {
            v3Path.set$ref(((RefPath)v2Path).get$ref());
        } else {
            Operation v2Operation;
            if (v2Path.getParameters() != null) {
                for (Parameter param : v2Path.getParameters()) {
                    v3Path.addParametersItem(this.convert(param));
                }
            }
            if ((v2Operation = v2Path.getGet()) != null) {
                v3Path.setGet(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPut()) != null) {
                v3Path.setPut(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPost()) != null) {
                v3Path.setPost(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPatch()) != null) {
                v3Path.setPatch(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getDelete()) != null) {
                v3Path.setDelete(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getHead()) != null) {
                v3Path.setHead(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getOptions()) != null) {
                v3Path.setOptions(this.convert(v2Operation));
            }
            v3Path.setExtensions(this.convert(v2Path.getVendorExtensions()));
        }
        return v3Path;
    }

    private boolean isRefABodyParam(Parameter param) {
        if (param instanceof RefParameter) {
            RefParameter refParameter = (RefParameter)param;
            String simpleRef = refParameter.getSimpleRef();
            Parameter parameter = this.globalV2Parameters.get(simpleRef);
            return "body".equals(parameter.getIn());
        }
        return false;
    }

    private boolean isRefAFormParam(Parameter param) {
        if (param instanceof RefParameter) {
            RefParameter refParameter = (RefParameter)param;
            String simpleRef = refParameter.getSimpleRef();
            Parameter parameter = this.globalV2Parameters.get(simpleRef);
            return "formData".equals(parameter.getIn());
        }
        return false;
    }

    public io.swagger.v3.oas.models.Operation convert(Operation v2Operation) {
        io.swagger.v3.oas.models.Operation operation = new io.swagger.v3.oas.models.Operation();
        if (StringUtils.isNotBlank(v2Operation.getDescription())) {
            operation.setDescription(v2Operation.getDescription());
        }
        if (StringUtils.isNotBlank(v2Operation.getSummary())) {
            operation.setSummary(v2Operation.getSummary());
        }
        operation.setDeprecated(v2Operation.isDeprecated());
        operation.setOperationId(v2Operation.getOperationId());
        operation.setExtensions(this.convert(v2Operation.getVendorExtensions()));
        operation.setTags(v2Operation.getTags());
        if (v2Operation.getParameters() != null) {
            ArrayList<Parameter> formParams = new ArrayList<Parameter>();
            for (Parameter param : v2Operation.getParameters()) {
                if ("formData".equals(param.getIn())) {
                    formParams.add(param);
                    continue;
                }
                if ("body".equals(param.getIn())) {
                    operation.setRequestBody(this.convertParameterToRequestBody(param, v2Operation.getConsumes()));
                    operation.addExtension("x-codegen-request-body-name", param.getName());
                    continue;
                }
                io.swagger.v3.oas.models.parameters.Parameter convert = this.convert(param);
                String $ref = convert.get$ref();
                if ($ref != null && $ref.startsWith("#/components/requestBodies/") && this.isRefABodyParam(param)) {
                    operation.setRequestBody(new RequestBody().$ref($ref));
                    continue;
                }
                if ($ref != null && $ref.startsWith("#/components/schemas/") && this.isRefAFormParam(param)) {
                    formParams.add(param);
                    continue;
                }
                operation.addParametersItem(convert);
            }
            if (formParams.size() > 0) {
                RequestBody body2 = this.convertFormDataToRequestBody(formParams, v2Operation.getConsumes());
                body2.getContent().forEach((key2, content2) -> {
                    Schema schema = content2.getSchema();
                    if (schema != null && schema.getRequired() != null && schema.getRequired().size() > 0) {
                        body2.setRequired(Boolean.TRUE);
                    }
                });
                operation.requestBody(body2);
            }
        }
        if (v2Operation.getResponses() != null) {
            for (String responseCode : v2Operation.getResponses().keySet()) {
                Response v2Response = v2Operation.getResponses().get(responseCode);
                ApiResponse response2 = this.convert(v2Response, v2Operation.getProduces());
                ApiResponses responses2 = operation.getResponses();
                if (responses2 == null) {
                    responses2 = new ApiResponses();
                }
                operation.responses(responses2.addApiResponse(responseCode, response2));
            }
        }
        if (v2Operation.getExternalDocs() != null) {
            operation.setExternalDocs(this.convert(v2Operation.getExternalDocs()));
        }
        if (v2Operation.getSecurity() != null) {
            operation.setSecurity(this.convertSecurityRequirementsMap(v2Operation.getSecurity()));
        }
        return operation;
    }

    private Map<String, Object> convert(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null && vendorExtensions.size() > 0) {
            vendorExtensions.entrySet().removeIf(extension -> ((String)extension.getKey()).equals("x-example") || ((String)extension.getKey()).equals("x-examples") || ((String)extension.getKey()).equals("x-nullable"));
        }
        return vendorExtensions;
    }

    private Schema convertFormDataToSchema(Parameter formParam) {
        SerializableParameter sp = (SerializableParameter)formParam;
        return this.convert(sp);
    }

    private RequestBody convertFormDataToRequestBody(List<Parameter> formParams, List<String> consumes2) {
        RequestBody body2 = new RequestBody();
        ObjectSchema formSchema = new ObjectSchema();
        for (Parameter param : formParams) {
            Schema schema;
            String name;
            SerializableParameter sp;
            if (param instanceof RefParameter) {
                RefParameter refParameter = (RefParameter)param;
                String simpleRef = refParameter.getSimpleRef();
                sp = (SerializableParameter)this.globalV2Parameters.get(simpleRef);
                name = this.components.getSchemas().get("formData_" + simpleRef).getName();
                schema = new Schema().$ref("#/components/schemas/formData_" + simpleRef);
            } else {
                sp = (SerializableParameter)param;
                schema = this.convert(sp);
                name = schema.getName();
            }
            if (sp.getRequired()) {
                formSchema.addRequiredItem(sp.getName());
            }
            formSchema.addProperty(name, schema);
        }
        ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
        if (consumes2 != null && consumes2.size() > 0) {
            mediaTypes.clear();
            mediaTypes.addAll(consumes2);
        }
        if (mediaTypes.size() == 0) {
            mediaTypes.add("multipart/form-data");
        }
        Content content2 = new Content();
        for (String type2 : mediaTypes) {
            content2.addMediaType(type2, new MediaType().schema(formSchema));
        }
        body2.content(content2);
        return body2;
    }

    private Schema convert(SerializableParameter sp) {
        Schema schema;
        if ("file".equals(sp.getType())) {
            schema = new FileSchema();
        } else if ("array".equals(sp.getType())) {
            ArraySchema as = new ArraySchema();
            if (sp.getItems() != null) {
                as.setItems(this.convert(sp.getItems()));
            }
            schema = as;
        } else {
            PrimitiveType ptype = PrimitiveType.fromTypeAndFormat(sp.getType(), sp.getFormat());
            if (ptype != null) {
                schema = ptype.createProperty();
            } else {
                ptype = PrimitiveType.fromTypeAndFormat(sp.getType(), null);
                if (ptype != null) {
                    schema = ptype.createProperty();
                    schema.setFormat(sp.getFormat());
                } else {
                    schema = new Schema();
                    schema.setType(sp.getType());
                    schema.setFormat(sp.getFormat());
                }
            }
        }
        schema.setDescription(sp.getDescription());
        schema.setReadOnly(sp.isReadOnly());
        schema.setEnum(sp.getEnum());
        if (sp.getMaxItems() != null) {
            schema.setMaxItems(sp.getMaxItems());
        }
        if (sp.getMinItems() != null) {
            schema.setMinItems(sp.getMinItems());
        }
        if (sp.isUniqueItems() != null) {
            schema.setUniqueItems(sp.isUniqueItems());
        }
        schema.setMaximum(sp.getMaximum());
        schema.setExclusiveMaximum(sp.isExclusiveMaximum());
        schema.setMinimum(sp.getMinimum());
        schema.setExclusiveMinimum(sp.isExclusiveMinimum());
        schema.setMinLength(sp.getMinLength());
        schema.setMaxLength(sp.getMaxLength());
        schema.setName(sp.getName());
        if (sp.getVendorExtensions() != null) {
            Object nullableExtension;
            Object exampleExtension = sp.getVendorExtensions().get("x-example");
            if (exampleExtension != null) {
                schema.setExample(exampleExtension);
            }
            if ((nullableExtension = sp.getVendorExtensions().get("x-nullable")) != null) {
                schema.setNullable((Boolean)nullableExtension);
            }
            schema.setExtensions(this.convert(sp.getVendorExtensions()));
        }
        if (sp.getMultipleOf() != null) {
            schema.setMultipleOf(new BigDecimal(sp.getMultipleOf().toString()));
        }
        schema.setPattern(sp.getPattern());
        if (sp instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter ap = (AbstractSerializableParameter)sp;
            schema.setDefault(ap.getDefault());
        }
        return schema;
    }

    private RequestBody convertParameterToRequestBody(Parameter param) {
        return this.convertParameterToRequestBody(param, null);
    }

    private RequestBody convertParameterToRequestBody(Parameter param, List<String> consumes2) {
        RequestBody body2 = new RequestBody();
        BodyParameter bp = (BodyParameter)param;
        ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
        if (consumes2 != null && consumes2.size() > 0) {
            mediaTypes.clear();
            mediaTypes.addAll(consumes2);
        }
        if (mediaTypes.size() == 0) {
            mediaTypes.add("*/*");
        }
        if (StringUtils.isNotBlank(param.getDescription())) {
            body2.description(param.getDescription());
        }
        body2.required(param.getRequired());
        Content content2 = new Content();
        for (String type2 : mediaTypes) {
            content2.addMediaType(type2, new MediaType().schema(this.convert(bp.getSchema())));
            if (!StringUtils.isNotBlank(bp.getDescription())) continue;
            body2.setDescription(bp.getDescription());
        }
        this.convertExamples(((BodyParameter)param).getExamples(), content2);
        body2.setExtensions(this.convert(param.getVendorExtensions()));
        body2.content(content2);
        return body2;
    }

    public ApiResponse convert(Response response2) {
        return this.convert(response2, null);
    }

    public ApiResponse convert(Response v2Response, List<String> produces) {
        ApiResponse response2 = new ApiResponse();
        Content content2 = new Content();
        if (v2Response instanceof RefResponse) {
            RefResponse ref = (RefResponse)v2Response;
            if (ref.get$ref().indexOf("#/responses") == 0) {
                String updatedRef = "#/components/responses" + ref.get$ref().substring("#/responses".length());
                ref.set$ref(updatedRef);
            }
            response2.set$ref(ref.get$ref());
        } else {
            ArrayList<String> mediaTypes = new ArrayList<String>(this.globalProduces);
            if (produces != null) {
                mediaTypes.clear();
                mediaTypes.addAll(produces);
            }
            if (mediaTypes.size() == 0) {
                mediaTypes.add("*/*");
            }
            response2.setDescription(v2Response.getDescription());
            if (v2Response.getResponseSchema() != null) {
                Schema schema = this.convertFileSchema(this.convert(v2Response.getResponseSchema()));
                for (String type2 : mediaTypes) {
                    MediaType mediaType = new MediaType();
                    content2.addMediaType(type2, mediaType.schema(schema));
                }
                response2.content(content2);
            }
            response2.content(this.convertExamples(v2Response.getExamples(), content2));
            response2.setExtensions(this.convert(v2Response.getVendorExtensions()));
            if (v2Response.getHeaders() != null && v2Response.getHeaders().size() > 0) {
                response2.setHeaders(this.convertHeaders(v2Response.getHeaders()));
            }
        }
        return response2;
    }

    private Content convertExamples(Map examples, Content content2) {
        if (examples != null) {
            examples.forEach((k2, v) -> {
                MediaType mT = (MediaType)content2.get(k2);
                if (mT == null) {
                    mT = new MediaType();
                    content2.addMediaType(k2.toString(), mT);
                }
                mT.setExample(v);
            });
        }
        return content2;
    }

    private Schema convertFileSchema(Schema schema) {
        if ("file".equals(schema.getType())) {
            schema.setType("string");
            schema.setFormat("binary");
        }
        return schema;
    }

    private Map<String, Header> convertHeaders(Map<String, Property> headers2) {
        HashMap<String, Header> result2 = new HashMap<String, Header>();
        headers2.forEach((k2, v) -> result2.put((String)k2, this.convertHeader((Property)v)));
        return result2;
    }

    private Header convertHeader(Property property2) {
        Schema schema = this.convert(property2);
        schema.setDescription(null);
        Header header = new Header();
        header.setDescription(property2.getDescription());
        header.setSchema(schema);
        return header;
    }

    private Schema convert(Property schema) {
        Schema result2;
        if (schema == null) {
            return null;
        }
        if (schema.getBooleanValue() != null) {
            return new Schema().booleanSchemaValue(schema.getBooleanValue());
        }
        if (schema instanceof RefProperty) {
            RefProperty ref = (RefProperty)schema;
            if (ref.get$ref().indexOf("#/definitions") == 0) {
                String updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
                ref.set$ref(updatedRef);
            }
            result2 = new Schema();
            result2.set$ref(ref.get$ref());
        } else if (schema instanceof ArrayProperty) {
            ArraySchema arraySchema = Json.mapper().convertValue((Object)schema, ArraySchema.class);
            Property items2 = ((ArrayProperty)schema).getItems();
            Schema itemsSchema = this.convert(items2);
            arraySchema.setItems(itemsSchema);
            if (((ArrayProperty)schema).getMaxItems() != null) {
                arraySchema.setMaxItems(((ArrayProperty)schema).getMaxItems());
            }
            if (((ArrayProperty)schema).getMinItems() != null) {
                arraySchema.setMinItems(((ArrayProperty)schema).getMinItems());
            }
            if (((ArrayProperty)schema).getUniqueItems() != null && ((ArrayProperty)schema).getUniqueItems().booleanValue()) {
                arraySchema.setUniqueItems(((ArrayProperty)schema).getUniqueItems());
            }
            result2 = arraySchema;
        } else if (schema instanceof FileProperty) {
            result2 = Json.mapper().convertValue((Object)schema, FileSchema.class);
        } else {
            result2 = Json.mapper().convertValue((Object)schema, Schema.class);
            if (schema.getExample() != null) {
                result2.setExample(schema.getExample());
            }
            if ("object".equals(schema.getType()) && result2.getProperties() != null && result2.getProperties().size() > 0) {
                LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                ((ObjectProperty)schema).getProperties().forEach((k2, v) -> properties.put((String)k2, this.convert((Property)v)));
                result2.setProperties(properties);
            }
            if (schema instanceof MapProperty) {
                MapProperty map2 = (MapProperty)schema;
                if (map2.getAdditionalProperties().getBooleanValue() != null) {
                    result2.setAdditionalProperties(map2.getAdditionalProperties().getBooleanValue());
                } else {
                    result2.setAdditionalProperties(this.convert(map2.getAdditionalProperties()));
                }
                result2.setMinProperties(map2.getMinProperties());
                result2.setMaxProperties(map2.getMaxProperties());
            }
            if (schema instanceof AbstractNumericProperty) {
                AbstractNumericProperty np = (AbstractNumericProperty)schema;
                result2.setExclusiveMaximum(np.getExclusiveMaximum());
                result2.setExclusiveMinimum(np.getExclusiveMinimum());
            }
            if (schema instanceof StringProperty) {
                StringProperty sp = (StringProperty)schema;
                result2.setMinLength(sp.getMinLength());
                result2.setMaxLength(sp.getMaxLength());
                result2.setPattern(sp.getPattern());
            }
        }
        if (schema.getVendorExtensions() != null) {
            Object nullableExtension = schema.getVendorExtensions().get("x-nullable");
            if (nullableExtension != null) {
                result2.setNullable((Boolean)nullableExtension);
            }
            result2.setExtensions(this.convert(schema.getVendorExtensions()));
        }
        return result2;
    }

    public io.swagger.v3.oas.models.parameters.Parameter convert(Parameter v2Parameter) {
        io.swagger.v3.oas.models.parameters.Parameter v3Parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank(v2Parameter.getDescription())) {
            v3Parameter.setDescription(v2Parameter.getDescription());
        }
        if (v2Parameter instanceof SerializableParameter) {
            v3Parameter.setAllowEmptyValue(((SerializableParameter)v2Parameter).getAllowEmptyValue());
        }
        v3Parameter.setIn(v2Parameter.getIn());
        v3Parameter.setName(v2Parameter.getName());
        Object exampleExtension = v2Parameter.getVendorExtensions().get("x-example");
        if (exampleExtension != null) {
            v3Parameter.setExample(exampleExtension);
        }
        Schema schema = null;
        if (v2Parameter instanceof RefParameter) {
            RefParameter ref = (RefParameter)v2Parameter;
            if (ref.get$ref().indexOf("#/parameters") == 0) {
                String updatedRef = "#/components/";
                updatedRef = this.components.getRequestBodies() != null && this.components.getRequestBodies().get(ref.getSimpleRef()) != null ? updatedRef + "requestBodies" : (this.components.getSchemas() != null && this.components.getSchemas().get("formData_" + ref.getSimpleRef()) != null ? updatedRef + "schemas" : updatedRef + "parameters");
                updatedRef = updatedRef + ref.get$ref().substring("#/parameters".length());
                ref.set$ref(updatedRef);
            }
            v3Parameter.set$ref(ref.get$ref());
        } else if (v2Parameter instanceof SerializableParameter) {
            Object nullableExtension;
            SerializableParameter sp = (SerializableParameter)v2Parameter;
            if ("array".equals(sp.getType())) {
                ArraySchema a2 = new ArraySchema();
                String cf = sp.getCollectionFormat();
                if (StringUtils.isEmpty(cf)) {
                    cf = "csv";
                }
                switch (cf) {
                    case "ssv": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.SPACEDELIMITED);
                        break;
                    }
                    case "pipes": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.PIPEDELIMITED);
                        break;
                    }
                    case "tsv": {
                        break;
                    }
                    case "multi": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.FORM);
                        v3Parameter.setExplode(true);
                        break;
                    }
                    default: {
                        if ("query".equals(v2Parameter.getIn())) {
                            v3Parameter.setStyle(Parameter.StyleEnum.FORM);
                            v3Parameter.setExplode(false);
                            break;
                        }
                        if (!"header".equals(v2Parameter.getIn()) && !"path".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.SIMPLE);
                        v3Parameter.setExplode(false);
                    }
                }
                Property items2 = sp.getItems();
                Schema itemsSchema = this.convert(items2);
                a2.setItems(itemsSchema);
                if (sp.getMaxItems() != null) {
                    a2.setMaxItems(sp.getMaxItems());
                }
                if (sp.getMinItems() != null) {
                    a2.setMinItems(sp.getMinItems());
                }
                if (sp.isUniqueItems() != null) {
                    a2.setUniqueItems(sp.isUniqueItems());
                }
                schema = a2;
            } else {
                schema = SchemaTypeUtil.createSchema(sp.getType(), sp.getFormat());
                schema.setType(sp.getType());
                schema.setFormat(sp.getFormat());
                schema.setMaximum(sp.getMaximum());
                schema.setExclusiveMaximum(sp.isExclusiveMaximum());
                schema.setMinimum(sp.getMinimum());
                schema.setExclusiveMinimum(sp.isExclusiveMinimum());
                schema.setMinLength(sp.getMinLength());
                schema.setMaxLength(sp.getMaxLength());
                if (sp.getMultipleOf() != null) {
                    schema.setMultipleOf(new BigDecimal(sp.getMultipleOf().toString()));
                }
                schema.setPattern(sp.getPattern());
            }
            if (sp.getEnum() != null) {
                block23: for (String e2 : sp.getEnum()) {
                    switch (sp.getType() == null ? "object" : sp.getType()) {
                        case "integer": {
                            schema.addEnumItemObject(Integer.parseInt(e2));
                            continue block23;
                        }
                        case "number": {
                            schema.addEnumItemObject(new BigDecimal(e2));
                            continue block23;
                        }
                        case "boolean": {
                            schema.addEnumItemObject(Boolean.valueOf(e2));
                            continue block23;
                        }
                    }
                    schema.addEnumItemObject(e2);
                }
            }
            if (sp.getVendorExtensions() != null && (nullableExtension = sp.getVendorExtensions().get("x-nullable")) != null) {
                schema.setNullable((Boolean)nullableExtension);
            }
            schema.setExtensions(this.convert(sp.getVendorExtensions()));
            if (sp instanceof AbstractSerializableParameter) {
                AbstractSerializableParameter ap = (AbstractSerializableParameter)sp;
                schema.setDefault(ap.getDefault());
            }
        }
        if (v2Parameter.getRequired()) {
            v3Parameter.setRequired(v2Parameter.getRequired());
        }
        v3Parameter.setSchema(schema);
        v3Parameter.setExtensions(this.convert(v2Parameter.getVendorExtensions()));
        return v3Parameter;
    }

    public Schema convert(Model v2Model) {
        Object nullableExtension;
        Schema result2;
        if (v2Model == null) {
            return null;
        }
        if (v2Model.getBooleanValue() != null) {
            return new Schema().booleanSchemaValue(v2Model.getBooleanValue());
        }
        if (v2Model instanceof ArrayModel) {
            ArraySchema arraySchema = Json.mapper().convertValue((Object)v2Model, ArraySchema.class);
            arraySchema.setItems(this.convert(((ArrayModel)v2Model).getItems()));
            result2 = arraySchema;
        } else if (v2Model instanceof ComposedModel) {
            ComposedModel composedModel = (ComposedModel)v2Model;
            ComposedSchema composed = new ComposedSchema();
            composed.setDescription(composedModel.getDescription());
            if (composedModel.getExample() != null) {
                composed.setExample(composedModel.getExample());
            }
            if (composedModel.getExternalDocs() != null) {
                composed.setExternalDocs(this.convert(composedModel.getExternalDocs()));
            }
            composed.setTitle(composedModel.getTitle());
            composed.setExtensions(this.convert(composedModel.getVendorExtensions()));
            composed.setAllOf(composedModel.getAllOf().stream().map(this::convert).collect(Collectors.toList()));
            composed.setRequired(composedModel.getRequired());
            this.addProperties(v2Model, composed);
            result2 = composed;
        } else {
            RefModel ref;
            ModelImpl model;
            String v2discriminator = null;
            if (v2Model instanceof ModelImpl) {
                model = (ModelImpl)v2Model;
                v2discriminator = model.getDiscriminator();
                model.setDiscriminator(null);
            }
            result2 = v2Model instanceof ModelImpl && "file".equals(((ModelImpl)v2Model).getType()) ? (Schema)Json.mapper().convertValue((Object)v2Model, FileSchema.class) : Json.mapper().convertValue((Object)v2Model, Schema.class);
            this.addProperties(v2Model, result2);
            if (v2Model instanceof ModelImpl) {
                model = (ModelImpl)v2Model;
                if (model.getAdditionalProperties() != null) {
                    if (model.getAdditionalProperties().getBooleanValue() != null) {
                        result2.setAdditionalProperties(model.getAdditionalProperties().getBooleanValue());
                    } else {
                        result2.setAdditionalProperties(this.convert(model.getAdditionalProperties()));
                    }
                }
            } else if (v2Model instanceof RefModel && (ref = (RefModel)v2Model).get$ref().indexOf("#/definitions") == 0) {
                String updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
                result2.set$ref(updatedRef);
            }
            if (v2discriminator != null) {
                Discriminator discriminator = new Discriminator();
                discriminator.setPropertyName(v2discriminator);
                result2.setDiscriminator(discriminator);
            }
        }
        if (v2Model.getVendorExtensions() != null && (nullableExtension = v2Model.getVendorExtensions().get("x-nullable")) != null) {
            result2.setNullable((Boolean)nullableExtension);
        }
        return result2;
    }

    private void addProperties(Model v2Model, Schema schema) {
        if (v2Model.getProperties() != null && v2Model.getProperties().size() > 0) {
            Map<String, Property> properties = v2Model.getProperties();
            properties.forEach((k2, v) -> schema.addProperties((String)k2, this.convert((Property)v)));
        }
    }
}

