/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.converter;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.List;

public class SwaggerInventory {
    private List<Path> paths = new ArrayList<Path>();
    private List<Property> properties = new ArrayList<Property>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Operation> operations = new ArrayList<Operation>();
    private List<Response> responses = new ArrayList<Response>();
    private List<Model> models = new ArrayList<Model>();
    private List<Tag> tags = new ArrayList<Tag>();

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters2) {
        this.parameters = parameters2;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public List<Response> getResponses() {
        return this.responses;
    }

    public void setResponses(List<Response> responses2) {
        this.responses = responses2;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public void setModels(List<Model> models) {
        this.models = models;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public SwaggerInventory process(Swagger swagger) {
        if (swagger.getTags() != null) {
            for (Tag key2 : swagger.getTags()) {
                this.process(key2);
            }
        }
        if (swagger.getPaths() != null) {
            for (String key1 : swagger.getPaths().keySet()) {
                Path model = swagger.getPath(key1);
                this.process(model);
            }
        }
        if (swagger.getDefinitions() != null) {
            for (String key1 : swagger.getDefinitions().keySet()) {
                Model model1 = swagger.getDefinitions().get(key1);
                this.process(model1);
            }
        }
        return this;
    }

    public void process(Tag tag) {
        this.tags.add(tag);
    }

    public void process(Path path2) {
        this.paths.add(path2);
        if (path2.getParameters() != null) {
            for (Parameter operation : path2.getParameters()) {
                this.process(operation);
            }
        }
        if (path2.getOperations() != null) {
            for (Operation operation1 : path2.getOperations()) {
                this.process(operation1);
            }
        }
    }

    public void process(Operation operation) {
        this.operations.add(operation);
        if (operation.getParameters() != null) {
            for (Parameter key2 : operation.getParameters()) {
                this.process(key2);
            }
        }
        if (operation.getResponses() != null) {
            for (String key1 : operation.getResponses().keySet()) {
                Response response2 = operation.getResponses().get(key1);
                this.process(response2);
            }
        }
    }

    public void process(Response response2) {
        this.responses.add(response2);
        if (response2.getSchema() != null) {
            this.process(response2.getSchema());
        }
    }

    public void process(Parameter parameter) {
        Model model;
        BodyParameter p;
        this.parameters.add(parameter);
        if (parameter instanceof BodyParameter && (p = (BodyParameter)parameter).getSchema() != null && (model = p.getSchema()) != null) {
            this.process(model);
        }
    }

    public void process(Model model) {
        block5: {
            ArrayModel m22;
            block6: {
                block4: {
                    this.models.add(model);
                    if (!(model instanceof ModelImpl)) break block4;
                    ModelImpl m4 = (ModelImpl)model;
                    if (m4.getProperties() == null) break block5;
                    for (String name : m4.getProperties().keySet()) {
                        Property ip = m4.getProperties().get(name);
                        this.process(ip);
                    }
                    break block5;
                }
                if (!(model instanceof ComposedModel)) break block6;
                ComposedModel m1 = (ComposedModel)model;
                if (m1.getAllOf() == null) break block5;
                for (Model name1 : m1.getAllOf()) {
                    this.process(name1);
                }
                break block5;
            }
            if (model instanceof ArrayModel && (m22 = (ArrayModel)model).getProperties() != null) {
                for (String name : m22.getProperties().keySet()) {
                    Property ip = m22.getProperties().get(name);
                    this.process(ip);
                }
            }
        }
    }

    public void process(Property property2) {
        ObjectProperty p2;
        this.properties.add(property2);
        if (property2 instanceof ArrayProperty) {
            ArrayProperty p = (ArrayProperty)property2;
            Property ap = p.getItems();
            this.process(ap);
        } else if (property2 instanceof MapProperty) {
            MapProperty p = (MapProperty)property2;
        } else if (property2 instanceof ObjectProperty && (p2 = (ObjectProperty)property2).getProperties() != null) {
            for (String name : p2.getProperties().keySet()) {
                Property ip = p2.getProperties().get(name);
                this.process(ip);
            }
        }
    }
}

