/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class CallbackProcessor {
    private final ResolverCache cache;
    private final OperationProcessor operationProcessor;
    private final ParameterProcessor parameterProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public CallbackProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this(cache2, openAPI, false);
    }

    public CallbackProcessor(ResolverCache cache2, OpenAPI openAPI, boolean openapi31) {
        this.cache = cache2;
        this.operationProcessor = new OperationProcessor(cache2, openAPI, openapi31);
        this.parameterProcessor = new ParameterProcessor(cache2, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache2, openAPI);
        this.openAPI = openAPI;
    }

    public void processCallback(Callback callback2) {
        if (callback2.get$ref() != null) {
            this.processReferenceCallback(callback2);
        }
        for (String name : callback2.keySet()) {
            PathItem pathItem = (PathItem)callback2.get(name);
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
            List<Parameter> parameters2 = pathItem.getParameters();
            if (parameters2 == null) continue;
            for (Parameter parameter : parameters2) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
    }

    public void processReferenceCallback(Callback callback2) {
        String newRef;
        String $ref = callback2.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
            callback2.set$ref("#/components/callbacks/" + newRef);
        }
    }
}

