/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.models.RefType;
import io.swagger.v3.parser.util.RefUtils;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ExternalRefProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this.cache = cache2;
        this.openAPI = openAPI;
    }

    private String finalNameRec(Map<String, Schema> schemas, String possiblyConflictingDefinitionName, Schema newSchema, int iteration) {
        String tryName = iteration == 0 ? possiblyConflictingDefinitionName : possiblyConflictingDefinitionName + "_" + iteration;
        Schema existingModel = schemas.get(tryName);
        if (existingModel != null) {
            if (existingModel.get$ref() != null) {
                existingModel = null;
            } else if (!newSchema.equals(existingModel)) {
                if (this.cache.getResolutionCache().get(newSchema.get$ref()) != null) {
                    return tryName;
                }
                LOGGER.debug("A model for " + existingModel + " already exists");
                return this.finalNameRec(schemas, possiblyConflictingDefinitionName, newSchema, ++iteration);
            }
        } else if (existingModel == null) {
            for (String name : schemas.keySet()) {
                if (!name.toLowerCase().equals(tryName.toLowerCase())) continue;
                existingModel = schemas.get(name);
                tryName = name;
                break;
            }
        }
        return tryName;
    }

    public String processRefToExternalSchema(String $ref, RefFormat refFormat) {
        Map<String, Schema> schemas;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Schema schema = this.cache.loadRef($ref, refFormat, Schema.class);
        if (schema == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((schemas = this.openAPI.getComponents().getSchemas()) == null) {
            schemas = new LinkedHashMap<String, Schema>();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        String newRef = this.finalNameRec(schemas, possiblyConflictingDefinitionName, schema, 0);
        this.cache.putRenamedRef($ref, newRef);
        Schema existingModel = schemas.get(newRef);
        if (existingModel != null && existingModel.get$ref() != null) {
            existingModel = null;
        }
        if (existingModel == null) {
            this.openAPI.getComponents().addSchemas(newRef, schema);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (schema.get$ref() != null) {
                RefFormat ref = RefUtils.computeRefFormat(schema.get$ref());
                if (RefUtils.isAnExternalRefFormat(ref)) {
                    if (!ref.equals((Object)RefFormat.URL)) {
                        String parent;
                        String schemaFullRef = schema.get$ref();
                        String string = parent = file2.contains("/") ? file2.substring(0, file2.lastIndexOf(47)) : "";
                        if (!parent.isEmpty() && !schemaFullRef.startsWith("/")) {
                            if (schemaFullRef.contains("#/")) {
                                String[] parts = schemaFullRef.split("#/");
                                String schemaFullRefFilePart = parts[0];
                                String schemaFullRefInternalRefPart = parts[1];
                                schemaFullRef = Paths.get(parent, schemaFullRefFilePart).normalize() + "#/" + schemaFullRefInternalRefPart;
                            } else {
                                schemaFullRef = Paths.get(parent, schemaFullRef).normalize().toString();
                            }
                            schemaFullRef = FilenameUtils.separatorsToUnix(schemaFullRef);
                        }
                        schema.set$ref(this.processRefToExternalSchema(schemaFullRef, ref));
                    }
                } else {
                    this.processRefToExternalSchema(file2 + schema.get$ref(), RefFormat.RELATIVE);
                }
            }
            if (schema instanceof ComposedSchema) {
                ComposedSchema composedSchema = (ComposedSchema)schema;
                this.processComposedSchema(composedSchema, file2);
            }
            Map<String, Schema> subProps = schema.getProperties();
            this.processProperties(subProps, file2);
            this.processDiscriminator(schema.getDiscriminator(), file2);
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                Schema additionalProperty = (Schema)schema.getAdditionalProperties();
                if (additionalProperty.get$ref() != null) {
                    this.processRefSchema(additionalProperty, file2);
                } else if (additionalProperty instanceof ArraySchema) {
                    ArraySchema arrayProp = (ArraySchema)additionalProperty;
                    if (arrayProp.getItems() != null && arrayProp.getItems().get$ref() != null && StringUtils.isNotBlank(arrayProp.get$ref())) {
                        this.processRefSchema(arrayProp.getItems(), file2);
                    }
                } else if (additionalProperty.getAdditionalProperties() != null && additionalProperty.getAdditionalProperties() instanceof Schema) {
                    Schema mapProp = (Schema)additionalProperty.getAdditionalProperties();
                    if (mapProp.get$ref() != null) {
                        this.processRefSchema(mapProp, file2);
                    } else if (mapProp.getAdditionalProperties() instanceof ArraySchema && ((ArraySchema)mapProp).getItems() != null && ((ArraySchema)mapProp).getItems().get$ref() != null && StringUtils.isNotBlank(((ArraySchema)mapProp).getItems().get$ref())) {
                        this.processRefSchema(((ArraySchema)mapProp).getItems(), file2);
                    }
                }
            }
            if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems() != null) {
                ArraySchema arraySchema = (ArraySchema)schema;
                if (StringUtils.isNotBlank(arraySchema.getItems().get$ref())) {
                    this.processRefSchema(((ArraySchema)schema).getItems(), file2);
                } else {
                    if (arraySchema.getItems() instanceof ComposedSchema) {
                        ComposedSchema composedSchema = (ComposedSchema)arraySchema.getItems();
                        this.processComposedSchema(composedSchema, file2);
                    }
                    this.processProperties(arraySchema.getItems().getProperties(), file2);
                }
            }
        }
        return newRef;
    }

    private void processComposedSchema(ComposedSchema composedSchema, String file2) {
        if (composedSchema.getAllOf() != null) {
            for (Schema item : composedSchema.getAllOf()) {
                if (item.get$ref() != null) {
                    this.processRefSchema(item, file2);
                    continue;
                }
                this.processSchema(item, file2);
            }
        }
        if (composedSchema.getOneOf() != null) {
            for (Schema item : composedSchema.getOneOf()) {
                if (item.get$ref() != null) {
                    this.processRefSchema(item, file2);
                    continue;
                }
                this.processSchema(item, file2);
            }
        }
        if (composedSchema.getAnyOf() != null) {
            for (Schema item : composedSchema.getAnyOf()) {
                if (item.get$ref() != null) {
                    this.processRefSchema(item, file2);
                    continue;
                }
                this.processSchema(item, file2);
            }
        }
    }

    private void processSchema(Schema property2, String file2) {
        if (property2 != null) {
            if (StringUtils.isNotBlank(property2.get$ref())) {
                this.processRefSchema(property2, file2);
            }
            if (property2.getProperties() != null) {
                this.processProperties(property2.getProperties(), file2);
            }
            if (property2 instanceof ArraySchema) {
                this.processSchema(((ArraySchema)property2).getItems(), file2);
            }
            if (property2.getAdditionalProperties() instanceof Schema) {
                this.processSchema((Schema)property2.getAdditionalProperties(), file2);
            }
            if (property2 instanceof ComposedSchema) {
                ComposedSchema composed = (ComposedSchema)property2;
                Map<String, String> refMap = Optional.ofNullable(composed.getDiscriminator()).map(Discriminator::getMapping).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                Map refCache = !refMap.isEmpty() && (composed.getAnyOf() != null || composed.getOneOf() != null) ? Stream.of(composed.getAnyOf(), composed.getOneOf()).filter(Objects::nonNull).filter(l -> !l.isEmpty()).flatMap(Collection::stream).filter(s2 -> s2.get$ref() != null).collect(Collectors.toMap(Schema::get$ref, Function.identity())) : Collections.emptyMap();
                this.processProperties(composed.getAllOf(), file2);
                this.processProperties(composed.getAnyOf(), file2);
                this.processProperties(composed.getOneOf(), file2);
                if (!refMap.isEmpty() && !refCache.isEmpty()) {
                    refCache.entrySet().stream().filter(e2 -> !((String)e2.getKey()).equals(((Schema)e2.getValue()).get$ref())).forEach(entry -> {
                        String newRef = ((Schema)entry.getValue()).get$ref();
                        property2.getDiscriminator().getMapping().put((String)refMap.get(entry.getKey()), newRef);
                    });
                }
            }
        }
    }

    private void processProperties(Collection<Schema> properties, String file2) {
        if (properties != null) {
            for (Schema property2 : properties) {
                this.processSchema(property2, file2);
            }
        }
    }

    private void processProperties(Map<String, Schema> properties, String file2) {
        if (properties != null) {
            this.processProperties(properties.values(), file2);
        }
    }

    public PathItem processRefToExternalPathItem(String $ref, RefFormat refFormat) {
        PathItem pathItem = this.cache.loadRef($ref, refFormat, PathItem.class);
        LinkedHashMap paths = this.openAPI.getPaths();
        if (paths == null) {
            paths = new LinkedHashMap();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        PathItem existingPathItem = (PathItem)paths.get("/" + possiblyConflictingDefinitionName);
        if (existingPathItem != null) {
            LOGGER.debug("A model for " + existingPathItem + " already exists");
            if (existingPathItem.get$ref() != null) {
                existingPathItem = null;
            } else {
                return pathItem;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (pathItem != null) {
            this.processPathItem(pathItem, $ref);
        }
        return pathItem;
    }

    private void processPathItem(PathItem pathItem, String $ref) {
        if (pathItem.readOperationsMap() != null) {
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                List<Parameter> parameters2;
                RequestBody body2;
                ApiResponses responses2;
                Operation operation = operationMap.get((Object)httpMethod);
                if (operation.getResponses() != null && (responses2 = operation.getResponses()) != null) {
                    for (String responseCode : responses2.keySet()) {
                        ApiResponse response2 = (ApiResponse)responses2.get(responseCode);
                        if (response2 == null) continue;
                        Schema schema = null;
                        if (response2.getContent() != null) {
                            Content content2 = response2.getContent();
                            for (String mediaName : content2.keySet()) {
                                MediaType mediaType = (MediaType)content2.get(mediaName);
                                if (mediaType.getSchema() == null) continue;
                                schema = mediaType.getSchema();
                                if (schema != null) {
                                    this.processRefSchemaObject(mediaType.getSchema(), $ref);
                                }
                                if (mediaType.getExamples() == null) continue;
                                this.processRefExamples(mediaType.getExamples(), $ref);
                            }
                        }
                        if (response2.getLinks() != null) {
                            this.processRefLinks(response2.getLinks(), $ref);
                        }
                        if (response2.getHeaders() == null) continue;
                        this.processRefHeaders(response2.getHeaders(), $ref);
                    }
                }
                if (operation.getRequestBody() != null && (body2 = operation.getRequestBody()).getContent() != null) {
                    Content content3 = body2.getContent();
                    for (String mediaName : content3.keySet()) {
                        Schema schema;
                        MediaType mediaType = (MediaType)content3.get(mediaName);
                        if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                        this.processRefSchemaObject(mediaType.getSchema(), $ref);
                    }
                }
                if ((parameters2 = operation.getParameters()) == null) continue;
                parameters2.stream().filter(parameter -> parameter.getSchema() != null).forEach(parameter -> this.processRefSchemaObject(parameter.getSchema(), $ref));
            }
        }
    }

    private void processDiscriminator(Discriminator d2, String file2) {
        if (d2 != null && d2.getMapping() != null) {
            this.processDiscriminatorMapping(d2.getMapping(), file2);
        }
    }

    private void processDiscriminatorMapping(Map<String, String> mapping, String file2) {
        for (String key2 : mapping.keySet()) {
            String ref = mapping.get(key2);
            Schema subtype = new Schema().$ref(ref);
            this.processSchema(subtype, file2);
            mapping.put(key2, subtype.get$ref());
        }
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        ApiResponse existingResponse;
        Map<String, ApiResponse> responses2;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        ApiResponse response2 = this.cache.loadRef($ref, refFormat, ApiResponse.class);
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((responses2 = this.openAPI.getComponents().getResponses()) == null) {
            responses2 = new LinkedHashMap<String, ApiResponse>();
        }
        if ((existingResponse = responses2.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingResponse + " already exists");
            if (existingResponse.get$ref() != null) {
                existingResponse = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingResponse == null) {
            this.openAPI.getComponents().addResponses(newRef, response2);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (response2.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(response2.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    String parent;
                    String fullRef = response2.get$ref();
                    if (!format2.equals((Object)RefFormat.URL) && !(parent = file2.substring(0, file2.lastIndexOf(47))).isEmpty()) {
                        if (fullRef.contains("#/")) {
                            String[] parts = fullRef.split("#/");
                            String fullRefFilePart = parts[0];
                            String fullRefInternalRefPart = parts[1];
                            fullRef = Paths.get(parent, fullRefFilePart).normalize().toString() + "#/" + fullRefInternalRefPart;
                        } else {
                            fullRef = Paths.get(parent, fullRef).normalize().toString();
                        }
                    }
                    response2.set$ref(this.processRefToExternalResponse(fullRef, format2));
                } else {
                    this.processRefToExternalResponse(file2 + response2.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        if (response2 != null) {
            if (response2.getContent() != null) {
                this.processRefContent(response2.getContent(), $ref);
            }
            if (response2.getHeaders() != null) {
                this.processRefHeaders(response2.getHeaders(), $ref);
            }
            if (response2.getLinks() != null) {
                this.processRefLinks(response2.getLinks(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalRequestBody(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        RequestBody existingBody;
        Map<String, RequestBody> bodies;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        RequestBody body2 = this.cache.loadRef($ref, refFormat, RequestBody.class);
        if (body2 == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((bodies = this.openAPI.getComponents().getRequestBodies()) == null) {
            bodies = new LinkedHashMap<String, RequestBody>();
        }
        if ((existingBody = bodies.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingBody + " already exists");
            if (existingBody.get$ref() != null) {
                existingBody = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingBody == null) {
            this.openAPI.getComponents().addRequestBodies(newRef, body2);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (body2.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(body2.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    body2.set$ref(this.processRefToExternalRequestBody(body2.get$ref(), format2));
                } else {
                    this.processRefToExternalRequestBody(file2 + body2.get$ref(), RefFormat.RELATIVE);
                }
            } else if (body2.getContent() != null) {
                this.processRefContent(body2.getContent(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalHeader(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Header existingHeader;
        Map<String, Header> headers2;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Header header = this.cache.loadRef($ref, refFormat, Header.class);
        if (header == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((headers2 = this.openAPI.getComponents().getHeaders()) == null) {
            headers2 = new LinkedHashMap<String, Header>();
        }
        if ((existingHeader = headers2.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingHeader + " already exists");
            if (existingHeader.get$ref() != null) {
                existingHeader = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingHeader == null) {
            this.openAPI.getComponents().addHeaders(newRef, header);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (header.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(header.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    header.set$ref(this.processRefToExternalHeader(header.get$ref(), format2));
                } else {
                    this.processRefToExternalHeader(file2 + header.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        if (header != null) {
            if (header.getContent() != null) {
                this.processRefContent(header.getContent(), $ref);
            }
            if (header.getSchema() != null) {
                this.processRefSchemaObject(header.getSchema(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalSecurityScheme(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        SecurityScheme existingSecurityScheme;
        Map<String, SecurityScheme> securitySchemeMap;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        SecurityScheme securityScheme = this.cache.loadRef($ref, refFormat, SecurityScheme.class);
        if (securityScheme == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((securitySchemeMap = this.openAPI.getComponents().getSecuritySchemes()) == null) {
            securitySchemeMap = new LinkedHashMap<String, SecurityScheme>();
        }
        if ((existingSecurityScheme = securitySchemeMap.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingSecurityScheme + " already exists");
            if (existingSecurityScheme.get$ref() != null) {
                existingSecurityScheme = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingSecurityScheme == null) {
            this.openAPI.getComponents().addSecuritySchemes(newRef, securityScheme);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (securityScheme.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(securityScheme.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    securityScheme.set$ref(this.processRefToExternalSecurityScheme(securityScheme.get$ref(), format2));
                } else {
                    this.processRefToExternalSecurityScheme(file2 + securityScheme.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalLink(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Link existingLink;
        Map<String, Link> links;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Link link = this.cache.loadRef($ref, refFormat, Link.class);
        if (link == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((links = this.openAPI.getComponents().getLinks()) == null) {
            links = new LinkedHashMap<String, Link>();
        }
        if ((existingLink = links.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingLink + " already exists");
            if (existingLink.get$ref() != null) {
                existingLink = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingLink == null) {
            this.openAPI.getComponents().addLinks(newRef, link);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (link.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(link.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    link.set$ref(this.processRefToExternalLink(link.get$ref(), format2));
                } else {
                    this.processRefToExternalLink(file2 + link.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalExample(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Example existingExample;
        Map<String, Example> examples;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Example example = this.cache.loadRef($ref, refFormat, Example.class);
        if (example == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((examples = this.openAPI.getComponents().getExamples()) == null) {
            examples = new LinkedHashMap<String, Example>();
        }
        if ((existingExample = examples.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingExample + " already exists");
            if (existingExample.get$ref() != null) {
                existingExample = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingExample == null) {
            this.openAPI.getComponents().addExamples(newRef, example);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (example.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(example.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    example.set$ref(this.processRefToExternalExample(example.get$ref(), format2));
                } else {
                    this.processRefToExternalExample(file2 + example.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalParameter(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Parameter existingParameters;
        Map<String, Parameter> parameters2;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Parameter parameter = this.cache.loadRef($ref, refFormat, Parameter.class);
        if (parameter == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((parameters2 = this.openAPI.getComponents().getParameters()) == null) {
            parameters2 = new LinkedHashMap<String, Parameter>();
        }
        if ((existingParameters = parameters2.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingParameters + " already exists");
            if (existingParameters.get$ref() != null) {
                existingParameters = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingParameters == null) {
            this.openAPI.getComponents().addParameters(newRef, parameter);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (parameter.get$ref() != null) {
                RefFormat format2 = RefUtils.computeRefFormat(parameter.get$ref());
                if (RefUtils.isAnExternalRefFormat(format2)) {
                    String parent;
                    String fullRef = parameter.get$ref();
                    if (!format2.equals((Object)RefFormat.URL) && !(parent = file2.substring(0, file2.lastIndexOf(47))).isEmpty()) {
                        if (fullRef.contains("#/")) {
                            String[] parts = fullRef.split("#/");
                            String fullRefFilePart = parts[0];
                            String fullRefInternalRefPart = parts[1];
                            fullRef = Paths.get(parent, fullRefFilePart).normalize().toString() + "#/" + fullRefInternalRefPart;
                        } else {
                            fullRef = Paths.get(parent, fullRef).normalize().toString();
                        }
                    }
                    parameter.set$ref(this.processRefToExternalParameter(fullRef, format2));
                } else {
                    this.processRefToExternalParameter(file2 + parameter.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        if (parameter != null) {
            if (parameter.getContent() != null) {
                this.processRefContent(parameter.getContent(), $ref);
            }
            if (parameter.getSchema() != null) {
                this.processRefSchemaObject(parameter.getSchema(), $ref);
            }
            if (parameter.getExamples() != null) {
                this.processRefExamples(parameter.getExamples(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalCallback(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Callback existingCallback;
        Map<String, Callback> callbacks;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Callback callback2 = this.cache.loadRef($ref, refFormat, Callback.class);
        if (callback2 == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((callbacks = this.openAPI.getComponents().getCallbacks()) == null) {
            callbacks = new LinkedHashMap<String, Callback>();
        }
        if ((existingCallback = callbacks.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingCallback + " already exists");
            if (existingCallback.get$ref() != null) {
                existingCallback = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingCallback == null) {
            this.openAPI.getComponents().addCallbacks(newRef, callback2);
            this.cache.addReferencedKey(newRef);
            String file2 = $ref.split("#/")[0];
            if (callback2.get$ref() != null) {
                if (callback2.get$ref() != null) {
                    RefFormat format2 = RefUtils.computeRefFormat(callback2.get$ref());
                    if (RefUtils.isAnExternalRefFormat(format2)) {
                        callback2.set$ref(this.processRefToExternalCallback(callback2.get$ref(), format2));
                    } else {
                        this.processRefToExternalCallback(file2 + callback2.get$ref(), RefFormat.RELATIVE);
                    }
                }
            } else {
                for (String path2 : callback2.keySet()) {
                    PathItem pathItem = (PathItem)callback2.get(path2);
                    if (pathItem == null) continue;
                    if (pathItem.get$ref() != null) {
                        RefFormat pathRefFormat = RefUtils.computeRefFormat(pathItem.get$ref());
                        String path$ref = pathItem.get$ref();
                        pathItem = RefUtils.isAnExternalRefFormat(refFormat) ? this.processRefToExternalPathItem(path$ref, pathRefFormat) : this.cache.loadRef(pathItem.get$ref(), refFormat, PathItem.class);
                        callback2.put(path2, pathItem);
                        continue;
                    }
                    this.processPathItem(pathItem, $ref);
                }
            }
        }
        return newRef;
    }

    private void processRefContent(Map<String, MediaType> content2, String $ref) {
        for (MediaType mediaType : content2.values()) {
            if (mediaType.getSchema() != null) {
                this.processRefSchemaObject(mediaType.getSchema(), $ref);
            }
            if (mediaType.getExamples() == null) continue;
            this.processRefExamples(mediaType.getExamples(), $ref);
        }
    }

    private void processRefExamples(Map<String, Example> examples, String $ref) {
        String file2 = $ref.split("#/")[0];
        for (Example example : examples.values()) {
            if (example.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(example.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefExample(example, $ref);
                continue;
            }
            this.processRefToExternalExample(file2 + example.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefExample(Example example, String externalFile) {
        RefFormat format2 = RefUtils.computeRefFormat(example.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format2)) {
            example.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + example.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = example.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(example.get$ref()).orElse(null);
        if (format2.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, example.get$ref());
            example.set$ref($ref);
        } else {
            this.processRefToExternalExample($ref, format2);
        }
    }

    private void processRefSchemaObject(Schema schema, String $ref) {
        String file2 = $ref.split("#/")[0];
        if (schema.get$ref() != null) {
            RefFormat ref = RefUtils.computeRefFormat(schema.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefSchema(schema, file2);
            } else {
                this.processRefToExternalSchema(file2 + schema.get$ref(), RefFormat.RELATIVE);
            }
        } else {
            this.processSchema(schema, file2);
        }
    }

    private void processRefHeaders(Map<String, Header> headers2, String $ref) {
        String file2 = $ref.split("#/")[0];
        for (Header header : headers2.values()) {
            if (header.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(header.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefHeader(header, $ref);
                continue;
            }
            this.processRefToExternalHeader(file2 + header.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefLinks(Map<String, Link> links, String $ref) {
        String file2 = $ref.split("#/")[0];
        for (Link link : links.values()) {
            if (link.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(link.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefLink(link, $ref);
                continue;
            }
            this.processRefToExternalLink(file2 + link.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefSchema(Schema subRef, String externalFile) {
        RefFormat format2 = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format2)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format2.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalSchema($ref, format2);
        }
    }

    protected String constructRef(Schema refProperty, String rootLocation) {
        String ref = refProperty.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    private void processRefHeader(Header subRef, String externalFile) {
        RefFormat format2 = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format2)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format2.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalHeader($ref, format2);
        }
    }

    private void processRefLink(Link subRef, String externalFile) {
        RefFormat format2 = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format2)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format2.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalLink($ref, format2);
        }
    }

    public static String join(String source2, String fragment) {
        try {
            boolean isRelative = false;
            if (source2.startsWith("/") || source2.startsWith(".")) {
                isRelative = true;
            }
            URI uri2 = new URI(source2);
            if (!source2.endsWith("/") && fragment.startsWith("./") && "".equals(uri2.getPath())) {
                uri2 = new URI(source2 + "/");
            } else if ("".equals(uri2.getPath()) && !fragment.startsWith("/")) {
                uri2 = new URI(source2 + "/");
            }
            URI f2 = new URI(fragment);
            URI resolved2 = uri2.resolve(f2);
            URI normalized = resolved2.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e2) {
            return source2;
        }
    }
}

