/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.processors.RequestBodyProcessor;
import io.swagger.v3.parser.processors.ResponseProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ResponseProcessor responseProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this(cache2, openAPI, false);
    }

    public OperationProcessor(ResolverCache cache2, OpenAPI openAPI, boolean openapi31) {
        this.parameterProcessor = new ParameterProcessor(cache2, openAPI, openapi31);
        this.responseProcessor = new ResponseProcessor(cache2, openAPI, openapi31);
        this.requestBodyProcessor = new RequestBodyProcessor(cache2, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache2, openAPI);
        this.cache = cache2;
    }

    public void processOperation(Operation operation) {
        Map<String, Callback> callbacks;
        ApiResponses responses2;
        Object requestBody2;
        List<Parameter> processedOperationParameters;
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
        if ((processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters())) != null) {
            operation.setParameters(processedOperationParameters);
        }
        if ((requestBody2 = operation.getRequestBody()) != null) {
            if (((RequestBody)requestBody2).get$ref() != null && this.cache != null && this.cache.getParseOptions() != null && this.cache.getParseOptions().isResolveRequestBody()) {
                this.requestBodyProcessor.processRequestBody((RequestBody)requestBody2);
                RefFormat refFormat = RefUtils.computeRefFormat(((RequestBody)requestBody2).get$ref());
                RequestBody resolvedRequestBody = this.cache.loadRef(((RequestBody)requestBody2).get$ref(), refFormat, RequestBody.class);
                if (resolvedRequestBody != null) {
                    requestBody2 = resolvedRequestBody;
                    operation.setRequestBody(resolvedRequestBody);
                }
            }
            this.requestBodyProcessor.processRequestBody((RequestBody)requestBody2);
        }
        if ((responses2 = operation.getResponses()) != null) {
            for (String responseCode : responses2.keySet()) {
                ApiResponse response2 = (ApiResponse)responses2.get(responseCode);
                if (response2 == null) continue;
                if (response2.get$ref() != null && this.cache != null && this.cache.getParseOptions() != null && this.cache.getParseOptions().isResolveResponses()) {
                    this.responseProcessor.processResponse(response2);
                    RefFormat refFormat = RefUtils.computeRefFormat(response2.get$ref());
                    ApiResponse resolvedResponse = this.cache.loadRef(response2.get$ref(), refFormat, ApiResponse.class);
                    if (resolvedResponse != null) {
                        response2 = resolvedResponse;
                        responses2.put(responseCode, resolvedResponse);
                    }
                }
                this.responseProcessor.processResponse(response2);
            }
        }
        if ((callbacks = operation.getCallbacks()) != null) {
            for (String name : callbacks.keySet()) {
                String newRef;
                String $ref;
                RefFormat refFormat;
                Callback callback2 = callbacks.get(name);
                if (callback2 == null) continue;
                if (callback2.get$ref() != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat($ref = callback2.get$ref())) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
                    callback2.set$ref(newRef);
                }
                for (String callbackName : callback2.keySet()) {
                    PathItem pathItem = (PathItem)callback2.get(callbackName);
                    Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
                    for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                        Operation op = operationMap.get((Object)httpMethod);
                        this.processOperation(op);
                    }
                    List<Parameter> parameters2 = pathItem.getParameters();
                    if (parameters2 == null) continue;
                    for (Parameter parameter : parameters2) {
                        this.parameterProcessor.processParameter(parameter);
                    }
                }
            }
        }
    }
}

