/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class PathsProcessor {
    private final OpenAPI openAPI;
    private final ResolverCache cache;
    private final OpenAPIResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public PathsProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this(cache2, openAPI, new OpenAPIResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache2, OpenAPI openAPI, OpenAPIResolver.Settings settings) {
        this(cache2, openAPI, settings, false);
    }

    public PathsProcessor(ResolverCache cache2, OpenAPI openAPI, OpenAPIResolver.Settings settings, boolean openapi31) {
        this.openAPI = openAPI;
        this.cache = cache2;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache2, openAPI, openapi31);
        this.operationProcessor = new OperationProcessor(cache2, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache2, openAPI);
    }

    public void processPaths() {
        Paths pathMap = this.openAPI.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            PathItem pathItem = (PathItem)pathMap.get(pathStr);
            if (pathItem.get$ref() != null) {
                PathItem resolvedPath = this.processReferencePath(pathItem);
                String pathRef = pathItem.get$ref().split("#")[0];
                if (resolvedPath != null) {
                    this.updateRefs(resolvedPath, pathRef);
                    this.openAPI.path(pathStr, resolvedPath);
                    pathItem = resolvedPath;
                }
            }
            this.addParametersToEachOperation(pathItem);
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(pathItem.getParameters());
            pathItem.setParameters(processedPathParameters);
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    private void addParametersToEachOperation(PathItem pathItem) {
        if (this.settings.addParametersToEachOperation()) {
            List<Operation> operations;
            List<Parameter> parameters2 = pathItem.getParameters();
            if (parameters2 != null && (operations = pathItem.readOperations()) != null) {
                for (Operation operation : operations) {
                    ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                    List<Parameter> existingParameters = operation.getParameters();
                    if (existingParameters == null) {
                        existingParameters = new ArrayList<Parameter>();
                        operation.setParameters(existingParameters);
                    }
                    for (Parameter parameterToAdd : parameters2) {
                        boolean matched = false;
                        for (Parameter existingParameter : existingParameters) {
                            if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                        }
                        if (matched) continue;
                        parametersToAdd.add(parameterToAdd);
                    }
                    if (parametersToAdd.size() <= 0) continue;
                    operation.getParameters().addAll(0, parametersToAdd);
                }
            }
            pathItem.setParameters(null);
        }
    }

    protected void updateRefs(PathItem path2, String pathRef) {
        if (path2.getParameters() != null) {
            List<Parameter> params = path2.getParameters();
            for (Parameter param : params) {
                this.updateRefs(param, pathRef);
            }
        }
        List<Operation> ops = path2.readOperations();
        for (Operation op : ops) {
            if (op.getParameters() != null) {
                for (Parameter param : op.getParameters()) {
                    this.updateRefs(param, pathRef);
                }
            }
            if (op.getResponses() != null) {
                for (ApiResponse response2 : op.getResponses().values()) {
                    this.updateRefs(response2, pathRef);
                }
            }
            if (op.getRequestBody() != null) {
                this.updateRefs(op.getRequestBody(), pathRef);
            }
            if (op.getCallbacks() == null) continue;
            Map<String, Callback> callbacks = op.getCallbacks();
            for (String name : callbacks.keySet()) {
                Callback callback2 = callbacks.get(name);
                if (callback2 == null) continue;
                if (callback2.get$ref() != null) {
                    callback2.set$ref(this.computeRef(callback2.get$ref(), pathRef));
                }
                for (String callbackName : callback2.keySet()) {
                    PathItem pathItem = (PathItem)callback2.get(callbackName);
                    this.updateRefs(pathItem, pathRef);
                }
            }
        }
    }

    protected void updateRefs(ApiResponse response2, String pathRef) {
        if (response2.get$ref() != null) {
            response2.set$ref(this.computeRef(response2.get$ref(), pathRef));
        }
        if (response2.getContent() != null) {
            Content content2 = response2.getContent();
            for (String key2 : content2.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content2.get(key2);
                if (mediaType.getSchema() != null) {
                    this.updateRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content2.get(key2)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateRefs(example, pathRef);
                }
            }
        }
    }

    protected void updateRefs(Example example, String pathRef) {
        if (example.get$ref() != null) {
            example.set$ref(this.computeRef(example.get$ref(), pathRef));
        }
    }

    protected void updateRefs(Parameter param, String pathRef) {
        if (param.get$ref() != null) {
            param.set$ref(this.computeRef(param.get$ref(), pathRef));
        }
        if (param.getSchema() != null) {
            this.updateRefs(param.getSchema(), pathRef);
        }
        if (param.getContent() != null) {
            Content content2 = param.getContent();
            for (String key2 : content2.keySet()) {
                MediaType mediaType = (MediaType)content2.get(key2);
                if (mediaType.getSchema() == null) continue;
                this.updateRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateRefs(RequestBody body2, String pathRef) {
        if (body2.get$ref() != null) {
            body2.set$ref(this.computeRef(body2.get$ref(), pathRef));
        }
        if (body2.getContent() != null) {
            Content content2 = body2.getContent();
            for (String key2 : content2.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content2.get(key2);
                if (mediaType.getSchema() != null) {
                    this.updateRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content2.get(key2)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateRefs(example, pathRef);
                }
            }
        } else if (body2.get$ref() != null) {
            // empty if block
        }
    }

    protected void updateRefs(Schema model, String pathRef) {
        ArraySchema arraySchema;
        if (model.get$ref() != null) {
            model.set$ref(this.computeRef(model.get$ref(), pathRef));
        } else if (model.getProperties() != null) {
            if (model.getProperties() != null) {
                Map<String, Schema> properties = model.getProperties();
                for (String key2 : properties.keySet()) {
                    Schema property2 = properties.get(key2);
                    if (property2 == null) continue;
                    this.updateRefs(property2, pathRef);
                }
            }
        } else if (model instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            if (composedSchema.getAllOf() != null) {
                for (Schema innerModel2 : composedSchema.getAllOf()) {
                    this.updateRefs(innerModel2, pathRef);
                }
            }
            if (composedSchema.getAnyOf() != null || composedSchema.getOneOf() != null) {
                HashMap refMappings = composedSchema.getDiscriminator() != null && composedSchema.getDiscriminator().getMapping() != null ? new HashMap() : null;
                Stream.of(composedSchema.getAnyOf(), composedSchema.getOneOf()).filter(Objects::nonNull).filter(l -> !l.isEmpty()).flatMap(Collection::stream).forEach(innerModel -> {
                    String oldRef = innerModel.get$ref();
                    this.updateRefs((Schema)innerModel, pathRef);
                    if (oldRef != null && refMappings != null && !oldRef.equals(innerModel.get$ref())) {
                        refMappings.put(oldRef, innerModel.get$ref());
                    }
                });
                if (refMappings != null && !refMappings.isEmpty()) {
                    Map<String, String> discriminatorMappings = composedSchema.getDiscriminator().getMapping();
                    for (String key3 : discriminatorMappings.keySet()) {
                        if (!refMappings.containsKey(discriminatorMappings.get(key3))) continue;
                        discriminatorMappings.put(key3, (String)refMappings.get(discriminatorMappings.get(key3)));
                    }
                }
            }
        } else if (model instanceof ArraySchema && (arraySchema = (ArraySchema)model).getItems() != null) {
            this.updateRefs(arraySchema.getItems(), pathRef);
        }
    }

    protected boolean isLocalRef(String ref) {
        return ref.startsWith("#");
    }

    protected boolean isAbsoluteRef(String ref) {
        return !ref.startsWith(".");
    }

    private boolean isInternalSchemaRef(String $ref) {
        return $ref.startsWith("#/components/schemas");
    }

    protected String computeRef(String ref, String prefix2) {
        if (this.isLocalRef(ref) && !this.isInternalSchemaRef(ref)) {
            return this.computeLocalRef(ref, prefix2);
        }
        if (this.isAbsoluteRef(ref)) {
            return ref;
        }
        if (this.isInternalSchemaRef(ref)) {
            return ref;
        }
        return this.computeRelativeRef(ref, prefix2);
    }

    protected String computeRelativeRef(String ref, String prefix2) {
        if (ref.startsWith("./")) {
            return ref;
        }
        int iIdxOfSlash = prefix2.lastIndexOf(47);
        if (iIdxOfSlash != -1) {
            return prefix2.substring(0, iIdxOfSlash + 1) + ref;
        }
        return prefix2 + ref;
    }

    protected String computeLocalRef(String ref, String prefix2) {
        return prefix2 + ref;
    }

    public PathItem processReferencePath(PathItem pathItem) {
        RefFormat refFormat = RefUtils.computeRefFormat(pathItem.get$ref());
        String $ref = pathItem.get$ref();
        pathItem = RefUtils.isAnExternalRefFormat(refFormat) ? this.externalRefProcessor.processRefToExternalPathItem($ref, refFormat) : this.cache.loadRef(pathItem.get$ref(), refFormat, PathItem.class);
        return pathItem;
    }
}

