/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExampleProcessor;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.SchemaProcessor;
import io.swagger.v3.parser.util.RefUtils;

public class RequestBodyProcessor {
    private final SchemaProcessor schemaProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public RequestBodyProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this(cache2, openAPI, false);
    }

    public RequestBodyProcessor(ResolverCache cache2, OpenAPI openAPI, boolean openapi31) {
        this.schemaProcessor = new SchemaProcessor(cache2, openAPI, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache2, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache2, openAPI);
        this.cache = cache2;
        this.openAPI = openAPI;
    }

    public void processRequestBody(RequestBody requestBody2) {
        if (requestBody2.get$ref() != null) {
            this.processReferenceRequestBody(requestBody2);
        }
        Schema schema = null;
        if (requestBody2.getContent() != null) {
            Content content2 = requestBody2.getContent();
            for (String mediaName : content2.keySet()) {
                MediaType mediaType = (MediaType)content2.get(mediaName);
                if (mediaType.getSchema() != null && (schema = mediaType.getSchema()) != null) {
                    this.schemaProcessor.processSchema(schema);
                }
                if (mediaType.getExamples() == null) continue;
                for (Example ex : mediaType.getExamples().values()) {
                    this.exampleProcessor.processExample(ex);
                }
            }
        }
    }

    public void processReferenceRequestBody(RequestBody requestBody2) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody2.get$ref());
        String $ref = requestBody2.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalRequestBody($ref, refFormat)) != null) {
            requestBody2.set$ref(newRef);
        }
    }
}

