/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.util.RefUtils;

public class SecuritySchemeProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public SecuritySchemeProcessor(ResolverCache cache2, OpenAPI openAPI) {
        this.cache = cache2;
        this.openAPI = openAPI;
        this.externalRefProcessor = new ExternalRefProcessor(cache2, openAPI);
    }

    public SecurityScheme processSecurityScheme(SecurityScheme securityScheme) {
        if (securityScheme.get$ref() != null) {
            RefFormat refFormat = RefUtils.computeRefFormat(securityScheme.get$ref());
            String $ref = securityScheme.get$ref();
            SecurityScheme newSecurityScheme = this.cache.loadRef($ref, refFormat, SecurityScheme.class);
            if (newSecurityScheme != null) {
                return newSecurityScheme;
            }
        }
        return securityScheme;
    }
}

