/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.ReferenceUtils;
import io.swagger.v3.parser.reference.Traverser;
import io.swagger.v3.parser.reference.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class IdsTraverser
implements Traverser {
    private DereferencerContext context;
    public Set<Object> visiting = new HashSet<Object>();
    protected HashMap<Object, Object> visitedMap = new HashMap();

    public IdsTraverser(DereferencerContext context) {
        this.context = context;
    }

    public DereferencerContext getContext() {
        return this.context;
    }

    public void setContext(DereferencerContext context) {
        this.context = context;
    }

    public IdsTraverser context(DereferencerContext context) {
        this.context = context;
        return this;
    }

    @Override
    public OpenAPI traverse(OpenAPI openAPI, Visitor visitor2) throws Exception {
        return this.traverseOpenApi(openAPI, visitor2);
    }

    public OpenAPI traverseOpenApi(OpenAPI openAPI, Visitor visitor2) {
        Components components;
        if (openAPI == null) {
            return null;
        }
        if (this.visiting.contains(openAPI)) {
            return openAPI;
        }
        if (this.visitedMap.containsKey(openAPI)) {
            return (OpenAPI)this.visitedMap.get(openAPI);
        }
        this.visiting.add(openAPI);
        OpenAPI resolved2 = openAPI;
        Paths paths = this.traversePaths(resolved2.getPaths(), visitor2);
        if (paths != null) {
            resolved2.paths(paths);
        }
        if ((components = this.traverseComponents(resolved2.getComponents(), visitor2)) != null) {
            resolved2.components(components);
        }
        this.traverseMap(resolved2.getWebhooks(), visitor2, this::traversePathItem);
        this.visitedMap.put(openAPI, resolved2);
        this.visiting.remove(openAPI);
        return resolved2;
    }

    public Components traverseComponents(Components components, Visitor visitor2) {
        if (components == null) {
            return null;
        }
        if (this.visiting.contains(components)) {
            return components;
        }
        if (this.visitedMap.containsKey(components)) {
            return (Components)this.visitedMap.get(components);
        }
        this.visiting.add(components);
        Components resolved2 = components;
        this.traverseMap(resolved2.getPathItems(), visitor2, this::traversePathItem);
        this.traverseMap(resolved2.getParameters(), visitor2, this::traverseParameter);
        this.traverseMap(resolved2.getCallbacks(), visitor2, this::traverseCallback);
        this.traverseMap(resolved2.getRequestBodies(), visitor2, this::traverseRequestBody);
        this.traverseMap(resolved2.getSecuritySchemes(), visitor2, this::traverseSecurityScheme);
        this.traverseSchemaMap(resolved2.getSchemas(), visitor2, new ArrayList<String>());
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.traverseMap(resolved2.getLinks(), visitor2, this::traverseLink);
        this.traverseMap(resolved2.getResponses(), visitor2, this::traverseResponse);
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        this.visitedMap.put(components, resolved2);
        this.visiting.remove(components);
        return resolved2;
    }

    public Paths traversePaths(Paths paths, Visitor visitor2) {
        if (paths == null) {
            return null;
        }
        if (this.visiting.contains(paths)) {
            return paths;
        }
        if (this.visitedMap.containsKey(paths)) {
            return (Paths)this.visitedMap.get(paths);
        }
        this.visiting.add(paths);
        Paths resolved2 = paths;
        this.traverseMap(resolved2, visitor2, this::traversePathItem);
        this.visitedMap.put(paths, resolved2);
        this.visiting.remove(paths);
        return resolved2;
    }

    public Operation traverseOperation(Operation operation, Visitor visitor2) {
        ApiResponses resolvedResponses;
        RequestBody resolvedRequestBody;
        if (operation == null) {
            return null;
        }
        if (this.visiting.contains(operation)) {
            return operation;
        }
        if (this.visitedMap.containsKey(operation)) {
            return (Operation)this.visitedMap.get(operation);
        }
        this.visiting.add(operation);
        Operation resolved2 = operation;
        if (resolved2.getParameters() != null) {
            for (int i2 = 0; i2 < resolved2.getParameters().size(); ++i2) {
                Parameter resolvedParameter = this.traverseParameter(resolved2.getParameters().get(i2), visitor2);
                if (resolvedParameter == null) continue;
                resolved2.getParameters().set(i2, resolvedParameter);
            }
        }
        if (resolved2.getRequestBody() != null && (resolvedRequestBody = this.traverseRequestBody(resolved2.getRequestBody(), visitor2)) != null) {
            resolved2.setRequestBody(resolvedRequestBody);
        }
        if (resolved2.getResponses() != null && (resolvedResponses = this.traverseResponses(resolved2.getResponses(), visitor2)) != null) {
            resolved2.setResponses(resolvedResponses);
        }
        this.traverseMap(resolved2.getCallbacks(), visitor2, this::traverseCallback);
        this.visitedMap.put(operation, resolved2);
        this.visiting.remove(operation);
        return resolved2;
    }

    public ApiResponses traverseResponses(ApiResponses responses2, Visitor visitor2) {
        if (responses2 == null) {
            return null;
        }
        if (this.visiting.contains(responses2)) {
            return responses2;
        }
        if (this.visitedMap.containsKey(responses2)) {
            return (ApiResponses)this.visitedMap.get(responses2);
        }
        this.visiting.add(responses2);
        ApiResponses resolved2 = responses2;
        this.traverseMap(resolved2, visitor2, this::traverseResponse);
        this.visitedMap.put(responses2, resolved2);
        this.visiting.remove(responses2);
        return resolved2;
    }

    public ApiResponse traverseResponse(ApiResponse response2, Visitor visitor2) {
        if (response2 == null) {
            return null;
        }
        if (this.visiting.contains(response2)) {
            return response2;
        }
        if (this.visitedMap.containsKey(response2)) {
            return (ApiResponse)this.visitedMap.get(response2);
        }
        this.visiting.add(response2);
        ApiResponse resolved2 = response2;
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.traverseMap(resolved2.getLinks(), visitor2, this::traverseLink);
        this.visitedMap.put(response2, this.deepcopy(resolved2, ApiResponse.class));
        this.visiting.remove(response2);
        return resolved2;
    }

    public RequestBody traverseRequestBody(RequestBody requestBody2, Visitor visitor2) {
        if (requestBody2 == null) {
            return null;
        }
        if (this.visiting.contains(requestBody2)) {
            return requestBody2;
        }
        if (this.visitedMap.containsKey(requestBody2)) {
            return (RequestBody)this.visitedMap.get(requestBody2);
        }
        this.visiting.add(requestBody2);
        RequestBody resolved2 = requestBody2;
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        this.visitedMap.put(requestBody2, this.deepcopy(resolved2, RequestBody.class));
        this.visiting.remove(requestBody2);
        return resolved2;
    }

    public PathItem traversePathItem(PathItem pathItem, Visitor visitor2) {
        Operation traceOp;
        Operation postOp;
        Operation headOp;
        Operation optionsOp;
        Operation patchOp;
        Operation deleteOp;
        Operation putOp;
        if (pathItem == null) {
            return null;
        }
        if (this.visiting.contains(pathItem)) {
            return pathItem;
        }
        if (this.visitedMap.containsKey(pathItem)) {
            return (PathItem)this.visitedMap.get(pathItem);
        }
        this.visiting.add(pathItem);
        PathItem resolved2 = pathItem;
        Operation getOp = resolved2.getGet();
        Operation resolvedOperation = this.traverseOperation(getOp, visitor2);
        if (resolvedOperation != null) {
            resolved2.setGet(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(putOp = resolved2.getPut(), visitor2)) != null) {
            resolved2.setPut(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(deleteOp = resolved2.getDelete(), visitor2)) != null) {
            resolved2.setDelete(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(patchOp = resolved2.getPatch(), visitor2)) != null) {
            resolved2.setPatch(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(optionsOp = resolved2.getOptions(), visitor2)) != null) {
            resolved2.setOptions(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(headOp = resolved2.getHead(), visitor2)) != null) {
            resolved2.setHead(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(postOp = resolved2.getPost(), visitor2)) != null) {
            resolved2.setPost(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(traceOp = resolved2.getTrace(), visitor2)) != null) {
            resolved2.setTrace(resolvedOperation);
        }
        if (resolved2.getParameters() != null) {
            for (int i2 = 0; i2 < resolved2.getParameters().size(); ++i2) {
                Parameter resolvedParameter = this.traverseParameter(resolved2.getParameters().get(i2), visitor2);
                if (resolvedParameter == null) continue;
                resolved2.getParameters().set(i2, resolvedParameter);
            }
        }
        this.visitedMap.put(pathItem, this.deepcopy(resolved2, PathItem.class));
        this.visiting.remove(pathItem);
        return resolved2;
    }

    public Parameter traverseParameter(Parameter parameter, Visitor visitor2) {
        Schema schema;
        if (parameter == null) {
            return null;
        }
        if (this.visiting.contains(parameter)) {
            return parameter;
        }
        if (this.visitedMap.containsKey(parameter)) {
            return (Parameter)this.visitedMap.get(parameter);
        }
        this.visiting.add(parameter);
        Parameter resolved2 = parameter;
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        if (resolved2.getSchema() != null && (schema = this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>())) != null) {
            resolved2.setSchema(schema);
        }
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        this.visitedMap.put(parameter, this.deepcopy(resolved2, Parameter.class));
        this.visiting.remove(parameter);
        return resolved2;
    }

    public Example traverseExample(Example example, Visitor visitor2) {
        if (example == null) {
            return null;
        }
        if (this.visiting.contains(example)) {
            return example;
        }
        if (this.visitedMap.containsKey(example)) {
            return (Example)this.visitedMap.get(example);
        }
        this.visiting.add(example);
        Example resolved2 = example;
        this.visitedMap.put(example, this.deepcopy(resolved2, Example.class));
        this.visiting.remove(example);
        return resolved2;
    }

    public Callback traverseCallback(Callback callback2, Visitor visitor2) {
        if (callback2 == null) {
            return null;
        }
        if (this.visiting.contains(callback2)) {
            return callback2;
        }
        if (this.visitedMap.containsKey(callback2)) {
            return (Callback)this.visitedMap.get(callback2);
        }
        this.visiting.add(callback2);
        this.traverseMap(callback2, visitor2, this::traversePathItem);
        this.visitedMap.put(callback2, callback2);
        this.visiting.remove(callback2);
        return callback2;
    }

    public MediaType traverseMediaType(MediaType mediaType, Visitor visitor2) {
        if (mediaType == null) {
            return null;
        }
        if (this.visiting.contains(mediaType)) {
            return mediaType;
        }
        if (this.visitedMap.containsKey(mediaType)) {
            return (MediaType)this.visitedMap.get(mediaType);
        }
        this.visiting.add(mediaType);
        MediaType resolved2 = mediaType;
        if (resolved2.getSchema() != null) {
            this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>());
        }
        this.traverseMap(resolved2.getEncoding(), visitor2, this::traverseEncoding);
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        this.visitedMap.put(mediaType, resolved2);
        this.visiting.remove(mediaType);
        return resolved2;
    }

    public Encoding traverseEncoding(Encoding encoding, Visitor visitor2) {
        if (encoding == null) {
            return null;
        }
        if (this.visiting.contains(encoding)) {
            return encoding;
        }
        if (this.visitedMap.containsKey(encoding)) {
            return (Encoding)this.visitedMap.get(encoding);
        }
        this.visiting.add(encoding);
        Encoding resolved2 = encoding;
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.visitedMap.put(encoding, resolved2);
        this.visiting.remove(encoding);
        return resolved2;
    }

    public Header traverseHeader(Header header, Visitor visitor2) {
        if (header == null) {
            return null;
        }
        if (this.visiting.contains(header)) {
            return header;
        }
        if (this.visitedMap.containsKey(header)) {
            return (Header)this.visitedMap.get(header);
        }
        this.visiting.add(header);
        Header resolved2 = header;
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        if (resolved2.getSchema() != null) {
            this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>());
        }
        this.visitedMap.put(header, this.deepcopy(resolved2, Header.class));
        this.visiting.remove(header);
        return resolved2;
    }

    public SecurityScheme traverseSecurityScheme(SecurityScheme securityScheme, Visitor visitor2) {
        if (securityScheme == null) {
            return null;
        }
        if (this.visiting.contains(securityScheme)) {
            return securityScheme;
        }
        if (this.visitedMap.containsKey(securityScheme)) {
            return (SecurityScheme)this.visitedMap.get(securityScheme);
        }
        this.visiting.add(securityScheme);
        SecurityScheme resolved2 = securityScheme;
        this.visitedMap.put(securityScheme, this.deepcopy(resolved2, SecurityScheme.class));
        this.visiting.remove(securityScheme);
        return resolved2;
    }

    public Link traverseLink(Link link, Visitor visitor2) {
        if (link == null) {
            return null;
        }
        if (this.visiting.contains(link)) {
            return link;
        }
        if (this.visitedMap.containsKey(link)) {
            return (Link)this.visitedMap.get(link);
        }
        this.visiting.add(link);
        Link resolved2 = link;
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.visitedMap.put(link, this.deepcopy(resolved2, Link.class));
        this.visiting.remove(link);
        return resolved2;
    }

    public Schema traverseSchema(Schema schema, Visitor visitor2, List<String> inheritedIds) {
        Schema resolvedSchema;
        Schema traversedSchema;
        if (schema == null) {
            return null;
        }
        if (this.visiting.contains(schema)) {
            return schema;
        }
        if (this.visitedMap.containsKey(schema)) {
            return (Schema)this.visitedMap.get(schema);
        }
        this.visiting.add(schema);
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.add(schema.get$id());
            try {
                String resolvedURI = this.context.currentUri;
                for (String id : inheritedIds) {
                    String urlWithoutHash = ReferenceUtils.toBaseURI(id);
                    resolvedURI = ReferenceUtils.resolve(urlWithoutHash, resolvedURI);
                    resolvedURI = ReferenceUtils.toBaseURI(resolvedURI);
                }
                this.context.getIdsCache().put(resolvedURI, Json31.pretty(schema));
            }
            catch (Exception resolvedURI) {
                // empty catch block
            }
        }
        Schema resolved2 = schema;
        this.traverseSchemaMap(resolved2.getProperties(), visitor2, inheritedIds);
        if (resolved2.getAdditionalItems() != null && (traversedSchema = this.traverseSchema(resolved2.getAdditionalItems(), visitor2, inheritedIds)) != null) {
            resolved2.setAdditionalItems(traversedSchema);
        }
        if (resolved2.getAdditionalProperties() != null && resolved2.getAdditionalProperties() instanceof Schema && (traversedSchema = this.traverseSchema((Schema)resolved2.getAdditionalProperties(), visitor2, inheritedIds)) != null) {
            resolved2.setAdditionalProperties(traversedSchema);
        }
        if (resolved2.getAllOf() != null) {
            for (int i2 = 0; i2 < resolved2.getAllOf().size(); ++i2) {
                resolvedSchema = this.traverseSchema(resolved2.getAllOf().get(i2), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getAllOf().set(i2, resolvedSchema);
            }
        }
        if (resolved2.getAnyOf() != null) {
            for (int i3 = 0; i3 < resolved2.getAnyOf().size(); ++i3) {
                resolvedSchema = this.traverseSchema(resolved2.getAnyOf().get(i3), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getAnyOf().set(i3, resolvedSchema);
            }
        }
        if (resolved2.getContains() != null && (traversedSchema = this.traverseSchema(resolved2.getContains(), visitor2, inheritedIds)) != null) {
            resolved2.setContains(traversedSchema);
        }
        if (resolved2.getContentSchema() != null && (traversedSchema = this.traverseSchema(resolved2.getContentSchema(), visitor2, inheritedIds)) != null) {
            resolved2.setContentSchema(traversedSchema);
        }
        this.traverseSchemaMap(resolved2.getDependentSchemas(), visitor2, inheritedIds);
        if (resolved2.getElse() != null && (traversedSchema = this.traverseSchema(resolved2.getElse(), visitor2, inheritedIds)) != null) {
            resolved2.setElse(traversedSchema);
        }
        if (resolved2.getIf() != null && (traversedSchema = this.traverseSchema(resolved2.getIf(), visitor2, inheritedIds)) != null) {
            resolved2.setIf(traversedSchema);
        }
        if (resolved2.getItems() != null && (traversedSchema = this.traverseSchema(resolved2.getItems(), visitor2, inheritedIds)) != null) {
            resolved2.setItems(traversedSchema);
        }
        if (resolved2.getNot() != null && (traversedSchema = this.traverseSchema(resolved2.getNot(), visitor2, inheritedIds)) != null) {
            resolved2.setNot(traversedSchema);
        }
        if (resolved2.getOneOf() != null) {
            for (int i4 = 0; i4 < resolved2.getOneOf().size(); ++i4) {
                resolvedSchema = this.traverseSchema(resolved2.getOneOf().get(i4), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getOneOf().set(i4, resolvedSchema);
            }
        }
        this.traverseSchemaMap(resolved2.getPatternProperties(), visitor2, inheritedIds);
        if (resolved2.getPrefixItems() != null) {
            for (int i5 = 0; i5 < resolved2.getPrefixItems().size(); ++i5) {
                resolvedSchema = this.traverseSchema(resolved2.getPrefixItems().get(i5), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getPrefixItems().set(i5, resolvedSchema);
            }
        }
        if (resolved2.getThen() != null && (traversedSchema = this.traverseSchema(resolved2.getThen(), visitor2, inheritedIds)) != null) {
            resolved2.setThen(traversedSchema);
        }
        if (resolved2.getUnevaluatedItems() != null && (traversedSchema = this.traverseSchema(resolved2.getUnevaluatedItems(), visitor2, inheritedIds)) != null) {
            resolved2.setUnevaluatedItems(traversedSchema);
        }
        if (resolved2.getAdditionalProperties() != null && resolved2.getUnevaluatedProperties() instanceof Schema && (traversedSchema = this.traverseSchema(resolved2.getUnevaluatedProperties(), visitor2, inheritedIds)) != null) {
            resolved2.setUnevaluatedProperties(traversedSchema);
        }
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.remove(schema.get$id());
        }
        this.visitedMap.put(schema, this.deepcopy(resolved2, Schema.class));
        this.visiting.remove(schema);
        return resolved2;
    }

    public <T> T deepcopy(T entity, Class<T> clazz) {
        try {
            return Json31.mapper().readValue(Json31.mapper().writeValueAsString(entity), clazz);
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public <T> void traverseMap(Map<String, T> map2, Visitor visitor2, BiFunction<T, Visitor, T> traverser) {
        if (map2 != null) {
            LinkedHashMap<String, T> copy2 = new LinkedHashMap<String, T>(map2);
            for (String key2 : copy2.keySet()) {
                Object entity = copy2.get(key2);
                T resolved2 = traverser.apply(entity, visitor2);
                if (resolved2 == null) continue;
                map2.put(key2, resolved2);
            }
        }
    }

    public void traverseSchemaMap(Map<String, Schema> map2, Visitor visitor2, List<String> inheritedIds) {
        if (map2 != null) {
            LinkedHashMap<String, Schema> copy2 = new LinkedHashMap<String, Schema>(map2);
            for (String key2 : copy2.keySet()) {
                Schema entity = (Schema)copy2.get(key2);
                Schema resolved2 = this.traverseSchema(entity, visitor2, inheritedIds);
                if (resolved2 == null) continue;
                map2.put(key2, resolved2);
            }
        }
    }
}

