/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.ReferenceUtils;
import io.swagger.v3.parser.reference.ReferenceVisitor;
import io.swagger.v3.parser.reference.Traverser;
import io.swagger.v3.parser.reference.Visitor;
import io.swagger.v3.parser.util.DeserializationUtils;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class OpenAPI31Traverser
implements Traverser {
    private DereferencerContext context;
    public Set<Object> visiting = new HashSet<Object>();
    protected HashMap<Object, Object> visitedMap = new HashMap();
    private OpenAPIDeserializer deserializer = new OpenAPIDeserializer();

    public OpenAPI31Traverser(DereferencerContext context) {
        this.context = context;
    }

    public DereferencerContext getContext() {
        return this.context;
    }

    public void setContext(DereferencerContext context) {
        this.context = context;
    }

    public OpenAPI31Traverser context(DereferencerContext context) {
        this.context = context;
        return this;
    }

    @Override
    public OpenAPI traverse(OpenAPI openAPI, Visitor visitor2) throws Exception {
        if (!(visitor2 instanceof ReferenceVisitor)) {
            return openAPI;
        }
        return this.traverseOpenApi(openAPI, (ReferenceVisitor)visitor2);
    }

    public <T> T deserializeFragment(JsonNode node, Class<T> expectedType2, String uri2, String fragment, Set<String> validationMessages) {
        String sanitizedFragment = fragment == null ? "" : fragment;
        OpenAPIDeserializer.ParseResult parseResult = new OpenAPIDeserializer.ParseResult().openapi31(true);
        Object result2 = null;
        if (expectedType2.equals(Schema.class)) {
            result2 = this.deserializer.getSchema((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(RequestBody.class)) {
            result2 = this.deserializer.getRequestBody((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(ApiResponse.class)) {
            result2 = this.deserializer.getResponse((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Callback.class)) {
            result2 = this.deserializer.getCallback((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Example.class)) {
            result2 = this.deserializer.getExample((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Header.class)) {
            result2 = this.deserializer.getHeader((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Link.class)) {
            result2 = this.deserializer.getLink((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(Parameter.class)) {
            result2 = this.deserializer.getParameter((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(SecurityScheme.class)) {
            result2 = this.deserializer.getSecurityScheme((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        } else if (expectedType2.equals(PathItem.class)) {
            result2 = this.deserializer.getPathItem((ObjectNode)node, sanitizedFragment.replace("/", "."), parseResult);
        }
        parseResult.getMessages().forEach(m4 -> validationMessages.add(m4 + " (" + uri2 + ")"));
        if (result2 != null) {
            return (T)result2;
        }
        return DeserializationUtils.deserialize(node, uri2, expectedType2);
    }

    public OpenAPI traverseOpenApi(OpenAPI openAPI, ReferenceVisitor visitor2) {
        Components components;
        Paths paths;
        if (openAPI == null) {
            return null;
        }
        if (this.visiting.contains(openAPI)) {
            return openAPI;
        }
        if (this.visitedMap.containsKey(openAPI)) {
            return (OpenAPI)this.visitedMap.get(openAPI);
        }
        this.visiting.add(openAPI);
        OpenAPI resolved2 = visitor2.visitOpenApi(openAPI);
        if (resolved2 == null) {
            resolved2 = openAPI;
        }
        if ((paths = this.traversePaths(resolved2.getPaths(), visitor2)) != null) {
            resolved2.paths(paths);
        }
        if ((components = this.traverseComponents(resolved2.getComponents(), visitor2)) != null) {
            resolved2.components(components);
        }
        this.traverseMap(resolved2.getWebhooks(), visitor2, this::traversePathItem);
        this.visitedMap.put(openAPI, resolved2);
        this.visiting.remove(openAPI);
        return resolved2;
    }

    public Components traverseComponents(Components components, ReferenceVisitor visitor2) {
        if (components == null) {
            return null;
        }
        if (this.visiting.contains(components)) {
            return components;
        }
        if (this.visitedMap.containsKey(components)) {
            return (Components)this.visitedMap.get(components);
        }
        this.visiting.add(components);
        Components resolved2 = visitor2.visitComponents(components);
        if (resolved2 == null) {
            resolved2 = components;
        }
        this.traverseMap(resolved2.getPathItems(), visitor2, this::traversePathItem);
        this.traverseMap(resolved2.getParameters(), visitor2, this::traverseParameter);
        this.traverseMap(resolved2.getCallbacks(), visitor2, this::traverseCallback);
        this.traverseMap(resolved2.getRequestBodies(), visitor2, this::traverseRequestBody);
        this.traverseMap(resolved2.getSecuritySchemes(), visitor2, this::traverseSecurityScheme);
        this.traverseSchemaMap(resolved2.getSchemas(), visitor2, new ArrayList<String>());
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.traverseMap(resolved2.getLinks(), visitor2, this::traverseLink);
        this.traverseMap(resolved2.getResponses(), visitor2, this::traverseResponse);
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        this.visitedMap.put(components, resolved2);
        this.visiting.remove(components);
        return resolved2;
    }

    public Paths traversePaths(Paths paths, ReferenceVisitor visitor2) {
        if (paths == null) {
            return null;
        }
        if (this.visiting.contains(paths)) {
            return paths;
        }
        if (this.visitedMap.containsKey(paths)) {
            return (Paths)this.visitedMap.get(paths);
        }
        this.visiting.add(paths);
        Paths resolved2 = visitor2.visitPaths(paths);
        if (resolved2 == null) {
            resolved2 = paths;
        }
        this.traverseMap(resolved2, visitor2, this::traversePathItem);
        this.visitedMap.put(paths, resolved2);
        this.visiting.remove(paths);
        return resolved2;
    }

    public Operation traverseOperation(Operation operation, ReferenceVisitor visitor2) {
        ApiResponses resolvedResponses;
        RequestBody resolvedRequestBody;
        if (operation == null) {
            return null;
        }
        if (this.visiting.contains(operation)) {
            return operation;
        }
        if (this.visitedMap.containsKey(operation)) {
            return (Operation)this.visitedMap.get(operation);
        }
        this.visiting.add(operation);
        Operation resolved2 = visitor2.visitOperation(operation);
        if (resolved2 == null) {
            resolved2 = operation;
        }
        if (resolved2.getParameters() != null) {
            for (int i2 = 0; i2 < resolved2.getParameters().size(); ++i2) {
                Parameter resolvedParameter = this.traverseParameter(resolved2.getParameters().get(i2), visitor2);
                if (resolvedParameter == null) continue;
                resolved2.getParameters().set(i2, resolvedParameter);
            }
        }
        if (resolved2.getRequestBody() != null && (resolvedRequestBody = this.traverseRequestBody(resolved2.getRequestBody(), visitor2)) != null) {
            resolved2.setRequestBody(resolvedRequestBody);
        }
        if (resolved2.getResponses() != null && (resolvedResponses = this.traverseResponses(resolved2.getResponses(), visitor2)) != null) {
            resolved2.setResponses(resolvedResponses);
        }
        this.traverseMap(resolved2.getCallbacks(), visitor2, this::traverseCallback);
        this.visitedMap.put(operation, resolved2);
        this.visiting.remove(operation);
        return resolved2;
    }

    public ApiResponses traverseResponses(ApiResponses responses2, ReferenceVisitor visitor2) {
        if (responses2 == null) {
            return null;
        }
        if (this.visiting.contains(responses2)) {
            return responses2;
        }
        if (this.visitedMap.containsKey(responses2)) {
            return (ApiResponses)this.visitedMap.get(responses2);
        }
        this.visiting.add(responses2);
        ApiResponses resolved2 = visitor2.visitResponses(responses2);
        if (resolved2 == null) {
            resolved2 = responses2;
        }
        this.traverseMap(resolved2, visitor2, this::traverseResponse);
        this.visitedMap.put(responses2, resolved2);
        this.visiting.remove(responses2);
        return resolved2;
    }

    public ApiResponse traverseResponse(ApiResponse response2, ReferenceVisitor visitor2) {
        if (response2 == null) {
            return null;
        }
        if (this.visiting.contains(response2)) {
            return response2;
        }
        if (this.visitedMap.containsKey(response2)) {
            return (ApiResponse)this.visitedMap.get(response2);
        }
        this.visiting.add(response2);
        ApiResponse resolved2 = visitor2.visitResponse(response2);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = response2;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.traverseMap(resolved2.getLinks(), visitor2, this::traverseLink);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, response2.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getResponses() == null) {
                this.context.getOpenApi().getComponents().responses(new LinkedHashMap<String, ApiResponse>());
            }
            this.visitedMap.put(response2, this.deepcopy(response2, ApiResponse.class));
            this.visiting.remove(response2);
            return this.handleRootLocalRefs(response2.get$ref(), resolved2, this.context.getOpenApi().getComponents().getResponses());
        }
        if (response2.getDescription() != null) {
            resolved2.description(response2.getDescription());
        }
        this.visitedMap.put(response2, this.deepcopy(resolved2, ApiResponse.class));
        this.visiting.remove(response2);
        return resolved2;
    }

    public RequestBody traverseRequestBody(RequestBody requestBody2, ReferenceVisitor visitor2) {
        if (requestBody2 == null) {
            return null;
        }
        if (this.visiting.contains(requestBody2)) {
            return requestBody2;
        }
        if (this.visitedMap.containsKey(requestBody2)) {
            return (RequestBody)this.visitedMap.get(requestBody2);
        }
        this.visiting.add(requestBody2);
        RequestBody resolved2 = visitor2.visitRequestBody(requestBody2);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = requestBody2;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, requestBody2.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getRequestBodies() == null) {
                this.context.getOpenApi().getComponents().requestBodies(new LinkedHashMap<String, RequestBody>());
            }
            this.visitedMap.put(requestBody2, this.deepcopy(requestBody2, RequestBody.class));
            this.visiting.remove(requestBody2);
            return this.handleRootLocalRefs(requestBody2.get$ref(), resolved2, this.context.getOpenApi().getComponents().getRequestBodies());
        }
        if (requestBody2.getDescription() != null) {
            resolved2.description(requestBody2.getDescription());
        }
        this.visitedMap.put(requestBody2, this.deepcopy(resolved2, RequestBody.class));
        this.visiting.remove(requestBody2);
        return resolved2;
    }

    public PathItem traversePathItem(PathItem pathItem, ReferenceVisitor visitor2) {
        Operation traceOp;
        Operation postOp;
        Operation headOp;
        Operation optionsOp;
        Operation patchOp;
        Operation deleteOp;
        Operation putOp;
        if (pathItem == null) {
            return null;
        }
        if (this.visiting.contains(pathItem)) {
            return pathItem;
        }
        if (this.visitedMap.containsKey(pathItem)) {
            return (PathItem)this.visitedMap.get(pathItem);
        }
        this.visiting.add(pathItem);
        PathItem resolved2 = visitor2.visitPathItem(pathItem);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = pathItem;
        } else {
            resolvedNotNull = true;
        }
        Operation getOp = resolved2.getGet();
        Operation resolvedOperation = this.traverseOperation(getOp, visitor2);
        if (resolvedOperation != null) {
            resolved2.setGet(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(putOp = resolved2.getPut(), visitor2)) != null) {
            resolved2.setPut(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(deleteOp = resolved2.getDelete(), visitor2)) != null) {
            resolved2.setDelete(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(patchOp = resolved2.getPatch(), visitor2)) != null) {
            resolved2.setPatch(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(optionsOp = resolved2.getOptions(), visitor2)) != null) {
            resolved2.setOptions(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(headOp = resolved2.getHead(), visitor2)) != null) {
            resolved2.setHead(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(postOp = resolved2.getPost(), visitor2)) != null) {
            resolved2.setPost(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(traceOp = resolved2.getTrace(), visitor2)) != null) {
            resolved2.setTrace(resolvedOperation);
        }
        if (resolved2.getParameters() != null) {
            for (int i2 = 0; i2 < resolved2.getParameters().size(); ++i2) {
                Parameter resolvedParameter = this.traverseParameter(resolved2.getParameters().get(i2), visitor2);
                if (resolvedParameter == null) continue;
                resolved2.getParameters().set(i2, resolvedParameter);
            }
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, pathItem.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getPathItems() == null) {
                this.context.getOpenApi().getComponents().pathItems(new LinkedHashMap<String, PathItem>());
            }
            this.visitedMap.put(pathItem, this.deepcopy(pathItem, PathItem.class));
            this.visiting.remove(pathItem);
            return this.handleRootLocalRefs(pathItem.get$ref(), resolved2, this.context.getOpenApi().getComponents().getPathItems());
        }
        if (pathItem.getParameters() != null) {
            resolved2.parameters(pathItem.getParameters());
        }
        if (pathItem.getDescription() != null) {
            resolved2.description(pathItem.getDescription());
        }
        if (pathItem.getSummary() != null) {
            resolved2.summary(pathItem.getSummary());
        }
        this.visitedMap.put(pathItem, this.deepcopy(resolved2, PathItem.class));
        this.visiting.remove(pathItem);
        return resolved2;
    }

    public Parameter traverseParameter(Parameter parameter, ReferenceVisitor visitor2) {
        Schema schema;
        if (parameter == null) {
            return null;
        }
        if (this.visiting.contains(parameter)) {
            return parameter;
        }
        if (this.visitedMap.containsKey(parameter)) {
            return (Parameter)this.visitedMap.get(parameter);
        }
        this.visiting.add(parameter);
        Parameter resolved2 = visitor2.visitParameter(parameter);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = parameter;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        if (resolved2.getSchema() != null && (schema = this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>())) != null) {
            resolved2.setSchema(schema);
        }
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, parameter.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getParameters() == null) {
                this.context.getOpenApi().getComponents().parameters(new LinkedHashMap<String, Parameter>());
            }
            this.visitedMap.put(parameter, this.deepcopy(parameter, Parameter.class));
            this.visiting.remove(parameter);
            return this.handleRootLocalRefs(parameter.get$ref(), resolved2, this.context.getOpenApi().getComponents().getParameters());
        }
        if (parameter.getDescription() != null) {
            resolved2.description(parameter.getDescription());
        }
        this.visitedMap.put(parameter, this.deepcopy(resolved2, Parameter.class));
        this.visiting.remove(parameter);
        return resolved2;
    }

    public Example traverseExample(Example example, ReferenceVisitor visitor2) {
        if (example == null) {
            return null;
        }
        if (this.visiting.contains(example)) {
            return example;
        }
        if (this.visitedMap.containsKey(example)) {
            return (Example)this.visitedMap.get(example);
        }
        this.visiting.add(example);
        Example resolved2 = visitor2.visitExample(example);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = example;
        } else {
            resolvedNotNull = true;
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, example.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getExamples() == null) {
                this.context.getOpenApi().getComponents().examples(new LinkedHashMap<String, Example>());
            }
            this.visitedMap.put(example, this.deepcopy(example, Example.class));
            this.visiting.remove(example);
            return this.handleRootLocalRefs(example.get$ref(), resolved2, this.context.getOpenApi().getComponents().getExamples());
        }
        if (example.getDescription() != null) {
            resolved2.description(example.getDescription());
        }
        if (example.getSummary() != null) {
            resolved2.summary(example.getSummary());
        }
        this.visitedMap.put(example, this.deepcopy(resolved2, Example.class));
        this.visiting.remove(example);
        return resolved2;
    }

    public Callback traverseCallback(Callback callback2, ReferenceVisitor visitor2) {
        if (callback2 == null) {
            return null;
        }
        if (this.visiting.contains(callback2)) {
            return callback2;
        }
        if (this.visitedMap.containsKey(callback2)) {
            return (Callback)this.visitedMap.get(callback2);
        }
        this.visiting.add(callback2);
        this.traverseMap(callback2, visitor2, this::traversePathItem);
        this.visitedMap.put(callback2, callback2);
        this.visiting.remove(callback2);
        return callback2;
    }

    public MediaType traverseMediaType(MediaType mediaType, ReferenceVisitor visitor2) {
        Schema schema;
        if (mediaType == null) {
            return null;
        }
        if (this.visiting.contains(mediaType)) {
            return mediaType;
        }
        if (this.visitedMap.containsKey(mediaType)) {
            return (MediaType)this.visitedMap.get(mediaType);
        }
        this.visiting.add(mediaType);
        MediaType resolved2 = visitor2.visitMediaType(mediaType);
        if (resolved2 == null) {
            resolved2 = mediaType;
        }
        if (resolved2.getSchema() != null && (schema = this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>())) != null) {
            resolved2.setSchema(schema);
        }
        this.traverseMap(resolved2.getEncoding(), visitor2, this::traverseEncoding);
        this.traverseMap(resolved2.getExamples(), visitor2, this::traverseExample);
        this.visitedMap.put(mediaType, resolved2);
        this.visiting.remove(mediaType);
        return resolved2;
    }

    public Encoding traverseEncoding(Encoding encoding, ReferenceVisitor visitor2) {
        if (encoding == null) {
            return null;
        }
        if (this.visiting.contains(encoding)) {
            return encoding;
        }
        if (this.visitedMap.containsKey(encoding)) {
            return (Encoding)this.visitedMap.get(encoding);
        }
        this.visiting.add(encoding);
        Encoding resolved2 = visitor2.visitEncoding(encoding);
        if (resolved2 == null) {
            resolved2 = encoding;
        }
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        this.visitedMap.put(encoding, resolved2);
        this.visiting.remove(encoding);
        return resolved2;
    }

    public Header traverseHeader(Header header, ReferenceVisitor visitor2) {
        Schema schema;
        if (header == null) {
            return null;
        }
        if (this.visiting.contains(header)) {
            return header;
        }
        if (this.visitedMap.containsKey(header)) {
            return (Header)this.visitedMap.get(header);
        }
        this.visiting.add(header);
        Header resolved2 = visitor2.visitHeader(header);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = header;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved2.getContent(), visitor2, this::traverseMediaType);
        if (resolved2.getSchema() != null && (schema = this.traverseSchema(resolved2.getSchema(), visitor2, new ArrayList<String>())) != null) {
            resolved2.setSchema(schema);
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, header.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getHeaders() == null) {
                this.context.getOpenApi().getComponents().headers(new LinkedHashMap<String, Header>());
            }
            this.visitedMap.put(header, this.deepcopy(header, Header.class));
            this.visiting.remove(header);
            return this.handleRootLocalRefs(header.get$ref(), resolved2, this.context.getOpenApi().getComponents().getHeaders());
        }
        if (header.getDescription() != null) {
            resolved2.description(header.getDescription());
        }
        this.visitedMap.put(header, this.deepcopy(resolved2, Header.class));
        this.visiting.remove(header);
        return resolved2;
    }

    public SecurityScheme traverseSecurityScheme(SecurityScheme securityScheme, ReferenceVisitor visitor2) {
        if (securityScheme == null) {
            return null;
        }
        if (this.visiting.contains(securityScheme)) {
            return securityScheme;
        }
        if (this.visitedMap.containsKey(securityScheme)) {
            return (SecurityScheme)this.visitedMap.get(securityScheme);
        }
        this.visiting.add(securityScheme);
        SecurityScheme resolved2 = visitor2.visitSecurityScheme(securityScheme);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = securityScheme;
        } else {
            resolvedNotNull = true;
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, securityScheme.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getSecuritySchemes() == null) {
                this.context.getOpenApi().getComponents().securitySchemes(new LinkedHashMap<String, SecurityScheme>());
            }
            this.visitedMap.put(securityScheme, this.deepcopy(securityScheme, SecurityScheme.class));
            this.visiting.remove(securityScheme);
            return this.handleRootLocalRefs(securityScheme.get$ref(), resolved2, this.context.getOpenApi().getComponents().getSecuritySchemes());
        }
        if (securityScheme.getDescription() != null) {
            resolved2.description(securityScheme.getDescription());
        }
        this.visitedMap.put(securityScheme, this.deepcopy(resolved2, SecurityScheme.class));
        this.visiting.remove(securityScheme);
        return resolved2;
    }

    public Link traverseLink(Link link, ReferenceVisitor visitor2) {
        if (link == null) {
            return null;
        }
        if (this.visiting.contains(link)) {
            return link;
        }
        if (this.visitedMap.containsKey(link)) {
            return (Link)this.visitedMap.get(link);
        }
        this.visiting.add(link);
        Link resolved2 = visitor2.visitLink(link);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = link;
        } else {
            resolvedNotNull = true;
        }
        this.traverseMap(resolved2.getHeaders(), visitor2, this::traverseHeader);
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, link.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getLinks() == null) {
                this.context.getOpenApi().getComponents().links(new LinkedHashMap<String, Link>());
            }
            this.visitedMap.put(link, this.deepcopy(link, Link.class));
            this.visiting.remove(link);
            return this.handleRootLocalRefs(link.get$ref(), resolved2, this.context.getOpenApi().getComponents().getLinks());
        }
        if (link.getDescription() != null) {
            resolved2.description(link.getDescription());
        }
        this.visitedMap.put(link, this.deepcopy(resolved2, Link.class));
        this.visiting.remove(link);
        return resolved2;
    }

    public Schema traverseSchema(Schema schema, ReferenceVisitor visitor2, List<String> inheritedIds) {
        Schema resolvedSchema;
        Schema traversedSchema;
        if (schema == null) {
            return null;
        }
        if (this.visiting.contains(schema)) {
            return schema;
        }
        if (this.visitedMap.containsKey(schema)) {
            return (Schema)this.visitedMap.get(schema);
        }
        this.visiting.add(schema);
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.add(schema.get$id());
            try {
                String resolvedURI = visitor2.reference.getUri();
                for (String id : inheritedIds) {
                    String urlWithoutHash = ReferenceUtils.toBaseURI(id);
                    resolvedURI = ReferenceUtils.resolve(urlWithoutHash, resolvedURI);
                    resolvedURI = ReferenceUtils.toBaseURI(resolvedURI);
                }
                this.context.getIdsCache().put(resolvedURI, Json31.pretty(schema));
            }
            catch (Exception resolvedURI) {
                // empty catch block
            }
        }
        Schema resolved2 = visitor2.visitSchema(schema, inheritedIds);
        boolean resolvedNotNull = false;
        if (resolved2 == null) {
            resolved2 = schema;
        } else {
            resolvedNotNull = true;
        }
        this.traverseSchemaMap(resolved2.getProperties(), visitor2, inheritedIds);
        if (resolved2.getAdditionalItems() != null && (traversedSchema = this.traverseSchema(resolved2.getAdditionalItems(), visitor2, inheritedIds)) != null) {
            resolved2.setAdditionalItems(traversedSchema);
        }
        if (resolved2.getAdditionalProperties() != null && resolved2.getAdditionalProperties() instanceof Schema && (traversedSchema = this.traverseSchema((Schema)resolved2.getAdditionalProperties(), visitor2, inheritedIds)) != null) {
            resolved2.setAdditionalProperties(traversedSchema);
        }
        if (resolved2.getAllOf() != null) {
            for (int i2 = 0; i2 < resolved2.getAllOf().size(); ++i2) {
                resolvedSchema = this.traverseSchema(resolved2.getAllOf().get(i2), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getAllOf().set(i2, resolvedSchema);
            }
        }
        if (resolved2.getAnyOf() != null) {
            for (int i3 = 0; i3 < resolved2.getAnyOf().size(); ++i3) {
                resolvedSchema = this.traverseSchema(resolved2.getAnyOf().get(i3), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getAnyOf().set(i3, resolvedSchema);
            }
        }
        if (resolved2.getContains() != null && (traversedSchema = this.traverseSchema(resolved2.getContains(), visitor2, inheritedIds)) != null) {
            resolved2.setContains(traversedSchema);
        }
        if (resolved2.getContentSchema() != null && (traversedSchema = this.traverseSchema(resolved2.getContentSchema(), visitor2, inheritedIds)) != null) {
            resolved2.setContentSchema(traversedSchema);
        }
        this.traverseSchemaMap(resolved2.getDependentSchemas(), visitor2, inheritedIds);
        if (resolved2.getElse() != null && (traversedSchema = this.traverseSchema(resolved2.getElse(), visitor2, inheritedIds)) != null) {
            resolved2.setElse(traversedSchema);
        }
        if (resolved2.getIf() != null && (traversedSchema = this.traverseSchema(resolved2.getIf(), visitor2, inheritedIds)) != null) {
            resolved2.setIf(traversedSchema);
        }
        if (resolved2.getItems() != null && (traversedSchema = this.traverseSchema(resolved2.getItems(), visitor2, inheritedIds)) != null) {
            resolved2.setItems(traversedSchema);
        }
        if (resolved2.getNot() != null && (traversedSchema = this.traverseSchema(resolved2.getNot(), visitor2, inheritedIds)) != null) {
            resolved2.setNot(traversedSchema);
        }
        if (resolved2.getOneOf() != null) {
            for (int i4 = 0; i4 < resolved2.getOneOf().size(); ++i4) {
                resolvedSchema = this.traverseSchema(resolved2.getOneOf().get(i4), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getOneOf().set(i4, resolvedSchema);
            }
        }
        this.traverseSchemaMap(resolved2.getPatternProperties(), visitor2, inheritedIds);
        if (resolved2.getPrefixItems() != null) {
            for (int i5 = 0; i5 < resolved2.getPrefixItems().size(); ++i5) {
                resolvedSchema = this.traverseSchema(resolved2.getPrefixItems().get(i5), visitor2, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved2.getPrefixItems().set(i5, resolvedSchema);
            }
        }
        if (resolved2.getThen() != null && (traversedSchema = this.traverseSchema(resolved2.getThen(), visitor2, inheritedIds)) != null) {
            resolved2.setThen(traversedSchema);
        }
        if (resolved2.getUnevaluatedItems() != null && (traversedSchema = this.traverseSchema(resolved2.getUnevaluatedItems(), visitor2, inheritedIds)) != null) {
            resolved2.setUnevaluatedItems(traversedSchema);
        }
        if (resolved2.getAdditionalProperties() != null && resolved2.getUnevaluatedProperties() instanceof Schema && (traversedSchema = this.traverseSchema(resolved2.getUnevaluatedProperties(), visitor2, inheritedIds)) != null) {
            resolved2.setUnevaluatedProperties(traversedSchema);
        }
        if (this.shouldHandleRootLocalRefs(resolvedNotNull, schema.get$ref(), visitor2)) {
            this.ensureComponents(this.context.getOpenApi());
            if (this.context.getOpenApi().getComponents().getSchemas() == null) {
                this.context.getOpenApi().getComponents().schemas(new LinkedHashMap<String, Schema>());
            }
            this.visitedMap.put(schema, this.deepcopy(schema, Schema.class));
            this.visiting.remove(schema);
            return this.handleRootLocalRefs(schema.get$ref(), resolved2, this.context.getOpenApi().getComponents().getSchemas());
        }
        this.mergeSchemas(schema, resolved2);
        this.visitedMap.put(schema, this.deepcopy(resolved2, Schema.class));
        this.visiting.remove(schema);
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.remove(schema.get$id());
        }
        return resolved2;
    }

    public <T> T deepcopy(T entity, Class<T> clazz) {
        try {
            return Json31.mapper().readValue(Json31.mapper().writeValueAsString(entity), clazz);
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public <T> void traverseMap(Map<String, T> map2, ReferenceVisitor visitor2, BiFunction<T, ReferenceVisitor, T> traverser) {
        if (map2 != null) {
            LinkedHashMap<String, T> copy2 = new LinkedHashMap<String, T>(map2);
            for (String key2 : copy2.keySet()) {
                Object entity = copy2.get(key2);
                T resolved2 = traverser.apply(entity, visitor2);
                if (resolved2 == null) continue;
                map2.put(key2, resolved2);
            }
        }
    }

    public void traverseSchemaMap(Map<String, Schema> map2, ReferenceVisitor visitor2, List<String> inheritedIds) {
        if (map2 != null) {
            LinkedHashMap<String, Schema> copy2 = new LinkedHashMap<String, Schema>(map2);
            for (String key2 : copy2.keySet()) {
                Schema entity = (Schema)copy2.get(key2);
                Schema resolved2 = this.traverseSchema(entity, visitor2, inheritedIds);
                if (resolved2 == null) continue;
                map2.put(key2, resolved2);
            }
        }
    }

    public <T> T handleRootLocalRefs(String ref, T entity, Map<String, T> map2) {
        if (!ReferenceUtils.isLocalRefToComponents(ref) && ReferenceUtils.isAnchorRef(ref)) {
            return null;
        }
        String name = ReferenceUtils.getRefName(ref);
        map2.put(name, entity);
        return null;
    }

    public boolean shouldHandleRootLocalRefs(boolean resolvedNotNull, String ref, ReferenceVisitor visitor2) {
        return resolvedNotNull && ReferenceUtils.isLocalRef(ref) && !this.getContext().getParseOptions().isResolveFully() && visitor2.reference.getUri().equals(this.getContext().getRootUri()) && (ReferenceUtils.isLocalRefToComponents(ref) || ReferenceUtils.isAnchorRef(ref));
    }

    public void ensureComponents(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
    }

    public void mergeSchemas(Schema source2, Schema target) {
        if (source2.getDescription() != null) {
            target.description(source2.getDescription());
        }
        if (source2.getOneOf() != null && !source2.getOneOf().isEmpty()) {
            target.oneOf(source2.getOneOf());
        }
        if (source2.getNot() != null) {
            target.not(source2.getNot());
        }
        if (source2.getAnyOf() != null && !source2.getAnyOf().isEmpty()) {
            target.anyOf(source2.getAnyOf());
        }
        if (source2.getType() != null) {
            target.type(source2.getType());
        }
        if (source2.getTypes() != null && !source2.getTypes().isEmpty()) {
            target.types(source2.getTypes());
        }
        if (source2.getFormat() != null) {
            target.format(source2.getFormat());
        }
        if (source2.getRequired() != null) {
            target.required(source2.getRequired());
        }
        if (source2.getThen() != null) {
            target.then(source2.getThen());
        }
        if (source2.getIf() != null) {
            target._if(source2.getIf());
        }
        if (source2.getElse() != null) {
            target._else(source2.getElse());
        }
        if (source2.getContentSchema() != null) {
            target.contentSchema(source2.getContentSchema());
        }
        if (source2.getContains() != null) {
            target.contains(source2.getContains());
        }
        if (source2.getAdditionalProperties() != null) {
            target.additionalProperties(source2.getAdditionalProperties());
        }
        if (source2.getUnevaluatedProperties() != null) {
            target.unevaluatedProperties(source2.getUnevaluatedProperties());
        }
        if (source2.getUnevaluatedItems() != null) {
            target.unevaluatedItems(source2.getUnevaluatedItems());
        }
        if (source2.getPrefixItems() != null && !source2.getPrefixItems().isEmpty()) {
            target.prefixItems(source2.getPrefixItems());
        }
        if (source2.getProperties() != null && !source2.getProperties().isEmpty()) {
            target.properties(source2.getProperties());
        }
        if (source2.getPatternProperties() != null && !source2.getPatternProperties().isEmpty()) {
            target.patternProperties(source2.getPatternProperties());
        }
        if (source2.getPattern() != null) {
            target.pattern(source2.getPattern());
        }
        if (source2.getDependentSchemas() != null && !source2.getDependentSchemas().isEmpty()) {
            target.dependentSchemas(source2.getDependentSchemas());
        }
        if (source2.getConst() != null) {
            target._const(source2.getConst());
        }
        if (source2.getAdditionalItems() != null) {
            target.additionalItems(source2.getAdditionalItems());
        }
        if (source2.getEnum() != null && !source2.getEnum().isEmpty()) {
            target._enum(source2.getEnum());
        }
        if (source2.getReadOnly() != null) {
            target.setReadOnly(source2.getReadOnly());
        }
        if (source2.getWriteOnly() != null) {
            target.setWriteOnly(source2.getWriteOnly());
        }
        if (source2.getMaxLength() != null) {
            target.setMaxLength(source2.getMaxLength());
        }
        if (source2.get$anchor() != null) {
            target.set$anchor(source2.get$anchor());
        }
        if (source2.get$comment() != null) {
            target.set$comment(source2.get$comment());
        }
        if (source2.get$id() != null) {
            target.set$id(source2.get$id());
        }
        if (source2.get$schema() != null) {
            target.set$schema(source2.get$schema());
        }
        if (source2.getContentEncoding() != null) {
            target.setContentEncoding(source2.getContentEncoding());
        }
        if (source2.getContentMediaType() != null) {
            target.setContentMediaType(source2.getContentMediaType());
        }
        if (source2.getDefault() != null) {
            target.setDefault(source2.getDefault());
        }
        if (source2.getDependentRequired() != null && !source2.getDependentRequired().isEmpty()) {
            target.setDependentRequired(source2.getDependentRequired());
        }
        if (source2.getDeprecated() != null) {
            target.setDeprecated(source2.getDeprecated());
        }
        if (source2.getDiscriminator() != null) {
            target.setDiscriminator(source2.getDiscriminator());
        }
        if (source2.getExample() != null) {
            target.setExample(source2.getExample());
        }
        if (source2.getExamples() != null && !source2.getExamples().isEmpty()) {
            target.setExamples(source2.getExamples());
        }
        if (source2.getExclusiveMaximum() != null) {
            target.setExclusiveMaximum(source2.getExclusiveMaximum());
        }
        if (source2.getExclusiveMaximumValue() != null) {
            target.setExclusiveMaximumValue(source2.getExclusiveMaximumValue());
        }
        if (source2.getExclusiveMinimum() != null) {
            target.setExclusiveMinimum(source2.getExclusiveMinimum());
        }
        if (source2.getExclusiveMinimumValue() != null) {
            target.setExclusiveMinimumValue(source2.getExclusiveMinimumValue());
        }
        if (source2.getExtensions() != null && !source2.getExtensions().isEmpty()) {
            target.setExtensions(source2.getExtensions());
        }
        if (source2.getExternalDocs() != null) {
            target.setExternalDocs(source2.getExternalDocs());
        }
        if (source2.getMaxContains() != null) {
            target.setMaxContains(source2.getMaxContains());
        }
        if (source2.getMaximum() != null) {
            target.setMaximum(source2.getMaximum());
        }
        if (source2.getMaxItems() != null) {
            target.setMaxItems(source2.getMaxItems());
        }
        if (source2.getMaxProperties() != null) {
            target.setMaxProperties(source2.getMaxProperties());
        }
        if (source2.getMinContains() != null) {
            target.setMinContains(source2.getMinContains());
        }
        if (source2.getMinItems() != null) {
            target.setMinItems(source2.getMinItems());
        }
        if (source2.getMinProperties() != null) {
            target.setMinProperties(source2.getMinProperties());
        }
        if (source2.getMultipleOf() != null) {
            target.setMultipleOf(source2.getMultipleOf());
        }
        if (source2.getNullable() != null) {
            target.setNullable(source2.getNullable());
        }
        if (source2.getPropertyNames() != null) {
            target.setPropertyNames(source2.getPropertyNames());
        }
        if (source2.getTitle() != null) {
            target.setTitle(source2.getTitle());
        }
        if (source2.getUniqueItems() != null) {
            target.setUniqueItems(source2.getUniqueItems());
        }
    }
}

