/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ReferenceUtils {
    public static String toBaseURI(String uri2) throws Exception {
        URI resolved2 = new URI(uri2);
        return (resolved2.getScheme() != null ? resolved2.getScheme() + ":" : "") + resolved2.getSchemeSpecificPart();
    }

    public static String getFragment(String uri2) throws Exception {
        URI resolved2 = new URI(uri2);
        return resolved2.getFragment();
    }

    public static String resolve(String uri2, String baseURI) throws Exception {
        if (StringUtils.isBlank(uri2)) {
            return baseURI;
        }
        return new URI(baseURI).resolve(uri2).toString();
    }

    public static boolean isLocalRef(String ref) {
        return !StringUtils.isBlank(ref) && ref.startsWith("#");
    }

    public static boolean isLocalRefToComponents(String ref) {
        return !StringUtils.isBlank(ref) && ref.startsWith("#/components");
    }

    public static boolean isAnchorRef(String ref) {
        if (!StringUtils.isBlank(ref) && ref.startsWith("#")) {
            return ReferenceUtils.isAnchor(ref.substring(1));
        }
        return false;
    }

    public static boolean isAnchor(String ref) {
        return !StringUtils.isBlank(ref) && Pattern.matches("^[A-Za-z_][A-Za-z_0-9.-]*$", ref);
    }

    public static String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    public static JsonNode jsonPointerEvaluate(String fragment, JsonNode tree, String uri2) {
        if (StringUtils.isBlank(fragment)) {
            return tree;
        }
        String[] tokens = fragment.split("/");
        JsonNode node = tree;
        for (String token2 : tokens) {
            if (StringUtils.isBlank(token2) || (node = node.isArray() ? node.get(Integer.valueOf(token2)) : node.get(ReferenceUtils.unescapePointer(token2))) != null) continue;
            throw new RuntimeException("Could not find " + fragment + " in contents of " + uri2);
        }
        return node;
    }

    public static String getRefName(String uri2) {
        if (uri2.indexOf("/") == -1 && uri2.startsWith("#")) {
            return uri2.substring(1);
        }
        String[] tokens = uri2.split("/");
        return tokens[tokens.length - 1];
    }
}

