/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.Yaml31;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.reference.AbstractVisitor;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.IdsTraverser;
import io.swagger.v3.parser.reference.OpenAPI31Traverser;
import io.swagger.v3.parser.reference.Reference;
import io.swagger.v3.parser.reference.ReferenceUtils;
import io.swagger.v3.parser.urlresolver.PermittedUrlsChecker;
import io.swagger.v3.parser.urlresolver.exceptions.HostDeniedException;
import io.swagger.v3.parser.util.RemoteUrl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceVisitor
extends AbstractVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceVisitor.class);
    protected HashSet<Object> visited;
    protected HashMap<Object, Object> visitedMap;
    protected OpenAPI31Traverser openAPITraverser;
    protected Reference reference;
    protected DereferencerContext context;

    public ReferenceVisitor(Reference reference, OpenAPI31Traverser openAPITraverser, HashSet<Object> visited, HashMap<Object, Object> visitedMap) {
        this.reference = reference;
        this.openAPITraverser = openAPITraverser;
        this.visited = visited;
        this.visitedMap = visitedMap;
        this.context = null;
    }

    public ReferenceVisitor(Reference reference, OpenAPI31Traverser openAPITraverser, HashSet<Object> visited, HashMap<Object, Object> visitedMap, DereferencerContext context) {
        this.reference = reference;
        this.openAPITraverser = openAPITraverser;
        this.visited = visited;
        this.visitedMap = visitedMap;
        this.context = context;
    }

    public String toBaseURI(String uri2) throws Exception {
        return ReferenceUtils.resolve(ReferenceUtils.toBaseURI(uri2), this.reference.getUri());
    }

    public Reference toReference(String uri2) throws Exception {
        String baseUri = this.toBaseURI(uri2);
        Map<String, Reference> referenceSet = this.reference.getReferenceSet();
        if (referenceSet.containsKey(baseUri)) {
            return referenceSet.get(baseUri);
        }
        JsonNode node = this.parse(baseUri, this.reference.getAuths());
        Reference ref = new Reference().auths(this.reference.getAuths()).jsonNode(node).uri(baseUri).referenceSet(referenceSet).messages(this.reference.getMessages());
        referenceSet.put(baseUri, ref);
        return ref;
    }

    public Reference toSchemaReference(String baseUri, JsonNode node) throws Exception {
        Map<String, Reference> referenceSet = this.reference.getReferenceSet();
        if (referenceSet.containsKey(baseUri)) {
            return referenceSet.get(baseUri);
        }
        Reference ref = new Reference().auths(this.reference.getAuths()).jsonNode(node).uri(baseUri).referenceSet(referenceSet).messages(this.reference.getMessages());
        referenceSet.put(baseUri, ref);
        return ref;
    }

    @Override
    public PathItem visitPathItem(PathItem pathItem) {
        if (StringUtils.isBlank(pathItem.get$ref())) {
            return null;
        }
        return this.resolveRef(pathItem, pathItem.get$ref(), PathItem.class, this.openAPITraverser::traversePathItem);
    }

    @Override
    public Parameter visitParameter(Parameter parameter) {
        if (StringUtils.isBlank(parameter.get$ref())) {
            return null;
        }
        return this.resolveRef(parameter, parameter.get$ref(), Parameter.class, this.openAPITraverser::traverseParameter);
    }

    @Override
    public Example visitExample(Example example) {
        if (StringUtils.isBlank(example.get$ref())) {
            return null;
        }
        return this.resolveRef(example, example.get$ref(), Example.class, this.openAPITraverser::traverseExample);
    }

    @Override
    public Schema visitSchema(Schema schema, List<String> inheritedIds) {
        if (StringUtils.isBlank(schema.get$ref())) {
            return null;
        }
        return this.resolveSchemaRef(schema, schema.get$ref(), inheritedIds);
    }

    @Override
    public ApiResponse visitResponse(ApiResponse response2) {
        if (StringUtils.isBlank(response2.get$ref())) {
            return null;
        }
        return this.resolveRef(response2, response2.get$ref(), ApiResponse.class, this.openAPITraverser::traverseResponse);
    }

    @Override
    public RequestBody visitRequestBody(RequestBody requestBody2) {
        if (StringUtils.isBlank(requestBody2.get$ref())) {
            return null;
        }
        return this.resolveRef(requestBody2, requestBody2.get$ref(), RequestBody.class, this.openAPITraverser::traverseRequestBody);
    }

    @Override
    public Link visitLink(Link link) {
        if (StringUtils.isBlank(link.get$ref())) {
            return null;
        }
        return this.resolveRef(link, link.get$ref(), Link.class, this.openAPITraverser::traverseLink);
    }

    @Override
    public SecurityScheme visitSecurityScheme(SecurityScheme securityScheme) {
        if (StringUtils.isBlank(securityScheme.get$ref())) {
            return null;
        }
        return this.resolveRef(securityScheme, securityScheme.get$ref(), SecurityScheme.class, this.openAPITraverser::traverseSecurityScheme);
    }

    @Override
    public Header visitHeader(Header header) {
        if (StringUtils.isBlank(header.get$ref())) {
            return null;
        }
        return this.resolveRef(header, header.get$ref(), Header.class, this.openAPITraverser::traverseHeader);
    }

    @Override
    public String readHttp(String uri2, List<AuthorizationValue> auths) throws Exception {
        if (this.context.getParseOptions().isSafelyResolveURL()) {
            this.checkUrlIsPermitted(uri2);
        }
        return RemoteUrl.urlToString(uri2, auths);
    }

    public <T> T resolveRef(T visiting, String ref, Class<T> clazz, BiFunction<T, ReferenceVisitor, T> traverseFunction) {
        try {
            Reference reference = this.toReference(ref);
            String fragment = ReferenceUtils.getFragment(ref);
            JsonNode node = ReferenceUtils.jsonPointerEvaluate(fragment, reference.getJsonNode(), ref);
            T resolved2 = this.openAPITraverser.deserializeFragment(node, clazz, ref, fragment, reference.getMessages());
            ReferenceVisitor visitor2 = new ReferenceVisitor(reference, this.openAPITraverser, this.visited, this.visitedMap, this.context);
            return traverseFunction.apply(resolved2, visitor2);
        }
        catch (Exception e2) {
            LOGGER.error("Error resolving " + ref, e2);
            this.reference.getMessages().add(e2.getMessage());
            return null;
        }
    }

    public Schema resolveSchemaRef(Schema visiting, String ref, List<String> inheritedIds) {
        try {
            String baseURI = this.reference.getUri();
            for (String id : inheritedIds) {
                String urlWithoutHash = ReferenceUtils.toBaseURI(id);
                baseURI = ReferenceUtils.resolve(urlWithoutHash, baseURI);
                baseURI = ReferenceUtils.toBaseURI(baseURI);
            }
            baseURI = ReferenceUtils.resolve(ref, baseURI);
            baseURI = ReferenceUtils.toBaseURI(baseURI);
            Reference reference = null;
            boolean isAnchor = false;
            if (this.reference.getReferenceSet().containsKey(baseURI)) {
                reference = this.reference.getReferenceSet().get(baseURI);
            } else {
                JsonNode node = null;
                try {
                    node = this.parse(baseURI, this.reference.getAuths());
                }
                catch (Exception e2) {
                    baseURI = this.toBaseURI(ref);
                    node = this.parse(baseURI, this.reference.getAuths());
                }
                reference = this.toSchemaReference(baseURI, node);
            }
            String fragment = ReferenceUtils.getFragment(ref);
            JsonNode evaluatedNode = null;
            try {
                evaluatedNode = ReferenceUtils.jsonPointerEvaluate(fragment, reference.getJsonNode(), ref);
            }
            catch (RuntimeException e3) {
                evaluatedNode = this.findAnchor(reference.getJsonNode(), fragment);
                if (evaluatedNode == null) {
                    throw new RuntimeException("Could not find " + fragment + " in contents of " + ref);
                }
                isAnchor = true;
            }
            Schema resolved2 = this.openAPITraverser.deserializeFragment(evaluatedNode, Schema.class, ref, fragment, reference.getMessages());
            if (isAnchor) {
                resolved2.$anchor(null);
            }
            ReferenceVisitor visitor2 = new ReferenceVisitor(reference, this.openAPITraverser, this.visited, this.visitedMap, this.context);
            return this.openAPITraverser.traverseSchema(resolved2, visitor2, inheritedIds);
        }
        catch (Exception e4) {
            LOGGER.error("Error resolving schema " + ref, e4);
            this.reference.getMessages().add(e4.getMessage());
            return null;
        }
    }

    public JsonNode findAnchor(JsonNode root, String anchor) {
        block4: {
            block3: {
                if (!root.isObject()) break block3;
                JsonNode anchorNode = root.get("$anchor");
                if (anchorNode != null && anchorNode.isValueNode() && anchor.equals(anchorNode.asText())) {
                    return root;
                }
                Iterator<String> fieldNames = root.fieldNames();
                while (fieldNames.hasNext()) {
                    String fieldName = fieldNames.next();
                    JsonNode fieldValue = root.get(fieldName);
                    JsonNode node = this.findAnchor(fieldValue, anchor);
                    if (node == null) continue;
                    return node;
                }
                break block4;
            }
            if (!root.isArray()) break block4;
            ArrayNode arrayNode = (ArrayNode)root;
            for (int i2 = 0; i2 < arrayNode.size(); ++i2) {
                JsonNode arrayElement = arrayNode.get(i2);
                JsonNode node = this.findAnchor(arrayElement, anchor);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public JsonNode deserializeIntoTree(String content2) throws Exception {
        boolean isJson = content2.trim().startsWith("{");
        return isJson ? Json31.mapper().readTree(content2) : Yaml31.mapper().readTree(content2);
    }

    public JsonNode parse(String absoluteUri, List<AuthorizationValue> auths) throws Exception {
        if (this.context.getIdsCache().containsKey(absoluteUri)) {
            return this.deserializeIntoTree(this.context.getIdsCache().get(absoluteUri));
        }
        IdsTraverser idsTraverser = new IdsTraverser(this.context);
        idsTraverser.traverse(this.context.getOpenApi(), null);
        if (this.context.getIdsCache().containsKey(absoluteUri)) {
            return this.deserializeIntoTree(this.context.getIdsCache().get(absoluteUri));
        }
        return this.deserializeIntoTree(this.readURI(absoluteUri, auths));
    }

    protected void checkUrlIsPermitted(String refSet) throws HostDeniedException {
        PermittedUrlsChecker permittedUrlsChecker = new PermittedUrlsChecker(this.context.getParseOptions().getRemoteRefAllowList(), this.context.getParseOptions().getRemoteRefBlockList());
        permittedUrlsChecker.verify(refSet);
    }
}

