/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public interface Visitor {
    public OpenAPI visitOpenApi(OpenAPI var1);

    public Paths visitPaths(Paths var1);

    public Components visitComponents(Components var1);

    public PathItem visitPathItem(PathItem var1);

    public Parameter visitParameter(Parameter var1);

    public Operation visitOperation(Operation var1);

    public Schema visitSchema(Schema var1, List<String> var2);

    public ApiResponse visitResponse(ApiResponse var1);

    public RequestBody visitRequestBody(RequestBody var1);

    public Link visitLink(Link var1);

    public SecurityScheme visitSecurityScheme(SecurityScheme var1);

    public ApiResponses visitResponses(ApiResponses var1);

    public MediaType visitMediaType(MediaType var1);

    public Encoding visitEncoding(Encoding var1);

    public Header visitHeader(Header var1);

    public Example visitExample(Example var1);

    default public String readFile(String path2) throws Exception {
        try (FileInputStream inputStream2 = new FileInputStream(path2);){
            String string = IOUtils.toString((InputStream)inputStream2, StandardCharsets.UTF_8);
            return string;
        }
    }

    default public String readClasspath(String classPath) throws Exception {
        return ClasspathHelper.loadFileFromClasspath(classPath);
    }

    default public String readHttp(String uri2, List<AuthorizationValue> auths) throws Exception {
        return RemoteUrl.urlToString(uri2, auths);
    }

    default public String readURI(String absoluteUri, List<AuthorizationValue> auths) throws Exception {
        URI resolved2 = new URI(absoluteUri);
        if (StringUtils.isNotBlank(resolved2.getScheme())) {
            if (resolved2.getScheme().startsWith("http")) {
                return this.readHttp(absoluteUri, auths);
            }
            if (resolved2.getScheme().startsWith("file")) {
                return this.readFile(resolved2.getPath());
            }
            if (resolved2.getScheme().startsWith("classpath")) {
                return this.readClasspath(resolved2.getPath());
            }
        }
        String content2 = null;
        try {
            content2 = this.readFile(absoluteUri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(content2)) {
            content2 = this.readClasspath(absoluteUri);
        }
        return content2;
    }
}

