/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.urlresolver;

import io.swagger.v3.parser.urlresolver.exceptions.HostDeniedException;
import io.swagger.v3.parser.urlresolver.matchers.UrlPatternMatcher;
import io.swagger.v3.parser.urlresolver.models.ResolvedUrl;
import io.swagger.v3.parser.urlresolver.utils.NetUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

public class PermittedUrlsChecker {
    protected final UrlPatternMatcher allowlistMatcher;
    protected final UrlPatternMatcher denylistMatcher;

    public PermittedUrlsChecker() {
        this.allowlistMatcher = new UrlPatternMatcher(Collections.emptyList());
        this.denylistMatcher = new UrlPatternMatcher(Collections.emptyList());
    }

    public PermittedUrlsChecker(List<String> allowlist, List<String> denylist) {
        this.allowlistMatcher = allowlist != null ? new UrlPatternMatcher(allowlist) : new UrlPatternMatcher(Collections.emptyList());
        this.denylistMatcher = denylist != null ? new UrlPatternMatcher(denylist) : new UrlPatternMatcher(Collections.emptyList());
    }

    public ResolvedUrl verify(String url2) throws HostDeniedException {
        String urlWithIp;
        InetAddress ip;
        String hostname;
        URL parsed;
        try {
            parsed = new URL(url2);
        }
        catch (MalformedURLException e2) {
            throw new HostDeniedException(String.format("Failed to parse URL. URL [%s]", url2), e2);
        }
        if (!parsed.getProtocol().equals("http") && !parsed.getProtocol().equals("https")) {
            throw new HostDeniedException(String.format("URL does not use a supported protocol. URL [%s]", url2));
        }
        try {
            hostname = NetUtils.getHostFromUrl(url2);
        }
        catch (MalformedURLException e3) {
            throw new HostDeniedException(String.format("Failed to get hostname from URL. URL [%s]", url2), e3);
        }
        if (this.allowlistMatcher.matches(url2)) {
            return new ResolvedUrl(url2, hostname);
        }
        if (this.denylistMatcher.matches(url2)) {
            throw new HostDeniedException(String.format("URL is part of the explicit denylist. URL [%s]", url2));
        }
        try {
            ip = NetUtils.getHostByName(hostname);
        }
        catch (UnknownHostException e4) {
            throw new HostDeniedException(String.format("Failed to resolve IP from hostname. Hostname [%s]", hostname), e4);
        }
        try {
            urlWithIp = NetUtils.setHost(url2, ip.getHostAddress());
        }
        catch (MalformedURLException e5) {
            throw new HostDeniedException(String.format("Failed to create new URL with IP. IP [%s] URL [%s]", ip.getHostAddress(), url2), e5);
        }
        if (this.allowlistMatcher.matches(urlWithIp)) {
            return new ResolvedUrl(urlWithIp, hostname);
        }
        if (this.isRestrictedIpRange(ip)) {
            throw new HostDeniedException(String.format("IP is restricted. URL [%s]", urlWithIp));
        }
        if (this.denylistMatcher.matches(urlWithIp)) {
            throw new HostDeniedException(String.format("IP is part of the explicit denylist. URL [%s]", urlWithIp));
        }
        return new ResolvedUrl(urlWithIp, hostname);
    }

    protected boolean isRestrictedIpRange(InetAddress ip) {
        return ip.isLinkLocalAddress() || ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.isAnyLocalAddress() || NetUtils.isUniqueLocalAddress(ip) || NetUtils.isNAT64Address(ip);
    }
}

