/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.extensions.JsonSchemaParserExtension;
import io.swagger.v3.parser.util.ReferenceValidator;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIDeserializer {
    protected static Set<String> JSON_SCHEMA_2020_12_TYPES = new LinkedHashSet<String>(Arrays.asList("null", "boolean", "object", "array", "number", "string", "integer"));
    protected static Set<String> ROOT_KEYS = new LinkedHashSet<String>(Arrays.asList("openapi", "info", "servers", "paths", "components", "security", "tags", "externalDocs"));
    protected static Set<String> INFO_KEYS = new LinkedHashSet<String>(Arrays.asList("title", "description", "termsOfService", "contact", "license", "version"));
    protected static Set<String> CONTACT_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url", "email"));
    protected static Set<String> LICENSE_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url"));
    protected static Set<String> TAG_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "name", "externalDocs"));
    protected static Set<String> RESPONSE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "headers", "content", "links"));
    protected static Set<String> SERVER_KEYS = new LinkedHashSet<String>(Arrays.asList("url", "description", "variables"));
    protected static Set<String> SERVER_VARIABLE_KEYS = new LinkedHashSet<String>(Arrays.asList("enum", "default", "description"));
    protected static Set<String> PATHITEM_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "get", "put", "post", "delete", "head", "patch", "options", "trace", "servers", "parameters"));
    protected static Set<String> OPERATION_KEYS = new LinkedHashSet<String>(Arrays.asList("tags", "summary", "description", "externalDocs", "operationId", "parameters", "requestBody", "responses", "callbacks", "deprecated", "security", "servers"));
    protected static Set<String> PARAMETER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> REQUEST_BODY_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "content", "required"));
    protected static Set<String> SECURITY_SCHEME_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "type", "name", "in", "description", "flows", "scheme", "bearerFormat", "openIdConnectUrl"));
    protected static Set<String> EXTERNAL_DOCS_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "url"));
    protected static Set<String> COMPONENTS_KEYS = new LinkedHashSet<String>(Arrays.asList("schemas", "responses", "parameters", "examples", "requestBodies", "headers", "securitySchemes", "links", "callbacks"));
    protected static Set<String> SCHEMA_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "title", "multipleOf", "maximum", "format", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties", "required", "enum", "type", "allOf", "oneOf", "anyOf", "not", "items", "properties", "additionalProperties", "description", "default", "nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"));
    protected static Set<String> EXAMPLE_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "value", "externalValue"));
    protected static Set<String> HEADER_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> LINK_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "operationRef", "operationId", "parameters", "requestBody", "description", "server"));
    protected static Set<String> MEDIATYPE_KEYS = new LinkedHashSet<String>(Arrays.asList("schema", "example", "examples", "encoding"));
    protected static Set<String> XML_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "namespace", "prefix", "attribute", "wrapped"));
    protected static Set<String> OAUTHFLOW_KEYS = new LinkedHashSet<String>(Arrays.asList("authorizationUrl", "tokenUrl", "refreshUrl", "scopes"));
    protected static Set<String> OAUTHFLOWS_KEYS = new LinkedHashSet<String>(Arrays.asList("implicit", "password", "clientCredentials", "authorizationCode"));
    protected static Set<String> ENCODING_KEYS = new LinkedHashSet<String>(Arrays.asList("contentType", "headers", "style", "explode", "allowReserved"));
    protected static Set<String> ROOT_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("openapi", "info", "servers", "paths", "components", "security", "tags", "externalDocs", "webhooks", "jsonSchemaDialect"));
    protected static Set<String> RESERVED_KEYWORDS_31 = new LinkedHashSet<String>(Arrays.asList("x-oai-", "x-oas-"));
    protected static Set<String> INFO_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("title", "summary", "description", "termsOfService", "contact", "license", "version"));
    protected static Set<String> CONTACT_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("name", "url", "email"));
    protected static Set<String> LICENSE_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("name", "url", "identifier"));
    protected static Set<String> TAG_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("description", "name", "externalDocs"));
    protected static Set<String> RESPONSE_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "headers", "content", "links"));
    protected static Set<String> SERVER_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("url", "description", "variables"));
    protected static Set<String> SERVER_VARIABLE_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("enum", "default", "description"));
    protected static Set<String> PATHITEM_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "get", "put", "post", "delete", "head", "patch", "options", "trace", "servers", "parameters"));
    protected static Set<String> OPERATION_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("tags", "summary", "description", "externalDocs", "operationId", "parameters", "requestBody", "responses", "callbacks", "deprecated", "security", "servers"));
    protected static Set<String> PARAMETER_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> REQUEST_BODY_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "description", "content", "required"));
    protected static Set<String> SECURITY_SCHEME_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "type", "name", "in", "description", "flows", "scheme", "bearerFormat", "openIdConnectUrl"));
    protected static Set<String> EXTERNAL_DOCS_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("description", "url"));
    protected static Set<String> COMPONENTS_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("schemas", "responses", "pathItems", "parameters", "examples", "requestBodies", "headers", "securitySchemes", "links", "callbacks"));
    protected static Set<String> SCHEMA_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "title", "multipleOf", "maximum", "format", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties", "required", "enum", "type", "allOf", "oneOf", "anyOf", "not", "items", "properties", "additionalProperties", "description", "default", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated", "const", "examples", "$id", "$comment", "if", "then", "else", "unevaluatedProperties", "unevaluatedItems", "prefixItems", "contains", "contentEncoding", "contentMediaType", "$anchor", "$schema", "contentSchema", "propertyNames", "dependentSchemas", "dependentRequired", "minContains", "maxContains", "patternProperties", "$vocabulary", "$dynamicAnchor", "$dynamicRef"));
    protected static Set<String> EXAMPLE_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "summary", "description", "value", "externalValue"));
    protected static Set<String> HEADER_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "name", "in", "description", "required", "deprecated", "allowEmptyValue", "style", "explode", "allowReserved", "schema", "example", "examples", "content"));
    protected static Set<String> LINK_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("$ref", "operationRef", "operationId", "parameters", "requestBody", "description", "server"));
    protected static Set<String> MEDIATYPE_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("schema", "example", "examples", "encoding"));
    protected static Set<String> XML_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("name", "namespace", "prefix", "attribute", "wrapped"));
    protected static Set<String> OAUTHFLOW_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("authorizationUrl", "tokenUrl", "refreshUrl", "scopes"));
    protected static Set<String> OAUTHFLOWS_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("implicit", "password", "clientCredentials", "authorizationCode"));
    protected static Set<String> ENCODING_KEYS_31 = new LinkedHashSet<String>(Arrays.asList("contentType", "headers", "style", "explode", "allowReserved"));
    protected static Map<String, Map<String, Set<String>>> KEYS = new LinkedHashMap<String, Map<String, Set<String>>>();
    protected static Set<JsonNodeType> validNodeTypes = new LinkedHashSet<JsonNodeType>(Arrays.asList(JsonNodeType.OBJECT, JsonNodeType.STRING));
    private static final String QUERY_PARAMETER = "query";
    private static final String COOKIE_PARAMETER = "cookie";
    private static final String PATH_PARAMETER = "path";
    private static final String HEADER_PARAMETER = "header";
    private static final Pattern RFC3339_DATE_TIME_PATTERN;
    private static final Pattern RFC3339_DATE_PATTERN;
    private static final String REFERENCE_SEPARATOR = "#/";
    private static final int MAX_EXTENSION_ENTRIES = 20;
    private static final Map<ClassLoader, List<JsonSchemaParserExtension>> jsonSchemaParserExtensionMap;
    private Components components;
    private JsonNode rootNode;
    private Map<String, Object> rootMap;
    private String basePath;
    private final Set<String> operationIDs = new HashSet<String>();
    private Map<String, String> localSchemaRefs = new HashMap<String, String>();

    public SwaggerParseResult deserialize(JsonNode rootNode) {
        return this.deserialize(rootNode, null);
    }

    public SwaggerParseResult deserialize(JsonNode rootNode, String path2) {
        return this.deserialize(rootNode, path2, new ParseOptions());
    }

    public SwaggerParseResult deserialize(JsonNode rootNode, String path2, ParseOptions options2) {
        return this.deserialize(rootNode, path2, new ParseOptions(), false);
    }

    public SwaggerParseResult deserialize(JsonNode rootNode, String path2, ParseOptions options2, boolean isOaiAuthor) {
        this.basePath = path2;
        this.rootNode = rootNode;
        this.rootMap = new ObjectMapper().convertValue((Object)rootNode, Map.class);
        SwaggerParseResult result2 = new SwaggerParseResult();
        try {
            ParseResult rootParse = new ParseResult();
            rootParse.setOaiAuthor(options2.isOaiAuthor());
            rootParse.setInferSchemaType(options2.isInferSchemaType());
            rootParse.setAllowEmptyStrings(options2.isAllowEmptyString());
            rootParse.setValidateInternalRefs(options2.isValidateInternalRefs());
            rootParse.setExplicitStyleAndExplode(options2.isExplicitStyleAndExplode());
            OpenAPI api = this.parseRoot(rootNode, rootParse, path2);
            result2.openapi31(rootParse.isOpenapi31());
            result2.setOpenAPI(api);
            result2.setMessages(rootParse.getMessages());
        }
        catch (Exception e2) {
            if (StringUtils.isNotBlank(e2.getMessage())) {
                result2.setMessages(Arrays.asList(e2.getMessage()));
            }
            result2.setMessages(Arrays.asList("Unexpected error deserialising spec"));
        }
        return result2;
    }

    public OpenAPI parseRoot(JsonNode node, ParseResult result2, String path2) {
        String location = "";
        OpenAPI openAPI = new OpenAPI();
        if (node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            Map<String, Object> extensions;
            List<SecurityRequirement> securityRequirements;
            ArrayNode array;
            ObjectNode rootNode = (ObjectNode)node;
            String value2 = this.getString("openapi", rootNode, true, location, result2);
            if (value2 == null || !value2.startsWith("3.0") && !value2.startsWith("3.1")) {
                return null;
            }
            if (value2.startsWith("3.1")) {
                result2.openapi31(true);
                openAPI.setSpecVersion(SpecVersion.V31);
            }
            if (!value2.startsWith("3.0.") && !value2.startsWith("3.1.")) {
                result2.warning(location, "The provided definition does not specify a valid version field");
            }
            openAPI.setOpenapi(value2);
            ObjectNode obj = this.getObject("info", rootNode, true, location, result2);
            if (obj != null) {
                Info info = this.getInfo(obj, "info", result2);
                openAPI.setInfo(info);
            }
            if ((obj = this.getObject("components", rootNode, false, location, result2)) != null) {
                Components components = this.getComponents(obj, "components", result2);
                openAPI.setComponents(components);
                this.components = components;
                if (result2.validateInternalRefs) {
                    for (String schema : this.localSchemaRefs.keySet()) {
                        if (components.getSchemas() == null) {
                            result2.missing(this.localSchemaRefs.get(schema), schema);
                            continue;
                        }
                        if (components.getSchemas().get(schema) != null) continue;
                        result2.invalidType(this.localSchemaRefs.get(schema), schema, "schema", rootNode);
                    }
                }
            }
            boolean pathsRequired = true;
            if (result2.isOpenapi31()) {
                pathsRequired = false;
            }
            if ((obj = this.getObject("paths", rootNode, pathsRequired, location, result2)) != null) {
                Paths paths = this.getPaths(obj, "paths", result2);
                openAPI.setPaths(paths);
            }
            if ((array = this.getArray("servers", rootNode, false, location, result2)) != null && array.size() > 0) {
                openAPI.setServers(this.getServersList(array, String.format("%s.%s", location, "servers"), result2, path2));
            } else {
                Server defaultServer = new Server();
                defaultServer.setUrl("/");
                ArrayList<Server> servers = new ArrayList<Server>();
                servers.add(defaultServer);
                openAPI.setServers(servers);
            }
            obj = this.getObject("externalDocs", rootNode, false, location, result2);
            if (obj != null) {
                ExternalDocumentation externalDocs = this.getExternalDocs(obj, "externalDocs", result2);
                openAPI.setExternalDocs(externalDocs);
            }
            if ((array = this.getArray("tags", rootNode, false, location, result2)) != null && array.size() > 0) {
                openAPI.setTags(this.getTagList(array, "tags", result2));
            }
            if ((array = this.getArray("security", rootNode, false, location, result2)) != null && array.size() > 0 && (securityRequirements = this.getSecurityRequirementsList(array, "security", result2)) != null && securityRequirements.size() > 0) {
                openAPI.setSecurity(securityRequirements);
            }
            if (result2.isOpenapi31() && (obj = this.getObject("webhooks", rootNode, false, location, result2)) != null) {
                Map<String, PathItem> webhooks = this.getWebhooks(obj, "webhooks", result2);
                openAPI.setWebhooks(webhooks);
            }
            if ((extensions = this.getExtensions(rootNode)) != null && extensions.size() > 0) {
                openAPI.setExtensions(extensions);
            }
            if (result2.isOpenapi31() && (value2 = this.getString("jsonSchemaDialect", rootNode, false, location, result2)) != null) {
                if (this.isValidURI(value2)) {
                    openAPI.setJsonSchemaDialect(value2);
                } else {
                    result2.warning(location, "jsonSchemaDialect. Invalid url: " + value2);
                }
            }
            if (result2.isOpenapi31() && openAPI.getComponents() == null && openAPI.getPaths() == null && openAPI.getWebhooks() == null) {
                result2.warning(location, "The OpenAPI document MUST contain at least one paths field, a components field or a webhooks field");
            }
            Set<String> keys2 = this.getKeys(rootNode);
            Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
            for (String key2 : keys2) {
                if (!specKeys.get("ROOT_KEYS").contains(key2) && !key2.startsWith("x-")) {
                    result2.extra(location, key2, node.get(key2));
                }
                this.validateReservedKeywords(specKeys, key2, location, result2);
            }
        } else {
            result2.invalidType(location, "openapi", "object", node);
            result2.invalid();
            return null;
        }
        return openAPI;
    }

    boolean isValidURI(String uriString) {
        try {
            URI uri2 = new URI(uriString);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void validateReservedKeywords(Map<String, Set<String>> specKeys, String key2, String location, ParseResult result2) {
        if (!result2.isOaiAuthor() && result2.isOpenapi31() && specKeys.get("RESERVED_KEYWORDS").stream().filter(rk -> key2.startsWith((String)rk)).findAny().orElse(null) != null) {
            result2.reserved(location, key2);
        }
    }

    public String mungedRef(String refString) {
        if (!(refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return null;
    }

    public Map<String, Object> getExtensions(ObjectNode node) {
        Map<String, Object> extensions = this.tryDirectExtensions(node);
        if (extensions.isEmpty()) {
            extensions = this.tryUnwrapLookupExtensions(node);
        }
        return extensions;
    }

    private Map<String, Object> tryUnwrapLookupExtensions(ObjectNode node) {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        JsonNode extensionsNode = node.get("extensions");
        if (Objects.nonNull(extensionsNode) && JsonNodeType.OBJECT.equals((Object)node.getNodeType())) {
            ObjectNode extensionsObjectNode = (ObjectNode)extensionsNode;
            extensions.putAll(this.tryDirectExtensions(extensionsObjectNode));
        }
        return extensions;
    }

    private Map<String, Object> tryDirectExtensions(ObjectNode node) {
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            if (!key2.startsWith("x-")) continue;
            extensions.put(key2, Json.mapper().convertValue((Object)node.get(key2), Object.class));
        }
        return extensions;
    }

    public Components getComponents(ObjectNode obj, String location, ParseResult result2) {
        if (obj == null) {
            return null;
        }
        Components components = new Components();
        ObjectNode node = this.getObject("schemas", obj, false, location, result2);
        if (node != null) {
            components.setSchemas(this.getSchemas(node, String.format("%s.%s", location, "schemas"), result2, true));
        }
        if ((node = this.getObject("responses", obj, false, location, result2)) != null) {
            components.setResponses(this.getResponses(node, String.format("%s.%s", location, "responses"), result2, true));
        }
        if (result2.isOpenapi31() && (node = this.getObject("pathItems", obj, false, location, result2)) != null) {
            components.setPathItems(this.getPathItems(node, String.format("%s.%s", location, "pathItems"), result2, true));
        }
        if ((node = this.getObject("parameters", obj, false, location, result2)) != null) {
            components.setParameters(this.getParameters(node, String.format("%s.%s", location, "parameters"), result2, true));
        }
        if ((node = this.getObject("examples", obj, false, location, result2)) != null) {
            components.setExamples(this.getExamples(node, String.format("%s.%s", location, "examples"), result2, true));
        }
        if ((node = this.getObject("requestBodies", obj, false, location, result2)) != null) {
            components.setRequestBodies(this.getRequestBodies(node, String.format("%s.%s", location, "requestBodies"), result2, true));
        }
        if ((node = this.getObject("headers", obj, false, location, result2)) != null) {
            components.setHeaders(this.getHeaders(node, String.format("%s.%s", location, "headers"), result2, true));
        }
        if ((node = this.getObject("securitySchemes", obj, false, location, result2)) != null) {
            components.setSecuritySchemes(this.getSecuritySchemes(node, String.format("%s.%s", location, "securitySchemes"), result2, true));
        }
        if ((node = this.getObject("links", obj, false, location, result2)) != null) {
            components.setLinks(this.getLinks(node, String.format("%s.%s", location, "links"), result2, true));
        }
        if ((node = this.getObject("callbacks", obj, false, location, result2)) != null) {
            components.setCallbacks(this.getCallbacks(node, String.format("%s.%s", location, "callbacks"), result2, true));
        }
        components.setExtensions(new LinkedHashMap<String, Object>());
        Map<String, Object> extensions = this.getExtensions(obj);
        if (extensions != null && extensions.size() > 0) {
            components.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("COMPONENTS_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return components;
    }

    public List<Tag> getTagList(ArrayNode obj, String location, ParseResult result2) {
        if (obj == null) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        HashSet<String> tagsTracker = new HashSet<String>();
        for (JsonNode item : obj) {
            Tag tag;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (tag = this.getTag((ObjectNode)item, location, result2)) == null) continue;
            tags.add(tag);
            if (tagsTracker.contains(tag.getName())) {
                result2.uniqueTags(location, tag.getName());
            }
            tagsTracker.add(tag.getName());
        }
        return tags;
    }

    public Tag getTag(ObjectNode obj, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode docs;
        ExternalDocumentation externalDocs;
        if (obj == null) {
            return null;
        }
        Tag tag = new Tag();
        String value2 = this.getString("name", obj, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            tag.setName(value2);
        }
        value2 = this.getString("description", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            tag.setDescription(value2);
        }
        if ((externalDocs = this.getExternalDocs(docs = this.getObject("externalDocs", obj, false, location, result2), String.format("%s.%s", location, "externalDocs"), result2)) != null) {
            tag.setExternalDocs(externalDocs);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            tag.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("TAG_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return tag;
    }

    public List<Server> getServersList(ArrayNode obj, String location, ParseResult result2, String path2) {
        ArrayList<Server> servers = new ArrayList<Server>();
        if (obj == null) {
            return null;
        }
        for (JsonNode item : obj) {
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT)) continue;
            Server server2 = this.getServer((ObjectNode)item, location, result2, path2);
            if (server2 != null) {
                servers.add(server2);
                continue;
            }
            Server defaultServer = new Server();
            defaultServer.setUrl("/");
            servers.add(defaultServer);
        }
        return servers;
    }

    public List<Server> getServersList(ArrayNode obj, String location, ParseResult result2) {
        return this.getServersList(obj, location, result2, null);
    }

    public Server getServer(ObjectNode obj, String location, ParseResult result2) {
        return this.getServer(obj, location, result2, null);
    }

    public Server getServer(ObjectNode obj, String location, ParseResult result2, String path2) {
        Map<String, Object> extensions;
        ObjectNode variables;
        ServerVariables serverVariables;
        if (obj == null) {
            return null;
        }
        Server server2 = new Server();
        if (obj.get("variables") != null && (serverVariables = this.getServerVariables(variables = this.getObject("variables", obj, false, location, result2), String.format("%s.%s", location, "variables"), result2)) != null && serverVariables.size() > 0) {
            server2.setVariables(serverVariables);
        }
        String value2 = this.getString("url", obj, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            block11: {
                if (!this.isValidURL(value2) && path2 != null) {
                    try {
                        URI absURI = new URI(path2.replaceAll("\\\\", "/"));
                        if ("http".equals(absURI.getScheme()) || "https".equals(absURI.getScheme())) {
                            value2 = absURI.resolve(new URI(value2)).toString();
                        }
                    }
                    catch (URISyntaxException e2) {
                        int openBrace = value2.indexOf("{");
                        int closeBrace = value2.indexOf("}");
                        if (openBrace <= -1 || closeBrace <= -1) break block11;
                        String variable = value2.substring(openBrace + 1, closeBrace);
                        if (server2.getVariables() == null || server2.getVariables().containsKey(variable)) break block11;
                        result2.warning(location, "invalid url : " + value2);
                    }
                }
            }
            server2.setUrl(value2);
        }
        value2 = this.getString("description", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            server2.setDescription(value2);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            server2.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("SERVER_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return server2;
    }

    boolean isValidURL(String urlString) {
        try {
            URL url2 = new URL(urlString);
            url2.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServerVariables getServerVariables(ObjectNode obj, String location, ParseResult result2) {
        ServerVariables serverVariables = new ServerVariables();
        if (obj == null) {
            return null;
        }
        Set<String> serverKeys = this.getKeys(obj);
        for (String serverName : serverKeys) {
            JsonNode serverValue = obj.get(serverName);
            ObjectNode server2 = (ObjectNode)serverValue;
            ServerVariable serverVariable = this.getServerVariable(server2, String.format("%s.%s", location, serverName), result2);
            serverVariables.addServerVariable(serverName, serverVariable);
        }
        return serverVariables;
    }

    public ServerVariable getServerVariable(ObjectNode obj, String location, ParseResult result2) {
        Map<String, Object> extensions;
        if (obj == null) {
            return null;
        }
        ServerVariable serverVariable = new ServerVariable();
        ArrayNode arrayNode = this.getArray("enum", obj, false, location, result2);
        if (arrayNode != null) {
            if (arrayNode.size() == 0 && result2.isOpenapi31()) {
                result2.warning(location, "enum array MUST NOT be empty");
            } else {
                ArrayList<String> _enum = new ArrayList<String>();
                for (JsonNode n : arrayNode) {
                    if (n.isValueNode()) {
                        _enum.add(n.asText());
                        serverVariable.setEnum(_enum);
                        continue;
                    }
                    result2.invalidType(location, "enum", "value", n);
                }
            }
        }
        String value2 = this.getString("default", obj, true, String.format("%s.%s", location, "default"), result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            serverVariable.setDefault(value2);
        }
        value2 = this.getString("description", obj, false, String.format("%s.%s", location, "description"), result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            serverVariable.setDescription(value2);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            serverVariable.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("SERVER_VARIABLE_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return serverVariable;
    }

    public Paths getPaths(ObjectNode obj, String location, ParseResult result2) {
        Paths paths = new Paths();
        if (this.getPathItems(obj, location, result2, paths, false)) {
            return paths;
        }
        return null;
    }

    public Map<String, PathItem> getPathItems(ObjectNode node, String location, ParseResult result2, boolean underComponents) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, PathItem> pathItems = new LinkedHashMap<String, PathItem>();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            PathItem pathItem;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", key2)) {
                result2.warning(location, "PathItem key " + key2 + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if ((pathItem = this.getPathItem((ObjectNode)node.get(key2), location, result2)) == null) continue;
            pathItems.put(key2, pathItem);
        }
        return pathItems;
    }

    public Map<String, PathItem> getWebhooks(ObjectNode obj, String location, ParseResult result2) {
        LinkedHashMap<String, PathItem> webhooks = new LinkedHashMap<String, PathItem>();
        if (this.getPathItems(obj, location, result2, webhooks, true)) {
            return webhooks;
        }
        return null;
    }

    protected boolean getPathItems(ObjectNode obj, String location, ParseResult result2, Map<String, PathItem> paths, boolean isWebhook) {
        if (obj == null) {
            return false;
        }
        Set<String> pathKeys = this.getKeys(obj);
        for (String pathName : pathKeys) {
            JsonNode pathValue = obj.get(pathName);
            if (paths instanceof Paths && pathName.startsWith("x-")) {
                Map<String, Object> extensions = this.getExtensions(obj);
                if (extensions == null || extensions.size() <= 0) continue;
                ((Paths)paths).setExtensions(extensions);
                continue;
            }
            if (!pathValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, pathName, "object", pathValue);
                continue;
            }
            if (!pathName.startsWith("/") && !isWebhook) {
                result2.warning(location, " Resource " + pathName + " should start with /");
            }
            ObjectNode path2 = (ObjectNode)pathValue;
            PathItem pathObj = this.getPathItem(path2, String.format("%s.'%s'", location, pathName), result2);
            ArrayList<String> eachPart = new ArrayList<String>();
            Matcher m4 = Pattern.compile("\\{(.+?)\\}").matcher(pathName);
            while (m4.find()) {
                eachPart.add(m4.group());
            }
            eachPart.stream().forEach(part2 -> {
                String pathParam = part2.substring(1, part2.length() - 1);
                boolean definedInPathLevel = this.isPathParamDefined(pathParam, pathObj.getParameters());
                if (!definedInPathLevel) {
                    List<Operation> operationsInAPath = this.getAllOperationsInAPath(pathObj);
                    operationsInAPath.forEach(operation -> {
                        List<Parameter> operationParameters = operation.getParameters();
                        if (operationParameters == null) {
                            operationParameters = Collections.emptyList();
                        }
                        operationParameters.forEach(parameter -> {
                            if (PATH_PARAMETER.equalsIgnoreCase(parameter.getIn()) && Boolean.FALSE.equals(parameter.getRequired())) {
                                result2.warning(location, "For path parameter " + parameter.getName() + " the required value should be true");
                            }
                        });
                        if (!this.isPathParamDefined(pathParam, operationParameters)) {
                            result2.warning(location + ".'" + pathName + "'", " Declared path parameter " + pathParam + " needs to be defined as a path parameter in path or operation level");
                            return;
                        }
                    });
                }
            });
            paths.put(pathName, pathObj);
        }
        return true;
    }

    private boolean isPathParamDefined(String pathParam, List<Parameter> parameters2) {
        if (parameters2 == null || parameters2.isEmpty()) {
            return false;
        }
        Parameter pathParamDefined = parameters2.stream().filter(parameter -> parameter.get$ref() != null || pathParam.equals(parameter.getName()) && PATH_PARAMETER.equals(parameter.getIn())).findFirst().orElse(null);
        return pathParamDefined != null;
    }

    private void addToOperationsList(List<Operation> operationsList, Operation operation) {
        if (operation == null) {
            return;
        }
        operationsList.add(operation);
    }

    public List<Operation> getAllOperationsInAPath(PathItem pathObj) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.addToOperationsList(operations, pathObj.getGet());
        this.addToOperationsList(operations, pathObj.getPut());
        this.addToOperationsList(operations, pathObj.getPost());
        this.addToOperationsList(operations, pathObj.getPatch());
        this.addToOperationsList(operations, pathObj.getDelete());
        this.addToOperationsList(operations, pathObj.getTrace());
        this.addToOperationsList(operations, pathObj.getOptions());
        this.addToOperationsList(operations, pathObj.getHead());
        return operations;
    }

    public PathItem getPathItem(ObjectNode obj, String location, ParseResult result2) {
        Map<String, Object> extensions;
        Operation operation;
        ObjectNode node;
        ArrayNode servers;
        ArrayNode parameters2;
        PathItem pathItem = new PathItem();
        if (obj.get("$ref") != null) {
            JsonNode ref = obj.get("$ref");
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    pathItem.set$ref(mungedRef);
                } else {
                    pathItem.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/pathItems")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type PathItem");
                }
                if (result2.isOpenapi31()) {
                    String value2 = this.getString("summary", obj, false, location, result2);
                    if (StringUtils.isNotBlank(value2)) {
                        pathItem.setSummary(value2);
                    }
                    if (StringUtils.isNotBlank(value2 = this.getString("description", obj, false, location, result2))) {
                        pathItem.setDescription(value2);
                    }
                }
                return pathItem;
            }
            if (ref.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode node2 = (ObjectNode)ref;
                Set<String> keys2 = this.getKeys(node2);
                for (String key2 : keys2) {
                    result2.extra(location, key2, node2.get(key2));
                }
            }
            return null;
        }
        String value3 = this.getString("summary", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            pathItem.setSummary(value3);
        }
        value3 = this.getString("description", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            pathItem.setDescription(value3);
        }
        if ((parameters2 = this.getArray("parameters", obj, false, location, result2)) != null && parameters2.size() > 0) {
            pathItem.setParameters(this.getParameterList(parameters2, location, result2));
        }
        if ((servers = this.getArray("servers", obj, false, location, result2)) != null && servers.size() > 0) {
            pathItem.setServers(this.getServersList(servers, location, result2));
        }
        if ((node = this.getObject("get", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(get)", result2)) != null) {
            pathItem.setGet(operation);
        }
        if ((node = this.getObject("put", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(put)", result2)) != null) {
            pathItem.setPut(operation);
        }
        if ((node = this.getObject("post", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(post)", result2)) != null) {
            pathItem.setPost(operation);
        }
        if ((node = this.getObject("head", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(head)", result2)) != null) {
            pathItem.setHead(operation);
        }
        if ((node = this.getObject("delete", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(delete)", result2)) != null) {
            pathItem.setDelete(operation);
        }
        if ((node = this.getObject("patch", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(patch)", result2)) != null) {
            pathItem.setPatch(operation);
        }
        if ((node = this.getObject("options", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(options)", result2)) != null) {
            pathItem.setOptions(operation);
        }
        if ((node = this.getObject("trace", obj, false, location, result2)) != null && (operation = this.getOperation(node, location + "(trace)", result2)) != null) {
            pathItem.setTrace(operation);
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            pathItem.setExtensions(extensions);
        }
        Set<String> keys3 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key3 : keys3) {
            if (!specKeys.get("PATHITEM_KEYS").contains(key3) && !key3.startsWith("x-")) {
                result2.extra(location, key3, obj.get(key3));
            }
            this.validateReservedKeywords(specKeys, key3, location, result2);
        }
        return pathItem;
    }

    public ExternalDocumentation getExternalDocs(ObjectNode node, String location, ParseResult result2) {
        ExternalDocumentation externalDocs = null;
        if (node != null) {
            Map<String, Object> extensions;
            externalDocs = new ExternalDocumentation();
            String value2 = this.getString("description", node, false, location, result2);
            if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
                externalDocs.description(value2);
            }
            value2 = this.getString("url", node, true, location, result2);
            if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
                externalDocs.url(value2);
            }
            if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
                externalDocs.setExtensions(extensions);
            }
            Set<String> keys2 = this.getKeys(node);
            Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
            for (String key2 : keys2) {
                if (specKeys.get("EXTERNAL_DOCS_KEYS").contains(key2) || key2.startsWith("x-")) continue;
                result2.extra(location, key2, node.get(key2));
            }
        }
        return externalDocs;
    }

    public String getString(String key2, ObjectNode node, boolean required, String location, ParseResult result2, Set<String> uniqueValues, boolean noInvalidError) {
        return this.getString(key2, node, required, location, result2, uniqueValues, noInvalidError, false);
    }

    public String getString(String key2, ObjectNode node, boolean required, String location, ParseResult result2, Set<String> uniqueValues, boolean noInvalidError, boolean missingForNullNode) {
        String value2 = null;
        JsonNode v = node.get(key2);
        if (node == null || v == null || v.isNull() && missingForNullNode) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (!v.isValueNode()) {
            if (!noInvalidError) {
                result2.invalidType(location, key2, "string", node);
            }
        } else if (!v.isNull()) {
            value2 = v.asText();
            if (uniqueValues != null && !uniqueValues.add(value2)) {
                result2.unique(location, "operationId");
                result2.invalid();
            }
        }
        return value2;
    }

    public String getString(String key2, ObjectNode node, boolean required, String location, ParseResult result2, Set<String> uniqueValues) {
        return this.getString(key2, node, required, location, result2, uniqueValues, false);
    }

    public String getString(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        return this.getString(key2, node, required, location, result2, null);
    }

    public Set<String> getKeys(ObjectNode node) {
        LinkedHashSet<String> keys2 = new LinkedHashSet<String>();
        if (node == null) {
            return keys2;
        }
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            keys2.add(it.next());
        }
        return keys2;
    }

    public ObjectNode getObject(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        JsonNode value2 = node.get(key2);
        ObjectNode object = null;
        if (value2 == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (!value2.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            result2.invalidType(location, key2, "object", value2);
            if (required) {
                result2.invalid();
            }
        } else {
            object = (ObjectNode)value2;
        }
        return object;
    }

    public JsonNode getObjectOrBoolean(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        JsonNode value2 = node.get(key2);
        if (value2 == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
            return null;
        }
        Boolean boolValue = null;
        if (value2.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            boolValue = value2.asBoolean();
        } else if (value2.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = value2.textValue();
            if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
                boolValue = Boolean.parseBoolean(stringValue);
            } else {
                result2.invalidType(location, key2, "object", value2);
                return null;
            }
        }
        if (boolValue != null) {
            return value2;
        }
        if (!value2.isObject()) {
            result2.invalidType(location, key2, "object", value2);
            return null;
        }
        return value2;
    }

    public Info getInfo(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        Info info = new Info();
        String value2 = this.getString("title", node, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            info.setTitle(value2);
        }
        value2 = this.getString("description", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            info.setDescription(value2);
        }
        if (result2.isOpenapi31() && StringUtils.isNotBlank(value2 = this.getString("summary", node, false, location, result2))) {
            info.setSummary(value2);
        }
        value2 = this.getString("termsOfService", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            info.setTermsOfService(value2);
        }
        ObjectNode obj = this.getObject("contact", node, false, "contact", result2);
        Contact contact = this.getContact(obj, String.format("%s.%s", location, "contact"), result2);
        if (obj != null) {
            info.setContact(contact);
        }
        obj = this.getObject("license", node, false, location, result2);
        License license2 = this.getLicense(obj, String.format("%s.%s", location, "license"), result2);
        if (obj != null) {
            info.setLicense(license2);
        }
        value2 = this.getString("version", node, true, location, result2, null, false, true);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            info.setVersion(value2);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            info.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("INFO_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return info;
    }

    public License getLicense(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        boolean needsIdentifier;
        if (node == null) {
            return null;
        }
        License license2 = new License();
        String value2 = this.getString("name", node, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            license2.setName(value2);
        }
        value2 = this.getString("url", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            try {
                new URL(value2);
            }
            catch (Exception e2) {
                result2.warning(location, value2);
            }
            license2.setUrl(value2);
        }
        if (result2.isOpenapi31() && StringUtils.isNotBlank(value2 = this.getString("identifier", node, needsIdentifier = license2.getUrl() == null, location, result2))) {
            if (!needsIdentifier) {
                result2.extra(location, "identifier", node);
                result2.invalid();
            } else {
                license2.setIdentifier(value2);
            }
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            license2.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("LICENSE_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return license2;
    }

    public Contact getContact(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        Contact contact = new Contact();
        String value2 = this.getString("name", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            contact.setName(value2);
        }
        value2 = this.getString("url", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            try {
                new URL(value2);
            }
            catch (Exception e2) {
                result2.warning(location, value2);
            }
            contact.setUrl(value2);
        }
        value2 = this.getString("email", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            contact.setEmail(value2);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            contact.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("CONTACT_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return contact;
    }

    public Content getContent(ObjectNode node, String location, ParseResult result2) {
        if (node == null) {
            return null;
        }
        Content content2 = new Content();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            MediaType mediaType = this.getMediaType((ObjectNode)node.get(key2), String.format("%s.'%s'", location, key2), result2);
            if (mediaType == null) continue;
            content2.addMediaType(key2, mediaType);
        }
        return content2;
    }

    public MediaType getMediaType(ObjectNode contentNode, String location, ParseResult result2) {
        Object example;
        ObjectNode examplesObject;
        Map<String, Object> extensions;
        ObjectNode encodingObject;
        if (contentNode == null) {
            return null;
        }
        MediaType mediaType = new MediaType();
        ObjectNode schemaObject = this.getObject("schema", contentNode, false, location, result2);
        if (schemaObject != null) {
            mediaType.setSchema(this.getSchema(schemaObject, String.format("%s.%s", location, "schema"), result2));
        }
        if ((encodingObject = this.getObject("encoding", contentNode, false, location, result2)) != null) {
            Set mediaTypeProperties;
            String encodingLocation = String.format("%s.%s", location, "encoding");
            mediaType.setEncoding(this.getEncodingMap(encodingObject, encodingLocation, result2));
            Set<Object> set2 = mediaType.getSchema() == null ? Collections.emptySet() : (mediaTypeProperties = mediaType.getSchema().get$ref() == null ? Optional.ofNullable(mediaType.getSchema().getProperties()).map(Map::keySet).orElse(Collections.emptySet()) : null);
            if (mediaTypeProperties != null) {
                mediaType.getEncoding().keySet().stream().filter(ep -> !mediaTypeProperties.contains(ep)).forEach(ep -> result2.extra(encodingLocation, (String)ep, encodingObject));
            }
        }
        if ((extensions = this.getExtensions(contentNode)) != null && extensions.size() > 0) {
            mediaType.setExtensions(extensions);
        }
        if ((examplesObject = this.getObject("examples", contentNode, false, location, result2)) != null) {
            mediaType.setExamples(this.getExamples(examplesObject, String.format("%s.%s", location, "examples"), result2, false));
        }
        if ((example = this.getAnyType("example", contentNode, location, result2)) != null) {
            if (examplesObject != null) {
                result2.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                mediaType.setExample(example instanceof NullNode ? null : example);
            }
        }
        Set<String> keys2 = this.getKeys(contentNode);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("MEDIATYPE_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, contentNode.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return mediaType;
    }

    public Map<String, Encoding> getEncodingMap(ObjectNode node, String location, ParseResult result2) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Encoding> encodings = new LinkedHashMap<String, Encoding>();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            Encoding encoding = this.getEncoding((ObjectNode)node.get(key2), location, result2);
            if (encoding == null) continue;
            encodings.put(key2, encoding);
        }
        return encodings;
    }

    public Encoding getEncoding(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode headersObject;
        Boolean allowReserved;
        Boolean explode;
        if (node == null) {
            return null;
        }
        Encoding encoding = new Encoding();
        String value2 = this.getString("contentType", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            encoding.setContentType(value2);
        }
        if (StringUtils.isBlank(value2 = this.getString("style", node, false, location, result2))) {
            if (result2.isExplicitStyleAndExplode()) {
                encoding.setStyle(Encoding.StyleEnum.FORM);
            }
        } else if (value2.equals(Encoding.StyleEnum.FORM.toString())) {
            encoding.setStyle(Encoding.StyleEnum.FORM);
        } else if (value2.equals(Encoding.StyleEnum.DEEP_OBJECT.toString())) {
            encoding.setStyle(Encoding.StyleEnum.DEEP_OBJECT);
        } else if (value2.equals(Encoding.StyleEnum.PIPE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.StyleEnum.PIPE_DELIMITED);
        } else if (value2.equals(Encoding.StyleEnum.SPACE_DELIMITED.toString())) {
            encoding.setStyle(Encoding.StyleEnum.SPACE_DELIMITED);
        } else {
            result2.invalidType(location, "style", "string", node);
        }
        if ((explode = this.getBoolean("explode", node, false, location, result2)) != null) {
            encoding.setExplode(explode);
        }
        if ((allowReserved = this.getBoolean("allowReserved", node, false, location, result2)) != null) {
            encoding.setAllowReserved(allowReserved);
        }
        if ((headersObject = this.getObject("headers", node, false, location, result2)) != null) {
            encoding.setHeaders(this.getHeaders(headersObject, location, result2, false));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            encoding.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("ENCODING_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return encoding;
    }

    public Map<String, Link> getLinks(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        Set<String> linkKeys = this.getKeys(obj);
        for (String linkName : linkKeys) {
            JsonNode linkValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", linkName)) {
                result2.warning(location, "Link name " + linkName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(linkValue = obj.get(linkName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, linkName, "object", linkValue);
                continue;
            }
            ObjectNode link = (ObjectNode)linkValue;
            Link linkObj = this.getLink(link, String.format("%s.%s", location, linkName), result2);
            if (linkObj == null) continue;
            links.put(linkName, linkObj);
        }
        return links;
    }

    public Link getLink(ObjectNode linkNode, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode serverObject;
        ObjectNode headerObject;
        ObjectNode parametersObject;
        if (linkNode == null) {
            return null;
        }
        Link link = new Link();
        JsonNode ref = linkNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String desc;
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    link.set$ref(mungedRef);
                } else {
                    link.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/links")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Link");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(desc = this.getString("description", linkNode, false, location, result2))) {
                    link.setDescription(desc);
                }
                return link;
            }
            result2.invalidType(location, "$ref", "string", linkNode);
            return null;
        }
        String value2 = this.getString("operationRef", linkNode, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            link.setOperationRef(value2);
        }
        value2 = this.getString("operationId", linkNode, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            link.setOperationId(value2);
        }
        if ((parametersObject = this.getObject("parameters", linkNode, false, location, result2)) != null) {
            link.setParameters(this.getLinkParameters(parametersObject, location, result2));
        }
        String requestBody2 = this.getString("requestBody", linkNode, false, location, result2);
        if (result2.isAllowEmptyStrings() && requestBody2 != null) {
            link.setRequestBody(requestBody2);
        }
        if ((headerObject = this.getObject("headers", linkNode, false, location, result2)) != null) {
            link.setHeaders(this.getHeaders(headerObject, location, result2, false));
        }
        if ((serverObject = this.getObject("server", linkNode, false, location, result2)) != null) {
            link.setServer(this.getServer(serverObject, location, result2));
        }
        value2 = this.getString("description", linkNode, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            link.setDescription(value2);
        }
        if ((extensions = this.getExtensions(linkNode)) != null && extensions.size() > 0) {
            link.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(linkNode);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("LINK_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, linkNode.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return link;
    }

    private Map<String, String> getLinkParameters(ObjectNode parametersObject, String location, ParseResult result2) {
        LinkedHashMap<String, String> linkParameters = new LinkedHashMap<String, String>();
        Set<String> keys2 = this.getKeys(parametersObject);
        for (String name : keys2) {
            JsonNode value2 = parametersObject.get(name);
            linkParameters.put(name, value2.asText());
        }
        return linkParameters;
    }

    public Map<String, Callback> getCallbacks(ObjectNode node, String location, ParseResult result2, boolean underComponents) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            Callback callback2;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", key2)) {
                result2.warning(location, "Callback key " + key2 + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if ((callback2 = this.getCallback((ObjectNode)node.get(key2), location, result2)) == null) continue;
            callbacks.put(key2, callback2);
        }
        return callbacks;
    }

    public Callback getCallback(ObjectNode node, String location, ParseResult result2) {
        if (node == null) {
            return null;
        }
        Callback callback2 = new Callback();
        Set<String> keys2 = this.getKeys(node);
        for (String name : keys2) {
            Map<String, Object> extensions;
            JsonNode value2 = node.get(name);
            if (node == null) continue;
            JsonNode ref = node.get("$ref");
            if (ref != null) {
                if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    String mungedRef = this.mungedRef(ref.textValue());
                    if (mungedRef != null) {
                        callback2.set$ref(mungedRef);
                    } else {
                        callback2.set$ref(ref.textValue());
                    }
                    if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/callbacks")) {
                        result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Callback");
                    }
                    return callback2;
                }
                result2.invalidType(location, "$ref", "string", node);
                return null;
            }
            if (value2.isObject()) {
                callback2.addPathItem(name, this.getPathItem((ObjectNode)value2, location, result2));
            } else {
                result2.invalidType(location, name, "object", value2);
            }
            if ((extensions = this.getExtensions(node)) == null || extensions.size() <= 0) continue;
            callback2.setExtensions(extensions);
        }
        return callback2;
    }

    public XML getXml(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        Boolean wrapped;
        Boolean attribute;
        if (node == null) {
            return null;
        }
        XML xml = new XML();
        String value2 = this.getString("name", node, false, String.format("%s.%s", location, "name"), result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            xml.setName(value2);
        }
        value2 = this.getString("namespace", node, false, String.format("%s.%s", location, "namespace"), result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            xml.setNamespace(value2);
        }
        value2 = this.getString("prefix", node, false, String.format("%s.%s", location, "prefix"), result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            xml.setPrefix(value2);
        }
        if ((attribute = this.getBoolean("attribute", node, false, location, result2)) != null) {
            xml.setAttribute(attribute);
        }
        if ((wrapped = this.getBoolean("wrapped", node, false, location, result2)) != null) {
            xml.setWrapped(wrapped);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            xml.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("XML_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return xml;
    }

    public ArrayNode getArray(String key2, ObjectNode node, boolean required, String location, ParseResult result2, boolean noInvalidError) {
        JsonNode value2 = node.get(key2);
        ArrayNode arrayNode = null;
        if (value2 == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (!value2.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            if (!noInvalidError) {
                result2.invalidType(location, key2, "array", value2);
            }
        } else {
            arrayNode = (ArrayNode)value2;
        }
        return arrayNode;
    }

    public ArrayNode getArray(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        return this.getArray(key2, node, required, location, result2, false);
    }

    public Boolean getBoolean(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        Boolean value2 = null;
        JsonNode v = node.get(key2);
        if (node == null || v == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            value2 = v.asBoolean();
        } else if (v.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = v.textValue();
            return Boolean.parseBoolean(stringValue);
        }
        return value2;
    }

    public BigDecimal getBigDecimal(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        BigDecimal value2 = null;
        JsonNode v = node.get(key2);
        if (node == null || v == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value2 = new BigDecimal(v.asText());
        } else if (!v.isValueNode()) {
            result2.invalidType(location, key2, "double", node);
        }
        return value2;
    }

    public Integer getInteger(String key2, ObjectNode node, boolean required, String location, ParseResult result2) {
        Integer value2 = null;
        JsonNode v = node.get(key2);
        if (node == null || v == null) {
            if (required) {
                result2.missing(location, key2);
                result2.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            if (v.isInt()) {
                value2 = v.intValue();
            }
        } else if (!v.isValueNode()) {
            result2.invalidType(location, key2, "integer", node);
        }
        return value2;
    }

    public Map<String, Parameter> getParameters(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Parameter> parameters2 = new LinkedHashMap<String, Parameter>();
        HashSet filter2 = new HashSet();
        Parameter parameter = null;
        Set<String> parameterKeys = this.getKeys(obj);
        for (String parameterName : parameterKeys) {
            ObjectNode parameterObj;
            JsonNode parameterValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", parameterName)) {
                result2.warning(location, "Parameter name " + parameterName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(parameterValue = obj.get(parameterName)).getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameterObj = (ObjectNode)parameterValue) == null || (parameter = this.getParameter(parameterObj, String.format("%s.%s", location, parameterName), result2)) == null) continue;
            if (PATH_PARAMETER.equalsIgnoreCase(parameter.getIn()) && Boolean.FALSE.equals(parameter.getRequired())) {
                result2.warning(location, "For path parameter " + parameterName + " the required value should be true");
            }
            parameters2.put(parameterName, parameter);
        }
        return parameters2;
    }

    public List<Parameter> getParameterList(ArrayNode obj, String location, ParseResult result2) {
        ArrayList<Parameter> parameters2 = new ArrayList<Parameter>();
        if (obj == null) {
            return parameters2;
        }
        for (JsonNode item : obj) {
            Parameter parameter;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (parameter = this.getParameter((ObjectNode)item, location, result2)) == null) continue;
            parameters2.add(parameter);
        }
        HashSet filter2 = new HashSet();
        parameters2.stream().map(this::getParameterDefinition).forEach(param -> {
            String ref = param.get$ref();
            if (!filter2.add(param.getName() + "#" + param.getIn())) {
                if (ref != null) {
                    if (ref.startsWith(REFERENCE_SEPARATOR)) {
                        result2.warning(location, " There are duplicate parameter values");
                    }
                } else {
                    result2.warning(location, " There are duplicate parameter values");
                }
            }
        });
        return parameters2;
    }

    private Parameter getParameterDefinition(Parameter parameter) {
        if (parameter.get$ref() == null) {
            return parameter;
        }
        Object parameterSchemaName = RefUtils.extractSimpleName(parameter.get$ref()).getLeft();
        return Optional.ofNullable(this.components).map(Components::getParameters).map(parameters2 -> (Parameter)parameters2.get(parameterSchemaName)).orElse(parameter);
    }

    public Parameter getParameter(ObjectNode obj, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Boolean allowReserved;
        Object example;
        ObjectNode examplesObject;
        ObjectNode parameterObject;
        Boolean allowEmptyValue;
        Boolean required;
        if (obj == null) {
            return null;
        }
        Parameter parameter = null;
        JsonNode ref = obj.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String desc;
                parameter = new Parameter();
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    parameter.set$ref(mungedRef);
                } else {
                    parameter.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/parameters") && !ref.textValue().startsWith("#/components/headers")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Parameter/Header");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(desc = this.getString("description", obj, false, location, result2))) {
                    parameter.setDescription(desc);
                }
                return parameter;
            }
            result2.invalidType(location, "$ref", "string", obj);
            return null;
        }
        String l = null;
        JsonNode ln = obj.get("name");
        l = ln != null ? ln.asText() : "['unknown']";
        location = location + ".[" + l + "]";
        String value2 = this.getString("in", obj, true, location, result2);
        if (!result2.isAllowEmptyStrings() && StringUtils.isBlank(value2) || result2.isAllowEmptyStrings() && value2 == null) {
            return null;
        }
        if (QUERY_PARAMETER.equals(value2)) {
            parameter = new QueryParameter();
        } else if (HEADER_PARAMETER.equals(value2)) {
            parameter = new HeaderParameter();
        } else if (PATH_PARAMETER.equals(value2)) {
            parameter = new PathParameter();
        } else if (COOKIE_PARAMETER.equals(value2)) {
            parameter = new CookieParameter();
        }
        if (parameter == null) {
            result2.invalidType(location, "in", "[query|header|path|cookie]", obj);
            return null;
        }
        parameter.setIn(value2);
        value2 = this.getString("name", obj, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            parameter.setName(value2);
        }
        value2 = this.getString("description", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            parameter.setDescription(value2);
        }
        if ((required = this.getBoolean("required", obj, false, location, result2)) != null) {
            parameter.setRequired(required);
        } else {
            parameter.setRequired(false);
        }
        Boolean deprecated = this.getBoolean("deprecated", obj, false, location, result2);
        if (deprecated != null) {
            parameter.setDeprecated(deprecated);
        }
        if (parameter instanceof QueryParameter && (allowEmptyValue = this.getBoolean("allowEmptyValue", obj, false, location, result2)) != null) {
            parameter.setAllowEmptyValue(allowEmptyValue);
        }
        if ((parameterObject = this.getObject("schema", obj, false, location, result2)) != null) {
            parameter.setSchema(this.getSchema(parameterObject, String.format("%s.%s", location, "schemas"), result2));
        }
        if ((examplesObject = this.getObject("examples", obj, false, location, result2)) != null) {
            parameter.setExamples(this.getExamples(examplesObject, String.format("%s.%s", location, "examples"), result2, false));
        }
        if ((example = this.getAnyType("example", obj, location, result2)) != null) {
            if (examplesObject != null) {
                result2.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                parameter.setExample(example instanceof NullNode ? null : example);
            }
        }
        if ((allowReserved = this.getBoolean("allowReserved", obj, false, location, result2)) != null) {
            parameter.setAllowReserved(allowReserved);
        }
        if ((contentNode = this.getObject("content", obj, false, location, result2)) != null) {
            Content content2 = this.getContent(contentNode, String.format("%s.%s", location, "content"), result2);
            if (content2.size() == 0) {
                result2.unsupported(location, "content with no media type", contentNode);
                result2.invalid();
            } else if (content2.size() > 1) {
                result2.unsupported(location, "content with multiple media types", contentNode);
                result2.invalid();
            } else if (parameter.getSchema() != null) {
                result2.unsupported(location, "content when schema defined", contentNode);
                result2.invalid();
            } else {
                parameter.setContent(content2);
            }
        } else if (parameter.getSchema() == null) {
            result2.missing(location, "content");
        }
        value2 = this.getString("style", obj, false, location, result2);
        if (parameter.getContent() == null) {
            this.setStyle(value2, parameter, location, obj, result2);
            Boolean explode = this.getBoolean("explode", obj, false, location, result2);
            if (explode != null) {
                parameter.setExplode(explode);
            } else if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle()) && result2.isExplicitStyleAndExplode()) {
                parameter.setExplode(Boolean.TRUE);
            } else if (result2.isExplicitStyleAndExplode()) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            parameter.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("PARAMETER_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return parameter;
    }

    public Map<String, Header> getHeaders(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Header> headers2 = new LinkedHashMap<String, Header>();
        Set<String> headerKeys = this.getKeys(obj);
        for (String headerName : headerKeys) {
            JsonNode headerValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", headerName)) {
                result2.warning(location, "Header name " + headerName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(headerValue = obj.get(headerName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, headerName, "object", headerValue);
                continue;
            }
            ObjectNode header = (ObjectNode)headerValue;
            Header headerObj = this.getHeader(header, String.format("%s.%s", location, headerName), result2);
            if (headerObj == null) continue;
            headers2.put(headerName, headerObj);
        }
        return headers2;
    }

    public Header getHeader(ObjectNode headerNode, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode contentNode;
        Object example;
        ObjectNode examplesObject;
        Boolean explode;
        String style;
        Boolean deprecated;
        Boolean required;
        if (headerNode == null) {
            return null;
        }
        Header header = new Header();
        JsonNode ref = headerNode.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String desc;
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    header.set$ref(mungedRef);
                } else {
                    header.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/parameters") && !ref.textValue().startsWith("#/components/headers")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Header/Parameter");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(desc = this.getString("description", headerNode, false, location, result2))) {
                    header.setDescription(desc);
                }
                return header;
            }
            result2.invalidType(location, "$ref", "string", headerNode);
            return null;
        }
        String value2 = this.getString("description", headerNode, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            header.setDescription(value2);
        }
        if ((required = this.getBoolean("required", headerNode, false, location, result2)) != null) {
            header.setRequired(required);
        }
        if ((deprecated = this.getBoolean("deprecated", headerNode, false, location, result2)) != null) {
            header.setDeprecated(deprecated);
        }
        if (StringUtils.isBlank(style = this.getString("style", headerNode, false, location, result2))) {
            if (result2.isExplicitStyleAndExplode()) {
                header.setStyle(Header.StyleEnum.SIMPLE);
            }
        } else if (style.equals(Header.StyleEnum.SIMPLE.toString())) {
            header.setStyle(Header.StyleEnum.SIMPLE);
        } else {
            result2.invalidType(location, "style", "simple", headerNode);
        }
        if ((explode = this.getBoolean("explode", headerNode, false, location, result2)) != null) {
            header.setExplode(explode);
        } else if (result2.isExplicitStyleAndExplode()) {
            header.setExplode(Boolean.FALSE);
        }
        ObjectNode headerObject = this.getObject("schema", headerNode, false, location, result2);
        if (headerObject != null) {
            header.setSchema(this.getSchema(headerObject, location, result2));
        }
        if ((examplesObject = this.getObject("examples", headerNode, false, location, result2)) != null) {
            header.setExamples(this.getExamples(examplesObject, location, result2, false));
        }
        if ((example = this.getAnyType("example", headerNode, location, result2)) != null) {
            if (examplesObject != null) {
                result2.warning(location, "examples already defined -- ignoring \"example\" field");
            } else {
                header.setExample(example instanceof NullNode ? null : example);
            }
        }
        if ((contentNode = this.getObject("content", headerNode, false, location, result2)) != null) {
            header.setContent(this.getContent(contentNode, String.format("%s.%s", location, "content"), result2));
        }
        if ((extensions = this.getExtensions(headerNode)) != null && extensions.size() > 0) {
            header.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(headerNode);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : oAuthFlowKeys) {
            if (specKeys.get("HEADER_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            result2.extra(location, key2, headerNode.get(key2));
        }
        return header;
    }

    public Object getAnyType(String nodeKey, ObjectNode node, String location, ParseResult result2) {
        JsonNode example = node.get(nodeKey);
        if (example != null) {
            if (example.getNodeType().equals((Object)JsonNodeType.STRING)) {
                return this.getString(nodeKey, node, false, location, result2);
            }
            if (example.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
                Integer integerExample = this.getInteger(nodeKey, node, false, location, result2);
                if (integerExample != null) {
                    return integerExample;
                }
                BigDecimal bigDecimalExample = this.getBigDecimal(nodeKey, node, false, location, result2);
                if (bigDecimalExample != null) {
                    return bigDecimalExample;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode objectValue = this.getObject(nodeKey, node, false, location, result2);
                if (objectValue != null) {
                    return objectValue;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                ArrayNode arrayValue = this.getArray(nodeKey, node, false, location, result2);
                if (arrayValue != null) {
                    return arrayValue;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
                Boolean bool = this.getBoolean(nodeKey, node, false, location, result2);
                if (bool != null) {
                    return bool;
                }
            } else if (example.getNodeType().equals((Object)JsonNodeType.NULL)) {
                return example;
            }
        }
        return null;
    }

    public Map<String, SecurityScheme> getSecuritySchemes(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        Set<String> securitySchemeKeys = this.getKeys(obj);
        for (String securitySchemeName : securitySchemeKeys) {
            JsonNode securitySchemeValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", securitySchemeName)) {
                result2.warning(location, "SecurityScheme name " + securitySchemeName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(securitySchemeValue = obj.get(securitySchemeName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, securitySchemeName, "object", securitySchemeValue);
                continue;
            }
            ObjectNode securityScheme = (ObjectNode)securitySchemeValue;
            SecurityScheme securitySchemeObj = this.getSecurityScheme(securityScheme, String.format("%s.%s", location, securitySchemeName), result2);
            if (securityScheme == null) continue;
            securitySchemes.put(securitySchemeName, securitySchemeObj);
        }
        return securitySchemes;
    }

    public SecurityScheme getSecurityScheme(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode flowsObject;
        if (node == null) {
            return null;
        }
        SecurityScheme securityScheme = new SecurityScheme();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String desc;
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    securityScheme.set$ref(mungedRef);
                } else {
                    securityScheme.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/securitySchemes")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type securitySchemes");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(desc = this.getString("description", node, false, location, result2))) {
                    securityScheme.setDescription(desc);
                }
                return securityScheme;
            }
            result2.invalidType(location, "$ref", "string", node);
            return null;
        }
        boolean openIdConnectRequired = false;
        boolean flowsRequired = false;
        boolean schemeRequired = false;
        boolean inRequired = false;
        boolean nameRequired = false;
        boolean bearerFormatRequired = false;
        boolean descriptionRequired = false;
        String value2 = this.getString("type", node, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            if (SecurityScheme.Type.APIKEY.toString().equals(value2)) {
                securityScheme.setType(SecurityScheme.Type.APIKEY);
                inRequired = true;
                nameRequired = true;
            } else if (SecurityScheme.Type.HTTP.toString().equals(value2)) {
                securityScheme.setType(SecurityScheme.Type.HTTP);
                schemeRequired = true;
            } else if (SecurityScheme.Type.OAUTH2.toString().equals(value2)) {
                securityScheme.setType(SecurityScheme.Type.OAUTH2);
                flowsRequired = true;
            } else if (SecurityScheme.Type.OPENIDCONNECT.toString().equals(value2)) {
                securityScheme.setType(SecurityScheme.Type.OPENIDCONNECT);
                openIdConnectRequired = true;
            } else if (result2.isOpenapi31() && SecurityScheme.Type.MUTUALTLS.toString().equals(value2)) {
                securityScheme.setType(SecurityScheme.Type.MUTUALTLS);
            } else {
                result2.invalidType(location + ".type", "type", "http|apiKey|oauth2|openIdConnect|mutualTLS ", node);
            }
        }
        value2 = this.getString("description", node, descriptionRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            securityScheme.setDescription(value2);
        }
        value2 = this.getString("name", node, nameRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            securityScheme.setName(value2);
        }
        String securitySchemeIn = this.getString("in", node, inRequired, location, result2);
        Optional<SecurityScheme.In> matchingIn = Arrays.stream(SecurityScheme.In.values()).filter(in -> in.toString().equals(securitySchemeIn)).findFirst();
        if (inRequired && securitySchemeIn != null && !matchingIn.isPresent()) {
            result2.invalidType(location, "in", "cookie|header|query", node);
        }
        securityScheme.setIn(matchingIn.orElse(null));
        value2 = this.getString("scheme", node, schemeRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            securityScheme.setScheme(value2);
        }
        value2 = this.getString("bearerFormat", node, bearerFormatRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            securityScheme.setBearerFormat(value2);
        }
        if ((flowsObject = this.getObject("flows", node, flowsRequired, location, result2)) != null) {
            securityScheme.setFlows(this.getOAuthFlows(flowsObject, location, result2));
        }
        value2 = this.getString("openIdConnectUrl", node, openIdConnectRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            securityScheme.setOpenIdConnectUrl(value2);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            securityScheme.setExtensions(extensions);
        }
        Set<String> securitySchemeKeys = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : securitySchemeKeys) {
            if (specKeys.get("SECURITY_SCHEME_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            result2.extra(location, key2, node.get(key2));
        }
        return securityScheme;
    }

    public OAuthFlows getOAuthFlows(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        if (node == null) {
            return null;
        }
        OAuthFlows oAuthFlows = new OAuthFlows();
        ObjectNode objectNode = this.getObject("implicit", node, false, location, result2);
        if (objectNode != null) {
            oAuthFlows.setImplicit(this.getOAuthFlow("implicit", objectNode, location, result2));
        }
        if ((objectNode = this.getObject("password", node, false, location, result2)) != null) {
            oAuthFlows.setPassword(this.getOAuthFlow("password", objectNode, location, result2));
        }
        if ((objectNode = this.getObject("clientCredentials", node, false, location, result2)) != null) {
            oAuthFlows.setClientCredentials(this.getOAuthFlow("clientCredentials", objectNode, location, result2));
        }
        if ((objectNode = this.getObject("authorizationCode", node, false, location, result2)) != null) {
            oAuthFlows.setAuthorizationCode(this.getOAuthFlow("authorizationCode", objectNode, location, result2));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            oAuthFlows.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : oAuthFlowKeys) {
            if (specKeys.get("OAUTHFLOWS_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            result2.extra(location, key2, node.get(key2));
        }
        return oAuthFlows;
    }

    public OAuthFlow getOAuthFlow(String oAuthFlowType, ObjectNode node, String location, ParseResult result2) {
        if (node == null) {
            return null;
        }
        OAuthFlow oAuthFlow = new OAuthFlow();
        boolean refreshUrlRequired = false;
        boolean tokenUrlRequired = false;
        boolean authorizationUrlRequired = false;
        boolean scopesRequired = true;
        switch (oAuthFlowType) {
            case "implicit": {
                authorizationUrlRequired = true;
                break;
            }
            case "password": {
                tokenUrlRequired = true;
                break;
            }
            case "clientCredentials": {
                tokenUrlRequired = true;
                break;
            }
            case "authorizationCode": {
                tokenUrlRequired = true;
                authorizationUrlRequired = true;
            }
        }
        String value2 = this.getString("authorizationUrl", node, authorizationUrlRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            oAuthFlow.setAuthorizationUrl(value2);
        }
        value2 = this.getString("tokenUrl", node, tokenUrlRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            oAuthFlow.setTokenUrl(value2);
        }
        value2 = this.getString("refreshUrl", node, refreshUrlRequired, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            oAuthFlow.setRefreshUrl(value2);
        }
        ObjectNode scopesObject = this.getObject("scopes", node, scopesRequired, location, result2);
        Scopes scope = new Scopes();
        Set<String> keys2 = this.getKeys(scopesObject);
        for (String name : keys2) {
            JsonNode scopeValue = scopesObject.get(name);
            if (scopesObject == null) continue;
            scope.addString(name, scopeValue.asText());
        }
        oAuthFlow.setScopes(scope);
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            oAuthFlow.setExtensions(extensions);
        }
        Set<String> oAuthFlowKeys = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : oAuthFlowKeys) {
            if (specKeys.get("OAUTHFLOW_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            result2.extra(location, key2, node.get(key2));
        }
        return oAuthFlow;
    }

    public Map<String, Schema> getSchemas(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        Set<String> schemaKeys = this.getKeys(obj);
        for (String schemaName : schemaKeys) {
            JsonNode schemaValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", schemaName)) {
                result2.warning(location, "Schema name " + schemaName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(schemaValue = obj.get(schemaName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, schemaName, "object", schemaValue);
                continue;
            }
            ObjectNode schema = (ObjectNode)schemaValue;
            Schema schemaObj = this.getSchema(schema, String.format("%s.%s", location, schemaName), result2);
            if (schemaObj == null) continue;
            schemas.put(schemaName, schemaObj);
        }
        return schemas;
    }

    public Discriminator getDiscriminator(ObjectNode node, String location, ParseResult result2) {
        ObjectNode mappingNode;
        Discriminator discriminator = new Discriminator();
        String value2 = this.getString("propertyName", node, true, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            discriminator.setPropertyName(value2);
        }
        if ((mappingNode = this.getObject("mapping", node, false, location, result2)) != null) {
            LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
            Set<String> keys2 = this.getKeys(mappingNode);
            for (String key2 : keys2) {
                mapping.put(key2, mappingNode.get(key2).asText());
            }
            discriminator.setMapping(mapping);
        }
        if (result2.isOpenapi31()) {
            Set<String> keys3 = this.getKeys(node);
            for (String key3 : keys3) {
                Map<String, Object> extensions;
                if (!key3.startsWith("x-") || (extensions = this.getExtensions(node)) == null || extensions.size() <= 0) continue;
                discriminator.setExtensions(extensions);
            }
        }
        return discriminator;
    }

    public Schema getSchema(JsonNode jsonNode, String location, ParseResult result2) {
        Schema not;
        ObjectNode notObj;
        ArrayNode enumArray;
        JsonNode ref;
        Boolean additionalProperties;
        ArraySchema items2;
        if (jsonNode == null) {
            return null;
        }
        if (result2 == null) {
            result2 = new ParseResult();
            result2.setAllowEmptyStrings(true);
        }
        Schema schema = null;
        List<JsonSchemaParserExtension> jsonschemaExtensions = OpenAPIDeserializer.getJsonSchemaParserExtensions();
        for (JsonSchemaParserExtension jsonschemaExtension : jsonschemaExtensions) {
            schema = jsonschemaExtension.getSchema(jsonNode, location, result2, this.rootMap, this.basePath);
            if (schema == null) continue;
            return schema;
        }
        if (result2.isOpenapi31()) {
            return this.getJsonSchema(jsonNode, location, result2);
        }
        ObjectNode node = null;
        if (!jsonNode.isObject()) {
            result2.invalidType(location, "", "object", jsonNode);
            return null;
        }
        node = (ObjectNode)jsonNode;
        ArrayNode oneOfArray = this.getArray("oneOf", node, false, location, result2);
        ArrayNode allOfArray = this.getArray("allOf", node, false, location, result2);
        ArrayNode anyOfArray = this.getArray("anyOf", node, false, location, result2);
        ObjectNode itemsNode = this.getObject("items", node, false, location, result2);
        if (allOfArray != null || anyOfArray != null || oneOfArray != null) {
            ComposedSchema composedSchema = new ComposedSchema();
            if (allOfArray != null) {
                for (JsonNode n : allOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result2);
                    composedSchema.addAllOfItem(schema);
                }
                schema = composedSchema;
            }
            if (anyOfArray != null) {
                for (JsonNode n : anyOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result2);
                    composedSchema.addAnyOfItem(schema);
                }
                schema = composedSchema;
            }
            if (oneOfArray != null) {
                for (JsonNode n : oneOfArray) {
                    if (!n.isObject()) continue;
                    schema = this.getSchema((ObjectNode)n, location, result2);
                    composedSchema.addOneOfItem(schema);
                }
                schema = composedSchema;
            }
        }
        if (itemsNode != null && result2.isInferSchemaType()) {
            items2 = new ArraySchema();
            if (itemsNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                items2.setItems(this.getSchema(itemsNode, location, result2));
            } else if (itemsNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                for (JsonNode n : itemsNode) {
                    if (!n.isValueNode()) continue;
                    items2.setItems(this.getSchema(itemsNode, location, result2));
                }
            }
            schema = items2;
        } else if (itemsNode != null) {
            items2 = new Schema();
            if (itemsNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                items2.setItems(this.getSchema(itemsNode, location, result2));
            } else if (itemsNode.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                for (JsonNode n : itemsNode) {
                    if (!n.isValueNode()) continue;
                    items2.setItems(this.getSchema(itemsNode, location, result2));
                }
            }
            schema = items2;
        }
        Boolean additionalPropertiesBoolean = this.getBoolean("additionalProperties", node, false, location, result2);
        ObjectNode additionalPropertiesObject = additionalPropertiesBoolean == null ? this.getObject("additionalProperties", node, false, location, result2) : null;
        Boolean bl = additionalProperties = additionalPropertiesObject != null ? this.getSchema(additionalPropertiesObject, location, result2) : additionalPropertiesBoolean;
        if (additionalProperties != null && result2.isInferSchemaType()) {
            if (schema == null) {
                schema = ((Object)additionalProperties).equals(Boolean.FALSE) ? new ObjectSchema() : new MapSchema();
            }
            schema.setAdditionalProperties(additionalProperties);
        } else if (additionalProperties != null) {
            if (schema == null) {
                schema = new Schema();
            }
            schema.setAdditionalProperties(additionalProperties);
        }
        if (schema == null) {
            schema = SchemaTypeUtil.createSchemaByType(node);
        }
        if ((ref = node.get("$ref")) != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef;
                if (location.startsWith("paths")) {
                    try {
                        String[] childComponents;
                        String[] newChildComponents;
                        boolean isValidComponent;
                        String[] components = ref.asText().split("#/components");
                        if (ref.asText().startsWith("#/components") && components.length > 1 && !(isValidComponent = ReferenceValidator.valueOf((newChildComponents = Arrays.copyOfRange(childComponents = components[1].split("/"), 1, childComponents.length))[0]).validateComponent(this.components, newChildComponents[1]))) {
                            result2.missing(location, ref.asText());
                        }
                    }
                    catch (Exception e2) {
                        result2.missing(location, ref.asText());
                    }
                }
                if ((mungedRef = this.mungedRef(ref.textValue())) != null) {
                    schema.set$ref(mungedRef);
                } else {
                    schema.set$ref(ref.asText());
                }
                if (schema.get$ref().startsWith("#/components/schemas") && StringUtils.countMatches((CharSequence)schema.get$ref(), "/") == 3) {
                    String refName = schema.get$ref().substring(schema.get$ref().lastIndexOf("/") + 1);
                    this.localSchemaRefs.put(refName, location);
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/schemas")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Schema");
                }
                return schema;
            }
            result2.invalidType(location, "$ref", "string", node);
            return null;
        }
        this.getCommonSchemaFields(node, location, result2, schema);
        Boolean bool = this.getBoolean("exclusiveMaximum", node, false, location, result2);
        if (bool != null) {
            schema.setExclusiveMaximum(bool);
        }
        if ((bool = this.getBoolean("exclusiveMinimum", node, false, location, result2)) != null) {
            schema.setExclusiveMinimum(bool);
        }
        if ((enumArray = this.getArray("enum", node, false, location, result2)) != null) {
            for (JsonNode n : enumArray) {
                if (n.isNumber()) {
                    schema.addEnumItemObject(n.numberValue());
                    continue;
                }
                if (n.isBoolean()) {
                    schema.addEnumItemObject(n.booleanValue());
                    continue;
                }
                if (n.isValueNode()) {
                    try {
                        schema.addEnumItemObject(this.getDecodedObject(schema, n.asText(null)));
                    }
                    catch (ParseException e3) {
                        result2.invalidType(location, String.format("enum=`%s`", e3.getMessage()), schema.getFormat(), n);
                    }
                    continue;
                }
                if (n.isContainerNode()) {
                    schema.addEnumItemObject(n.isNull() ? null : n);
                    continue;
                }
                result2.invalidType(location, "enum", "value", n);
            }
        }
        String value2 = this.getString("type", node, false, location, result2);
        if (StringUtils.isBlank(schema.getType())) {
            JsonNode enumNode;
            if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
                schema.setType(value2);
            } else if (result2.isInferSchemaType() && (enumNode = node.get("enum")) != null && enumNode.isArray()) {
                String type2 = this.inferTypeFromArray((ArrayNode)enumNode);
                schema.setType(type2);
            }
            if ("array".equals(schema.getType()) && schema.getItems() == null) {
                result2.missing(location, "items");
            }
        }
        if ((notObj = this.getObject("not", node, false, location, result2)) != null && (not = this.getSchema(notObj, location, result2)) != null) {
            schema.setNot(not);
        }
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        ObjectNode propertiesObj = this.getObject("properties", node, false, location, result2);
        Set<String> keys2 = this.getKeys(propertiesObj);
        for (String name : keys2) {
            Schema property2;
            JsonNode propertyValue = propertiesObj.get(name);
            if (!propertyValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, "properties", "object", propertyValue);
                continue;
            }
            if (propertiesObj == null || (property2 = this.getSchema((ObjectNode)propertyValue, location, result2)) == null) continue;
            properties.put(name, property2);
        }
        if (propertiesObj != null) {
            schema.setProperties(properties);
        }
        if ((bool = this.getBoolean("nullable", node, false, location, result2)) != null) {
            schema.setNullable(bool);
        }
        if (node.get("default") != null && result2.isInferSchemaType()) {
            boolean isDefaultNodeTypeNull;
            boolean nullable = schema.getNullable() == null || schema.getNullable() != false;
            boolean bl2 = isDefaultNodeTypeNull = node.get("default") != null && node.get("default").isNull();
            if (!StringUtils.isBlank(schema.getType())) {
                Number number;
                if (isDefaultNodeTypeNull) {
                    if (nullable) {
                        schema.setDefault(null);
                    } else {
                        String expectedType2 = String.format("non-null %s", schema.getType());
                        result2.invalidType(location, "default", expectedType2, node);
                    }
                } else if (schema.getType().equals("array")) {
                    ArrayNode array = this.getArray("default", node, false, location, result2);
                    if (array != null) {
                        schema.setDefault(array);
                    }
                } else if (schema.getType().equals("string")) {
                    value2 = this.getString("default", node, false, location, result2);
                    if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
                        try {
                            schema.setDefault(this.getDecodedObject(schema, value2));
                        }
                        catch (ParseException e4) {
                            result2.invalidType(location, String.format("default=`%s`", e4.getMessage()), schema.getFormat(), node);
                        }
                    }
                } else if (schema.getType().equals("boolean")) {
                    bool = this.getBoolean("default", node, false, location, result2);
                    if (bool != null) {
                        schema.setDefault(bool);
                    }
                } else if (schema.getType().equals("object")) {
                    ObjectNode object = this.getObject("default", node, false, location, result2);
                    if (object != null) {
                        schema.setDefault(object);
                    }
                } else if (schema.getType().equals("integer")) {
                    number = this.getInteger("default", node, false, location, result2);
                    if (number != null) {
                        schema.setDefault(number);
                    }
                } else if (schema.getType().equals("number") && (number = this.getBigDecimal("default", node, false, location, result2)) != null) {
                    schema.setDefault(number);
                }
            } else {
                Object defaultObject = this.getAnyType("default", node, location, result2);
                if (defaultObject != null) {
                    schema.setDefault(defaultObject);
                }
            }
        } else if (node.get("default") != null) {
            Object defaultObject = this.getAnyType("default", node, location, result2);
            if (defaultObject != null) {
                schema.setDefault(defaultObject);
            }
        } else {
            schema.setDefault(null);
        }
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            schema.setExtensions(extensions);
        }
        Set<String> schemaKeys = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get("openapi30");
        for (String key2 : schemaKeys) {
            if (specKeys.get("SCHEMA_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            result2.extra(location, key2, node.get(key2));
        }
        return schema;
    }

    protected void getCommonSchemaFields(ObjectNode node, String location, ParseResult result2, Schema schema) {
        Object example;
        ExternalDocumentation docs;
        ObjectNode externalDocs;
        XML xml;
        ObjectNode xmlNode2;
        ArrayNode required;
        Boolean bool;
        Integer integer;
        BigDecimal bigDecimal;
        ObjectNode discriminatorNode;
        String value2 = this.getString("title", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            schema.setTitle(value2);
        }
        if ((discriminatorNode = this.getObject("discriminator", node, false, location, result2)) != null) {
            schema.setDiscriminator(this.getDiscriminator(discriminatorNode, location, result2));
        }
        if ((bigDecimal = this.getBigDecimal("multipleOf", node, false, location, result2)) != null) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                schema.setMultipleOf(bigDecimal);
            } else {
                result2.warning(location, "multipleOf value must be > 0");
            }
        }
        if ((bigDecimal = this.getBigDecimal("maximum", node, false, location, result2)) != null) {
            schema.setMaximum(bigDecimal);
        }
        if ((bigDecimal = this.getBigDecimal("minimum", node, false, location, result2)) != null) {
            schema.setMinimum(bigDecimal);
        }
        if ((integer = this.getInteger("minLength", node, false, location, result2)) != null) {
            schema.setMinLength(integer);
        }
        if ((integer = this.getInteger("maxLength", node, false, location, result2)) != null) {
            schema.setMaxLength(integer);
        }
        String pattern2 = this.getString("pattern", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && pattern2 != null) {
            schema.setPattern(pattern2);
        }
        if ((integer = this.getInteger("maxItems", node, false, location, result2)) != null) {
            schema.setMaxItems(integer);
        }
        if ((integer = this.getInteger("minItems", node, false, location, result2)) != null) {
            schema.setMinItems(integer);
        }
        if ((bool = this.getBoolean("uniqueItems", node, false, location, result2)) != null) {
            schema.setUniqueItems(bool);
        }
        if ((integer = this.getInteger("maxProperties", node, false, location, result2)) != null) {
            schema.setMaxProperties(integer);
        }
        if ((integer = this.getInteger("minProperties", node, false, location, result2)) != null) {
            schema.setMinProperties(integer);
        }
        if ((required = this.getArray("required", node, false, location, result2)) != null) {
            ArrayList<String> requiredList = new ArrayList<String>();
            for (JsonNode n : required) {
                if (n.getNodeType().equals((Object)JsonNodeType.STRING)) {
                    requiredList.add(((TextNode)n).textValue());
                    continue;
                }
                result2.invalidType(location, "required", "string", n);
            }
            if (requiredList.size() > 0) {
                schema.setRequired(requiredList);
            }
        }
        value2 = this.getString("description", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            schema.setDescription(value2);
        }
        value2 = this.getString("format", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            schema.setFormat(value2);
        }
        if ((bool = this.getBoolean("readOnly", node, false, location, result2)) != null) {
            schema.setReadOnly(bool);
        }
        if ((bool = this.getBoolean("writeOnly", node, false, location, result2)) != null) {
            schema.setWriteOnly(bool);
        }
        if ((bool = Boolean.valueOf(Optional.ofNullable(this.getBoolean("writeOnly", node, false, location, result2)).orElse(false) != false && Optional.ofNullable(this.getBoolean("readOnly", node, false, location, result2)).orElse(false) != false)).booleanValue()) {
            result2.warning(location, " writeOnly and readOnly are both present");
        }
        if ((xmlNode2 = this.getObject("xml", node, false, location, result2)) != null && (xml = this.getXml(xmlNode2, location, result2)) != null) {
            schema.setXml(xml);
        }
        if ((externalDocs = this.getObject("externalDocs", node, false, location, result2)) != null && (docs = this.getExternalDocs(externalDocs, location, result2)) != null) {
            schema.setExternalDocs(docs);
        }
        if ((example = this.getAnyType("example", node, location, result2)) != null) {
            schema.setExample(example instanceof NullNode ? null : example);
        }
        if ((bool = this.getBoolean("deprecated", node, false, location, result2)) != null) {
            schema.setDeprecated(bool);
        }
    }

    private Object getDecodedObject(Schema schema, String objectString) throws ParseException {
        Date object;
        Comparable<Comparable<OffsetDateTime>> comparable = objectString == null ? null : (schema.getClass().equals(DateSchema.class) ? this.toDate(objectString) : (schema.getClass().equals(DateTimeSchema.class) ? this.toDateTime(objectString) : (object = schema.getClass().equals(ByteArraySchema.class) ? (Comparable<Comparable<OffsetDateTime>>)this.toBytes(objectString) : objectString)));
        if (object == null && objectString != null) {
            throw new ParseException(objectString, 0);
        }
        return object;
    }

    private Object getDecodedObject31(Schema schema, String objectString) throws ParseException {
        Date object;
        Comparable<Comparable<OffsetDateTime>> comparable = objectString == null ? null : ("string".equals(schema.getType()) && "date".equals(schema.getFormat()) ? this.toDate(objectString) : ("string".equals(schema.getType()) && "date-time".equals(schema.getFormat()) ? this.toDateTime(objectString) : (object = "string".equals(schema.getType()) && "byte".equals(schema.getFormat()) ? (Comparable<Comparable<OffsetDateTime>>)this.toBytes(objectString) : objectString)));
        if (object == null && objectString != null) {
            throw new ParseException(objectString, 0);
        }
        return object;
    }

    private OffsetDateTime toDateTime(String dateString) {
        OffsetDateTime dateTime = null;
        try {
            dateTime = OffsetDateTime.parse(dateString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateTime;
    }

    private Date toDate(String dateString) {
        Matcher matcher = RFC3339_DATE_PATTERN.matcher(dateString);
        Date date = null;
        if (matcher.matches()) {
            String year2 = matcher.group(1);
            String month = matcher.group(2);
            String day2 = matcher.group(3);
            try {
                date = new Calendar.Builder().setDate(Integer.parseInt(year2), Integer.parseInt(month) - 1, Integer.parseInt(day2)).build().getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    private byte[] toBytes(String byteString) {
        byte[] bytes;
        try {
            bytes = Base64.getDecoder().decode(byteString);
        }
        catch (Exception e2) {
            bytes = null;
        }
        return bytes;
    }

    public Map<String, Example> getExamples(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, Example> examples = new LinkedHashMap<String, Example>();
        Set<String> exampleKeys = this.getKeys(obj);
        for (String exampleName : exampleKeys) {
            Example exampleObj;
            JsonNode exampleValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", exampleName)) {
                result2.warning(location, "Example name " + exampleName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!validNodeTypes.contains((Object)(exampleValue = obj.get(exampleName)).getNodeType())) {
                result2.invalidType(location, exampleName, "object", exampleValue);
                continue;
            }
            if (exampleValue.getNodeType().equals((Object)JsonNodeType.STRING)) {
                TextNode stringExample = (TextNode)exampleValue;
                if (stringExample == null || (exampleObj = this.getTextExample(stringExample)) == null) continue;
                examples.put(exampleName, exampleObj);
                continue;
            }
            ObjectNode example = (ObjectNode)exampleValue;
            if (example == null || (exampleObj = this.getExample(example, String.format("%s.%s", location, exampleName), result2)) == null) continue;
            examples.put(exampleName, exampleObj);
        }
        return examples;
    }

    private Example getTextExample(TextNode textNode) {
        if (textNode == null) {
            return null;
        }
        Example example = new Example();
        example.setValue(textNode.textValue());
        return example;
    }

    public Example getExample(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        Object sample2;
        if (node == null) {
            return null;
        }
        Example example = new Example();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    example.set$ref(mungedRef);
                } else {
                    example.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/examples")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Examples");
                }
                if (result2.isOpenapi31()) {
                    String value2 = this.getString("summary", node, false, location, result2);
                    if (StringUtils.isNotBlank(value2)) {
                        example.setSummary(value2);
                    }
                    if (StringUtils.isNotBlank(value2 = this.getString("description", node, false, location, result2))) {
                        example.setDescription(value2);
                    }
                }
                return example;
            }
            result2.invalidType(location, "$ref", "string", node);
            return null;
        }
        String value3 = this.getString("summary", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            example.setSummary(value3);
        }
        value3 = this.getString("description", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            example.setDescription(value3);
        }
        if ((sample2 = this.getAnyType("value", node, location, result2)) != null) {
            example.setValue(sample2 instanceof NullNode ? null : sample2);
        }
        value3 = this.getString("externalValue", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            example.setExternalValue(value3);
        }
        if (sample2 != null && value3 != null) {
            result2.warning(location, " value and externalValue are both present");
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            example.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("EXAMPLE_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return example;
    }

    public void setStyle(String value2, Parameter parameter, String location, ObjectNode obj, ParseResult result2) {
        if (StringUtils.isBlank(value2)) {
            if (result2.isExplicitStyleAndExplode()) {
                if (QUERY_PARAMETER.equals(parameter.getIn()) || COOKIE_PARAMETER.equals(parameter.getIn())) {
                    parameter.setStyle(Parameter.StyleEnum.FORM);
                } else if (PATH_PARAMETER.equals(parameter.getIn()) || HEADER_PARAMETER.equals(parameter.getIn())) {
                    parameter.setStyle(Parameter.StyleEnum.SIMPLE);
                }
            }
        } else if (value2.equals(Parameter.StyleEnum.FORM.toString())) {
            parameter.setStyle(Parameter.StyleEnum.FORM);
        } else if (value2.equals(Parameter.StyleEnum.DEEPOBJECT.toString())) {
            parameter.setStyle(Parameter.StyleEnum.DEEPOBJECT);
        } else if (value2.equals(Parameter.StyleEnum.LABEL.toString())) {
            parameter.setStyle(Parameter.StyleEnum.LABEL);
        } else if (value2.equals(Parameter.StyleEnum.MATRIX.toString())) {
            parameter.setStyle(Parameter.StyleEnum.MATRIX);
        } else if (value2.equals(Parameter.StyleEnum.PIPEDELIMITED.toString())) {
            parameter.setStyle(Parameter.StyleEnum.PIPEDELIMITED);
        } else if (value2.equals(Parameter.StyleEnum.SIMPLE.toString())) {
            parameter.setStyle(Parameter.StyleEnum.SIMPLE);
        } else if (value2.equals(Parameter.StyleEnum.SPACEDELIMITED.toString())) {
            parameter.setStyle(Parameter.StyleEnum.SPACEDELIMITED);
        } else {
            result2.invalidType(location, "style", "StyleEnum", obj);
        }
    }

    public ApiResponses getResponses(ObjectNode node, String location, ParseResult result2, boolean underComponents) {
        if (node == null) {
            return null;
        }
        ApiResponses apiResponses = new ApiResponses();
        Set<String> keys2 = this.getKeys(node);
        for (String key2 : keys2) {
            ApiResponse response2;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", key2)) {
                result2.warning(location, "Response key " + key2 + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (key2.startsWith("x-")) {
                Map<String, Object> extensions = this.getExtensions(node);
                if (extensions == null || extensions.size() <= 0) continue;
                apiResponses.setExtensions(extensions);
                continue;
            }
            ObjectNode obj = this.getObject(key2, node, false, location, result2);
            if (obj == null || (response2 = this.getResponse(obj, String.format("%s.%s", location, key2), result2)) == null) continue;
            apiResponses.put(key2, response2);
        }
        return apiResponses;
    }

    public ApiResponse getResponse(ObjectNode node, String location, ParseResult result2) {
        Map<String, Object> extensions;
        ObjectNode contentObject;
        Map<String, Link> links;
        ObjectNode linksObj;
        Map<String, Header> headers2;
        ObjectNode headerObject;
        if (node == null) {
            return null;
        }
        ApiResponse apiResponse = new ApiResponse();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String value2;
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    apiResponse.set$ref(mungedRef);
                } else {
                    apiResponse.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/responses")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Response");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(value2 = this.getString("description", node, false, location, result2))) {
                    apiResponse.setDescription(value2);
                }
                return apiResponse;
            }
            result2.invalidType(location, "$ref", "string", node);
            return null;
        }
        String value3 = this.getString("description", node, true, location, result2);
        if (result2.isAllowEmptyStrings() && value3 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value3)) {
            apiResponse.description(value3);
        }
        if ((headerObject = this.getObject("headers", node, false, location, result2)) != null && (headers2 = this.getHeaders(headerObject, String.format("%s.%s", location, "headers"), result2, false)) != null && headers2.size() > 0) {
            apiResponse.setHeaders(headers2);
        }
        if ((linksObj = this.getObject("links", node, false, location, result2)) != null && (links = this.getLinks(linksObj, String.format("%s.%s", location, "links"), result2, false)) != null && links.size() > 0) {
            apiResponse.setLinks(links);
        }
        if ((contentObject = this.getObject("content", node, false, location, result2)) != null) {
            apiResponse.setContent(this.getContent(contentObject, String.format("%s.%s", location, "content"), result2));
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            apiResponse.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("RESPONSE_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return apiResponse;
    }

    public List<String> getTagsStrings(ArrayNode nodes2, String location, ParseResult result2) {
        if (nodes2 == null) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (JsonNode node : nodes2) {
            if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) continue;
            tags.add(node.textValue());
        }
        return tags;
    }

    public Operation getOperation(ObjectNode obj, String location, ParseResult result2) {
        Map<String, Object> extensions;
        Boolean deprecated;
        ObjectNode callbacksNode;
        Map<String, Callback> callbacks;
        ObjectNode responsesNode;
        ApiResponses responses2;
        ObjectNode requestObjectNode;
        ArrayNode parameters2;
        ObjectNode externalDocs;
        ExternalDocumentation docs;
        if (obj == null) {
            return null;
        }
        Operation operation = new Operation();
        ArrayNode array = this.getArray("tags", obj, false, location, result2);
        List<String> tags = this.getTagsStrings(array, String.format("%s.%s", location, "tags"), result2);
        if (tags != null) {
            operation.setTags(tags);
        }
        String value2 = this.getString("summary", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            operation.setSummary(value2);
        }
        value2 = this.getString("description", obj, false, location, result2);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            operation.setDescription(value2);
        }
        if ((docs = this.getExternalDocs(externalDocs = this.getObject("externalDocs", obj, false, location, result2), String.format("%s.%s", location, "externalDocs"), result2)) != null) {
            operation.setExternalDocs(docs);
        }
        value2 = this.getString("operationId", obj, false, location, result2, this.operationIDs);
        if (result2.isAllowEmptyStrings() && value2 != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(value2)) {
            operation.operationId(value2);
        }
        if ((parameters2 = this.getArray("parameters", obj, false, location, result2)) != null) {
            operation.setParameters(this.getParameterList(parameters2, String.format("%s.%s", location, "parameters"), result2));
        }
        if ((requestObjectNode = this.getObject("requestBody", obj, false, location, result2)) != null) {
            operation.setRequestBody(this.getRequestBody(requestObjectNode, String.format("%s.%s", location, "requestBody"), result2));
        }
        if ((responses2 = this.getResponses(responsesNode = this.getObject("responses", obj, true, location, result2), String.format("%s.%s", location, "responses"), result2, false)) != null) {
            operation.setResponses(responses2);
        }
        if ((callbacks = this.getCallbacks(callbacksNode = this.getObject("callbacks", obj, false, location, result2), String.format("%s.%s", location, "callbacks"), result2, false)) != null) {
            operation.setCallbacks(callbacks);
        }
        if ((deprecated = this.getBoolean("deprecated", obj, false, location, result2)) != null) {
            operation.setDeprecated(deprecated);
        }
        if ((array = this.getArray("servers", obj, false, location, result2)) != null && array.size() > 0) {
            operation.setServers(this.getServersList(array, String.format("%s.%s", location, "servers"), result2));
        }
        if ((array = this.getArray("security", obj, false, location, result2)) != null) {
            operation.setSecurity(this.getSecurityRequirementsList(array, String.format("%s.%s", location, "security"), result2));
        }
        if ((extensions = this.getExtensions(obj)) != null && extensions.size() > 0) {
            operation.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(obj);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("OPERATION_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, obj.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return operation;
    }

    public List<SecurityRequirement> getSecurityRequirementsList(ArrayNode nodes2, String location, ParseResult result2) {
        if (nodes2 == null) {
            return null;
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (JsonNode node : nodes2) {
            if (!node.getNodeType().equals((Object)JsonNodeType.OBJECT)) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            Set<String> keys2 = this.getKeys((ObjectNode)node);
            if (keys2.size() == 0) {
                securityRequirements.add(securityRequirement);
                continue;
            }
            for (String key2 : keys2) {
                if (key2 == null) continue;
                JsonNode value2 = node.get(key2);
                if (key2 == null || !JsonNodeType.ARRAY.equals((Object)value2.getNodeType())) continue;
                ArrayNode arrayNode = (ArrayNode)value2;
                List<String> scopes = Stream.generate(arrayNode.elements()::next).map(n -> n.asText()).limit(arrayNode.size()).collect(Collectors.toList());
                securityRequirement.addList(key2, scopes);
            }
            if (securityRequirement.size() <= 0) continue;
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    public Map<String, RequestBody> getRequestBodies(ObjectNode obj, String location, ParseResult result2, boolean underComponents) {
        if (obj == null) {
            return null;
        }
        LinkedHashMap<String, RequestBody> bodies = new LinkedHashMap<String, RequestBody>();
        Set<String> bodyKeys = this.getKeys(obj);
        for (String bodyName : bodyKeys) {
            JsonNode bodyValue;
            if (underComponents && !Pattern.matches("^[a-zA-Z0-9\\.\\-_]+$", bodyName)) {
                result2.warning(location, "RequestBody name " + bodyName + " doesn't adhere to regular expression ^[a-zA-Z0-9\\.\\-_]+$");
            }
            if (!(bodyValue = obj.get(bodyName)).getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result2.invalidType(location, bodyName, "object", bodyValue);
                continue;
            }
            ObjectNode bodyObj = (ObjectNode)bodyValue;
            RequestBody body2 = this.getRequestBody(bodyObj, String.format("%s.%s", location, bodyName), result2);
            if (body2 == null) continue;
            bodies.put(bodyName, body2);
        }
        return bodies;
    }

    public RequestBody getRequestBody(ObjectNode node, String location, ParseResult result2) {
        ObjectNode contentNode;
        Content content2;
        Boolean required;
        if (node == null) {
            return null;
        }
        RequestBody body2 = new RequestBody();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String desc;
                String mungedRef = this.mungedRef(ref.textValue());
                if (mungedRef != null) {
                    body2.set$ref(mungedRef);
                } else {
                    body2.set$ref(ref.textValue());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/requestBodies")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type RequestBody");
                }
                if (result2.isOpenapi31() && StringUtils.isNotBlank(desc = this.getString("description", node, false, location, result2))) {
                    body2.setDescription(desc);
                }
                return body2;
            }
            result2.invalidType(location, "$ref", "string", node);
            return null;
        }
        String description = this.getString("description", node, false, location, result2);
        if (result2.isAllowEmptyStrings() && description != null) {
            body2.setDescription(description);
        }
        if ((required = this.getBoolean("required", node, false, location, result2)) != null) {
            body2.setRequired(required);
        }
        if ((content2 = this.getContent(contentNode = this.getObject("content", node, true, location, result2), location + ".content", result2)) != null && content2.isEmpty()) {
            result2.unsupported(location, "content with no media type", contentNode);
            result2.invalid();
        } else {
            body2.setContent(content2);
        }
        Map<String, Object> extensions = this.getExtensions(node);
        if (extensions != null && extensions.size() > 0) {
            body2.setExtensions(extensions);
        }
        Set<String> keys2 = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get(result2.isOpenapi31() ? "openapi31" : "openapi30");
        for (String key2 : keys2) {
            if (!specKeys.get("REQUEST_BODY_KEYS").contains(key2) && !key2.startsWith("x-")) {
                result2.extra(location, key2, node.get(key2));
            }
            this.validateReservedKeywords(specKeys, key2, location, result2);
        }
        return body2;
    }

    public String inferTypeFromArray(ArrayNode an) {
        if (an.size() == 0) {
            return "string";
        }
        String type2 = null;
        for (int i2 = 0; i2 < an.size(); ++i2) {
            JsonNode element = an.get(0);
            if (element.isBoolean()) {
                if (type2 == null) {
                    type2 = "boolean";
                    continue;
                }
                if ("boolean".equals(type2)) continue;
                type2 = "string";
                continue;
            }
            if (element.isNumber()) {
                if (type2 == null) {
                    type2 = "number";
                    continue;
                }
                if ("number".equals(type2)) continue;
                type2 = "string";
                continue;
            }
            type2 = "string";
        }
        return type2;
    }

    public static List<JsonSchemaParserExtension> getJsonSchemaParserExtensions() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        List<JsonSchemaParserExtension> extensions = OpenAPIDeserializer.getJsonSchemaParserExtensions(tccl);
        ClassLoader cl = JsonSchemaParserExtension.class.getClassLoader();
        if (cl != tccl) {
            extensions.addAll(OpenAPIDeserializer.getJsonSchemaParserExtensions(cl));
        }
        return extensions;
    }

    protected static List<JsonSchemaParserExtension> getJsonSchemaParserExtensions(ClassLoader cl) {
        if (jsonSchemaParserExtensionMap.containsKey(cl)) {
            return jsonSchemaParserExtensionMap.get(cl);
        }
        ArrayList<JsonSchemaParserExtension> extensions = new ArrayList<JsonSchemaParserExtension>();
        ServiceLoader<JsonSchemaParserExtension> loader = ServiceLoader.load(JsonSchemaParserExtension.class, cl);
        for (JsonSchemaParserExtension extension : loader) {
            extensions.add(extension);
        }
        if (cl != null) {
            jsonSchemaParserExtensionMap.put(cl, extensions);
        }
        return extensions;
    }

    public Schema getJsonSchema(JsonNode jsonNode, String location, ParseResult result2) {
        Map<String, Object> extensions;
        String value2;
        Object constValue;
        Schema contains;
        JsonNode containsObj;
        ArrayNode prefixItemsArray;
        Schema unevaluatedItemsSchema;
        JsonNode unevaluatedItems;
        Schema _else;
        JsonNode elseObj;
        Schema _then;
        JsonNode thenObj;
        Schema _if;
        JsonNode ifObj;
        Schema propertyNames;
        JsonNode propertyNamesObj;
        Schema contentSchema;
        JsonNode contentSchemaObj;
        Schema not;
        JsonNode notObj;
        Integer integer;
        BigDecimal bigDecimal;
        JsonNode ref;
        JsonNode unevaluatedProperties;
        JsonNode additionalProperties;
        if (jsonNode == null) {
            return null;
        }
        Schema schema = null;
        Boolean boolValue = null;
        if (jsonNode.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            boolValue = jsonNode.asBoolean();
        } else if (jsonNode.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = jsonNode.textValue();
            if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
                boolValue = Boolean.parseBoolean(stringValue);
            } else {
                result2.invalidType(location, "", "object", jsonNode);
                return null;
            }
        }
        if (boolValue != null) {
            return new JsonSchema().booleanSchemaValue(boolValue);
        }
        ObjectNode node = null;
        if (!jsonNode.isObject()) {
            result2.invalidType(location, "", "object", jsonNode);
            return null;
        }
        node = (ObjectNode)jsonNode;
        ArrayNode oneOfArray = this.getArray("oneOf", node, false, location, result2);
        ArrayNode allOfArray = this.getArray("allOf", node, false, location, result2);
        ArrayNode anyOfArray = this.getArray("anyOf", node, false, location, result2);
        JsonNode itemsNode = this.getObjectOrBoolean("items", node, false, location, result2);
        if (allOfArray != null || anyOfArray != null || oneOfArray != null) {
            JsonSchema composedSchema = new JsonSchema();
            if (allOfArray != null) {
                for (JsonNode n : allOfArray) {
                    schema = this.getJsonSchema(n, location, result2);
                    composedSchema.addAllOfItem(schema);
                }
                schema = composedSchema;
            }
            if (anyOfArray != null) {
                for (JsonNode n : anyOfArray) {
                    schema = this.getJsonSchema(n, location, result2);
                    composedSchema.addAnyOfItem(schema);
                }
                schema = composedSchema;
            }
            if (oneOfArray != null) {
                for (JsonNode n : oneOfArray) {
                    schema = this.getJsonSchema(n, location, result2);
                    composedSchema.addOneOfItem(schema);
                }
                schema = composedSchema;
            }
        }
        if (itemsNode != null) {
            JsonSchema items2 = new JsonSchema();
            items2.setItems(this.getJsonSchema(itemsNode, location, result2));
            schema = items2;
        }
        if ((additionalProperties = this.getObjectOrBoolean("additionalProperties", node, false, location, result2)) != null) {
            Schema additionalPropertiesSchema = this.getJsonSchema(additionalProperties, location, result2);
            if (schema == null) {
                schema = new JsonSchema();
            }
            schema.setAdditionalProperties(additionalPropertiesSchema);
        }
        if ((unevaluatedProperties = this.getObjectOrBoolean("unevaluatedProperties", node, false, location, result2)) != null) {
            Schema unevaluatedPropertiesSchema = this.getJsonSchema(unevaluatedProperties, location, result2);
            if (schema == null) {
                schema = new JsonSchema();
            }
            schema.setUnevaluatedProperties(unevaluatedPropertiesSchema);
        }
        if (schema == null) {
            schema = new JsonSchema();
        }
        if ((ref = node.get("$ref")) != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                String mungedRef;
                if (location.startsWith("paths")) {
                    try {
                        String[] childComponents;
                        String[] newChildComponents;
                        boolean isValidComponent;
                        String[] components = ref.asText().split("#/components");
                        if (ref.asText().startsWith("#/components") && components.length > 1 && !(isValidComponent = ReferenceValidator.valueOf((newChildComponents = Arrays.copyOfRange(childComponents = components[1].split("/"), 1, childComponents.length))[0]).validateComponent(this.components, newChildComponents[1]))) {
                            result2.missing(location, ref.asText());
                        }
                    }
                    catch (Exception e2) {
                        result2.missing(location, ref.asText());
                    }
                }
                if ((mungedRef = this.mungedRef(ref.textValue())) != null) {
                    schema.set$ref(mungedRef);
                } else {
                    schema.set$ref(ref.asText());
                }
                if (ref.textValue().startsWith("#/components") && !ref.textValue().startsWith("#/components/schemas")) {
                    result2.warning(location, "$ref target " + ref.textValue() + " is not of expected type Schema");
                }
            } else {
                result2.invalidType(location, "$ref", "string", node);
            }
        }
        this.getCommonSchemaFields(node, location, result2, schema);
        if (node.get("default") != null) {
            schema.setDefault(this.getAnyType("default", node, location, result2));
        }
        if ((bigDecimal = this.getBigDecimal("exclusiveMaximum", node, false, location, result2)) != null) {
            schema.setExclusiveMaximumValue(bigDecimal);
        }
        if ((bigDecimal = this.getBigDecimal("exclusiveMinimum", node, false, location, result2)) != null) {
            schema.setExclusiveMinimumValue(bigDecimal);
        }
        if ((integer = this.getInteger("minContains", node, false, location, result2)) != null) {
            schema.setMinContains(integer);
        }
        if ((integer = this.getInteger("maxContains", node, false, location, result2)) != null) {
            schema.setMaxContains(integer);
        }
        String typeString = this.getString("type", node, false, location, result2, null, true);
        ArrayNode typeArray = this.getArray("type", node, false, location, result2, true);
        if (result2.isAllowEmptyStrings() && typeString != null || !result2.isAllowEmptyStrings() && !StringUtils.isBlank(typeString)) {
            schema.addType(typeString);
        } else if (typeArray != null) {
            for (JsonNode n : typeArray) {
                if (n.isValueNode()) {
                    if (!JSON_SCHEMA_2020_12_TYPES.contains(n.asText())) {
                        result2.warning(location, " invalid type " + n.asText());
                    }
                    if (schema.addType(n.asText())) continue;
                    result2.warning(location, " duplicated type " + n.asText());
                    continue;
                }
                result2.invalidType(location, "type", "value", n);
            }
        } else {
            JsonNode enumNode = node.get("enum");
            if (enumNode != null && enumNode.isArray()) {
                String type2 = this.inferTypeFromArray((ArrayNode)enumNode);
                schema.addType(type2);
            }
        }
        ArrayNode enumArray = this.getArray("enum", node, false, location, result2);
        if (enumArray != null) {
            for (JsonNode n : enumArray) {
                if (n.isNumber()) {
                    schema.addEnumItemObject(n.numberValue());
                    continue;
                }
                if (n.isBoolean()) {
                    schema.addEnumItemObject(n.booleanValue());
                    continue;
                }
                if (n.isValueNode()) {
                    try {
                        schema.addEnumItemObject(this.getDecodedObject31(schema, n.asText(null)));
                    }
                    catch (ParseException e3) {
                        result2.invalidType(location, String.format("enum=`%s`", e3.getMessage()), schema.getFormat(), n);
                    }
                    continue;
                }
                if (n.isContainerNode()) {
                    schema.addEnumItemObject(n.isNull() ? null : n);
                    continue;
                }
                result2.invalidType(location, "enum", "value", n);
            }
        }
        if ((notObj = this.getObjectOrBoolean("not", node, false, location, result2)) != null && (not = this.getJsonSchema(notObj, location, result2)) != null) {
            schema.setNot(not);
        }
        if ((contentSchemaObj = this.getObjectOrBoolean("contentSchema", node, false, location, result2)) != null && (contentSchema = this.getJsonSchema(contentSchemaObj, location, result2)) != null) {
            schema.setContentSchema(contentSchema);
        }
        if ((propertyNamesObj = this.getObjectOrBoolean("propertyNames", node, false, location, result2)) != null && (propertyNames = this.getJsonSchema(propertyNamesObj, location, result2)) != null) {
            schema.setPropertyNames(propertyNames);
        }
        if ((ifObj = this.getObjectOrBoolean("if", node, false, location, result2)) != null && (_if = this.getJsonSchema(ifObj, location, result2)) != null) {
            schema.setIf(_if);
        }
        if ((thenObj = this.getObjectOrBoolean("then", node, false, location, result2)) != null && (_then = this.getJsonSchema(thenObj, location, result2)) != null) {
            schema.setThen(_then);
        }
        if ((elseObj = this.getObjectOrBoolean("else", node, false, location, result2)) != null && (_else = this.getJsonSchema(elseObj, location, result2)) != null) {
            schema.setElse(_else);
        }
        if ((unevaluatedItems = this.getObjectOrBoolean("unevaluatedItems", node, false, location, result2)) != null && (unevaluatedItemsSchema = this.getJsonSchema(unevaluatedItems, location, result2)) != null) {
            schema.setUnevaluatedItems(unevaluatedItemsSchema);
        }
        LinkedHashMap<String, List<String>> dependentRequiredList = new LinkedHashMap<String, List<String>>();
        ObjectNode dependentRequiredObj = this.getObject("dependentRequired", node, false, location, result2);
        ArrayList<String> dependentRequired = new ArrayList<String>();
        Set<String> dependentRequiredKeys = this.getKeys(dependentRequiredObj);
        for (String name : dependentRequiredKeys) {
            JsonNode dependentRequiredValue = dependentRequiredObj.get(name);
            if (!dependentRequiredValue.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                result2.invalidType(location, "dependentRequired", "object", dependentRequiredValue);
                continue;
            }
            if (dependentRequiredObj == null) continue;
            for (Object n : dependentRequiredValue) {
                if (!((JsonNode)n).getNodeType().equals((Object)JsonNodeType.STRING)) continue;
                dependentRequired.add(((JsonNode)n).textValue());
            }
            dependentRequiredList.put(name, dependentRequired);
        }
        if (dependentRequiredObj != null) {
            schema.setDependentRequired(dependentRequiredList);
        }
        LinkedHashMap<String, Schema> dependentSchemasList = new LinkedHashMap<String, Schema>();
        ObjectNode dependentSchemasObj = this.getObject("dependentSchemas", node, false, location, result2);
        if (dependentSchemasObj != null) {
            Schema dependentSchemas = null;
            Set<String> dependentSchemasKeys = this.getKeys(dependentSchemasObj);
            for (String string : dependentSchemasKeys) {
                JsonNode dependentSchemasValue = dependentSchemasObj.get(string);
                dependentSchemas = this.getJsonSchema(dependentSchemasValue, location, result2);
                if (dependentSchemas == null) continue;
                dependentSchemasList.put(string, dependentSchemas);
            }
            schema.setDependentSchemas(dependentSchemasList);
        }
        if ((prefixItemsArray = this.getArray("prefixItems", node, false, location, result2)) != null) {
            Schema prefixItems = new JsonSchema();
            ArrayList<Schema> prefixItemsList = new ArrayList<Schema>();
            for (JsonNode n : prefixItemsArray) {
                prefixItems = this.getJsonSchema(n, location, result2);
                if (prefixItems == null) continue;
                prefixItemsList.add(prefixItems);
            }
            if (prefixItemsList.size() > 0) {
                schema.setPrefixItems(prefixItemsList);
            }
        }
        if ((containsObj = this.getObjectOrBoolean("contains", node, false, location, result2)) != null && (contains = this.getJsonSchema(containsObj, location, result2)) != null) {
            schema.setContains(contains);
        }
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        ObjectNode objectNode = this.getObject("properties", node, false, location, result2);
        Schema property2 = null;
        Set<String> keys2 = this.getKeys(objectNode);
        for (String name : keys2) {
            JsonNode propertyValue = objectNode.get(name);
            property2 = this.getJsonSchema(propertyValue, location, result2);
            if (property2 == null) continue;
            properties.put(name, property2);
        }
        if (objectNode != null) {
            schema.setProperties(properties);
        }
        LinkedHashMap<String, Schema> patternProperties = new LinkedHashMap<String, Schema>();
        ObjectNode patternPropertiesObj = this.getObject("patternProperties", node, false, location, result2);
        Schema patternProperty = null;
        Set<String> patternKeys = this.getKeys(patternPropertiesObj);
        for (String name : patternKeys) {
            JsonNode propertyValue = patternPropertiesObj.get(name);
            if (patternPropertiesObj == null || (patternProperty = this.getJsonSchema(propertyValue, location, result2)) == null) continue;
            patternProperties.put(name, patternProperty);
        }
        if (patternPropertiesObj != null) {
            schema.setPatternProperties(patternProperties);
        }
        if ((constValue = this.getAnyType("const", node, location, result2)) != null) {
            schema.setConst(constValue);
        }
        if ((value2 = this.getString("contentEncoding", node, false, location, result2)) != null) {
            schema.setContentEncoding(value2);
        }
        if ((value2 = this.getString("contentMediaType", node, false, location, result2)) != null) {
            schema.setContentMediaType(value2);
        }
        ArrayNode examples = this.getArray("examples", node, false, location, result2);
        ArrayList<JsonNode> exampleList = new ArrayList<JsonNode>();
        if (examples != null) {
            for (JsonNode item : examples) {
                exampleList.add(item);
            }
        }
        if (exampleList.size() > 0) {
            schema.setExamples(exampleList);
        }
        if ((value2 = this.getString("$anchor", node, false, location, result2)) != null) {
            schema.set$anchor(value2);
        }
        if ((value2 = this.getString("$vocabulary", node, false, location, result2)) != null) {
            schema.set$vocabulary(value2);
        }
        if ((value2 = this.getString("$dynamicAnchor", node, false, location, result2)) != null) {
            schema.set$dynamicAnchor(value2);
        }
        if ((value2 = this.getString("$dynamicRef", node, false, location, result2)) != null) {
            schema.set$dynamicRef(value2);
        }
        if ((value2 = this.getString("$id", node, false, location, result2)) != null) {
            schema.set$id(value2);
        }
        if ((value2 = this.getString("$schema", node, false, location, result2)) != null) {
            schema.set$schema(value2);
        }
        if ((value2 = this.getString("$comment", node, false, location, result2)) != null) {
            schema.set$comment(value2);
        }
        if ((extensions = this.getExtensions(node)) != null && extensions.size() > 0) {
            schema.setExtensions(extensions);
        }
        Set<String> schemaKeys = this.getKeys(node);
        Map<String, Set<String>> specKeys = KEYS.get("openapi31");
        for (String key2 : schemaKeys) {
            this.validateReservedKeywords(specKeys, key2, location, result2);
            if (specKeys.get("SCHEMA_KEYS").contains(key2) || key2.startsWith("x-")) continue;
            extensions.put(key2, Json.mapper().convertValue((Object)node.get(key2), Object.class));
            schema.setExtensions(extensions);
        }
        return schema;
    }

    static {
        LinkedHashMap<String, Set<String>> keys30 = new LinkedHashMap<String, Set<String>>();
        LinkedHashMap<String, Set<String>> keys31 = new LinkedHashMap<String, Set<String>>();
        keys30.put("ROOT_KEYS", ROOT_KEYS);
        keys30.put("INFO_KEYS", INFO_KEYS);
        keys30.put("CONTACT_KEYS", CONTACT_KEYS);
        keys30.put("LICENSE_KEYS", LICENSE_KEYS);
        keys30.put("TAG_KEYS", TAG_KEYS);
        keys30.put("RESPONSE_KEYS", RESPONSE_KEYS);
        keys30.put("SERVER_KEYS", SERVER_KEYS);
        keys30.put("SERVER_VARIABLE_KEYS", SERVER_VARIABLE_KEYS);
        keys30.put("PATHITEM_KEYS", PATHITEM_KEYS);
        keys30.put("OPERATION_KEYS", OPERATION_KEYS);
        keys30.put("PARAMETER_KEYS", PARAMETER_KEYS);
        keys30.put("REQUEST_BODY_KEYS", REQUEST_BODY_KEYS);
        keys30.put("SECURITY_SCHEME_KEYS", SECURITY_SCHEME_KEYS);
        keys30.put("EXTERNAL_DOCS_KEYS", EXTERNAL_DOCS_KEYS);
        keys30.put("COMPONENTS_KEYS", COMPONENTS_KEYS);
        keys30.put("SCHEMA_KEYS", SCHEMA_KEYS);
        keys30.put("EXAMPLE_KEYS", EXAMPLE_KEYS);
        keys30.put("HEADER_KEYS", HEADER_KEYS);
        keys30.put("LINK_KEYS", LINK_KEYS);
        keys30.put("MEDIATYPE_KEYS", MEDIATYPE_KEYS);
        keys30.put("XML_KEYS", XML_KEYS);
        keys30.put("OAUTHFLOW_KEYS", OAUTHFLOW_KEYS);
        keys30.put("OAUTHFLOWS_KEYS", OAUTHFLOWS_KEYS);
        keys30.put("ENCODING_KEYS", ENCODING_KEYS);
        keys31.put("ROOT_KEYS", ROOT_KEYS_31);
        keys31.put("INFO_KEYS", INFO_KEYS_31);
        keys31.put("CONTACT_KEYS", CONTACT_KEYS_31);
        keys31.put("LICENSE_KEYS", LICENSE_KEYS_31);
        keys31.put("TAG_KEYS", TAG_KEYS_31);
        keys31.put("RESPONSE_KEYS", RESPONSE_KEYS_31);
        keys31.put("SERVER_KEYS", SERVER_KEYS_31);
        keys31.put("SERVER_VARIABLE_KEYS", SERVER_VARIABLE_KEYS_31);
        keys31.put("PATHITEM_KEYS", PATHITEM_KEYS_31);
        keys31.put("OPERATION_KEYS", OPERATION_KEYS_31);
        keys31.put("PARAMETER_KEYS", PARAMETER_KEYS_31);
        keys31.put("REQUEST_BODY_KEYS", REQUEST_BODY_KEYS_31);
        keys31.put("SECURITY_SCHEME_KEYS", SECURITY_SCHEME_KEYS_31);
        keys31.put("EXTERNAL_DOCS_KEYS", EXTERNAL_DOCS_KEYS_31);
        keys31.put("COMPONENTS_KEYS", COMPONENTS_KEYS_31);
        keys31.put("SCHEMA_KEYS", SCHEMA_KEYS_31);
        keys31.put("EXAMPLE_KEYS", EXAMPLE_KEYS_31);
        keys31.put("HEADER_KEYS", HEADER_KEYS_31);
        keys31.put("LINK_KEYS", LINK_KEYS_31);
        keys31.put("MEDIATYPE_KEYS", MEDIATYPE_KEYS_31);
        keys31.put("XML_KEYS", XML_KEYS_31);
        keys31.put("OAUTHFLOW_KEYS", OAUTHFLOW_KEYS_31);
        keys31.put("OAUTHFLOWS_KEYS", OAUTHFLOWS_KEYS_31);
        keys31.put("ENCODING_KEYS", ENCODING_KEYS_31);
        keys31.put("RESERVED_KEYWORDS", RESERVED_KEYWORDS_31);
        KEYS.put("openapi30", keys30);
        KEYS.put("openapi31", keys31);
        RFC3339_DATE_TIME_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?((Z)|([+-]\\d{2}:\\d{2}))$");
        RFC3339_DATE_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");
        jsonSchemaParserExtensionMap = new LinkedHashMap<ClassLoader, List<JsonSchemaParserExtension>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ClassLoader, List<JsonSchemaParserExtension>> eldest) {
                return this.size() > 20;
            }
        };
    }

    protected static class Location {
        private String location;
        private String key;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location1 = (Location)o;
            if (this.location != null ? !this.location.equals(location1.location) : location1.location != null) {
                return false;
            }
            return !(this.key == null ? location1.key != null : !this.key.equals(location1.key));
        }

        public int hashCode() {
            int result2 = this.location != null ? this.location.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }

        public Location(String location, String key2) {
            this.location = location;
            this.key = key2;
        }
    }

    public static class ParseResult {
        private boolean valid = true;
        private Map<Location, JsonNode> extra = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, JsonNode> unsupported = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, String> invalidType = new LinkedHashMap<Location, String>();
        private List<Location> missing = new ArrayList<Location>();
        private List<Location> warnings = new ArrayList<Location>();
        private List<Location> unique = new ArrayList<Location>();
        private List<Location> uniqueTags = new ArrayList<Location>();
        private boolean allowEmptyStrings = true;
        private List<Location> reserved = new ArrayList<Location>();
        private boolean validateInternalRefs;
        private boolean inferSchemaType = true;
        private boolean openapi31 = false;
        private boolean oaiAuthor = false;
        private boolean explicitStyleAndExplode = true;

        public boolean isInferSchemaType() {
            return this.inferSchemaType;
        }

        public void setInferSchemaType(boolean inferSchemaType) {
            this.inferSchemaType = inferSchemaType;
        }

        public ParseResult inferSchemaType(boolean inferSchemaType) {
            this.inferSchemaType = inferSchemaType;
            return this;
        }

        public boolean isAllowEmptyStrings() {
            return this.allowEmptyStrings;
        }

        public void setAllowEmptyStrings(boolean allowEmptyStrings) {
            this.allowEmptyStrings = allowEmptyStrings;
        }

        public ParseResult allowEmptyStrings(boolean allowEmptyStrings) {
            this.allowEmptyStrings = allowEmptyStrings;
            return this;
        }

        public void unsupported(String location, String key2, JsonNode value2) {
            this.unsupported.put(new Location(location, key2), value2);
        }

        public void reserved(String location, String key2) {
            this.reserved.add(new Location(location, key2));
        }

        public void extra(String location, String key2, JsonNode value2) {
            this.extra.put(new Location(location, key2), value2);
        }

        public void missing(String location, String key2) {
            this.missing.add(new Location(location, key2));
        }

        public void warning(String location, String key2) {
            this.warnings.add(new Location(location, key2));
        }

        public void unique(String location, String key2) {
            this.unique.add(new Location(location, key2));
        }

        public void uniqueTags(String location, String key2) {
            this.uniqueTags.add(new Location(location, key2));
        }

        public void invalidType(String location, String key2, String expectedType2, JsonNode value2) {
            this.invalidType.put(new Location(location, key2), expectedType2);
        }

        public void invalid() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setOpenapi31(boolean openapi31) {
            this.openapi31 = openapi31;
        }

        public ParseResult openapi31(boolean openapi31) {
            this.openapi31 = openapi31;
            return this;
        }

        public boolean isOpenapi31() {
            return this.openapi31;
        }

        public boolean isOaiAuthor() {
            return this.oaiAuthor;
        }

        public void setOaiAuthor(boolean oaiAuthor) {
            this.oaiAuthor = oaiAuthor;
        }

        public ParseResult oaiAuthor(boolean oaiAuthor) {
            this.oaiAuthor = oaiAuthor;
            return this;
        }

        public boolean isExplicitStyleAndExplode() {
            return this.explicitStyleAndExplode;
        }

        public void setExplicitStyleAndExplode(boolean explicitStyleAndExplode) {
            this.explicitStyleAndExplode = explicitStyleAndExplode;
        }

        public ParseResult explicitStyleAndExplode(boolean explicitStyleAndExplode) {
            this.explicitStyleAndExplode = explicitStyleAndExplode;
            return this;
        }

        public List<String> getMessages() {
            String message;
            String location;
            ArrayList<String> messages = new ArrayList<String>();
            for (Location l : this.extra.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unexpected";
                messages.add(message);
            }
            for (Location l : this.invalidType.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is not of type `" + this.invalidType.get(l) + "`";
                messages.add(message);
            }
            for (Location l : this.missing) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is missing";
                messages.add(message);
            }
            for (Location l : this.warnings) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = location + l.key;
                messages.add(message);
            }
            for (Location l : this.unsupported.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unsupported";
                messages.add(message);
            }
            for (Location l : this.unique) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is repeated";
                messages.add(message);
            }
            for (Location l : this.uniqueTags) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is repeated";
                messages.add(message);
            }
            for (Location l : this.reserved) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is reserved by The OpenAPI Initiative";
                messages.add(message);
            }
            return messages;
        }

        public void setValidateInternalRefs(boolean validateInternalRefs) {
            this.validateInternalRefs = validateInternalRefs;
        }

        public boolean isValidateInternalRefs() {
            return this.validateInternalRefs;
        }
    }
}

