/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathUtils {
    static final String SCHEME_FILE = "file:";
    static final String SCHEME_HTTP = "http:";
    static final String SCHEME_HTTPS = "https:";

    public static Path getParentDirectoryOfFile(String location) {
        Path file2 = null;
        try {
            location = location.replaceAll("\\\\", "/");
            file2 = location.toLowerCase().startsWith(SCHEME_FILE) ? Paths.get(URI.create(location)).toAbsolutePath() : Paths.get(location, new String[0]).toAbsolutePath();
            if (!Files.exists(file2, new LinkOption[0])) {
                return PathUtils.getParentDirectoryFromUrl(location);
            }
        }
        catch (Exception e2) {
            e2.getMessage();
        }
        return file2.toAbsolutePath().getParent();
    }

    private static Path getParentDirectoryFromUrl(String location) {
        try {
            URL url2 = PathUtils.class.getResource(location);
            if (url2 == null) {
                url2 = PathUtils.class.getClassLoader().getResource(location);
            }
            if (url2 == null) {
                url2 = ClassLoader.getSystemResource(location);
            }
            Path file2 = Paths.get(URI.create(url2.toExternalForm()));
            return file2.getParent();
        }
        catch (Exception e2) {
            e2.getMessage();
            return null;
        }
    }

    public static String getAbsoluteUrl(String location) {
        Path file2;
        block4: {
            file2 = null;
            try {
                location = location.replaceAll("\\\\", "/");
                if (location.toLowerCase().startsWith(SCHEME_HTTP) || location.toLowerCase().startsWith(SCHEME_HTTPS)) {
                    return location;
                }
                file2 = location.toLowerCase().startsWith(SCHEME_FILE) ? Paths.get(URI.create(location)).toAbsolutePath() : Paths.get(location, new String[0]).toAbsolutePath();
                if (!Files.exists(file2, new LinkOption[0])) {
                    return PathUtils.getClasspathUrl(location);
                }
            }
            catch (Exception e2) {
                if (file2 != null) break block4;
                return location;
            }
        }
        return file2.toAbsolutePath().toUri().toString();
    }

    private static String getClasspathUrl(String location) {
        try {
            URL url2 = PathUtils.class.getResource(location);
            if (url2 == null) {
                url2 = PathUtils.class.getClassLoader().getResource(location);
            }
            if (url2 == null) {
                url2 = ClassLoader.getSystemResource(location);
            }
            Path file2 = Paths.get(URI.create(url2.toExternalForm()));
            return file2.toAbsolutePath().toUri().toString();
        }
        catch (Exception e2) {
            return location;
        }
    }
}

