/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class RefUtils {
    private static final String REFERENCE_SEPARATOR = "#/";

    private RefUtils() {
    }

    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split(REFERENCE_SEPARATOR);
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file2 = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file2.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split2 = plausibleName.split("\\.");
            plausibleName = split2.length > 2 ? String.join((CharSequence)"", Arrays.copyOf(split2, split2.length - 1)) : split2[0];
        }
        return plausibleName;
    }

    public static Optional<String> getExternalPath(String ref) {
        if (ref == null) {
            return Optional.empty();
        }
        return Optional.of(ref.split(REFERENCE_SEPARATOR)).filter(it -> ((String[])it).length == 2).map(it -> it[0]).filter(it -> !it.isEmpty());
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static RefFormat computeRefFormat(String ref) {
        RefFormat result2 = RefFormat.INTERNAL;
        if ((ref = RefUtils.mungedRef(ref)).startsWith("http") || ref.startsWith("https")) {
            result2 = RefFormat.URL;
        } else if (ref.startsWith(REFERENCE_SEPARATOR)) {
            result2 = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/") || ref.indexOf(REFERENCE_SEPARATOR) > 0) {
            result2 = RefFormat.RELATIVE;
        }
        return result2;
    }

    public static String mungedRef(String refString) {
        if (!(refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.contains("$") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return refString;
    }

    public static String readExternalUrlRef(String file2, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result2;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url2 = RefUtils.buildUrl(rootPath, file2);
                return RefUtils.readExternalRef(url2, RefFormat.URL, auths, null);
            }
            result2 = RemoteUrl.urlToString(file2, auths);
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file2, e2);
        }
        return result2;
    }

    public static String readExternalClasspathRef(String file2, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result2;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat == RefFormat.URL) {
                result2 = RemoteUrl.urlToString(file2, auths);
            } else {
                String pathRef = ExternalRefProcessor.join(rootPath, file2);
                result2 = ClasspathHelper.loadFileFromClasspath(pathRef);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file2, e2);
        }
        return result2;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        if (rootPath == null || relativePath == null) {
            return null;
        }
        try {
            int until = rootPath.lastIndexOf("/") + 1;
            String root = rootPath.substring(0, until);
            URL rootUrl = new URL(root);
            URL finalUrl = new URL(rootUrl, relativePath);
            return finalUrl.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String readExternalRef(String file2, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        String result2 = null;
        try {
            if (refFormat == RefFormat.URL) {
                result2 = RemoteUrl.urlToString(file2, auths);
            } else {
                Path pathToUse = parentDirectory.resolve(file2).normalize();
                if (Files.exists(pathToUse, new LinkOption[0])) {
                    result2 = RefUtils.readAll(pathToUse);
                } else {
                    String url2 = file2;
                    if (url2.contains("..")) {
                        int parentCount = 0;
                        while (url2.contains("..")) {
                            url2 = url2.substring(url2.indexOf(".") + 2);
                            ++parentCount;
                        }
                        for (int i2 = 0; i2 < parentCount - 1; ++i2) {
                            parentDirectory = parentDirectory.getParent();
                        }
                        url2 = parentDirectory + url2;
                    } else {
                        url2 = parentDirectory + url2.substring(url2.indexOf(".") + 1);
                    }
                    Path pathToUse2 = parentDirectory.resolve(url2).normalize();
                    if (Files.exists(pathToUse2, new LinkOption[0])) {
                        result2 = RefUtils.readAll(pathToUse2);
                    }
                }
                if (result2 == null) {
                    result2 = ClasspathHelper.loadFileFromClasspath(file2);
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file2 + " path: " + parentDirectory, e2);
        }
        return result2;
    }

    private static String readAll(Path path2) throws IOException {
        try (FileInputStream inputStream2 = new FileInputStream(path2.toFile());){
            String string = IOUtils.toString((InputStream)inputStream2, StandardCharsets.UTF_8);
            return string;
        }
    }
}

