/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.JsonSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.util.RefUtils;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private boolean aggregateCombinators;
    private ParseOptions parseOptions = new ParseOptions();
    private Map<String, Schema> schemas;
    private Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;
    private Map<String, Parameter> parameters;
    private Map<String, ApiResponse> responses;
    private Map<String, RequestBody> requestBodies;
    private Map<String, Header> headers;
    private Map<String, Link> links;
    private Map<String, Schema> resolvedProperties = new IdentityHashMap<String, Schema>();
    private Map<String, Callback> callbacks;

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public ResolverFully(ParseOptions options2) {
        this.aggregateCombinators = options2 != null ? options2.isResolveCombinators() : true;
        this.parseOptions = options2;
    }

    public void resolveFully(OpenAPI openAPI) {
        Paths paths;
        Components components = openAPI.getComponents();
        if (components != null && components.getRequestBodies() != null) {
            this.requestBodies = components.getRequestBodies();
            if (this.requestBodies == null) {
                this.requestBodies = new HashMap<String, RequestBody>();
            }
        }
        if (components != null && components.getSchemas() != null) {
            this.schemas = components.getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (components != null && components.getResponses() != null) {
            this.responses = components.getResponses();
            if (this.responses == null) {
                this.responses = new HashMap<String, ApiResponse>();
            }
        }
        if (components != null && components.getExamples() != null) {
            this.examples = components.getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (components != null && components.getHeaders() != null) {
            this.headers = components.getHeaders();
            if (this.headers == null) {
                this.headers = new HashMap<String, Header>();
            }
        }
        if (components != null && components.getParameters() != null) {
            this.parameters = components.getParameters();
            if (this.parameters == null) {
                this.parameters = new HashMap<String, Parameter>();
            }
        }
        if (components != null && components.getLinks() != null) {
            this.links = components.getLinks();
            if (this.links == null) {
                this.links = new HashMap<String, Link>();
            }
        }
        if (components != null && components.getCallbacks() != null) {
            this.callbacks = components.getCallbacks();
            if (this.callbacks == null) {
                this.callbacks = new HashMap<String, Callback>();
            }
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem pathItem = (PathItem)paths.get(pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            ApiResponses apiResponses;
            RequestBody refRequestBody;
            if (op.getParameters() != null) {
                for (Parameter parameter : op.getParameters()) {
                    Schema resolved2;
                    Parameter parameter2;
                    Parameter parameter3 = parameter2 = parameter.get$ref() != null ? this.resolveParameter(parameter) : parameter;
                    if (parameter2.getSchema() != null && (resolved2 = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved2);
                    }
                    if (parameter2.getContent() == null) continue;
                    Content content2 = parameter2.getContent();
                    for (Object key2 : content2.keySet()) {
                        Schema resolvedSchema;
                        if (content2.get(key2) == null || ((MediaType)content2.get(key2)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content2.get(key2)).getSchema())) == null) continue;
                        ((MediaType)content2.get(key2)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map<String, Callback> callbacks = op.getCallbacks();
                for (String name : callbacks.keySet()) {
                    Callback callback2 = callbacks.get(name);
                    Callback callback3 = callback2 = callback2.get$ref() != null ? this.resolveCallback(callback2) : callback2;
                    if (callback2 != null) {
                        Object key2;
                        key2 = callback2.keySet().iterator();
                        while (key2.hasNext()) {
                            String callbackName = (String)key2.next();
                            PathItem path2 = (PathItem)callback2.get(callbackName);
                            if (path2 == null) continue;
                            this.resolvePath(path2);
                        }
                    }
                    op.getCallbacks().put(name, callback2);
                }
            }
            if ((refRequestBody = op.getRequestBody()) != null) {
                RequestBody requestBody2 = refRequestBody.get$ref() != null ? this.resolveRequestBody(refRequestBody) : refRequestBody;
                op.setRequestBody(requestBody2);
                if (requestBody2.getContent() != null) {
                    Content content2 = requestBody2.getContent();
                    for (String key2 : content2.keySet()) {
                        Schema resolved3;
                        if (content2.get(key2) == null || ((MediaType)content2.get(key2)).getSchema() == null || (resolved3 = this.resolveSchema(((MediaType)content2.get(key2)).getSchema())) == null) continue;
                        ((MediaType)content2.get(key2)).setSchema(resolved3);
                    }
                }
            }
            if ((apiResponses = op.getResponses()) == null) continue;
            ApiResponses resolvedResponses = new ApiResponses();
            for (String code : apiResponses.keySet()) {
                ApiResponse response2 = (ApiResponse)apiResponses.get(code);
                ApiResponse apiResponse = response2 = response2.get$ref() != null ? this.resolveResponse(response2) : response2;
                if (response2.getContent() != null) {
                    Content content3 = response2.getContent();
                    for (String string : content3.keySet()) {
                        if (((MediaType)content3.get(string)).getSchema() != null) {
                            Schema resolved4 = this.resolveSchema(((MediaType)content3.get(string)).getSchema());
                            ((MediaType)response2.getContent().get(string)).setSchema(resolved4);
                        }
                        if (((MediaType)content3.get(string)).getExamples() == null) continue;
                        Map<String, Example> resolved2 = this.resolveExample(((MediaType)content3.get(string)).getExamples());
                        ((MediaType)response2.getContent().get(string)).setExamples(resolved2);
                    }
                }
                this.resolveHeaders(response2.getHeaders());
                Map<String, Link> links = response2.getLinks();
                if (links != null) {
                    for (Map.Entry entry : links.entrySet()) {
                        Link value2 = (Link)entry.getValue();
                        Link resolvedValue = value2.get$ref() != null ? this.resolveLink(value2) : value2;
                        entry.setValue(resolvedValue);
                    }
                }
                resolvedResponses.addApiResponse(code, response2);
            }
            op.setResponses(resolvedResponses);
        }
    }

    private void resolveHeaders(Map<String, Header> headers2) {
        if (headers2 == null || headers2.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Header> header : headers2.entrySet()) {
            Schema resolvedSchema;
            Schema schema;
            Header value2 = header.getValue();
            Header resolvedValue = value2.get$ref() != null ? this.resolveHeader(value2) : value2;
            Map<String, Example> examples = resolvedValue.getExamples();
            if (examples != null) {
                Map<String, Example> resolved2 = this.resolveExample(examples);
                resolvedValue.setExamples(resolved2);
            }
            if ((schema = resolvedValue.getSchema()) != null && (resolvedSchema = this.resolveSchema(schema)) != null) {
                resolvedValue.setSchema(resolvedSchema);
            }
            header.setValue(resolvedValue);
        }
    }

    public Header resolveHeader(Header header) {
        RefFormat refFormat = RefUtils.computeRefFormat(header.get$ref());
        String $ref = header.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.headers != null && !this.headers.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.headers.getOrDefault(referenceKey, header);
        }
        return header;
    }

    public Link resolveLink(Link link) {
        RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
        String $ref = link.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.links != null && !this.links.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            Link link1 = this.links.getOrDefault(referenceKey, link);
            if (link1 == null) {
                return null;
            }
            this.resolveHeaders(link1.getHeaders());
            return link1;
        }
        return link;
    }

    public RequestBody resolveRequestBody(RequestBody requestBody2) {
        RefFormat refFormat = RefUtils.computeRefFormat(requestBody2.get$ref());
        String $ref = requestBody2.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.requestBodies != null && !this.requestBodies.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.requestBodies.getOrDefault(referenceKey, requestBody2);
        }
        return requestBody2;
    }

    public ApiResponse resolveResponse(ApiResponse apiResponse) {
        RefFormat refFormat = RefUtils.computeRefFormat(apiResponse.get$ref());
        String $ref = apiResponse.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.responses != null && !this.responses.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.responses.getOrDefault(referenceKey, apiResponse);
        }
        return apiResponse;
    }

    public Callback resolveCallback(Callback callback2) {
        RefFormat refFormat = RefUtils.computeRefFormat(callback2.get$ref());
        String $ref = callback2.get$ref();
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.callbacks != null && !this.callbacks.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.callbacks.getOrDefault(referenceKey, callback2);
        }
        return callback2;
    }

    public Parameter resolveParameter(Parameter parameter) {
        String $ref = parameter.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (!RefUtils.isAnExternalRefFormat(refFormat) && this.parameters != null && !this.parameters.isEmpty()) {
            String referenceKey = RefUtils.computeDefinitionName($ref);
            return this.parameters.getOrDefault(referenceKey, parameter);
        }
        return parameter;
    }

    public Schema resolveSchema(Schema schema) {
        MapSchema mapSchema;
        if (schema == null) {
            return null;
        }
        if (schema.get$ref() != null) {
            Schema resolved2;
            String ref = schema.get$ref();
            if (ref.contains("/properties/")) {
                String[] split2 = ref.split("/");
                String refSchema = split2[3];
                Schema parentSchema = this.schemas.get(refSchema);
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                resolved2 = parentSchema.getProperties().get(ref);
            } else {
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Schema schema2 = resolved2 = this.schemas != null ? this.schemas.get(ref) : null;
            }
            if (resolved2 != null) {
                if (this.resolvedModels.containsKey(ref)) {
                    LOGGER.debug("avoiding infinite loop");
                    return this.resolvedModels.get(ref);
                }
                this.resolvedModels.put(ref, schema);
                Schema model = this.resolveSchema(resolved2);
                this.resolvedModels.put(ref, model);
                this.schemas.put(ref, model);
                return model;
            }
            return schema;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            arrayModel.setItems(this.resolveSchema(arrayModel.getItems()));
            return arrayModel;
        }
        if (schema instanceof MapSchema && (mapSchema = (MapSchema)schema).getAdditionalProperties() instanceof Schema) {
            Schema additionalPropertiesSchema = (Schema)mapSchema.getAdditionalProperties();
            mapSchema.setAdditionalProperties(this.resolveSchema(additionalPropertiesSchema));
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema obj = (ObjectSchema)schema;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Schema innerProperty = obj.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    updated.put(propertyName, this.resolveSchemaProperty(propertyName, innerProperty));
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        Schema result2 = schema;
        if (schema instanceof ComposedSchema) {
            boolean adjacent;
            ComposedSchema composedSchema = (ComposedSchema)schema;
            boolean hasAllOf = composedSchema.getAllOf() != null;
            boolean hasAnyOf = composedSchema.getAnyOf() != null;
            boolean hasOneOf = composedSchema.getOneOf() != null;
            boolean bl = adjacent = hasAllOf && hasAnyOf || hasAllOf && hasOneOf || hasAnyOf && hasOneOf;
            if (this.aggregateCombinators && (hasAllOf || adjacent)) {
                Schema combinedModel = null;
                if (SpecVersion.V30.equals((Object)composedSchema.getSpecVersion())) {
                    combinedModel = SchemaTypeUtil.createSchema(this.getSchemaType(composedSchema), composedSchema.getFormat());
                } else {
                    combinedModel = new JsonSchema();
                    combinedModel.setFormat(composedSchema.getFormat());
                    combinedModel.setTypes(composedSchema.getTypes());
                }
                HashSet<Object> examples = new HashSet<Object>();
                HashSet<Object> defaultValues = new HashSet<Object>();
                if (hasAllOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getAllOf(), examples, defaultValues);
                }
                if (hasOneOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getOneOf(), examples, defaultValues);
                }
                if (hasAnyOf) {
                    this.aggregateSchemaCombinators(composedSchema, combinedModel, composedSchema.getAnyOf(), examples, defaultValues);
                }
                if (defaultValues.size() == 1) {
                    combinedModel.setDefault(defaultValues.iterator().next());
                }
                if (schema.getExample() != null) {
                    combinedModel.setExample(schema.getExample());
                } else if (!examples.isEmpty()) {
                    combinedModel.setExample(examples);
                }
                if (schema.getXml() != null) {
                    combinedModel.setXml(schema.getXml());
                }
                if (schema.getDescription() != null) {
                    combinedModel.setDescription(schema.getDescription());
                }
                if (schema.getExtensions() != null) {
                    Map<String, Object> extensions = schema.getExtensions();
                    for (String key2 : extensions.keySet()) {
                        combinedModel.addExtension(key2, extensions.get(key2));
                    }
                }
                if (schema.getProperties() != null) {
                    if (combinedModel.getProperties() == null) {
                        combinedModel.setProperties(new HashMap<String, Schema>());
                    }
                    combinedModel.getProperties().putAll(schema.getProperties());
                }
                if (schema.getRequired() != null) {
                    if (combinedModel.getRequired() == null) {
                        combinedModel.required(new ArrayList<String>());
                    }
                    combinedModel.getRequired().addAll(schema.getRequired());
                }
                result2 = combinedModel;
            } else {
                if (hasAllOf) {
                    composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
                if (hasOneOf) {
                    composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
                if (hasAnyOf) {
                    composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
                }
            }
        }
        if (result2.getProperties() != null) {
            Schema property2;
            Schema model = result2;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map<String, Schema> properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property2 = model.getProperties().get(propertyName);
                updated.put(propertyName, this.resolveSchemaProperty(propertyName, property2));
            }
            for (String key3 : updated.keySet()) {
                property2 = (Schema)updated.get(key3);
                if (property2.getProperties() != model.getProperties()) {
                    if (!this.hasSchemaType(property2) && this.parseOptions.isExplicitObjectSchema()) {
                        if (SpecVersion.V30.equals((Object)property2.getSpecVersion())) {
                            property2.setType("object");
                        } else {
                            property2.addType("object");
                        }
                    }
                    model.addProperties(key3, property2);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                ObjectSchema newSchema = new ObjectSchema();
                model.addProperties(key3, newSchema);
            }
            return model;
        }
        return result2;
    }

    protected String getSchemaType(Schema schema) {
        if (SpecVersion.V30.equals((Object)schema.getSpecVersion())) {
            return schema.getType();
        }
        if (schema.getTypes() != null && schema.getTypes().size() == 1) {
            return schema.getTypes().iterator().next();
        }
        return null;
    }

    protected boolean hasSchemaType(Schema schema) {
        if (SpecVersion.V30.equals((Object)schema.getSpecVersion())) {
            return schema.getType() != null;
        }
        return schema.getTypes() != null && schema.getTypes().size() > 0;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).get$ref() == null) continue;
                String ref = examples.get(name).get$ref();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample2 = this.examples.get(ref);
                resolveExamples.replace(name, sample2);
            }
        }
        return resolveExamples;
    }

    private void aggregateSchemaCombinators(ComposedSchema sourceSchema, Schema targetSchema, List<Schema> schemasToAggregate, Set<Object> examples, Set<Object> defaultValues) {
        HashSet<String> requiredProperties = new HashSet<String>();
        for (Schema innerModel : schemasToAggregate) {
            Map<String, Object> extensions;
            boolean hasOneOf;
            Schema resolved2 = this.resolveSchema(innerModel);
            Map<String, Schema> properties = resolved2.getProperties();
            if (resolved2.getProperties() != null) {
                for (String key2 : properties.keySet()) {
                    Schema prop = resolved2.getProperties().get(key2);
                    targetSchema.addProperties(key2, this.resolveSchemaProperty(key2, prop));
                }
                if (resolved2.getRequired() != null) {
                    for (String required : resolved2.getRequired()) {
                        if (required == null) continue;
                        requiredProperties.add(required.toString());
                    }
                }
            }
            boolean hasAllOf = innerModel.getAllOf() != null;
            boolean hasAnyOf = innerModel.getAnyOf() != null;
            boolean bl = hasOneOf = innerModel.getOneOf() != null;
            if (hasAllOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getAllOf(), examples, defaultValues);
            }
            if (hasOneOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getOneOf(), examples, defaultValues);
            }
            if (hasAnyOf) {
                this.aggregateSchemaCombinators(sourceSchema, targetSchema, innerModel.getAnyOf(), examples, defaultValues);
            }
            if (resolved2.getEnum() != null) {
                targetSchema.setEnum(resolved2.getEnum());
            }
            if (resolved2.getExample() != null) {
                examples.add(resolved2.getExample());
            }
            if (sourceSchema.getDefault() != null && resolved2.getDefault() == null) {
                defaultValues.add(sourceSchema.getDefault());
            } else {
                defaultValues.add(resolved2.getDefault());
            }
            if (resolved2.getExtensions() != null) {
                extensions = resolved2.getExtensions();
                for (String key3 : extensions.keySet()) {
                    targetSchema.addExtension(key3, extensions.get(key3));
                }
            }
            if (sourceSchema.getExtensions() != null) {
                extensions = sourceSchema.getExtensions();
                for (String key3 : extensions.keySet()) {
                    targetSchema.addExtension(key3, sourceSchema.getExtensions().get(key3));
                }
            }
            if (resolved2.getMaximum() != null) {
                targetSchema.setMaximum(resolved2.getMaximum());
            }
            if (resolved2.getExclusiveMaximum() != null) {
                targetSchema.setExclusiveMaximum(resolved2.getExclusiveMaximum());
            }
            if (resolved2.getMinimum() != null) {
                targetSchema.setMinimum(resolved2.getMinimum());
            }
            if (resolved2.getExclusiveMinimum() != null) {
                targetSchema.setExclusiveMinimum(resolved2.getExclusiveMinimum());
            }
            if (resolved2.getMaxLength() != null) {
                targetSchema.setMaxLength(resolved2.getMaxLength());
            }
            if (resolved2.getMinLength() != null) {
                targetSchema.setMinLength(resolved2.getMinLength());
            }
            if (resolved2.getPattern() != null) {
                targetSchema.setPattern(resolved2.getPattern());
            }
            if (resolved2.getMaxItems() != null) {
                targetSchema.setMaxItems(resolved2.getMaxItems());
            }
            if (resolved2.getMinItems() != null) {
                targetSchema.setMinItems(resolved2.getMinItems());
            }
            if (resolved2.getUniqueItems() != null) {
                targetSchema.setUniqueItems(resolved2.getUniqueItems());
            }
            if (resolved2.getMaxProperties() != null) {
                targetSchema.setMaxProperties(resolved2.getMaxProperties());
            }
            if (resolved2.getMinProperties() != null) {
                targetSchema.setMinProperties(resolved2.getMinProperties());
            }
            if (resolved2.getType() != null) {
                targetSchema.setType(resolved2.getType());
            }
            if (resolved2.getDescription() != null) {
                targetSchema.setDescription(resolved2.getDescription());
            }
            if (resolved2.getFormat() != null) {
                targetSchema.setFormat(resolved2.getFormat());
            }
            if (resolved2.getNullable() != null) {
                targetSchema.setNullable(resolved2.getNullable());
            }
            if (resolved2.getReadOnly() != null) {
                targetSchema.setReadOnly(resolved2.getReadOnly());
            }
            if (resolved2.getWriteOnly() != null) {
                targetSchema.setWriteOnly(resolved2.getWriteOnly());
            }
            if (resolved2.getExclusiveMaximumValue() != null) {
                targetSchema.setExclusiveMaximumValue(resolved2.getExclusiveMaximumValue());
            }
            if (resolved2.getExclusiveMinimumValue() != null) {
                targetSchema.setExclusiveMinimumValue(resolved2.getExclusiveMinimumValue());
            }
            if (resolved2.getMaxContains() != null) {
                targetSchema.setMaxContains(resolved2.getMaxContains());
            }
            if (resolved2.getMinContains() == null) continue;
            targetSchema.setMinContains(resolved2.getMinContains());
        }
        if (requiredProperties.size() > 0) {
            ArrayList<String> required = new ArrayList<String>();
            if (targetSchema.getRequired() != null) {
                required.addAll(targetSchema.getRequired());
            }
            required.addAll(requiredProperties);
            targetSchema.setRequired(required);
        }
    }

    private Schema resolveSchemaProperty(String propertyName, Schema innerProperty) {
        if (this.resolvedProperties.get(propertyName) == null || this.resolvedProperties.get(propertyName) != innerProperty) {
            LOGGER.debug("avoiding infinite loop");
            Schema resolved2 = this.resolveSchema(innerProperty);
            this.resolvedProperties.put(propertyName, resolved2);
            return resolved2;
        }
        return this.resolvedProperties.get(propertyName);
    }
}

