/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.validate;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.swagger.transform.util.SwaggerJsonSchemaFactory;

public abstract class SwaggerSchemaValidator {
    protected static final JsonSchemaFactory FACTORY = SwaggerJsonSchemaFactory.getInstance().getFactory();
    private final JsonSchema schema;

    protected SwaggerSchemaValidator(String schemaPath) {
        try {
            this.schema = FACTORY.getJsonSchema(schemaPath);
        }
        catch (ProcessingException e2) {
            throw new RuntimeException("Unhandled exception", e2);
        }
    }

    public final ProcessingReport validate(JsonNode input) throws ProcessingException {
        return this.schema.validate(input, true);
    }
}

