/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import javassist.ClassPath;
import javassist.JarClassPath;
import javassist.NotFoundException;

final class JarDirClassPath
implements ClassPath {
    JarClassPath[] jars;

    JarDirClassPath(String dirName) throws NotFoundException {
        File[] files2 = new File(dirName).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (files2 != null) {
            this.jars = new JarClassPath[files2.length];
            for (int i2 = 0; i2 < files2.length; ++i2) {
                this.jars[i2] = new JarClassPath(files2[i2].getPath());
            }
        }
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        if (this.jars != null) {
            for (int i2 = 0; i2 < this.jars.length; ++i2) {
                InputStream is = this.jars[i2].openClassfile(classname);
                if (is == null) continue;
                return is;
            }
        }
        return null;
    }

    @Override
    public URL find(String classname) {
        if (this.jars != null) {
            for (int i2 = 0; i2 < this.jars.length; ++i2) {
                URL url2 = this.jars[i2].find(classname);
                if (url2 == null) continue;
                return url2;
            }
        }
        return null;
    }
}

