/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;

public class SerialVersionUID {
    public static void setSerialVersionUID(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            if (!SerialVersionUID.isSerializable(clazz)) {
                return;
            }
            CtField field = new CtField(CtClass.longType, "serialVersionUID", clazz);
            field.setModifiers(26);
            clazz.addField(field, SerialVersionUID.calculateDefault(clazz) + "L");
            return;
        }
    }

    private static boolean isSerializable(CtClass clazz) throws NotFoundException {
        ClassPool pool = clazz.getClassPool();
        return clazz.subtypeOf(pool.get("java.io.Serializable"));
    }

    public static long calculateDefault(CtClass clazz) throws CannotCompileException {
        try {
            int mods;
            int i2;
            int i3;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out2 = new DataOutputStream(bout);
            ClassFile classFile = clazz.getClassFile();
            String javaName = SerialVersionUID.javaName(clazz);
            out2.writeUTF(javaName);
            CtMethod[] methods2 = clazz.getDeclaredMethods();
            int classMods = clazz.getModifiers();
            if ((classMods & 0x200) != 0) {
                classMods = methods2.length > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            out2.writeInt(classMods);
            Object[] interfaces = classFile.getInterfaces();
            for (i3 = 0; i3 < interfaces.length; ++i3) {
                interfaces[i3] = SerialVersionUID.javaName((String)interfaces[i3]);
            }
            Arrays.sort(interfaces);
            for (i3 = 0; i3 < interfaces.length; ++i3) {
                out2.writeUTF((String)interfaces[i3]);
            }
            CtField[] fields2 = clazz.getDeclaredFields();
            Arrays.sort(fields2, new Comparator<CtField>(){

                @Override
                public int compare(CtField field1, CtField field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (int i4 = 0; i4 < fields2.length; ++i4) {
                CtField field = fields2[i4];
                int mods2 = field.getModifiers();
                if ((mods2 & 2) != 0 && (mods2 & 0x88) != 0) continue;
                out2.writeUTF(field.getName());
                out2.writeInt(mods2);
                out2.writeUTF(field.getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                out2.writeUTF("<clinit>");
                out2.writeInt(8);
                out2.writeUTF("()V");
            }
            CtConstructor[] constructors2 = clazz.getDeclaredConstructors();
            Arrays.sort(constructors2, new Comparator<CtConstructor>(){

                @Override
                public int compare(CtConstructor c1, CtConstructor c2) {
                    return c1.getMethodInfo2().getDescriptor().compareTo(c2.getMethodInfo2().getDescriptor());
                }
            });
            for (i2 = 0; i2 < constructors2.length; ++i2) {
                CtConstructor constructor = constructors2[i2];
                mods = constructor.getModifiers();
                if ((mods & 2) != 0) continue;
                out2.writeUTF("<init>");
                out2.writeInt(mods);
                out2.writeUTF(constructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(methods2, new Comparator<CtMethod>(){

                @Override
                public int compare(CtMethod m1, CtMethod m22) {
                    int value2 = m1.getName().compareTo(m22.getName());
                    if (value2 == 0) {
                        value2 = m1.getMethodInfo2().getDescriptor().compareTo(m22.getMethodInfo2().getDescriptor());
                    }
                    return value2;
                }
            });
            for (i2 = 0; i2 < methods2.length; ++i2) {
                CtMethod method2 = methods2[i2];
                mods = method2.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                out2.writeUTF(method2.getName());
                out2.writeInt(mods);
                out2.writeUTF(method2.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            out2.flush();
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] digested = digest.digest(bout.toByteArray());
            long hash = 0L;
            for (int i5 = Math.min(digested.length, 8) - 1; i5 >= 0; --i5) {
                hash = hash << 8 | (long)(digested[i5] & 0xFF);
            }
            return hash;
        }
        catch (IOException e2) {
            throw new CannotCompileException(e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new CannotCompileException(e3);
        }
    }

    private static String javaName(CtClass clazz) {
        return Descriptor.toJavaName(Descriptor.toJvmName(clazz));
    }

    private static String javaName(String name) {
        return Descriptor.toJavaName(Descriptor.toJvmName(name));
    }
}

