/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class BootstrapMethodsAttribute
extends AttributeInfo {
    public static final String tag = "BootstrapMethods";

    BootstrapMethodsAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public BootstrapMethodsAttribute(ConstPool cp, BootstrapMethod[] methods2) {
        super(cp, tag);
        int size2 = 2;
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            size2 += 4 + methods2[i2].arguments.length * 2;
        }
        byte[] data2 = new byte[size2];
        ByteArray.write16bit(methods2.length, data2, 0);
        int pos = 2;
        for (int i3 = 0; i3 < methods2.length; ++i3) {
            ByteArray.write16bit(methods2[i3].methodRef, data2, pos);
            ByteArray.write16bit(methods2[i3].arguments.length, data2, pos + 2);
            int[] args2 = methods2[i3].arguments;
            pos += 4;
            for (int k2 = 0; k2 < args2.length; ++k2) {
                ByteArray.write16bit(args2[k2], data2, pos);
                pos += 2;
            }
        }
        this.set(data2);
    }

    public BootstrapMethod[] getMethods() {
        byte[] data2 = this.get();
        int num = ByteArray.readU16bit(data2, 0);
        BootstrapMethod[] methods2 = new BootstrapMethod[num];
        int pos = 2;
        for (int i2 = 0; i2 < num; ++i2) {
            int ref = ByteArray.readU16bit(data2, pos);
            int len2 = ByteArray.readU16bit(data2, pos + 2);
            int[] args2 = new int[len2];
            pos += 4;
            for (int k2 = 0; k2 < len2; ++k2) {
                args2[k2] = ByteArray.readU16bit(data2, pos);
                pos += 2;
            }
            methods2[i2] = new BootstrapMethod(ref, args2);
        }
        return methods2;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        BootstrapMethod[] methods2 = this.getMethods();
        ConstPool thisCp = this.getConstPool();
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            BootstrapMethod m4 = methods2[i2];
            m4.methodRef = thisCp.copy(m4.methodRef, newCp, classnames);
            for (int k2 = 0; k2 < m4.arguments.length; ++k2) {
                m4.arguments[k2] = thisCp.copy(m4.arguments[k2], newCp, classnames);
            }
        }
        return new BootstrapMethodsAttribute(newCp, methods2);
    }

    public static class BootstrapMethod {
        public int methodRef;
        public int[] arguments;

        public BootstrapMethod(int method2, int[] args2) {
            this.methodRef = method2;
            this.arguments = args2;
        }
    }
}

