/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class MethodParametersAttribute
extends AttributeInfo {
    public static final String tag = "MethodParameters";

    MethodParametersAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    public MethodParametersAttribute(ConstPool cp, String[] names2, int[] flags) {
        super(cp, tag);
        byte[] data2 = new byte[names2.length * 4 + 1];
        data2[0] = (byte)names2.length;
        for (int i2 = 0; i2 < names2.length; ++i2) {
            ByteArray.write16bit(cp.addUtf8Info(names2[i2]), data2, i2 * 4 + 1);
            ByteArray.write16bit(flags[i2], data2, i2 * 4 + 3);
        }
        this.set(data2);
    }

    public int size() {
        return this.info[0] & 0xFF;
    }

    public int name(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 4 + 1);
    }

    public String parameterName(int i2) {
        return this.getConstPool().getUtf8Info(this.name(i2));
    }

    public int accessFlags(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 4 + 3);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        int s2 = this.size();
        ConstPool cp = this.getConstPool();
        String[] names2 = new String[s2];
        int[] flags = new int[s2];
        for (int i2 = 0; i2 < s2; ++i2) {
            names2[i2] = cp.getUtf8Info(this.name(i2));
            flags[i2] = this.accessFlags(i2);
        }
        return new MethodParametersAttribute(newCp, names2, flags);
    }
}

