/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Opcode;
import javassist.bytecode.analysis.Subroutine;
import javassist.bytecode.analysis.Util;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map<Integer, Subroutine> subTable = new HashMap<Integer, Subroutine>();
    Set<Integer> done = new HashSet<Integer>();

    public Subroutine[] scan(MethodInfo method2) throws BadBytecode {
        CodeAttribute code = method2.getCodeAttribute();
        CodeIterator iter = code.iterator();
        this.subroutines = new Subroutine[code.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, iter, null);
        ExceptionTable exceptions2 = code.getExceptionTable();
        for (int i2 = 0; i2 < exceptions2.size(); ++i2) {
            int handler2 = exceptions2.handlerPc(i2);
            this.scan(handler2, iter, this.subroutines[exceptions2.startPc(i2)]);
        }
        return this.subroutines;
    }

    private void scan(int pos, CodeIterator iter, Subroutine sub2) throws BadBytecode {
        boolean next2;
        if (this.done.contains(pos)) {
            return;
        }
        this.done.add(pos);
        int old = iter.lookAhead();
        iter.move(pos);
        while (next2 = this.scanOp(pos = iter.next(), iter, sub2) && iter.hasNext()) {
        }
        iter.move(old);
    }

    private boolean scanOp(int pos, CodeIterator iter, Subroutine sub2) throws BadBytecode {
        this.subroutines[pos] = sub2;
        int opcode = iter.byteAt(pos);
        if (opcode == 170) {
            this.scanTableSwitch(pos, iter, sub2);
            return false;
        }
        if (opcode == 171) {
            this.scanLookupSwitch(pos, iter, sub2);
            return false;
        }
        if (Util.isReturn(opcode) || opcode == 169 || opcode == 191) {
            return false;
        }
        if (Util.isJumpInstruction(opcode)) {
            int target = Util.getJumpTarget(pos, iter);
            if (opcode == 168 || opcode == 201) {
                Subroutine s2 = this.subTable.get(target);
                if (s2 == null) {
                    s2 = new Subroutine(target, pos);
                    this.subTable.put(target, s2);
                    this.scan(target, iter, s2);
                } else {
                    s2.addCaller(pos);
                }
            } else {
                this.scan(target, iter, sub2);
                if (Util.isGoto(opcode)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int pos, CodeIterator iter, Subroutine sub2) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter.s32bitAt(index), iter, sub2);
        int npairs = iter.s32bitAt(index += 4);
        int end2 = npairs * 8 + (index += 4);
        index += 4;
        while (index < end2) {
            int target = iter.s32bitAt(index) + pos;
            this.scan(target, iter, sub2);
            index += 8;
        }
    }

    private void scanTableSwitch(int pos, CodeIterator iter, Subroutine sub2) throws BadBytecode {
        int index = (pos & 0xFFFFFFFC) + 4;
        this.scan(pos + iter.s32bitAt(index), iter, sub2);
        int low = iter.s32bitAt(index += 4);
        int high = iter.s32bitAt(index += 4);
        int end2 = (high - low + 1) * 4 + (index += 4);
        while (index < end2) {
            int target = iter.s32bitAt(index) + pos;
            this.scan(target, iter, sub2);
            index += 4;
        }
    }
}

