/*
 * Decompiled with CFR 0.152.
 */
package javassist.tools.web;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;

public class Viewer
extends ClassLoader {
    private String server;
    private int port;

    public static void main(String[] args2) throws Throwable {
        if (args2.length >= 3) {
            Viewer cl = new Viewer(args2[0], Integer.parseInt(args2[1]));
            String[] args22 = new String[args2.length - 3];
            System.arraycopy(args2, 3, args22, 0, args2.length - 3);
            cl.run(args2[2], args22);
        } else {
            System.err.println("Usage: java javassist.tools.web.Viewer <host> <port> class [args ...]");
        }
    }

    public Viewer(String host2, int p) {
        this.server = host2;
        this.port = p;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void run(String classname, String[] args2) throws Throwable {
        Class<?> c2 = this.loadClass(classname);
        try {
            c2.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args2});
        }
        catch (InvocationTargetException e2) {
            throw e2.getTargetException();
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> c2 = this.findLoadedClass(name);
        if (c2 == null) {
            c2 = this.findClass(name);
        }
        if (c2 == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve2) {
            this.resolveClass(c2);
        }
        return c2;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c2 = null;
        if (name.startsWith("java.") || name.startsWith("javax.") || name.equals("javassist.tools.web.Viewer")) {
            c2 = this.findSystemClass(name);
        }
        if (c2 == null) {
            try {
                byte[] b2 = this.fetchClass(name);
                if (b2 != null) {
                    c2 = this.defineClass(name, b2, 0, b2.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return c2;
    }

    protected byte[] fetchClass(String classname) throws Exception {
        byte[] b2;
        URL url2 = new URL("http", this.server, this.port, "/" + classname.replace('.', '/') + ".class");
        URLConnection con = url2.openConnection();
        con.connect();
        int size2 = con.getContentLength();
        InputStream s2 = con.getInputStream();
        if (size2 <= 0) {
            b2 = this.readStream(s2);
        } else {
            int n;
            b2 = new byte[size2];
            int len2 = 0;
            do {
                if ((n = s2.read(b2, len2, size2 - len2)) >= 0) continue;
                s2.close();
                throw new IOException("the stream was closed: " + classname);
            } while ((len2 += n) < size2);
        }
        s2.close();
        return b2;
    }

    private byte[] readStream(InputStream fin) throws IOException {
        byte[] buf = new byte[4096];
        int size2 = 0;
        int len2 = 0;
        do {
            if (buf.length - (size2 += len2) > 0) continue;
            byte[] newbuf = new byte[buf.length * 2];
            System.arraycopy(buf, 0, newbuf, 0, size2);
            buf = newbuf;
        } while ((len2 = fin.read(buf, size2, buf.length - size2)) >= 0);
        byte[] result2 = new byte[size2];
        System.arraycopy(buf, 0, result2, 0, size2);
        return result2;
    }
}

