/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax0.license3j.parsers.NumericParser;

public class Feature {
    private static final String[] DATE_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd"};
    private static final int VARIABLE_LENGTH = -1;
    private final String name;
    private final Type type;
    private final byte[] value;

    private Feature(String name, Type type2, byte[] value2) {
        this.name = name;
        this.type = type2;
        this.value = value2;
    }

    private static SimpleDateFormat getUTCDateFormat(String format2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format2);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    private static String dateFormat(Object date) {
        return Feature.getUTCDateFormat(DATE_FORMAT[0]).format(date);
    }

    private static Date dateParse(String date) {
        for (String format2 : DATE_FORMAT) {
            try {
                return Feature.getUTCDateFormat(format2).parse(date);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Cannot parse " + date);
    }

    static String[] splitString(String feature) {
        int typeEnd = feature.indexOf("=");
        if (typeEnd == -1) {
            throw new IllegalArgumentException("The feature's string representation must have a '=' after the type");
        }
        int colIndex = feature.substring(0, typeEnd).indexOf(":");
        int nameEnd = colIndex == -1 ? typeEnd : colIndex;
        String name = feature.substring(0, nameEnd).trim();
        String type2 = nameEnd == typeEnd ? "STRING" : feature.substring(nameEnd + 1, typeEnd).trim();
        String valueString = feature.substring(typeEnd + 1);
        return new String[]{name, type2, valueString};
    }

    static Feature getFeature(String name, String typeString, String valueString) {
        Type type2 = Type.valueOf(typeString);
        Object value2 = type2.unstringer.apply(valueString);
        return type2.factory.apply(name, value2);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.toStringWith(this.valueString());
    }

    String toStringWith(String value2) {
        return this.name + this.type.colonedToString() + "=" + value2;
    }

    public String valueString() {
        return this.type.stringer.apply(this.type.objecter.apply(this));
    }

    public byte[] serialized() {
        byte[] nameBuffer = this.name.getBytes(StandardCharsets.UTF_8);
        int typeLength = 4;
        int nameLength = 4 + nameBuffer.length;
        int valueLength = this.type.fixedSize == -1 ? 4 + this.value.length : this.type.fixedSize;
        ByteBuffer buffer = ByteBuffer.allocate(4 + nameLength + valueLength).putInt(this.type.serialized).putInt(nameBuffer.length);
        if (this.type.fixedSize == -1) {
            buffer.putInt(this.value.length);
        }
        buffer.put(nameBuffer).put(this.value);
        return buffer.array();
    }

    public boolean isBinary() {
        return this.type == Type.BINARY;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isByte() {
        return this.type == Type.BYTE;
    }

    public boolean isShort() {
        return this.type == Type.SHORT;
    }

    public boolean isInt() {
        return this.type == Type.INT;
    }

    public boolean isLong() {
        return this.type == Type.LONG;
    }

    public boolean isFloat() {
        return this.type == Type.FLOAT;
    }

    public boolean isDouble() {
        return this.type == Type.DOUBLE;
    }

    public boolean isBigInteger() {
        return this.type == Type.BIGINTEGER;
    }

    public boolean isBigDecimal() {
        return this.type == Type.BIGDECIMAL;
    }

    public boolean isDate() {
        return this.type == Type.DATE;
    }

    public boolean isUUID() {
        return this.type == Type.UUID;
    }

    public byte[] getBinary() {
        if (this.type != Type.BINARY) {
            throw new IllegalArgumentException("Feature is not BINARY");
        }
        return this.value;
    }

    public String getString() {
        if (this.type != Type.STRING) {
            throw new IllegalArgumentException("Feature is not STRING");
        }
        return new String(this.value, StandardCharsets.UTF_8);
    }

    public byte getByte() {
        if (this.type != Type.BYTE) {
            throw new IllegalArgumentException("Feature is not BYTE");
        }
        return this.value[0];
    }

    public short getShort() {
        if (this.type != Type.SHORT) {
            throw new IllegalArgumentException("Feature is not SHORT");
        }
        return ByteBuffer.wrap(this.value).getShort();
    }

    public int getInt() {
        if (this.type != Type.INT) {
            throw new IllegalArgumentException("Feature is not INT");
        }
        return ByteBuffer.wrap(this.value).getInt();
    }

    public long getLong() {
        if (this.type != Type.LONG) {
            throw new IllegalArgumentException("Feature is not LONG");
        }
        return ByteBuffer.wrap(this.value).getLong();
    }

    public float getFloat() {
        if (this.type != Type.FLOAT) {
            throw new IllegalArgumentException("Feature is not FLOAT");
        }
        return ByteBuffer.wrap(this.value).getFloat();
    }

    public double getDouble() {
        if (this.type != Type.DOUBLE) {
            throw new IllegalArgumentException("Feature is not DOUBLE");
        }
        return ByteBuffer.wrap(this.value).getDouble();
    }

    public BigInteger getBigInteger() {
        if (this.type != Type.BIGINTEGER) {
            throw new IllegalArgumentException("Feature is not BIGINTEGER");
        }
        return new BigInteger(this.value);
    }

    public Date getDate() {
        if (this.type != Type.DATE) {
            throw new IllegalArgumentException("Feature is not DATE");
        }
        return new Date(ByteBuffer.wrap(this.value).getLong());
    }

    public BigDecimal getBigDecimal() {
        if (this.type != Type.BIGDECIMAL) {
            throw new IllegalArgumentException("Feature is not BIGDECIMAL");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        int scale = bb.getInt(this.value.length - 4);
        return new BigDecimal(new BigInteger(Arrays.copyOf(this.value, this.value.length - 4)), scale);
    }

    public UUID getUUID() {
        if (this.type != Type.UUID) {
            throw new IllegalArgumentException("Feature is not UUID");
        }
        ByteBuffer bb = ByteBuffer.wrap(this.value);
        long ls = bb.getLong();
        long ms = bb.getLong();
        return new UUID(ms, ls);
    }

    private static enum Type {
        BINARY(1, -1, Feature::getBinary, (name, value2) -> Create.binaryFeature(name, (byte[])value2), ba -> Base64.getEncoder().encodeToString((byte[])ba), enc -> Base64.getDecoder().decode((String)enc)),
        STRING(2, -1, Feature::getString, (name, value2) -> Create.stringFeature(name, (String)value2), Object::toString, s2 -> s2),
        BYTE(3, 1, Feature::getByte, (name, value2) -> Create.byteFeature(name, (Byte)value2), b2 -> String.format("0x%02X", (Byte)b2), NumericParser.Byte::parse),
        SHORT(4, 2, Feature::getShort, (name, value2) -> Create.shortFeature(name, (Short)value2), Object::toString, NumericParser.Short::parse),
        INT(5, 4, Feature::getInt, (name, value2) -> Create.intFeature(name, (Integer)value2), Object::toString, NumericParser.Int::parse),
        LONG(6, 8, Feature::getLong, (name, value2) -> Create.longFeature(name, (Long)value2), Object::toString, NumericParser.Long::parse),
        FLOAT(7, 4, Feature::getFloat, (name, value2) -> Create.floatFeature(name, (Float)value2), Object::toString, Float::parseFloat),
        DOUBLE(8, 8, Feature::getDouble, (name, value2) -> Create.doubleFeature(name, (Double)value2), Object::toString, Double::parseDouble),
        BIGINTEGER(9, -1, Feature::getBigInteger, (name, value2) -> Create.bigIntegerFeature(name, (BigInteger)value2), Object::toString, BigInteger::new),
        BIGDECIMAL(10, -1, Feature::getBigDecimal, (name, value2) -> Create.bigDecimalFeature(name, (BigDecimal)value2), Object::toString, BigDecimal::new),
        DATE(11, 8, Feature::getDate, (name, value2) -> Create.dateFeature(name, (Date)value2), x$0 -> Feature.dateFormat(x$0), x$0 -> Feature.dateParse(x$0)),
        UUID(12, 16, Feature::getUUID, (name, value2) -> Create.uuidFeature(name, (UUID)value2), Object::toString, UUID::fromString);

        final int serialized;
        final int fixedSize;
        final Function<Feature, Object> objecter;
        final BiFunction<String, Object, Feature> factory;
        final Function<Object, String> stringer;
        final Function<String, Object> unstringer;

        private Type(int serialized, int fixedSize, Function<Feature, Object> objecter, BiFunction<String, Object, Feature> factory2, Function<Object, String> stringer, Function<String, Object> unstringer) {
            this.serialized = serialized;
            this.fixedSize = fixedSize;
            this.stringer = stringer;
            this.objecter = objecter;
            this.unstringer = unstringer;
            this.factory = factory2;
        }

        public String colonedToString() {
            return this == STRING ? "" : ":" + String.valueOf((Object)this);
        }
    }

    public static class Create {
        private Create() {
        }

        public static Feature binaryFeature(String name, byte[] value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.BINARY, value2);
        }

        public static Feature stringFeature(String name, String value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.STRING, value2.getBytes(StandardCharsets.UTF_8));
        }

        public static Feature byteFeature(String name, Byte value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.BYTE, new byte[]{value2});
        }

        public static Feature shortFeature(String name, Short value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.SHORT, ByteBuffer.allocate(2).putShort(value2).array());
        }

        public static Feature intFeature(String name, Integer value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.INT, ByteBuffer.allocate(4).putInt(value2).array());
        }

        public static Feature longFeature(String name, Long value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.LONG, ByteBuffer.allocate(8).putLong(value2).array());
        }

        public static Feature floatFeature(String name, Float value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.FLOAT, ByteBuffer.allocate(4).putFloat(value2.floatValue()).array());
        }

        public static Feature doubleFeature(String name, Double value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.DOUBLE, ByteBuffer.allocate(8).putDouble(value2).array());
        }

        public static Feature bigIntegerFeature(String name, BigInteger value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.BIGINTEGER, value2.toByteArray());
        }

        public static Feature uuidFeature(String name, UUID value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.UUID, ByteBuffer.allocate(16).putLong(value2.getLeastSignificantBits()).putLong(value2.getMostSignificantBits()).array());
        }

        public static Feature dateFeature(String name, Date value2) {
            Objects.requireNonNull(value2);
            return new Feature(name, Type.DATE, ByteBuffer.allocate(8).putLong(value2.getTime()).array());
        }

        public static Feature bigDecimalFeature(String name, BigDecimal value2) {
            Objects.requireNonNull(value2);
            byte[] b2 = value2.unscaledValue().toByteArray();
            return new Feature(name, Type.BIGDECIMAL, ByteBuffer.allocate(4 + b2.length).put(b2).putInt(value2.scale()).array());
        }

        public static Feature from(String s2) {
            Objects.requireNonNull(s2);
            String[] parts = Feature.splitString(s2);
            return Feature.getFeature(parts[0], parts[1], parts[2]);
        }

        public static Feature from(byte[] serialized) {
            int valueLength;
            Objects.requireNonNull(serialized);
            if (serialized.length < 8) {
                Create.throwBinaryWayTooShort(serialized.length);
            }
            ByteBuffer bb = ByteBuffer.wrap(serialized);
            int typeSerialized = bb.getInt();
            Type type2 = Create.typeFrom(typeSerialized);
            int nameLength = bb.getInt();
            if (nameLength < 0) {
                Create.throwBinaryTooLong("Name");
            }
            int n = valueLength = type2.fixedSize == -1 ? bb.getInt() : type2.fixedSize;
            if (valueLength < 0) {
                Create.throwBinaryTooLong("Value");
            }
            byte[] nameBuffer = new byte[nameLength];
            if (nameLength > 0) {
                if (bb.remaining() < nameLength) {
                    Create.throwBinaryTooShort(valueLength + nameLength - bb.remaining());
                }
                bb.get(nameBuffer);
            }
            byte[] value2 = new byte[valueLength];
            if (valueLength > 0) {
                if (bb.remaining() < valueLength) {
                    Create.throwBinaryTooShort(valueLength - bb.remaining());
                }
                bb.get(value2);
            }
            if (bb.remaining() > 0) {
                Create.throwBinaryTooLong(serialized.length, bb.remaining());
            }
            String name = new String(nameBuffer, StandardCharsets.UTF_8);
            return new Feature(name, type2, value2);
        }

        public static void throwBinaryWayTooShort(int len2) {
            throw new IllegalArgumentException("Cannot load feature from a byte array that has " + len2 + " bytes which is < 8");
        }

        public static void throwBinaryTooShort(int len2) {
            throw new IllegalArgumentException("Feature binary is too short. It is " + len2 + " bytes shy.");
        }

        public static void throwBinaryTooLong(int len2, int extra) {
            throw new IllegalArgumentException("Cannot load feature from a byte array that has " + len2 + " bytes which is " + extra + " bytes too long");
        }

        public static void throwBinaryTooLong(String s2) {
            throw new IllegalArgumentException(s2 + " size is too big. 31bit length should be enough.");
        }

        private static Type typeFrom(int typeSerialized) {
            for (Type type2 : Type.values()) {
                if (type2.serialized != typeSerialized) continue;
                return type2;
            }
            throw new IllegalArgumentException("The deserialized form has a type value " + typeSerialized + " which is not valid.");
        }
    }
}

