/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.UUID;
import javax0.license3j.Feature;
import javax0.license3j.License;

public class RevocableLicense {
    private static final String REVOCATION_URL = "revocationUrl";
    HttpHandler httpHandler = new HttpHandler();
    private final License license;

    public RevocableLicense(License license2) {
        this.license = license2;
    }

    public URL getRevocationURL() throws MalformedURLException {
        String revocationURLTemplate;
        String string = revocationURLTemplate = this.license.get(REVOCATION_URL) == null ? null : this.license.get(REVOCATION_URL).getString();
        if (revocationURLTemplate != null) {
            UUID id = Optional.ofNullable(this.license.getLicenseId()).orElse(this.license.fingerprint());
            if (id != null) {
                return new URL(revocationURLTemplate.replaceAll("\\$\\{licenseId}", id.toString()));
            }
            return new URL(revocationURLTemplate);
        }
        return null;
    }

    public void setRevocationURL(String url2) {
        this.license.add(Feature.Create.stringFeature(REVOCATION_URL, url2));
    }

    public void setRevocationURL(URL url2) {
        this.setRevocationURL(url2.toString());
    }

    public boolean isRevoked() {
        return this.isRevoked(false);
    }

    public boolean isRevoked(boolean defaultRevocationState) {
        boolean revoked = true;
        try {
            URL url2 = this.getRevocationURL();
            if (url2 == null) {
                return false;
            }
            URLConnection con = this.httpHandler.open(url2);
            con.setUseCaches(false);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection hCon = (HttpURLConnection)con;
                hCon.connect();
                return this.httpHandler.responseCode(hCon) != 200;
            }
            return false;
        }
        catch (IOException exception) {
            revoked = defaultRevocationState;
            return revoked;
        }
    }

    static class HttpHandler {
        HttpHandler() {
        }

        int responseCode(HttpURLConnection connection) throws IOException {
            return connection.getResponseCode();
        }

        URLConnection open(URL url2) throws IOException {
            return url2.openConnection();
        }
    }
}

