/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class SimpleLicense {
    private final String SECRET_KEY;
    private final String VALUE;
    private final String LICENSE_STRING;
    private static final int CHARBLOCKS = 4;
    private static final int BLOCKCHARS = 6;

    private SimpleLicense(String secretKey, String value2) throws NoSuchAlgorithmException {
        this.SECRET_KEY = secretKey;
        this.VALUE = value2;
        this.LICENSE_STRING = this.generate();
    }

    public static Builder withSecret(String secret) {
        Builder it = new Builder();
        it.SECRET_KEY = secret;
        return it;
    }

    public String toString() {
        return this.LICENSE_STRING;
    }

    private String generate() throws NoSuchAlgorithmException {
        String dataToEncode = this.VALUE + this.SECRET_KEY;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(dataToEncode.getBytes(StandardCharsets.UTF_8));
        return SimpleLicense.encode(hash);
    }

    public boolean isOK(String code) {
        return this.LICENSE_STRING.equals(code);
    }

    private static String encode(byte[] hash) {
        String asc = Base64.getUrlEncoder().withoutPadding().encodeToString(hash).replaceAll("[^A-Za-z0-9]", "").toUpperCase();
        return SimpleLicense.blockAndTruncate(asc);
    }

    private static String blockAndTruncate(String asc) {
        StringBuilder lic = new StringBuilder(27);
        lic.append(asc, 0, 24);
        for (int i2 = 6; i2 < 27; i2 += 7) {
            lic.insert(i2, "-");
        }
        return lic.toString();
    }

    public static class Builder {
        private String SECRET_KEY;

        public SimpleLicense forValue(String value2) throws NoSuchAlgorithmException {
            return new SimpleLicense(this.SECRET_KEY, value2);
        }
    }
}

